/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.ex;

import com.intellij.openapi.actionSystem.ActionButtonComponent;
import com.intellij.openapi.actionSystem.impl.IdeaActionButtonLook;
import com.intellij.openapi.actionSystem.impl.Win10ActionButtonLook;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JComponent;

public abstract class ActionButtonLook {
    public static final ActionButtonLook SYSTEM_LOOK = new ActionButtonLook(){
        private ActionButtonLook delegate;
        {
            this.updateUI();
        }

        @Override
        public void updateUI() {
            this.delegate = UIUtil.isUnderWin10LookAndFeel() ? new Win10ActionButtonLook() : new IdeaActionButtonLook();
        }

        @Override
        public void paintBackground(Graphics g, JComponent component, int state2) {
            this.delegate.paintBackground(g, component, state2);
        }

        @Override
        public void paintBorder(Graphics g, JComponent component, int state2) {
            this.delegate.paintBorder(g, component, state2);
        }

        @Override
        public Insets getInsets() {
            return this.delegate.getInsets();
        }
    };
    public static final ActionButtonLook INPLACE_LOOK = new ActionButtonLook(){

        @Override
        public void paintBackground(Graphics g, JComponent component, int state2) {
        }

        @Override
        public void paintBorder(Graphics g, JComponent component, int state2) {
        }
    };

    public <ButtonType extends JComponent> void paintBackground(Graphics g, ButtonType button) {
        this.paintBackground(g, button, this.getState((ActionButtonComponent)button));
    }

    public <ButtonType extends JComponent> void paintBorder(Graphics g, ButtonType button) {
        this.paintBorder(g, button, this.getState((ActionButtonComponent)button));
    }

    public abstract void paintBackground(Graphics var1, JComponent var2, @ActionButtonComponent.ButtonState int var3);

    public abstract void paintBorder(Graphics var1, JComponent var2, @ActionButtonComponent.ButtonState int var3);

    public void updateUI() {
    }

    @ActionButtonComponent.ButtonState
    protected int getState(ActionButtonComponent button) {
        return button.getPopState();
    }

    public void paintIcon(Graphics g, ActionButtonComponent actionButton, Icon icon) {
        int width = icon.getIconWidth();
        int height = icon.getIconHeight();
        int x = (actionButton.getWidth() - width) / 2;
        int y = (actionButton.getHeight() - height) / 2;
        this.paintIconAt(g, icon, x, y);
    }

    public void paintIconAt(Graphics g, Icon icon, int x, int y) {
        icon.paintIcon(null, g, x, y);
    }

    public Insets getInsets() {
        return JBUI.emptyInsets();
    }
}

