/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.CommonBundle;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MultiLineLabelUI;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.ui.ScrollPaneFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.LabelUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSelectFilesDialog<T>
extends DialogWrapper {
    protected JCheckBox myDoNotShowCheckbox;
    protected final VcsShowConfirmationOption myConfirmationOption;
    private final String myPrompt;
    private final boolean myShowDoNotAskOption;

    public AbstractSelectFilesDialog(Project project, boolean canBeParent, VcsShowConfirmationOption confirmationOption, String prompt, boolean showDoNotAskOption) {
        super(project, canBeParent);
        this.myConfirmationOption = confirmationOption;
        this.myPrompt = prompt;
        this.myShowDoNotAskOption = showDoNotAskOption;
    }

    @NotNull
    protected abstract ChangesTree getFileList();

    @Nullable
    private JLabel createPromptLabel() {
        if (this.myPrompt != null) {
            JLabel label = new JLabel(this.myPrompt);
            label.setUI((LabelUI)new MultiLineLabelUI());
            label.setBorder(new EmptyBorder(5, 1, 5, 1));
            return label;
        }
        return null;
    }

    protected JComponent createNorthPanel() {
        return this.createPromptLabel();
    }

    protected void doOKAction() {
        if (this.myDoNotShowCheckbox != null && this.myDoNotShowCheckbox.isSelected()) {
            this.myConfirmationOption.setValue(VcsShowConfirmationOption.Value.DO_ACTION_SILENTLY);
        }
        super.doOKAction();
    }

    public void doCancelAction() {
        if (this.myDoNotShowCheckbox != null && this.myDoNotShowCheckbox.isSelected()) {
            this.myConfirmationOption.setValue(VcsShowConfirmationOption.Value.DO_NOTHING_SILENTLY);
        }
        super.doCancelAction();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.getFileList();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)this.createToolbar(), "North");
        panel2.add((Component)ScrollPaneFactory.createScrollPane((Component)((Object)this.getFileList())), "Center");
        if (this.myShowDoNotAskOption) {
            this.myDoNotShowCheckbox = new JCheckBox(CommonBundle.message((String)"dialog.options.do.not.ask", (Object[])new Object[0]));
            panel2.add((Component)this.myDoNotShowCheckbox, "South");
        }
        return panel2;
    }

    private JComponent createToolbar() {
        DefaultActionGroup group = this.createToolbarActions();
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("VcsSelectFilesDialog", (ActionGroup)group, true);
        return toolbar.getComponent();
    }

    @NotNull
    protected DefaultActionGroup createToolbarActions() {
        AnAction[] actions;
        DefaultActionGroup group = new DefaultActionGroup();
        for (AnAction action : actions = this.getFileList().getTreeActions()) {
            group.add(action);
        }
        DefaultActionGroup defaultActionGroup = group;
        if (defaultActionGroup == null) {
            AbstractSelectFilesDialog.$$$reportNull$$$0(0);
        }
        return defaultActionGroup;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/AbstractSelectFilesDialog", "createToolbarActions"));
    }
}

