/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.AbstractFileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.SharedPsiElementImplUtil;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MultiplePsiFilesPerDocumentFileViewProvider
extends AbstractFileViewProvider {
    private final ConcurrentMap<Language, PsiFileImpl> myRoots = ContainerUtil.newConcurrentMap((int)1, (float)0.75f, (int)1);
    private MultiplePsiFilesPerDocumentFileViewProvider myOriginal = null;

    public MultiplePsiFilesPerDocumentFileViewProvider(PsiManager manager, VirtualFile virtualFile, boolean eventSystemEnabled) {
        super(manager, virtualFile, eventSystemEnabled, virtualFile.getFileType());
    }

    @NotNull
    public abstract Language getBaseLanguage();

    @NotNull
    public List<PsiFile> getAllFiles() {
        ArrayList<PsiFile> roots = new ArrayList<PsiFile>();
        for (Language language : this.getLanguages()) {
            PsiFile psi = this.getPsi(language);
            if (psi == null) continue;
            roots.add(psi);
        }
        PsiFile base = this.getPsi(this.getBaseLanguage());
        if (!roots.isEmpty() && roots.get(0) != base) {
            roots.remove(base);
            roots.add(0, base);
        }
        ArrayList<PsiFile> arrayList = roots;
        if (arrayList == null) {
            MultiplePsiFilesPerDocumentFileViewProvider.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    protected final void removeFile(Language language) {
        PsiFileImpl file2 = (PsiFileImpl)this.myRoots.remove(language);
        if (file2 != null) {
            file2.markInvalidated();
        }
    }

    @Override
    protected PsiFile getPsiInner(@NotNull Language target2) {
        PsiFileImpl file2;
        if (target2 == null) {
            MultiplePsiFilesPerDocumentFileViewProvider.$$$reportNull$$$0(1);
        }
        if ((file2 = (PsiFileImpl)this.myRoots.get(target2)) == null) {
            PsiFile originalFile;
            if (this.isPhysical()) {
                VirtualFile virtualFile = this.getVirtualFile();
                if (this.isIgnored()) {
                    return null;
                }
                VirtualFile parent = virtualFile.getParent();
                if (parent != null) {
                    this.getManager().findDirectory(parent);
                }
            }
            if (target2 != this.getBaseLanguage() && !this.getLanguages().contains(target2)) {
                return null;
            }
            file2 = (PsiFileImpl)this.createFile(target2);
            if (file2 == null) {
                return null;
            }
            if (this.myOriginal != null && (originalFile = this.myOriginal.getPsi(target2)) != null) {
                file2.setOriginalFile(originalFile);
            }
            file2 = (PsiFileImpl)ConcurrencyUtil.cacheOrGet(this.myRoots, (Object)target2, (Object)file2);
        }
        return file2;
    }

    @Override
    public final PsiFile getCachedPsi(@NotNull Language target2) {
        if (target2 == null) {
            MultiplePsiFilesPerDocumentFileViewProvider.$$$reportNull$$$0(2);
        }
        return (PsiFile)this.myRoots.get(target2);
    }

    @Override
    public final List<PsiFile> getCachedPsiFiles() {
        return ContainerUtil.mapNotNull(this.myRoots.keySet(), (Function)((NullableFunction)language -> this.getCachedPsi((Language)language)));
    }

    @Override
    @NotNull
    public final List<FileElement> getKnownTreeRoots() {
        ArrayList<FileElement> files = new ArrayList<FileElement>(this.myRoots.size());
        for (PsiFile file2 : this.myRoots.values()) {
            FileElement treeElement = ((PsiFileImpl)file2).getTreeElement();
            if (treeElement == null) continue;
            files.add(treeElement);
        }
        ArrayList<FileElement> arrayList = files;
        if (arrayList == null) {
            MultiplePsiFilesPerDocumentFileViewProvider.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    public void checkAllTreesEqual() {
        Collection roots = this.myRoots.values();
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.getManager().getProject());
        documentManager.commitAllDocuments();
        for (PsiFile root : roots) {
            Document document = documentManager.getDocument(root);
            assert (document != null);
            PsiDocumentManagerBase.checkConsistency(root, document);
            assert (root.getText().equals(document.getText()));
        }
    }

    @NotNull
    public final MultiplePsiFilesPerDocumentFileViewProvider createCopy(@NotNull VirtualFile fileCopy) {
        if (fileCopy == null) {
            MultiplePsiFilesPerDocumentFileViewProvider.$$$reportNull$$$0(4);
        }
        MultiplePsiFilesPerDocumentFileViewProvider copy = this.cloneInner(fileCopy);
        copy.myOriginal = this.myOriginal == null ? this : this.myOriginal;
        MultiplePsiFilesPerDocumentFileViewProvider multiplePsiFilesPerDocumentFileViewProvider = copy;
        if (multiplePsiFilesPerDocumentFileViewProvider == null) {
            MultiplePsiFilesPerDocumentFileViewProvider.$$$reportNull$$$0(5);
        }
        return multiplePsiFilesPerDocumentFileViewProvider;
    }

    protected abstract MultiplePsiFilesPerDocumentFileViewProvider cloneInner(VirtualFile var1);

    @Nullable
    public PsiElement findElementAt(int offset, @NotNull Class<? extends Language> lang) {
        if (lang == null) {
            MultiplePsiFilesPerDocumentFileViewProvider.$$$reportNull$$$0(6);
        }
        PsiFile mainRoot = this.getPsi(this.getBaseLanguage());
        PsiElement ret = null;
        for (Language language : this.getLanguages()) {
            PsiFile psiRoot;
            PsiElement psiElement;
            if (!ReflectionUtil.isAssignable(lang, language.getClass()) || lang.equals(Language.class) && !this.getLanguages().contains(language) || (psiElement = MultiplePsiFilesPerDocumentFileViewProvider.findElementAt((PsiElement)(psiRoot = this.getPsi(language)), offset)) == null || psiElement instanceof OuterLanguageElement || ret != null && psiRoot == mainRoot) continue;
            ret = psiElement;
        }
        return ret;
    }

    @Nullable
    public PsiElement findElementAt(int offset) {
        return this.findElementAt(offset, Language.class);
    }

    @Nullable
    public PsiReference findReferenceAt(int offset) {
        TextRange minRange = new TextRange(0, this.getContents().length());
        PsiReference ret = null;
        for (Language language : this.getLanguages()) {
            TextRange textRange;
            PsiFile psiRoot = this.getPsi(language);
            PsiReference reference = SharedPsiElementImplUtil.findReferenceAt((PsiElement)psiRoot, offset, language);
            if (reference == null || !minRange.contains(textRange = reference.getRangeInElement().shiftRight(reference.getElement().getTextRange().getStartOffset())) || textRange.contains(minRange)) continue;
            minRange = textRange;
            ret = reference;
        }
        return ret;
    }

    @Override
    public void contentsSynchronized() {
        Set languages = this.getLanguages();
        Iterator iterator = this.myRoots.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (languages.contains(entry.getKey())) continue;
            PsiFileImpl file2 = (PsiFileImpl)entry.getValue();
            iterator.remove();
            file2.markInvalidated();
        }
        super.contentsSynchronized();
    }

    @Override
    public final void markInvalidated() {
        for (PsiFileImpl file2 : this.myRoots.values()) {
            file2.markInvalidated();
        }
        super.markInvalidated();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/MultiplePsiFilesPerDocumentFileViewProvider";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileCopy";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lang";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllFiles";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/MultiplePsiFilesPerDocumentFileViewProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getKnownTreeRoots";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createCopy";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getPsiInner";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getCachedPsi";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createCopy";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findElementAt";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

