/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageNamesValidation;
import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.openapi.project.Project;
import com.intellij.refactoring.util.AbstractVariableData;
import com.intellij.ui.BooleanTableCellRenderer;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.EditableModel;
import com.intellij.util.ui.ListTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.function.Predicate;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.DefaultCellEditor;
import javax.swing.InputMap;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractParameterTablePanel<P extends AbstractVariableData>
extends JPanel {
    private P[] myParameterData;
    protected final JBTable myTable;
    private final MyTableModel myTableModel;

    public P[] getVariableData() {
        return this.myParameterData;
    }

    protected abstract void updateSignature();

    protected abstract void doEnterAction();

    protected abstract void doCancelAction();

    protected boolean areTypesDirected() {
        return true;
    }

    public AbstractParameterTablePanel(P[] parameterData, ColumnInfo ... columnInfos) {
        this(columnInfos);
        this.init((AbstractVariableData[])parameterData);
    }

    public AbstractParameterTablePanel(ColumnInfo ... columnInfos) {
        super(new BorderLayout());
        this.myTableModel = new MyTableModel(columnInfos);
        this.myTable = new JBTable((TableModel)((Object)this.myTableModel));
        for (int i = 0; i < columnInfos.length; ++i) {
            if (!(columnInfos[i] instanceof PassParameterColumnInfo)) continue;
            TableUtil.setupCheckboxColumn((JTable)this.myTable, (int)i);
        }
        DefaultCellEditor defaultEditor = (DefaultCellEditor)this.myTable.getDefaultEditor(Object.class);
        defaultEditor.setClickCountToStart(1);
        this.myTable.getSelectionModel().setSelectionMode(0);
        this.myTable.setCellSelectionEnabled(true);
        this.myTable.setPreferredScrollableViewportSize(new Dimension(250, this.myTable.getRowHeight() * 5));
        this.myTable.setShowGrid(false);
        this.myTable.setIntercellSpacing(new Dimension(0, 0));
        InputMap inputMap = this.myTable.getInputMap();
        inputMap.put(KeyStroke.getKeyStroke(32, 0), "enable_disable");
        ActionMap actionMap = this.myTable.getActionMap();
        actionMap.put("enable_disable", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AbstractParameterTablePanel.this.myTable.isEditing()) {
                    return;
                }
                int[] rows = AbstractParameterTablePanel.this.myTable.getSelectedRows();
                if (rows.length > 0) {
                    boolean valueToBeSet = false;
                    for (int row : rows) {
                        if (AbstractParameterTablePanel.this.getVariableData()[row].isPassAsParameter()) continue;
                        valueToBeSet = true;
                        break;
                    }
                    for (int row : rows) {
                        AbstractParameterTablePanel.this.getVariableData()[row].passAsParameter = valueToBeSet;
                    }
                    AbstractParameterTablePanel.this.myTableModel.fireTableRowsUpdated(rows[0], rows[rows.length - 1]);
                    TableUtil.selectRows((JTable)AbstractParameterTablePanel.this.myTable, (int[])rows);
                }
            }
        });
        actionMap.put("doCancel", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableCellEditor editor = AbstractParameterTablePanel.this.myTable.getCellEditor();
                if (editor != null) {
                    editor.stopCellEditing();
                } else {
                    AbstractParameterTablePanel.this.doCancelAction();
                }
            }
        });
        JPanel listPanel = ToolbarDecorator.createDecorator((JTable)this.myTable).disableAddAction().disableRemoveAction().createPanel();
        this.add((Component)listPanel, "Center");
        this.myTableModel.addTableModelListener(e -> this.updateSignature());
    }

    public void init(P[] parameterData) {
        this.myParameterData = parameterData;
        this.myTableModel.setItems(Arrays.asList(parameterData));
        if (parameterData.length > 1) {
            this.myTable.getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.myTable.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    protected void exchangeRows(int row, int targetRow, P currentItem) {
        this.getVariableData()[row] = this.getVariableData()[targetRow];
        this.getVariableData()[targetRow] = currentItem;
    }

    private class MyTableModel
    extends ListTableModel<AbstractVariableData>
    implements EditableModel {
        public MyTableModel(ColumnInfo ... columnInfos) {
            if (columnInfos == null) {
                MyTableModel.$$$reportNull$$$0(0);
            }
            super(columnInfos);
        }

        public void addRow() {
            throw new IllegalAccessError("Not implemented");
        }

        public void removeRow(int index) {
            throw new IllegalAccessError("Not implemented");
        }

        public void exchangeRows(int row, int targetRow) {
            if (row < 0 || row >= AbstractParameterTablePanel.this.getVariableData().length) {
                return;
            }
            if (targetRow < 0 || targetRow >= AbstractParameterTablePanel.this.getVariableData().length) {
                return;
            }
            AbstractVariableData currentItem = AbstractParameterTablePanel.this.getVariableData()[row];
            AbstractParameterTablePanel.this.exchangeRows(row, targetRow, currentItem);
            AbstractParameterTablePanel.this.myTableModel.fireTableRowsUpdated(Math.min(targetRow, row), Math.max(targetRow, row));
            AbstractParameterTablePanel.this.myTable.getSelectionModel().setSelectionInterval(targetRow, targetRow);
            AbstractParameterTablePanel.this.updateSignature();
        }

        public boolean canExchangeRows(int row, int targetRow) {
            if (row < 0 || row >= AbstractParameterTablePanel.this.getVariableData().length) {
                return false;
            }
            return targetRow >= 0 && targetRow < AbstractParameterTablePanel.this.getVariableData().length;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnInfos", "com/intellij/refactoring/util/AbstractParameterTablePanel$MyTableModel", "<init>"));
        }
    }

    public static class PassParameterColumnInfo
    extends ColumnInfo<AbstractVariableData, Boolean> {
        public PassParameterColumnInfo() {
            super("");
        }

        @Nullable
        public TableCellRenderer getRenderer(AbstractVariableData data) {
            return new BooleanTableCellRenderer();
        }

        @Nullable
        public Boolean valueOf(AbstractVariableData data) {
            return data.isPassAsParameter();
        }

        public void setValue(AbstractVariableData data, Boolean value) {
            data.passAsParameter = value;
        }

        public boolean isCellEditable(AbstractVariableData data) {
            return true;
        }

        public Class<?> getColumnClass() {
            return Boolean.class;
        }
    }

    public static class NameColumnInfo
    extends ColumnInfo<AbstractVariableData, String> {
        private final Predicate<String> myNameValidator;

        public NameColumnInfo(Predicate<String> nameValidator) {
            super("Name");
            this.myNameValidator = nameValidator;
        }

        public NameColumnInfo(Language lang, Project project) {
            super("Name");
            this.myNameValidator = paramName -> ((NamesValidator)LanguageNamesValidation.INSTANCE.forLanguage(lang)).isIdentifier(paramName, project);
        }

        @Nullable
        public String valueOf(AbstractVariableData data) {
            return data.getName();
        }

        public void setValue(AbstractVariableData data, String value) {
            if (this.myNameValidator.test(value)) {
                data.name = value;
            }
        }

        public boolean isCellEditable(AbstractVariableData data) {
            return true;
        }
    }
}

