/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tree;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.LoadingNode;
import com.intellij.ui.tree.AbstractTreeWalker;
import com.intellij.ui.tree.ChildrenProvider;
import com.intellij.ui.tree.Identifiable;
import com.intellij.ui.tree.Navigatable;
import com.intellij.ui.tree.Searchable;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.Command;
import com.intellij.util.concurrency.Invoker;
import com.intellij.util.concurrency.InvokerSupplier;
import com.intellij.util.containers.SmartHashSet;
import com.intellij.util.ui.tree.AbstractTreeModel;
import com.intellij.util.ui.tree.TreeModelAdapter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Obsolescent;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public final class AsyncTreeModel
extends AbstractTreeModel
implements Identifiable,
Searchable,
Navigatable,
TreeVisitor.Acceptor {
    private static final Logger LOG = Logger.getInstance(AsyncTreeModel.class);
    private final Command.Processor processor;
    private final Tree tree;
    private final TreeModel model;
    private final boolean showLoadingNode;
    private final TreeModelListener listener;

    public AsyncTreeModel(@NotNull TreeModel model) {
        if (model == null) {
            AsyncTreeModel.$$$reportNull$$$0(0);
        }
        this(model, false);
    }

    public AsyncTreeModel(@NotNull TreeModel model, boolean showLoadingNode) {
        Invoker.EDT foreground;
        if (model == null) {
            AsyncTreeModel.$$$reportNull$$$0(1);
        }
        this.tree = new Tree();
        this.listener = new TreeModelAdapter(){

            protected void process(TreeModelEvent event, TreeModelAdapter.EventType type) {
                TreePath path = event.getTreePath();
                if (path == null) {
                    AsyncTreeModel.this.processor.process(new CmdGetRoot("Reload root", null));
                    return;
                }
                Object object = path.getLastPathComponent();
                if (object == null) {
                    LOG.warn("unsupported path: " + path);
                    return;
                }
                if (path.getParentPath() == null && type == TreeModelAdapter.EventType.StructureChanged) {
                    AsyncTreeModel.this.processor.process(new CmdGetRoot("Update root", object));
                    return;
                }
                AsyncTreeModel.this.onValidThread(() -> {
                    Node node = (Node)AsyncTreeModel.this.tree.map.get(object);
                    if (node == null || node.isLoadingRequired()) {
                        LOG.debug("ignore updating of nonexistent node: ", new Object[]{object});
                    } else if (type == TreeModelAdapter.EventType.NodesChanged) {
                        AsyncTreeModel.this.treeNodesChanged(event.getTreePath(), event.getChildIndices(), event.getChildren());
                    } else if (type == TreeModelAdapter.EventType.NodesInserted) {
                        AsyncTreeModel.this.processor.process(new CmdGetChildren("Insert children", node, false));
                    } else if (type == TreeModelAdapter.EventType.NodesRemoved) {
                        AsyncTreeModel.this.processor.process(new CmdGetChildren("Remove children", node, false));
                    } else {
                        AsyncTreeModel.this.processor.process(new CmdGetChildren("Update children", node, true));
                    }
                });
            }
        };
        if (model instanceof Disposable) {
            Disposer.register((Disposable)this, (Disposable)((Disposable)model));
        }
        Invoker background = foreground = new Invoker.EDT((Disposable)this);
        if (model instanceof InvokerSupplier) {
            InvokerSupplier supplier = (InvokerSupplier)((Object)model);
            background = supplier.getInvoker();
        }
        this.processor = new Command.Processor(foreground, background);
        this.model = model;
        this.model.addTreeModelListener(this.listener);
        this.showLoadingNode = showLoadingNode;
    }

    public void dispose() {
        super.dispose();
        this.model.removeTreeModelListener(this.listener);
    }

    @Override
    public Object getUniqueID(@NotNull TreePath path) {
        if (path == null) {
            AsyncTreeModel.$$$reportNull$$$0(2);
        }
        return this.model instanceof Identifiable ? ((Identifiable)((Object)this.model)).getUniqueID(path) : null;
    }

    @Override
    @NotNull
    public Promise<TreePath> getTreePath(Object object) {
        if (this.disposed) {
            Promise promise2 = Promises.rejectedPromise();
            if (promise2 == null) {
                AsyncTreeModel.$$$reportNull$$$0(3);
            }
            return promise2;
        }
        Promise<TreePath> promise3 = this.resolve(this.model instanceof Searchable ? ((Searchable)((Object)this.model)).getTreePath(object) : null);
        if (promise3 == null) {
            AsyncTreeModel.$$$reportNull$$$0(4);
        }
        return promise3;
    }

    @Override
    @NotNull
    public Promise<TreePath> nextTreePath(@NotNull TreePath path, Object object) {
        if (path == null) {
            AsyncTreeModel.$$$reportNull$$$0(5);
        }
        if (this.disposed) {
            Promise promise2 = Promises.rejectedPromise();
            if (promise2 == null) {
                AsyncTreeModel.$$$reportNull$$$0(6);
            }
            return promise2;
        }
        Promise<TreePath> promise3 = this.resolve(this.model instanceof Navigatable ? ((Navigatable)((Object)this.model)).nextTreePath(path, object) : null);
        if (promise3 == null) {
            AsyncTreeModel.$$$reportNull$$$0(7);
        }
        return promise3;
    }

    @Override
    @NotNull
    public Promise<TreePath> prevTreePath(@NotNull TreePath path, Object object) {
        if (path == null) {
            AsyncTreeModel.$$$reportNull$$$0(8);
        }
        if (this.disposed) {
            Promise promise2 = Promises.rejectedPromise();
            if (promise2 == null) {
                AsyncTreeModel.$$$reportNull$$$0(9);
            }
            return promise2;
        }
        Promise<TreePath> promise3 = this.resolve(this.model instanceof Navigatable ? ((Navigatable)((Object)this.model)).prevTreePath(path, object) : null);
        if (promise3 == null) {
            AsyncTreeModel.$$$reportNull$$$0(10);
        }
        return promise3;
    }

    @NotNull
    public Promise<TreePath> resolve(TreePath path) {
        AsyncPromise async = new AsyncPromise();
        this.onValidThread(() -> this.resolve((AsyncPromise<TreePath>)async, path));
        AsyncPromise asyncPromise = async;
        if (asyncPromise == null) {
            AsyncTreeModel.$$$reportNull$$$0(11);
        }
        return asyncPromise;
    }

    private Promise<TreePath> resolve(Promise<TreePath> promise2) {
        if (promise2 == null && this.isValidThread()) {
            return Promises.rejectedPromise();
        }
        AsyncPromise async = new AsyncPromise();
        if (promise2 == null) {
            this.onValidThread(() -> async.setError("rejected"));
        } else {
            promise2.rejected(this.onValidThread(arg_0 -> ((AsyncPromise)async).setError(arg_0)));
            promise2.done(this.onValidThread(path -> this.resolve((AsyncPromise<TreePath>)async, (TreePath)path)));
        }
        return async;
    }

    private void resolve(AsyncPromise<TreePath> async, TreePath path) {
        LOG.debug("resolve path: ", new Object[]{path});
        if (path == null) {
            async.setError("path is null");
            return;
        }
        Object object = path.getLastPathComponent();
        if (object == null) {
            async.setError("path is wrong");
            return;
        }
        this.accept((TreeVisitor)new TreeVisitor.PathFinder(path)).processed(result2 -> {
            if (result2 == null) {
                async.setError("path not found");
                return;
            }
            async.setResult(result2);
        });
    }

    public Object getRoot() {
        if (this.disposed || !this.isValidThread()) {
            return null;
        }
        this.promiseRootEntry();
        Node node = this.tree.root;
        return node == null ? null : node.object;
    }

    public Object getChild(Object object, int index) {
        List<Node> children2 = this.getEntryChildren(object);
        return 0 <= index && index < children2.size() ? children2.get(index).object : null;
    }

    public int getChildCount(Object object) {
        return this.getEntryChildren(object).size();
    }

    public boolean isLeaf(Object object) {
        Node node = this.getEntry(object);
        return node == null || node.leaf;
    }

    public void valueForPathChanged(TreePath path, Object value) {
        this.processor.background.invokeLaterIfNeeded(() -> this.model.valueForPathChanged(path, value));
    }

    public int getIndexOfChild(Object object, Object child) {
        if (child != null) {
            List<Node> children2 = this.getEntryChildren(object);
            for (int i = 0; i < children2.size(); ++i) {
                if (!child.equals(children2.get(i).object)) continue;
                return i;
            }
        }
        return -1;
    }

    @NotNull
    public Promise<TreePath> accept(@NotNull TreeVisitor visitor2) {
        if (visitor2 == null) {
            AsyncTreeModel.$$$reportNull$$$0(12);
        }
        Promise<TreePath> promise2 = this.accept(visitor2, true);
        if (promise2 == null) {
            AsyncTreeModel.$$$reportNull$$$0(13);
        }
        return promise2;
    }

    @NotNull
    public Promise<TreePath> accept(@NotNull TreeVisitor visitor2, final boolean allowLoading) {
        if (visitor2 == null) {
            AsyncTreeModel.$$$reportNull$$$0(14);
        }
        AbstractTreeWalker<Node> walker = new AbstractTreeWalker<Node>(visitor2, node -> ((Node)node).object){

            @Override
            protected Collection<Node> getChildren(@NotNull Node node) {
                if (node == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (node.leaf || !allowLoading) {
                    return node.getChildren();
                }
                AsyncTreeModel.this.promiseChildren(node).done(parent -> this.setChildren(((Node)parent).getChildren())).rejected(this::setError);
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/ui/tree/AsyncTreeModel$2", "getChildren"));
            }
        };
        this.onValidThread(() -> {
            if (allowLoading) {
                this.promiseRootEntry().done(walker::start).rejected(walker::setError);
            } else {
                walker.start(this.tree.root);
            }
        });
        Promise<TreePath> promise2 = walker.promise();
        if (promise2 == null) {
            AsyncTreeModel.$$$reportNull$$$0(15);
        }
        return promise2;
    }

    public boolean isProcessing() {
        return this.processor.getTaskCount() > 0 || ((CmdGetRoot)this.tree.queue.get()).isPending();
    }

    private boolean isValidThread() {
        if (this.processor.foreground.isValidThread()) {
            return true;
        }
        LOG.warn("AsyncTreeModel is used from unexpected thread");
        return false;
    }

    public void onValidThread(Runnable runnable2) {
        this.processor.foreground.invokeLaterIfNeeded(runnable2);
    }

    @NotNull
    private <T> Consumer<T> onValidThread(Consumer<T> consumer) {
        Consumer consumer2 = value -> this.onValidThread(() -> consumer.consume(value));
        if (consumer2 == null) {
            AsyncTreeModel.$$$reportNull$$$0(16);
        }
        return consumer2;
    }

    @NotNull
    private Promise<Node> promiseRootEntry() {
        if (this.disposed) {
            Promise promise2 = Promises.rejectedPromise();
            if (promise2 == null) {
                AsyncTreeModel.$$$reportNull$$$0(17);
            }
            return promise2;
        }
        Promise<Node> promise3 = this.tree.queue.promise(this.processor, () -> new CmdGetRoot("Load root", null));
        if (promise3 == null) {
            AsyncTreeModel.$$$reportNull$$$0(18);
        }
        return promise3;
    }

    @NotNull
    private Promise<Node> promiseChildren(@NotNull Node node) {
        if (node == null) {
            AsyncTreeModel.$$$reportNull$$$0(19);
        }
        if (this.disposed) {
            Promise promise2 = Promises.rejectedPromise();
            if (promise2 == null) {
                AsyncTreeModel.$$$reportNull$$$0(20);
            }
            return promise2;
        }
        Promise<Node> promise3 = node.queue.promise(this.processor, () -> {
            if (node == null) {
                AsyncTreeModel.$$$reportNull$$$0(27);
            }
            node.setLoading(!this.showLoadingNode ? null : new Node(new LoadingNode(), true));
            return new CmdGetChildren("Load children", node, false);
        });
        if (promise3 == null) {
            AsyncTreeModel.$$$reportNull$$$0(21);
        }
        return promise3;
    }

    private Node getEntry(Object object) {
        return this.disposed || object == null || !this.isValidThread() ? null : (Node)this.tree.map.get(object);
    }

    @NotNull
    private List<Node> getEntryChildren(Object object) {
        Node node = this.getEntry(object);
        if (node == null) {
            List<Node> list2 = Collections.emptyList();
            if (list2 == null) {
                AsyncTreeModel.$$$reportNull$$$0(22);
            }
            return list2;
        }
        if (node.isLoadingRequired()) {
            this.promiseChildren(node);
        }
        List list3 = node.getChildren();
        if (list3 == null) {
            AsyncTreeModel.$$$reportNull$$$0(23);
        }
        return list3;
    }

    private TreeModelEvent createEvent(TreePath path, LinkedHashMap<Object, Integer> map2) {
        if (map2 == null || map2.isEmpty()) {
            return new TreeModelEvent((Object)this, path, null, null);
        }
        int i = 0;
        int size = map2.size();
        int[] indices = new int[size];
        Object[] children2 = new Object[size];
        for (Map.Entry<Object, Integer> entry : map2.entrySet()) {
            indices[i] = entry.getValue();
            children2[i] = entry.getKey();
            ++i;
        }
        return new TreeModelEvent((Object)this, path, indices, children2);
    }

    private void treeNodesChanged(Node node, LinkedHashMap<Object, Integer> map2) {
        if (!this.listeners.isEmpty()) {
            for (TreePath path : node.paths) {
                this.listeners.treeNodesChanged(this.createEvent(path, map2));
            }
        }
    }

    private void treeNodesInserted(Node node, LinkedHashMap<Object, Integer> map2) {
        if (!this.listeners.isEmpty()) {
            for (TreePath path : node.paths) {
                this.listeners.treeNodesInserted(this.createEvent(path, map2));
            }
        }
    }

    private void treeNodesRemoved(Node node, LinkedHashMap<Object, Integer> map2) {
        if (!this.listeners.isEmpty()) {
            for (TreePath path : node.paths) {
                this.listeners.treeNodesRemoved(this.createEvent(path, map2));
            }
        }
    }

    @NotNull
    private static LinkedHashMap<Object, Integer> getIndices(@NotNull List<Node> children2, ToIntFunction<Node> function) {
        if (children2 == null) {
            AsyncTreeModel.$$$reportNull$$$0(24);
        }
        LinkedHashMap<Object, Integer> map2 = new LinkedHashMap<Object, Integer>();
        for (int i = 0; i < children2.size(); ++i) {
            Node child = children2.get(i);
            if (map2.containsKey(child.object)) {
                LOG.warn("ignore duplicated " + (function == null ? "old" : "new") + " child at " + i);
                continue;
            }
            map2.put(child.object, function == null ? i : function.applyAsInt(child));
        }
        LinkedHashMap<Object, Integer> linkedHashMap = map2;
        if (linkedHashMap == null) {
            AsyncTreeModel.$$$reportNull$$$0(25);
        }
        return linkedHashMap;
    }

    private static int getIntersectionCount(LinkedHashMap<Object, Integer> indices, Iterable<Object> objects) {
        int count = 0;
        int last = -1;
        for (Object object : objects) {
            Integer index = indices.get(object);
            if (index == null || last >= index) continue;
            last = index;
            ++count;
        }
        return count;
    }

    private static List<Object> getIntersection(LinkedHashMap<Object, Integer> indices, Iterable<Object> objects) {
        ArrayList<Object> list2 = new ArrayList<Object>(indices.size());
        int last = -1;
        for (Object object : objects) {
            Integer index = indices.get(object);
            if (index == null || last >= index) continue;
            last = index;
            list2.add(object);
        }
        return list2;
    }

    private static List<Object> getIntersection(LinkedHashMap<Object, Integer> removed, LinkedHashMap<Object, Integer> inserted) {
        int countTwo;
        if (removed.isEmpty() || inserted.isEmpty()) {
            return Collections.emptyList();
        }
        int countOne = AsyncTreeModel.getIntersectionCount(removed, inserted.keySet());
        if (countOne > (countTwo = AsyncTreeModel.getIntersectionCount(inserted, removed.keySet()))) {
            return AsyncTreeModel.getIntersection(removed, inserted.keySet());
        }
        if (countTwo > 0) {
            return AsyncTreeModel.getIntersection(inserted, removed.keySet());
        }
        return Collections.emptyList();
    }

    @Deprecated
    public void setRootImmediately(@NotNull Object object) {
        if (object == null) {
            AsyncTreeModel.$$$reportNull$$$0(26);
        }
        Node node = new Node(object, false);
        node.insertPath(new TreePath(object));
        this.tree.root = node;
        this.tree.map.put(object, node);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/tree/AsyncTreeModel";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 19: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/tree/AsyncTreeModel";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreePath";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "nextTreePath";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "prevTreePath";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "resolve";
                break;
            }
            case 13: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "accept";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "onValidThread";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "promiseRootEntry";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "promiseChildren";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getEntryChildren";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndices";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getUniqueID";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "nextTreePath";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "prevTreePath";
                break;
            }
            case 12: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "promiseChildren";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getIndices";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "setRootImmediately";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "lambda$promiseChildren$10";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class Node {
        private final CommandQueue<CmdGetChildren> queue;
        private final Set<TreePath> paths;
        private final Object object;
        private volatile boolean leaf;
        private volatile List<Node> children;
        private volatile Node loading;

        private Node(@NotNull Object object, boolean leaf) {
            if (object == null) {
                Node.$$$reportNull$$$0(0);
            }
            this.queue = new CommandQueue();
            this.paths = new SmartHashSet();
            this.object = object;
            this.leaf = leaf;
        }

        private void setLeaf(boolean leaf) {
            this.leaf = leaf;
            this.children = leaf ? null : Collections.emptyList();
            this.loading = null;
        }

        private void setChildren(List<Node> children2) {
            this.leaf = children2 == null;
            this.children = children2;
            this.loading = null;
        }

        private void setLoading(Node loading) {
            this.leaf = false;
            this.children = loading != null ? Collections.singletonList(loading) : Collections.emptyList();
            this.loading = loading;
        }

        private boolean isLoadingRequired() {
            return !this.leaf && this.children == null;
        }

        @NotNull
        private List<Node> getChildren() {
            List<Node> list2 = this.children;
            List<Node> list3 = list2 != null ? list2 : Collections.emptyList();
            if (list3 == null) {
                Node.$$$reportNull$$$0(1);
            }
            return list3;
        }

        private void forEachChildExceptLoading(Consumer<Node> consumer) {
            for (Node node : this.getChildren()) {
                if (node == this.loading) continue;
                consumer.consume((Object)node);
            }
        }

        private void insertPath(TreePath path) {
            if (!this.paths.add(path)) {
                LOG.warn("node is already attached to " + path);
            }
            this.forEachChildExceptLoading((Consumer<Node>)((Consumer)child -> child.insertPath(path.pathByAddingChild(child.object))));
        }

        private void insertMapping(Node parent) {
            if (parent == null) {
                this.insertPath(new TreePath(this.object));
            } else if (parent.loading == this) {
                LOG.warn("insert loading node unexpectedly");
            } else if (parent.paths.isEmpty()) {
                LOG.warn("insert to invalid parent");
            } else {
                parent.paths.forEach(path -> this.insertPath(path.pathByAddingChild(this.object)));
            }
        }

        private void removePath(TreePath path) {
            if (!this.paths.remove(path)) {
                LOG.warn("node is not attached to " + path);
            }
            this.forEachChildExceptLoading((Consumer<Node>)((Consumer)child -> child.removePath(path.pathByAddingChild(child.object))));
        }

        private void removeMapping(Node parent, Tree tree) {
            if (parent == null) {
                this.removePath(new TreePath(this.object));
                tree.removeEmpty(this);
            } else if (parent.loading == this) {
                parent.loading = null;
            } else if (parent.paths.isEmpty()) {
                LOG.warn("remove from invalid parent");
            } else {
                parent.paths.forEach(path -> this.removePath(path.pathByAddingChild(this.object)));
                tree.removeEmpty(this);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/tree/AsyncTreeModel$Node";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/tree/AsyncTreeModel$Node";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class Tree {
        private final CommandQueue<CmdGetRoot> queue = new CommandQueue();
        private final HashMap<Object, Node> map = new HashMap();
        private volatile Node root;

        private Tree() {
        }

        private void removeEmpty(@NotNull Node child) {
            if (child == null) {
                Tree.$$$reportNull$$$0(0);
            }
            child.forEachChildExceptLoading((Consumer<Node>)this::removeEmpty);
            if (child.paths.isEmpty()) {
                child.queue.close();
                Node node = this.map.remove(child.object);
                if (node != child) {
                    LOG.warn("invalid node: " + child.object);
                    if (node != null) {
                        this.map.put(node.object, node);
                    }
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/ui/tree/AsyncTreeModel$Tree", "removeEmpty"));
        }
    }

    private static final class CommandQueue<T extends ObsolescentCommand> {
        private final ArrayDeque<T> deque = new ArrayDeque();
        private volatile boolean closed;

        private CommandQueue() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        T get() {
            ArrayDeque<T> arrayDeque = this.deque;
            synchronized (arrayDeque) {
                return (T)((ObsolescentCommand)this.deque.peekFirst());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @NotNull
        Promise<Node> promise(@NotNull Command.Processor processor2, @NotNull Supplier<T> supplier) {
            ObsolescentCommand command;
            if (processor2 == null) {
                CommandQueue.$$$reportNull$$$0(0);
            }
            if (supplier == null) {
                CommandQueue.$$$reportNull$$$0(1);
            }
            ArrayDeque<T> arrayDeque = this.deque;
            synchronized (arrayDeque) {
                command = (ObsolescentCommand)this.deque.peekFirst();
                if (command != null) {
                    AsyncPromise<Node> asyncPromise = command.promise;
                    // MONITOREXIT @DISABLED, blocks:[2, 5] lbl10 : MonitorExitStatement: MONITOREXIT : var4_3
                    if (asyncPromise == null) {
                        CommandQueue.$$$reportNull$$$0(2);
                    }
                    return asyncPromise;
                }
                command = (ObsolescentCommand)supplier.get();
            }
            processor2.process(command);
            AsyncPromise<Node> asyncPromise = command.promise;
            if (asyncPromise == null) {
                CommandQueue.$$$reportNull$$$0(3);
            }
            return asyncPromise;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void add(@NotNull T command, @NotNull Predicate<T> predicate) {
            if (command == null) {
                CommandQueue.$$$reportNull$$$0(4);
            }
            if (predicate == null) {
                CommandQueue.$$$reportNull$$$0(5);
            }
            ArrayDeque<T> arrayDeque = this.deque;
            synchronized (arrayDeque) {
                boolean add;
                if (this.closed) {
                    return;
                }
                ObsolescentCommand old = (ObsolescentCommand)this.deque.peekFirst();
                boolean bl = add = old == null || predicate.test(old);
                if (add) {
                    this.deque.addFirst(command);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void done(T command, Node node) {
            Iterable<AsyncPromise<Node>> promises;
            ArrayDeque<T> arrayDeque = this.deque;
            synchronized (arrayDeque) {
                if (this.closed) {
                    return;
                }
                if (!this.deque.contains(command)) {
                    return;
                }
                promises = this.getPromises(command);
                if (this.deque.isEmpty()) {
                    this.deque.addLast(command);
                }
            }
            promises.forEach(promise2 -> promise2.setResult((Object)node));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void close() {
            Iterable<AsyncPromise<Node>> promises;
            ArrayDeque<T> arrayDeque = this.deque;
            synchronized (arrayDeque) {
                if (this.closed) {
                    return;
                }
                this.closed = true;
                if (this.deque.isEmpty()) {
                    return;
                }
                promises = this.getPromises(null);
            }
            promises.forEach(promise2 -> promise2.setError("cancel loading"));
        }

        private Iterable<AsyncPromise<Node>> getPromises(T command) {
            ObsolescentCommand last;
            ArrayList<AsyncPromise<Node>> list2 = new ArrayList<AsyncPromise<Node>>();
            while ((last = (ObsolescentCommand)this.deque.pollLast()) != null) {
                if (last.isPending()) {
                    list2.add(last.promise);
                }
                if (!last.equals(command)) continue;
                break;
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "supplier";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/tree/AsyncTreeModel$CommandQueue";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "command";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "predicate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/tree/AsyncTreeModel$CommandQueue";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "promise";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "promise";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "add";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private final class CmdGetChildren
    extends ObsolescentCommand {
        private final Node node;
        private volatile boolean deep;

        public CmdGetChildren(String name, Node node, boolean deep) {
            super(name, node.object);
            this.node = node;
            if (deep) {
                this.deep = true;
            }
            node.queue.add(this, old -> {
                if (!deep && old.deep && old.isPending()) {
                    this.deep = true;
                }
                return true;
            });
        }

        public boolean isObsolete() {
            return AsyncTreeModel.this.disposed || this != this.node.queue.get();
        }

        @Override
        Node getNode(Object object) {
            Node loaded = new Node(object, AsyncTreeModel.this.model.isLeaf(object));
            if (loaded.leaf || this.isObsolete()) {
                return loaded;
            }
            if (AsyncTreeModel.this.model instanceof ChildrenProvider) {
                ChildrenProvider provider = (ChildrenProvider)((Object)AsyncTreeModel.this.model);
                List children2 = provider.getChildren(object);
                if (children2 == null) {
                    throw new ProcessCanceledException();
                }
                loaded.children = this.load(children2.size(), index -> children2.get(index));
            } else {
                loaded.children = this.load(AsyncTreeModel.this.model.getChildCount(object), index -> AsyncTreeModel.this.model.getChild(object, index));
            }
            return loaded;
        }

        private List<Node> load(int count, IntFunction function) {
            if (count < 0) {
                LOG.warn("illegal child count: " + count);
            }
            if (count <= 0) {
                return Collections.emptyList();
            }
            SmartHashSet set2 = new SmartHashSet(count);
            ArrayList<Node> children2 = new ArrayList<Node>(count);
            for (int i = 0; i < count; ++i) {
                if (this.isObsolete()) {
                    return null;
                }
                Object child = function.apply(i);
                if (child == null) {
                    LOG.warn("ignore null child at " + i);
                    continue;
                }
                if (!set2.add(child)) {
                    LOG.warn("ignore duplicated child at " + i);
                    continue;
                }
                if (this.isObsolete()) {
                    return null;
                }
                children2.add(new Node(child, AsyncTreeModel.this.model.isLeaf(child)));
            }
            return children2;
        }

        @Override
        void setNode(Node loaded) {
            if (loaded == null || loaded.isLoadingRequired()) {
                LOG.debug("cancelled command: ", new Object[]{this});
                return;
            }
            if (this.node != AsyncTreeModel.this.tree.map.get(loaded.object)) {
                this.node.queue.close();
                LOG.warn("ignore removed node: " + this.node.object);
                return;
            }
            List oldChildren = this.node.getChildren();
            ArrayList newChildren = loaded.getChildren();
            if (oldChildren.isEmpty() && newChildren.isEmpty()) {
                this.node.setLeaf(loaded.leaf);
                AsyncTreeModel.this.treeNodesChanged(this.node, null);
                LOG.debug("no children: ", new Object[]{this.node.object});
                this.node.queue.done(this, this.node);
                return;
            }
            LinkedHashMap removed = AsyncTreeModel.getIndices(oldChildren, null);
            if (newChildren.isEmpty()) {
                oldChildren.forEach(child -> ((Node)child).removeMapping(this.node, AsyncTreeModel.this.tree));
                this.node.setLeaf(loaded.leaf);
                AsyncTreeModel.this.treeNodesRemoved(this.node, removed);
                LOG.debug("children removed: ", new Object[]{this.node.object});
                this.node.queue.done(this, this.node);
                return;
            }
            ArrayList list2 = new ArrayList(newChildren.size());
            SmartHashSet reload = new SmartHashSet();
            LinkedHashMap inserted = AsyncTreeModel.getIndices(newChildren, child -> {
                Node found = (Node)AsyncTreeModel.this.tree.map.get(((Node)child).object);
                if (found == null) {
                    AsyncTreeModel.this.tree.map.put(((Node)child).object, child);
                    list2.add(child);
                } else {
                    list2.add(found);
                    if (found.leaf) {
                        if (!((Node)child).leaf) {
                            found.setLeaf(false);
                            reload.add(found.object);
                        }
                    } else if (((Node)child).leaf || !found.isLoadingRequired() && (this.deep || !removed.containsKey(found.object))) {
                        reload.add(found.object);
                    }
                }
                return list2.size() - 1;
            });
            newChildren = list2;
            if (oldChildren.isEmpty()) {
                newChildren.forEach(child -> ((Node)child).insertMapping(this.node));
                this.node.setChildren(newChildren);
                AsyncTreeModel.this.treeNodesInserted(this.node, inserted);
                LOG.debug("children inserted: ", new Object[]{this.node.object});
                this.node.queue.done(this, this.node);
                return;
            }
            LinkedHashMap contained = new LinkedHashMap();
            for (Object object : AsyncTreeModel.getIntersection((LinkedHashMap<Object, Integer>)removed, inserted)) {
                Integer newIndex;
                Integer oldIndex = (Integer)removed.remove(object);
                if (oldIndex == null) {
                    LOG.warn("intersection failed");
                }
                if ((newIndex = (Integer)inserted.remove(object)) == null) {
                    LOG.warn("intersection failed");
                    continue;
                }
                contained.put(object, newIndex);
            }
            for (Node child2 : newChildren) {
                if (removed.containsKey(child2.object) || !inserted.containsKey(child2.object)) continue;
                child2.insertMapping(this.node);
            }
            for (Node child2 : oldChildren) {
                if (!removed.containsKey(child2.object) || inserted.containsKey(child2.object)) continue;
                child2.removeMapping(this.node, AsyncTreeModel.this.tree);
            }
            this.node.setChildren(newChildren);
            if (!removed.isEmpty()) {
                AsyncTreeModel.this.treeNodesRemoved(this.node, removed);
            }
            if (!inserted.isEmpty()) {
                AsyncTreeModel.this.treeNodesInserted(this.node, inserted);
            }
            if (!contained.isEmpty()) {
                AsyncTreeModel.this.treeNodesChanged(this.node, contained);
            }
            LOG.debug("children changed: ", new Object[]{this.node.object});
            if (!reload.isEmpty()) {
                for (Node child2 : newChildren) {
                    if (child2.isLoadingRequired() || !reload.contains(child2.object)) continue;
                    AsyncTreeModel.this.processor.process(new CmdGetChildren("Update children recursively", child2, true));
                }
            }
            this.node.queue.done(this, this.node);
        }
    }

    private final class CmdGetRoot
    extends ObsolescentCommand {
        private CmdGetRoot(String name, Object object) {
            super(name, object);
            AsyncTreeModel.this.tree.queue.add(this, old -> old.started || old.object != object);
        }

        public boolean isObsolete() {
            return AsyncTreeModel.this.disposed || this != AsyncTreeModel.this.tree.queue.get();
        }

        @Override
        Node getNode(Object object) {
            if (object == null) {
                object = AsyncTreeModel.this.model.getRoot();
            }
            if (object == null || this.isObsolete()) {
                return null;
            }
            return new Node(object, AsyncTreeModel.this.model.isLeaf(object));
        }

        @Override
        void setNode(Node loaded) {
            Node root = AsyncTreeModel.this.tree.root;
            if (root == null && loaded == null) {
                LOG.debug("no root");
                AsyncTreeModel.this.tree.queue.done(this, null);
                return;
            }
            if (root != null && loaded != null && root.object.equals(loaded.object)) {
                LOG.debug("same root: ", new Object[]{root.object});
                if (!root.isLoadingRequired()) {
                    AsyncTreeModel.this.processor.process(new CmdGetChildren("Update root children", root, true));
                }
                AsyncTreeModel.this.tree.queue.done(this, root);
                return;
            }
            if (root != null) {
                root.removeMapping(null, AsyncTreeModel.this.tree);
            }
            if (!AsyncTreeModel.this.tree.map.isEmpty()) {
                AsyncTreeModel.this.tree.map.values().forEach(node -> {
                    ((Node)node).queue.close();
                    LOG.warn("remove staled node: " + ((Node)node).object);
                });
                AsyncTreeModel.this.tree.map.clear();
            }
            AsyncTreeModel.this.tree.root = loaded;
            if (loaded != null) {
                AsyncTreeModel.this.tree.map.put(loaded.object, loaded);
                TreePath path = new TreePath(loaded.object);
                loaded.insertPath(path);
                AsyncTreeModel.this.treeStructureChanged(path, null, null);
                LOG.debug("new root: ", new Object[]{loaded.object});
                AsyncTreeModel.this.tree.queue.done(this, loaded);
            } else {
                AsyncTreeModel.this.treeStructureChanged(null, null, null);
                LOG.debug("root removed");
                AsyncTreeModel.this.tree.queue.done(this, null);
            }
        }
    }

    private static abstract class ObsolescentCommand
    implements Obsolescent,
    Command<Node> {
        final AsyncPromise<Node> promise = new AsyncPromise();
        final String name;
        final Object object;
        volatile boolean started;

        ObsolescentCommand(String name, Object object) {
            this.name = name;
            this.object = object;
            LOG.debug("create command: ", new Object[]{this});
        }

        abstract Node getNode(Object var1);

        abstract void setNode(Node var1);

        boolean isPending() {
            return Promise.State.PENDING == this.promise.getState();
        }

        public String toString() {
            return this.object == null ? this.name : this.name + ": " + this.object;
        }

        @Override
        public Node get() {
            this.started = true;
            if (this.isObsolete()) {
                LOG.debug("obsolete command: ", new Object[]{this});
                return null;
            }
            LOG.debug("background command: ", new Object[]{this});
            return this.getNode(this.object);
        }

        @Override
        public void accept(Node node) {
            if (this.isObsolete()) {
                LOG.debug("obsolete command: ", new Object[]{this});
            } else {
                LOG.debug("foreground command: ", new Object[]{this});
                this.setNode(node);
            }
        }
    }
}

