/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.filter;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.vcs.ui.FlatSpeedSearchPopup;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLogUserFilter;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.ui.filter.FilterModel;
import com.intellij.vcs.log.ui.filter.MultipleValueFilterPopupComponent;
import com.intellij.vcs.log.util.VcsUserUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class UserFilterPopupComponent
extends MultipleValueFilterPopupComponent<VcsLogUserFilter> {
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private final List<String> myAllUsers;

    UserFilterPopupComponent(@NotNull MainVcsLogUiProperties uiProperties, @NotNull VcsLogData logData, @NotNull FilterModel<VcsLogUserFilter> filterModel) {
        if (uiProperties == null) {
            UserFilterPopupComponent.$$$reportNull$$$0(0);
        }
        if (logData == null) {
            UserFilterPopupComponent.$$$reportNull$$$0(1);
        }
        if (filterModel == null) {
            UserFilterPopupComponent.$$$reportNull$$$0(2);
        }
        super("User", uiProperties, filterModel);
        this.myLogData = logData;
        this.myAllUsers = UserFilterPopupComponent.collectUsers(logData);
    }

    @Override
    @NotNull
    protected String getText(@NotNull VcsLogUserFilter filter2) {
        if (filter2 == null) {
            UserFilterPopupComponent.$$$reportNull$$$0(3);
        }
        String string = UserFilterPopupComponent.displayableText(this.myFilterModel.getFilterValues(filter2));
        if (string == null) {
            UserFilterPopupComponent.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    @Nullable
    protected String getToolTip(@NotNull VcsLogUserFilter filter2) {
        if (filter2 == null) {
            UserFilterPopupComponent.$$$reportNull$$$0(5);
        }
        return UserFilterPopupComponent.tooltip(this.myFilterModel.getFilterValues(filter2));
    }

    @Override
    protected ActionGroup createActionGroup() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add(this.createAllAction());
        group.add(this.createSelectMultipleValuesAction());
        if (!this.myLogData.getCurrentUser().isEmpty()) {
            group.add((AnAction)new MultipleValueFilterPopupComponent.PredefinedValueAction((MultipleValueFilterPopupComponent)this, "me"));
        }
        group.addAll(this.createRecentItemsActionGroup());
        return group;
    }

    @NotNull
    protected ActionGroup createSpeedSearchActionGroup() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new SpeedsearchPredefinedValueAction("me"));
        group.add((AnAction)Separator.getInstance());
        for (String user : this.myAllUsers) {
            group.add((AnAction)new SpeedsearchPredefinedValueAction(user));
        }
        DefaultActionGroup defaultActionGroup = group;
        if (defaultActionGroup == null) {
            UserFilterPopupComponent.$$$reportNull$$$0(6);
        }
        return defaultActionGroup;
    }

    @Override
    @NotNull
    protected List<List<String>> getRecentValuesFromSettings() {
        List<List<String>> list2 = this.myUiProperties.getRecentlyFilteredUserGroups();
        if (list2 == null) {
            UserFilterPopupComponent.$$$reportNull$$$0(7);
        }
        return list2;
    }

    @Override
    protected void rememberValuesInSettings(@NotNull Collection<String> values) {
        if (values == null) {
            UserFilterPopupComponent.$$$reportNull$$$0(8);
        }
        this.myUiProperties.addRecentlyFilteredUserGroup(new ArrayList<String>(values));
    }

    @Override
    @NotNull
    protected List<String> getAllValues() {
        List<String> list2 = this.myAllUsers;
        if (list2 == null) {
            UserFilterPopupComponent.$$$reportNull$$$0(9);
        }
        return list2;
    }

    @Override
    @NotNull
    protected ListPopup createPopupMenu() {
        ActionGroup actionGroup = this.createActionGroup();
        ActionGroup speedsearchGroup = this.createSpeedSearchActionGroup();
        UserLogSpeedSearchPopup userLogSpeedSearchPopup = new UserLogSpeedSearchPopup(new DefaultActionGroup(new AnAction[]{actionGroup, speedsearchGroup}), DataManager.getInstance().getDataContext((Component)this));
        if (userLogSpeedSearchPopup == null) {
            UserFilterPopupComponent.$$$reportNull$$$0(10);
        }
        return userLogSpeedSearchPopup;
    }

    @NotNull
    private static List<String> collectUsers(@NotNull VcsLogData logData) {
        if (logData == null) {
            UserFilterPopupComponent.$$$reportNull$$$0(11);
        }
        List users = ContainerUtil.map(logData.getAllUsers(), user -> {
            String shortPresentation = VcsUserUtil.getShortPresentation(user);
            Couple<String> firstAndLastName = VcsUserUtil.getFirstAndLastName(shortPresentation);
            if (firstAndLastName == null) {
                return shortPresentation;
            }
            return VcsUserUtil.capitalizeName((String)firstAndLastName.first) + " " + VcsUserUtil.capitalizeName((String)firstAndLastName.second);
        });
        TreeSet sortedUniqueUsers = new TreeSet(users);
        ArrayList<String> arrayList = new ArrayList<String>(sortedUniqueUsers);
        if (arrayList == null) {
            UserFilterPopupComponent.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiProperties";
                break;
            }
            case 1: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logData";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filterModel";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/filter/UserFilterPopupComponent";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/filter/UserFilterPopupComponent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createSpeedSearchActionGroup";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRecentValuesFromSettings";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllValues";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createPopupMenu";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "collectUsers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getText";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getToolTip";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "rememberValuesInSettings";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "collectUsers";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class SpeedsearchPredefinedValueAction
    extends MultipleValueFilterPopupComponent.PredefinedValueAction
    implements FlatSpeedSearchPopup.SpeedsearchAction {
        public SpeedsearchPredefinedValueAction(String user) {
            super((MultipleValueFilterPopupComponent)UserFilterPopupComponent.this, user);
        }
    }

    private static class UserLogSpeedSearchPopup
    extends FlatSpeedSearchPopup {
        public UserLogSpeedSearchPopup(@NotNull DefaultActionGroup actionGroup, @NotNull DataContext dataContext) {
            if (actionGroup == null) {
                UserLogSpeedSearchPopup.$$$reportNull$$$0(0);
            }
            if (dataContext == null) {
                UserLogSpeedSearchPopup.$$$reportNull$$$0(1);
            }
            super(null, actionGroup, dataContext, null, false);
        }

        @Override
        public boolean shouldBeShowing(@NotNull AnAction action) {
            if (action == null) {
                UserLogSpeedSearchPopup.$$$reportNull$$$0(2);
            }
            if (!super.shouldBeShowing(action)) {
                return false;
            }
            if (this.getSpeedSearch().isHoldingFilter()) {
                if (action instanceof MultipleValueFilterPopupComponent.PredefinedValueAction) {
                    return action instanceof FlatSpeedSearchPopup.SpeedsearchAction || ((MultipleValueFilterPopupComponent.PredefinedValueAction)action).myValues.size() > 1;
                }
                return true;
            }
            return !UserLogSpeedSearchPopup.isSpeedsearchAction(action);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actionGroup";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataContext";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/ui/filter/UserFilterPopupComponent$UserLogSpeedSearchPopup";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "shouldBeShowing";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

