/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.intentions;

import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.LinkedHashMap;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.codeInsight.intentions.PyBaseIntentionAction;
import com.jetbrains.python.codeInsight.typing.PyTypingTypeProvider;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyForPart;
import com.jetbrains.python.psi.PySequenceExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTypeDeclarationStatement;
import com.jetbrains.python.psi.PyWithItem;
import com.jetbrains.python.psi.PyWithStatement;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyConvertTypeCommentToVariableAnnotationIntention
extends PyBaseIntentionAction {
    @Override
    public void doInvoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
        Map<PyTargetExpression, String> map2;
        PsiComment typeComment;
        if (project == null) {
            PyConvertTypeCommentToVariableAnnotationIntention.$$$reportNull$$$0(0);
        }
        if ((typeComment = PyConvertTypeCommentToVariableAnnotationIntention.findCommentUnderCaret(editor, file2)) != null && (map2 = PyConvertTypeCommentToVariableAnnotationIntention.mapTargetsToAnnotations(typeComment)) != null) {
            if (typeComment.getParent() instanceof PyAssignmentStatement && map2.size() == 1) {
                Document document = editor.getDocument();
                PyConvertTypeCommentToVariableAnnotationIntention.runWithDocumentReleasedAndCommitted(project, document, () -> {
                    PyTargetExpression target2 = (PyTargetExpression)ContainerUtil.getFirstItem(map2.keySet());
                    assert (target2 != null);
                    document.insertString(target2.getTextRange().getEndOffset(), (CharSequence)(": " + (String)map2.get(target2)));
                });
            } else {
                PyStatement statement = (PyStatement)PsiTreeUtil.getParentOfType((PsiElement)typeComment, PyStatement.class);
                assert (statement != null);
                PyElementGenerator generator = PyElementGenerator.getInstance(project);
                ArrayList<Map.Entry<PyTargetExpression, String>> entries = new ArrayList<Map.Entry<PyTargetExpression, String>>(map2.entrySet());
                Collections.reverse(entries);
                PyStatement anchor = statement;
                for (Map.Entry entry : entries) {
                    PyTargetExpression target2 = (PyTargetExpression)entry.getKey();
                    String annotation = (String)entry.getValue();
                    PyTypeDeclarationStatement declaration = generator.createFromText(LanguageLevel.PYTHON36, PyTypeDeclarationStatement.class, target2.getText() + ": " + annotation);
                    anchor = statement.getParent().addBefore((PsiElement)declaration, (PsiElement)anchor);
                }
            }
            PyPsiUtils.assertValid((PsiElement)typeComment);
            typeComment.delete();
        }
    }

    @NotNull
    public String getText() {
        String string = PyBundle.message("INTN.convert.type.comment.to.variable.annotation.text", new Object[0]);
        if (string == null) {
            PyConvertTypeCommentToVariableAnnotationIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = PyBundle.message("INTN.convert.type.comment.to.variable.annotation.family", new Object[0]);
        if (string == null) {
            PyConvertTypeCommentToVariableAnnotationIntention.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        if (project == null) {
            PyConvertTypeCommentToVariableAnnotationIntention.$$$reportNull$$$0(3);
        }
        if (file2 instanceof PyFile && LanguageLevel.forElement((PsiElement)file2).isAtLeast(LanguageLevel.PYTHON36)) {
            PsiComment comment = PyConvertTypeCommentToVariableAnnotationIntention.findCommentUnderCaret(editor, file2);
            return comment != null && PyConvertTypeCommentToVariableAnnotationIntention.isSuitableTypeComment(comment);
        }
        return false;
    }

    @Nullable
    private static PsiComment findCommentUnderCaret(@NotNull Editor editor, @NotNull PsiFile file2) {
        if (editor == null) {
            PyConvertTypeCommentToVariableAnnotationIntention.$$$reportNull$$$0(4);
        }
        if (file2 == null) {
            PyConvertTypeCommentToVariableAnnotationIntention.$$$reportNull$$$0(5);
        }
        PsiElement element = file2.findElementAt(editor.getCaretModel().getOffset());
        return (PsiComment)PsiTreeUtil.getParentOfType((PsiElement)element, PsiComment.class, (boolean)false);
    }

    private static boolean isSuitableTypeComment(@NotNull PsiComment comment) {
        String annotation;
        if (comment == null) {
            PyConvertTypeCommentToVariableAnnotationIntention.$$$reportNull$$$0(6);
        }
        return (annotation = PyTypingTypeProvider.getTypeCommentValue(comment.getText())) != null && PyConvertTypeCommentToVariableAnnotationIntention.mapTargetsToAnnotations(comment) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runWithDocumentReleasedAndCommitted(@NotNull Project project, @NotNull Document document, @NotNull Runnable runnable2) {
        if (project == null) {
            PyConvertTypeCommentToVariableAnnotationIntention.$$$reportNull$$$0(7);
        }
        if (document == null) {
            PyConvertTypeCommentToVariableAnnotationIntention.$$$reportNull$$$0(8);
        }
        if (runnable2 == null) {
            PyConvertTypeCommentToVariableAnnotationIntention.$$$reportNull$$$0(9);
        }
        PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)project);
        manager.doPostponedOperationsAndUnblockDocument(document);
        try {
            runnable2.run();
        }
        finally {
            manager.commitDocument(document);
        }
    }

    @Nullable
    private static Map<PyTargetExpression, String> mapTargetsToAnnotations(@NotNull PsiComment typeComment) {
        PyExpression target2;
        PyWithItem[] withItems;
        PsiElement parent;
        if (typeComment == null) {
            PyConvertTypeCommentToVariableAnnotationIntention.$$$reportNull$$$0(10);
        }
        if ((parent = typeComment.getParent()) instanceof PyAssignmentStatement) {
            PyAssignmentStatement assignment = (PyAssignmentStatement)parent;
            PyExpression[] rawTargets = assignment.getRawTargets();
            if (rawTargets.length == 1) {
                return PyConvertTypeCommentToVariableAnnotationIntention.mapTargetsToAnnotations(rawTargets[0], typeComment);
            }
        } else if (parent instanceof PyForPart) {
            PyForPart forPart = (PyForPart)parent;
            PyExpression target3 = forPart.getTarget();
            if (target3 != null) {
                return PyConvertTypeCommentToVariableAnnotationIntention.mapTargetsToAnnotations(target3, typeComment);
            }
        } else if (parent instanceof PyWithStatement && (withItems = ((PyWithStatement)parent).getWithItems()).length == 1 && (target2 = withItems[0].getTarget()) != null) {
            return PyConvertTypeCommentToVariableAnnotationIntention.mapTargetsToAnnotations(target2, typeComment);
        }
        return null;
    }

    @Nullable
    private static Map<PyTargetExpression, String> mapTargetsToAnnotations(@NotNull PyExpression targetExpr, @NotNull PsiComment typeComment) {
        PyTargetExpression firstTarget;
        if (targetExpr == null) {
            PyConvertTypeCommentToVariableAnnotationIntention.$$$reportNull$$$0(11);
        }
        if (typeComment == null) {
            PyConvertTypeCommentToVariableAnnotationIntention.$$$reportNull$$$0(12);
        }
        if ((firstTarget = (PyTargetExpression)PsiTreeUtil.findChildOfType((PsiElement)targetExpr, PyTargetExpression.class, (boolean)false)) == null || firstTarget.getTypeComment() != typeComment) {
            return null;
        }
        String annotation = PyTypingTypeProvider.getTypeCommentValue(typeComment.getText());
        if (annotation != null) {
            if (targetExpr instanceof PyTargetExpression) {
                return ImmutableMap.of((Object)((PyTargetExpression)targetExpr), (Object)annotation);
            }
            PyElementGenerator generator = PyElementGenerator.getInstance(targetExpr.getProject());
            PyExpression parsed = generator.createExpressionFromText(LanguageLevel.PYTHON36, annotation);
            if (parsed != null) {
                return PyConvertTypeCommentToVariableAnnotationIntention.mapTargetsToAnnotations(targetExpr, parsed);
            }
        }
        return null;
    }

    @Nullable
    private static Map<PyTargetExpression, String> mapTargetsToAnnotations(@NotNull PyExpression targetExpr, @NotNull PyExpression typeExpr) {
        if (targetExpr == null) {
            PyConvertTypeCommentToVariableAnnotationIntention.$$$reportNull$$$0(13);
        }
        if (typeExpr == null) {
            PyConvertTypeCommentToVariableAnnotationIntention.$$$reportNull$$$0(14);
        }
        PyExpression targetsNoParen = PyPsiUtils.flattenParens(targetExpr);
        PyExpression typesNoParen = PyPsiUtils.flattenParens(typeExpr);
        if (targetsNoParen == null || typesNoParen == null) {
            return null;
        }
        if (targetsNoParen instanceof PySequenceExpression && typesNoParen instanceof PySequenceExpression) {
            Ref result2 = new Ref((Object)new LinkedHashMap());
            PyConvertTypeCommentToVariableAnnotationIntention.mapTargetsToExpressions((PySequenceExpression)targetsNoParen, (PySequenceExpression)typesNoParen, (Ref<Map<PyTargetExpression, String>>)result2);
            return (Map)result2.get();
        }
        if (targetsNoParen instanceof PyTargetExpression && !(typesNoParen instanceof PySequenceExpression)) {
            return ImmutableMap.of((Object)((PyTargetExpression)targetsNoParen), (Object)typesNoParen.getText());
        }
        return null;
    }

    private static void mapTargetsToExpressions(@NotNull PySequenceExpression targetSequence, @NotNull PySequenceExpression valueSequence, @NotNull Ref<Map<PyTargetExpression, String>> result2) {
        PyExpression[] values;
        PyExpression[] targets;
        if (targetSequence == null) {
            PyConvertTypeCommentToVariableAnnotationIntention.$$$reportNull$$$0(15);
        }
        if (valueSequence == null) {
            PyConvertTypeCommentToVariableAnnotationIntention.$$$reportNull$$$0(16);
        }
        if (result2 == null) {
            PyConvertTypeCommentToVariableAnnotationIntention.$$$reportNull$$$0(17);
        }
        if ((targets = targetSequence.getElements()).length != (values = valueSequence.getElements()).length) {
            result2.set(null);
            return;
        }
        for (int i = 0; i < targets.length; ++i) {
            PyExpression target2 = PyPsiUtils.flattenParens(targets[i]);
            PyExpression value = PyPsiUtils.flattenParens(values[i]);
            if (target2 == null || value == null) {
                result2.set(null);
                return;
            }
            if (target2 instanceof PySequenceExpression && value instanceof PySequenceExpression) {
                PyConvertTypeCommentToVariableAnnotationIntention.mapTargetsToExpressions((PySequenceExpression)target2, (PySequenceExpression)value, result2);
                if (!result2.isNull()) continue;
                return;
            }
            if (target2 instanceof PyTargetExpression && !(value instanceof PySequenceExpression)) {
                Map map2 = (Map)result2.get();
                assert (map2 != null);
                map2.put((PyTargetExpression)target2, value.getText());
                continue;
            }
            result2.set(null);
            return;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/intentions/PyConvertTypeCommentToVariableAnnotationIntention";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeComment";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetExpr";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeExpr";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetSequence";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueSequence";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/intentions/PyConvertTypeCommentToVariableAnnotationIntention";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doInvoke";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findCommentUnderCaret";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isSuitableTypeComment";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "runWithDocumentReleasedAndCommitted";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "mapTargetsToAnnotations";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "mapTargetsToExpressions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

