/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.testIntegration;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testIntegration.TestFinder;
import com.intellij.testIntegration.TestFinderHelper;
import com.intellij.util.ThreeState;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDocStringOwner;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.stubs.PyClassNameIndex;
import com.jetbrains.python.psi.stubs.PyFunctionNameIndex;
import com.jetbrains.python.testing.PythonUnitTestUtil;
import com.jetbrains.python.testing.doctest.PythonDocTestUtil;
import com.jetbrains.python.testing.pytest.PyTestUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class PyTestFinder
implements TestFinder {
    public PyDocStringOwner findSourceElement(@NotNull PsiElement element) {
        if (element == null) {
            PyTestFinder.$$$reportNull$$$0(0);
        }
        return (PyDocStringOwner)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PyClass.class, PyFunction.class});
    }

    @NotNull
    public Collection<PsiElement> findTestsForClass(@NotNull PsiElement element) {
        PyDocStringOwner source;
        if (element == null) {
            PyTestFinder.$$$reportNull$$$0(1);
        }
        if ((source = this.findSourceElement(element)) == null) {
            Set<PsiElement> set2 = Collections.emptySet();
            if (set2 == null) {
                PyTestFinder.$$$reportNull$$$0(2);
            }
            return set2;
        }
        String sourceName = source.getName();
        if (sourceName == null) {
            Set<PsiElement> set3 = Collections.emptySet();
            if (set3 == null) {
                PyTestFinder.$$$reportNull$$$0(3);
            }
            return set3;
        }
        ArrayList<Pair<? extends PsiNamedElement, Integer>> classesWithProximities = new ArrayList<Pair<? extends PsiNamedElement, Integer>>();
        if (source instanceof PyClass) {
            Collection<String> names = PyClassNameIndex.allKeys(element.getProject());
            for (String eachName : names) {
                if (!eachName.contains(sourceName)) continue;
                for (PyClass eachClass : PyClassNameIndex.find(eachName, element.getProject(), GlobalSearchScope.projectScope((Project)element.getProject()))) {
                    if (!PythonUnitTestUtil.isTestClass(eachClass, ThreeState.UNSURE, null) && !PythonDocTestUtil.isDocTestClass(eachClass)) continue;
                    classesWithProximities.add((Pair<? extends PsiNamedElement, Integer>)new Pair((Object)eachClass, (Object)TestFinderHelper.calcTestNameProximity(sourceName, eachName)));
                }
            }
        } else {
            Collection<String> names = PyFunctionNameIndex.allKeys(element.getProject());
            for (String eachName : names) {
                if (!eachName.contains(sourceName)) continue;
                for (PyFunction eachFunction : PyFunctionNameIndex.find(eachName, element.getProject(), GlobalSearchScope.projectScope((Project)element.getProject()))) {
                    if (!PythonUnitTestUtil.isTestFunction(eachFunction, ThreeState.UNSURE, null) && !PythonDocTestUtil.isDocTestFunction(eachFunction)) continue;
                    classesWithProximities.add((Pair<? extends PsiNamedElement, Integer>)new Pair((Object)eachFunction, (Object)TestFinderHelper.calcTestNameProximity(sourceName, eachName)));
                }
            }
        }
        List<PsiElement> list2 = TestFinderHelper.getSortedElements(classesWithProximities, true);
        if (list2 == null) {
            PyTestFinder.$$$reportNull$$$0(4);
        }
        return list2;
    }

    @NotNull
    public Collection<PsiElement> findClassesForTest(@NotNull PsiElement element) {
        if (element == null) {
            PyTestFinder.$$$reportNull$$$0(5);
        }
        PyFunction sourceFunction = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)element, PyFunction.class);
        PyClass source = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)element, PyClass.class);
        if (sourceFunction == null && source == null) {
            Set<PsiElement> set2 = Collections.emptySet();
            if (set2 == null) {
                PyTestFinder.$$$reportNull$$$0(6);
            }
            return set2;
        }
        ArrayList<Pair<? extends PsiNamedElement, Integer>> classesWithWeights = new ArrayList<Pair<? extends PsiNamedElement, Integer>>();
        ArrayList<Pair<String, Integer>> possibleNames = new ArrayList<Pair<String, Integer>>();
        if (source != null) {
            possibleNames.addAll(TestFinderHelper.collectPossibleClassNamesWithWeights(source.getName()));
        }
        if (sourceFunction != null) {
            possibleNames.addAll(TestFinderHelper.collectPossibleClassNamesWithWeights(sourceFunction.getName()));
        }
        for (Pair pair : possibleNames) {
            for (PyClass eachClass : PyClassNameIndex.find((String)pair.first, element.getProject(), GlobalSearchScope.projectScope((Project)element.getProject()))) {
                if (PyTestUtil.isPyTestClass(eachClass, null)) continue;
                classesWithWeights.add((Pair<? extends PsiNamedElement, Integer>)new Pair((Object)eachClass, pair.second));
            }
            for (PyFunction function : PyFunctionNameIndex.find((String)pair.first, element.getProject(), GlobalSearchScope.projectScope((Project)element.getProject()))) {
                if (PyTestUtil.isPyTestFunction(function)) continue;
                classesWithWeights.add((Pair<? extends PsiNamedElement, Integer>)new Pair((Object)function, pair.second));
            }
        }
        List<PsiElement> list2 = TestFinderHelper.getSortedElements(classesWithWeights, false);
        if (list2 == null) {
            PyTestFinder.$$$reportNull$$$0(7);
        }
        return list2;
    }

    public boolean isTest(@NotNull PsiElement element) {
        PyClass cl;
        if (element == null) {
            PyTestFinder.$$$reportNull$$$0(8);
        }
        if ((cl = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)element, PyClass.class, (boolean)false)) != null) {
            return PyTestUtil.isPyTestClass(cl, null);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/testIntegration/PyTestFinder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/testIntegration/PyTestFinder";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findTestsForClass";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findClassesForTest";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findSourceElement";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findTestsForClass";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findClassesForTest";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isTest";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

