/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.BaseScopeProcessor;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.PyNamedTupleInspection;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyTargetExpression;
import java.util.Comparator;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0003\u000b\f\rB\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/python/inspections/PyNamedTupleInspection;", "Lcom/jetbrains/python/inspections/PyInspection;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "FieldsProcessor", "MaxBy", "Visitor", "python-community"})
public final class PyNamedTupleInspection
extends PyInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session2) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        Intrinsics.checkParameterIsNotNull((Object)session2, (String)"session");
        return new Visitor(holder, session2);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J(\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0012\u0010\u0013\u001a\u00020\f2\b\u0010\u0014\u001a\u0004\u0018\u00010\nH\u0016\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/python/inspections/PyNamedTupleInspection$Visitor;", "Lcom/jetbrains/python/inspections/PyInspectionVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "(Lcom/intellij/codeInspection/ProblemsHolder;Lcom/intellij/codeInspection/LocalInspectionToolSession;)V", "isTypingNTInheritor", "", "cls", "Lcom/jetbrains/python/psi/PyClass;", "registerErrorOnTargetsAboveBound", "", "bound", "Lcom/jetbrains/python/psi/PyTargetExpression;", "targets", "Ljava/util/TreeSet;", "message", "", "visitPyClass", "node", "python-community"})
    private static final class Visitor
    extends PyInspectionVisitor {
        @Override
        public void visitPyClass(@Nullable PyClass node) {
            super.visitPyClass(node);
            if (node != null && LanguageLevel.forElement((PsiElement)node).isAtLeast(LanguageLevel.PYTHON36) && this.isTypingNTInheritor(node)) {
                FieldsProcessor fieldsProcessor = new FieldsProcessor();
                node.processClassLevelDeclarations(fieldsProcessor);
                this.registerErrorOnTargetsAboveBound(fieldsProcessor.getLastFieldWithoutDefaultValue(), fieldsProcessor.getFieldsWithDefaultValue(), "Fields with a default value must come after any fields without a default.");
            }
        }

        private final boolean isTypingNTInheritor(PyClass cls) {
            Object v0;
            block1: {
                Iterable iterable;
                Function1 isTypingNT2 = isTypingNTInheritor.isTypingNT.1.INSTANCE;
                Iterable iterable2 = iterable = (Iterable)cls.getSuperClassTypes(this.myTypeEvalContext);
                for (Object t : iterable2) {
                    if (!((Boolean)isTypingNT2.invoke(t)).booleanValue()) continue;
                    v0 = t;
                    break block1;
                }
                v0 = null;
            }
            return v0 != null;
        }

        /*
         * WARNING - void declaration
         */
        private final void registerErrorOnTargetsAboveBound(PyTargetExpression bound, TreeSet<PyTargetExpression> targets, String message) {
            if (bound != null) {
                void $receiver$iv;
                Iterable iterable = targets.headSet(bound);
                for (Object element$iv : $receiver$iv) {
                    PyTargetExpression it = (PyTargetExpression)element$iv;
                    this.registerProblem((PsiElement)it, message, ProblemHighlightType.GENERIC_ERROR);
                }
            }
        }

        public Visitor(@NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session2) {
            Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
            Intrinsics.checkParameterIsNotNull((Object)session2, (String)"session");
            super(holder, session2);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\b\u001a\u0004\u0018\u00010\u00058F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/python/inspections/PyNamedTupleInspection$FieldsProcessor;", "Lcom/intellij/psi/scope/BaseScopeProcessor;", "()V", "fieldsWithDefaultValue", "Ljava/util/TreeSet;", "Lcom/jetbrains/python/psi/PyTargetExpression;", "getFieldsWithDefaultValue", "()Ljava/util/TreeSet;", "lastFieldWithoutDefaultValue", "getLastFieldWithoutDefaultValue", "()Lcom/jetbrains/python/psi/PyTargetExpression;", "lastFieldWithoutDefaultValueBox", "Lcom/jetbrains/python/inspections/PyNamedTupleInspection$MaxBy;", "execute", "", "element", "Lcom/intellij/psi/PsiElement;", "state", "Lcom/intellij/psi/ResolveState;", "python-community"})
    private static final class FieldsProcessor
    extends BaseScopeProcessor {
        @NotNull
        private final TreeSet<PyTargetExpression> fieldsWithDefaultValue;
        private final MaxBy<PyTargetExpression> lastFieldWithoutDefaultValueBox;

        @Nullable
        public final PyTargetExpression getLastFieldWithoutDefaultValue() {
            return this.lastFieldWithoutDefaultValueBox.getResult();
        }

        @NotNull
        public final TreeSet<PyTargetExpression> getFieldsWithDefaultValue() {
            return this.fieldsWithDefaultValue;
        }

        public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state2) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)state2, (String)"state");
            if (element instanceof PyTargetExpression) {
                if (((PyTargetExpression)element).findAssignedValue() != null) {
                    this.fieldsWithDefaultValue.add((PyTargetExpression)element);
                } else {
                    this.lastFieldWithoutDefaultValueBox.apply((PyTargetExpression)element);
                }
            }
            return true;
        }

        public FieldsProcessor() {
            Comparator offsetComparator = new Comparator<T>(){

                public final int compare(T a, T b) {
                    PyTargetExpression p1 = (PyTargetExpression)a;
                    Comparable comparable = Integer.valueOf(p1.getTextOffset());
                    p1 = (PyTargetExpression)b;
                    Comparable comparable2 = comparable;
                    Integer n = p1.getTextOffset();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
                }
            };
            this.lastFieldWithoutDefaultValueBox = new MaxBy(offsetComparator);
            this.fieldsWithDefaultValue = new TreeSet(offsetComparator);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0002\u0010\u0005J\u0013\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u000bR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0007\u001a\u0004\u0018\u00018\u00002\b\u0010\u0006\u001a\u0004\u0018\u00018\u0000@BX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\f\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/python/inspections/PyNamedTupleInspection$MaxBy;", "T", "", "comparator", "Ljava/util/Comparator;", "(Ljava/util/Comparator;)V", "<set-?>", "result", "getResult", "()Ljava/lang/Object;", "setResult", "(Ljava/lang/Object;)V", "Ljava/lang/Object;", "apply", "", "t", "python-community"})
    private static final class MaxBy<T> {
        @Nullable
        private T result;
        private final Comparator<T> comparator;

        @Nullable
        public final T getResult() {
            return this.result;
        }

        private final void setResult(T t) {
            this.result = t;
        }

        public final void apply(T t) {
            if (this.result == null || this.comparator.compare(this.result, t) < 0) {
                this.result = t;
            }
        }

        public MaxBy(@NotNull Comparator<T> comparator2) {
            Intrinsics.checkParameterIsNotNull(comparator2, (String)"comparator");
            this.comparator = comparator2;
        }
    }
}

