/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.packaging.PyPackage;
import com.jetbrains.python.packaging.requirement.PyRequirementRelation;
import com.jetbrains.python.packaging.requirement.PyRequirementVersion;
import com.jetbrains.python.packaging.requirement.PyRequirementVersionNormalizer;
import com.jetbrains.python.packaging.requirement.PyRequirementVersionSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyRequirement {
    @NotNull
    private static final String LINE_WS_REGEXP = "[ \t]";
    @NotNull
    private static final String COMMENT_GROUP = "comment";
    @NotNull
    private static final String COMMENT_REGEXP = "(?<comment>[ \t]+#.*)?";
    @NotNull
    private static final String NAME_GROUP = "name";
    @NotNull
    private static final Pattern GITHUB_ARCHIVE_URL = Pattern.compile("https?://github\\.com/[^/\\s]+/(?<name>[^/\\s]+)/archive/\\S+(?<comment>[ \t]+#.*)?");
    @NotNull
    private static final Pattern GITLAB_ARCHIVE_URL = Pattern.compile("https?://gitlab\\.com/[^/\\s]+/(?<name>[^/\\s]+)/repository/\\S+(?<comment>[ \t]+#.*)?");
    @NotNull
    private static final Pattern ARCHIVE_URL = Pattern.compile("https?://\\S+/(?<name>\\S+)(\\.tar\\.gz|\\.zip)(#(sha1|sha224|sha256|sha384|sha512|md5)=\\w+)?(?<comment>[ \t]+#.*)?");
    @NotNull
    private static final String VCS_EDITABLE_GROUP = "editable";
    @NotNull
    private static final String VCS_EDITABLE_REGEXP = "((?<editable>-e|--editable)[ \t]+)?";
    @NotNull
    private static final String VCS_SRC_BEFORE_GROUP = "srcb";
    @NotNull
    private static final String VCS_SRC_AFTER_GROUP = "srca";
    @NotNull
    private static final String VCS_SRC_BEFORE_REGEXP = "(?<srcb>--src[ \t]+\\S+[ \t]+)?";
    @NotNull
    private static final String VCS_SRC_AFTER_REGEXP = "(?<srca>[ \t]+--src[ \t]+\\S+)?";
    @NotNull
    private static final String PATH_IN_VCS_GROUP = "path";
    @NotNull
    private static final String PATH_IN_VCS_REGEXP = "(?<path>[^@#\\s]+)";
    @NotNull
    private static final String VCS_REVISION_REGEXP = "(@[^#\\s]+)?";
    @NotNull
    private static final String VCS_EGG_BEFORE_SUBDIR_GROUP = "eggb";
    @NotNull
    private static final String VCS_EGG_AFTER_SUBDIR_GROUP = "egga";
    @NotNull
    private static final String VCS_PARAMS_REGEXP = "((#egg=(?<eggb>[^&\\s]+)(&subdirectory=\\S+)?)|(#subdirectory=[^&\\s]+&egg=(?<egga>\\S+)))?";
    @NotNull
    private static final String VCS_GROUP = "vcs";
    @NotNull
    private static final String VCS_URL_PREFIX = "(?<srcb>--src[ \t]+\\S+[ \t]+)?((?<editable>-e|--editable)[ \t]+)?(?<vcs>";
    @NotNull
    private static final String VCS_URL_SUFFIX = "(?<path>[^@#\\s]+)(@[^#\\s]+)?((#egg=(?<eggb>[^&\\s]+)(&subdirectory=\\S+)?)|(#subdirectory=[^&\\s]+&egg=(?<egga>\\S+)))?)(?<srca>[ \t]+--src[ \t]+\\S+)?(?<comment>[ \t]+#.*)?";
    @NotNull
    private static final String GIT_USER_AT_REGEXP = "[\\w-]+@";
    @NotNull
    private static final Pattern GIT_PROJECT_URL = Pattern.compile("(?<srcb>--src[ \t]+\\S+[ \t]+)?((?<editable>-e|--editable)[ \t]+)?(?<vcs>git\\+[\\w-]+@[^:\\s]+:(?<path>[^@#\\s]+)(@[^#\\s]+)?((#egg=(?<eggb>[^&\\s]+)(&subdirectory=\\S+)?)|(#subdirectory=[^&\\s]+&egg=(?<egga>\\S+)))?)(?<srca>[ \t]+--src[ \t]+\\S+)?(?<comment>[ \t]+#.*)?");
    @NotNull
    private static final Pattern BZR_PROJECT_URL = Pattern.compile("(?<srcb>--src[ \t]+\\S+[ \t]+)?((?<editable>-e|--editable)[ \t]+)?(?<vcs>bzr\\+lp:(?<path>[^@#\\s]+)(@[^#\\s]+)?((#egg=(?<eggb>[^&\\s]+)(&subdirectory=\\S+)?)|(#subdirectory=[^&\\s]+&egg=(?<egga>\\S+)))?)(?<srca>[ \t]+--src[ \t]+\\S+)?(?<comment>[ \t]+#.*)?");
    @NotNull
    private static final Pattern VCS_PROJECT_URL = Pattern.compile("(?<srcb>--src[ \t]+\\S+[ \t]+)?((?<editable>-e|--editable)[ \t]+)?(?<vcs>(bzr|git|hg|svn)(\\+[A-Za-z]+)?://?[^/]+/(?<path>[^@#\\s]+)(@[^#\\s]+)?((#egg=(?<eggb>[^&\\s]+)(&subdirectory=\\S+)?)|(#subdirectory=[^&\\s]+&egg=(?<egga>\\S+)))?)(?<srca>[ \t]+--src[ \t]+\\S+)?(?<comment>[ \t]+#.*)?");
    @NotNull
    private static final String IDENTIFIER_REGEXP = "[A-Za-z0-9]([-_\\.]?[A-Za-z0-9])*";
    @NotNull
    private static final String REQUIREMENT_NAME_REGEXP = "(?<name>[A-Za-z0-9]([-_\\.]?[A-Za-z0-9])*)";
    @NotNull
    private static final String REQUIREMENT_EXTRAS_GROUP = "extras";
    @NotNull
    private static final String REQUIREMENT_EXTRAS_REGEXP = "(?<extras>\\[[A-Za-z0-9]([-_\\.]?[A-Za-z0-9])*([ \t]*,[ \t]*[A-Za-z0-9]([-_\\.]?[A-Za-z0-9])*)*\\])?";
    @NotNull
    private static final String REQUIREMENT_VERSIONS_SPECS_GROUP = "versionspecs";
    @NotNull
    private static final String REQUIREMENT_VERSION_SPEC_REGEXP = "(<=?|!=|===?|>=?|~=)[ \t]*[\\.\\*\\+!\\w-]+";
    @NotNull
    private static final String REQUIREMENT_VERSIONS_SPECS_REGEXP = "(?<versionspecs>(<=?|!=|===?|>=?|~=)[ \t]*[\\.\\*\\+!\\w-]+([ \t]*,[ \t]*(<=?|!=|===?|>=?|~=)[ \t]*[\\.\\*\\+!\\w-]+)*)?";
    @NotNull
    private static final String REQUIREMENT_OPTIONS_GROUP = "options";
    @NotNull
    private static final String REQUIREMENT_OPTIONS_REGEXP = "(?<options>([ \t]+(--global-option|--install-option)=\"[^\"]*\")+)?";
    @NotNull
    private static final String REQUIREMENT_GROUP = "requirement";
    @NotNull
    private static final Pattern REQUIREMENT = Pattern.compile("(?<requirement>(?<name>[A-Za-z0-9]([-_\\.]?[A-Za-z0-9])*)[ \t]*(?<extras>\\[[A-Za-z0-9]([-_\\.]?[A-Za-z0-9])*([ \t]*,[ \t]*[A-Za-z0-9]([-_\\.]?[A-Za-z0-9])*)*\\])?[ \t]*(?<versionspecs>(<=?|!=|===?|>=?|~=)[ \t]*[\\.\\*\\+!\\w-]+([ \t]*,[ \t]*(<=?|!=|===?|>=?|~=)[ \t]*[\\.\\*\\+!\\w-]+)*)?)(?<options>([ \t]+(--global-option|--install-option)=\"[^\"]*\")+)?(?<comment>[ \t]+#.*)?");
    @NotNull
    private final String myName;
    @NotNull
    private final List<PyRequirementVersionSpec> myVersionSpecs;
    @NotNull
    private final List<String> myInstallOptions;
    @NotNull
    private final String myExtras;

    @Deprecated
    public PyRequirement(@NotNull String name) {
        if (name == null) {
            PyRequirement.$$$reportNull$$$0(0);
        }
        this(name, Collections.emptyList());
    }

    @Deprecated
    public PyRequirement(@NotNull String name, @NotNull PyRequirementRelation relation, @NotNull String version) {
        if (name == null) {
            PyRequirement.$$$reportNull$$$0(1);
        }
        if (relation == null) {
            PyRequirement.$$$reportNull$$$0(2);
        }
        if (version == null) {
            PyRequirement.$$$reportNull$$$0(3);
        }
        this(name, Collections.singletonList(PyRequirement.calculateVersionSpec(version, relation)));
    }

    @Deprecated
    public PyRequirement(@NotNull String name, @NotNull String version) {
        if (name == null) {
            PyRequirement.$$$reportNull$$$0(4);
        }
        if (version == null) {
            PyRequirement.$$$reportNull$$$0(5);
        }
        this(name, PyRequirementRelation.EQ, version);
    }

    @Deprecated
    public PyRequirement(@NotNull String name, @NotNull String version, @NotNull List<String> installOptions) {
        if (name == null) {
            PyRequirement.$$$reportNull$$$0(6);
        }
        if (version == null) {
            PyRequirement.$$$reportNull$$$0(7);
        }
        if (installOptions == null) {
            PyRequirement.$$$reportNull$$$0(8);
        }
        this(name, Collections.singletonList(PyRequirement.calculateVersionSpec(version, PyRequirementRelation.EQ)), installOptions);
    }

    @Deprecated
    public PyRequirement(@NotNull String name, @NotNull String version, @NotNull List<String> installOptions, @NotNull String extras) {
        if (name == null) {
            PyRequirement.$$$reportNull$$$0(9);
        }
        if (version == null) {
            PyRequirement.$$$reportNull$$$0(10);
        }
        if (installOptions == null) {
            PyRequirement.$$$reportNull$$$0(11);
        }
        if (extras == null) {
            PyRequirement.$$$reportNull$$$0(12);
        }
        this(name, Collections.singletonList(PyRequirement.calculateVersionSpec(version, PyRequirementRelation.EQ)), installOptions, extras);
    }

    @Deprecated
    public PyRequirement(@NotNull String name, @NotNull List<PyRequirementVersionSpec> versionSpecs) {
        if (name == null) {
            PyRequirement.$$$reportNull$$$0(13);
        }
        if (versionSpecs == null) {
            PyRequirement.$$$reportNull$$$0(14);
        }
        this.myName = name;
        this.myVersionSpecs = versionSpecs;
        this.myExtras = "";
        this.myInstallOptions = Collections.singletonList(this.toString());
    }

    @Deprecated
    public PyRequirement(@NotNull String name, @NotNull List<PyRequirementVersionSpec> versionSpecs, @NotNull List<String> installOptions) {
        if (name == null) {
            PyRequirement.$$$reportNull$$$0(15);
        }
        if (versionSpecs == null) {
            PyRequirement.$$$reportNull$$$0(16);
        }
        if (installOptions == null) {
            PyRequirement.$$$reportNull$$$0(17);
        }
        this.myName = name;
        this.myVersionSpecs = versionSpecs;
        this.myInstallOptions = Collections.unmodifiableList(installOptions);
        this.myExtras = "";
    }

    @Deprecated
    public PyRequirement(@NotNull String name, @NotNull List<PyRequirementVersionSpec> versionSpecs, @NotNull List<String> installOptions, @NotNull String extras) {
        if (name == null) {
            PyRequirement.$$$reportNull$$$0(18);
        }
        if (versionSpecs == null) {
            PyRequirement.$$$reportNull$$$0(19);
        }
        if (installOptions == null) {
            PyRequirement.$$$reportNull$$$0(20);
        }
        if (extras == null) {
            PyRequirement.$$$reportNull$$$0(21);
        }
        this.myName = name;
        this.myVersionSpecs = versionSpecs;
        this.myInstallOptions = Collections.unmodifiableList(installOptions);
        this.myExtras = extras;
    }

    @Deprecated
    @NotNull
    public PyRequirement withVersionComparator(@NotNull Comparator<String> comparator2) {
        if (comparator2 == null) {
            PyRequirement.$$$reportNull$$$0(22);
        }
        PyRequirement pyRequirement = new PyRequirement(this.myName, ContainerUtil.map(this.myVersionSpecs, spec -> {
            if (comparator2 == null) {
                PyRequirement.$$$reportNull$$$0(105);
            }
            return spec.withVersionComparator(comparator2);
        }), this.myInstallOptions, this.myExtras);
        if (pyRequirement == null) {
            PyRequirement.$$$reportNull$$$0(23);
        }
        return pyRequirement;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            PyRequirement.$$$reportNull$$$0(24);
        }
        return string;
    }

    @Deprecated
    @NotNull
    public String getFullName() {
        String string = this.myName + this.myExtras;
        if (string == null) {
            PyRequirement.$$$reportNull$$$0(25);
        }
        return string;
    }

    @NotNull
    public String getExtras() {
        String string = this.myExtras;
        if (string == null) {
            PyRequirement.$$$reportNull$$$0(26);
        }
        return string;
    }

    @NotNull
    public List<PyRequirementVersionSpec> getVersionSpecs() {
        List<PyRequirementVersionSpec> list2 = this.myVersionSpecs;
        if (list2 == null) {
            PyRequirement.$$$reportNull$$$0(27);
        }
        return list2;
    }

    @NotNull
    public List<String> getInstallOptions() {
        List<String> list2 = this.myInstallOptions;
        if (list2 == null) {
            PyRequirement.$$$reportNull$$$0(28);
        }
        return list2;
    }

    public String toString() {
        return this.myName + this.myExtras + StringUtil.join(this.myVersionSpecs, (String)",");
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PyRequirement that = (PyRequirement)o;
        if (!this.myName.equals(that.myName)) {
            return false;
        }
        if (!this.myVersionSpecs.equals(that.myVersionSpecs)) {
            return false;
        }
        if (!this.myInstallOptions.equals(that.myInstallOptions)) {
            return false;
        }
        return this.myExtras.equals(that.myExtras);
    }

    public int hashCode() {
        int result2 = this.myName.hashCode();
        result2 = 31 * result2 + this.myVersionSpecs.hashCode();
        result2 = 31 * result2 + this.myInstallOptions.hashCode();
        result2 = 31 * result2 + this.myExtras.hashCode();
        return result2;
    }

    @Nullable
    public PyPackage match(@NotNull List<PyPackage> packages) {
        if (packages == null) {
            PyRequirement.$$$reportNull$$$0(29);
        }
        String normalizedName = PyRequirement.normalizeName(this.myName);
        return packages.stream().filter(pkg -> normalizedName.equalsIgnoreCase(pkg.getName())).findAny().filter(pkg -> this.myVersionSpecs.stream().allMatch(spec -> spec.matches(pkg.getVersion()))).orElse(null);
    }

    @Deprecated
    @Nullable
    public static PyRequirement fromLine(@NotNull String line) {
        PyRequirement githubArchiveUrl;
        if (line == null) {
            PyRequirement.$$$reportNull$$$0(30);
        }
        if ((githubArchiveUrl = PyRequirement.parseGitArchiveUrl(GITHUB_ARCHIVE_URL, line)) != null) {
            return githubArchiveUrl;
        }
        PyRequirement gitlabArchiveUrl = PyRequirement.parseGitArchiveUrl(GITLAB_ARCHIVE_URL, line);
        if (gitlabArchiveUrl != null) {
            return gitlabArchiveUrl;
        }
        PyRequirement archiveUrl = PyRequirement.parseArchiveUrl(line);
        if (archiveUrl != null) {
            return archiveUrl;
        }
        PyRequirement vcsProjectUrl = PyRequirement.parseVcsProjectUrl(line);
        if (vcsProjectUrl != null) {
            return vcsProjectUrl;
        }
        return PyRequirement.parseRequirement(line);
    }

    @Deprecated
    @NotNull
    public static List<PyRequirement> fromText(@NotNull String text) {
        if (text == null) {
            PyRequirement.$$$reportNull$$$0(31);
        }
        List<PyRequirement> list2 = PyRequirement.fromText(text, null, new HashSet<VirtualFile>());
        if (list2 == null) {
            PyRequirement.$$$reportNull$$$0(32);
        }
        return list2;
    }

    @Deprecated
    @NotNull
    public static List<PyRequirement> fromFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PyRequirement.$$$reportNull$$$0(33);
        }
        List<PyRequirement> list2 = PyRequirement.fromText(PyRequirement.loadText(file2), file2, new HashSet<VirtualFile>());
        if (list2 == null) {
            PyRequirement.$$$reportNull$$$0(34);
        }
        return list2;
    }

    @Deprecated
    @NotNull
    public static PyRequirementVersionSpec calculateVersionSpec(@NotNull String version, @NotNull PyRequirementRelation expectedRelation) {
        if (version == null) {
            PyRequirement.$$$reportNull$$$0(35);
        }
        if (expectedRelation == null) {
            PyRequirement.$$$reportNull$$$0(36);
        }
        if (expectedRelation == PyRequirementRelation.STR_EQ) {
            PyRequirementVersionSpec pyRequirementVersionSpec = new PyRequirementVersionSpec(version);
            if (pyRequirementVersionSpec == null) {
                PyRequirement.$$$reportNull$$$0(37);
            }
            return pyRequirementVersionSpec;
        }
        PyRequirementVersion normalizedVersion = PyRequirementVersionNormalizer.normalize(version);
        PyRequirementVersionSpec pyRequirementVersionSpec = normalizedVersion == null ? new PyRequirementVersionSpec(version) : new PyRequirementVersionSpec(expectedRelation, normalizedVersion);
        if (pyRequirementVersionSpec == null) {
            PyRequirement.$$$reportNull$$$0(38);
        }
        return pyRequirementVersionSpec;
    }

    @Nullable
    private static PyRequirement parseGitArchiveUrl(@NotNull Pattern pattern, @NotNull String line) {
        Matcher matcher;
        if (pattern == null) {
            PyRequirement.$$$reportNull$$$0(39);
        }
        if (line == null) {
            PyRequirement.$$$reportNull$$$0(40);
        }
        if ((matcher = pattern.matcher(line)).matches()) {
            return new PyRequirement(matcher.group(NAME_GROUP), Collections.emptyList(), Collections.singletonList(PyRequirement.dropComments(line, matcher)));
        }
        return null;
    }

    @Nullable
    private static PyRequirement parseArchiveUrl(@NotNull String line) {
        Matcher matcher;
        if (line == null) {
            PyRequirement.$$$reportNull$$$0(41);
        }
        if ((matcher = ARCHIVE_URL.matcher(line)).matches()) {
            return PyRequirement.createVcsOrArchiveRequirement(Collections.singletonList(PyRequirement.dropComments(line, matcher)), PyRequirement.parseNameAndVersionFromVcsOrArchive(matcher.group(NAME_GROUP)));
        }
        return null;
    }

    @Nullable
    private static PyRequirement parseVcsProjectUrl(@NotNull String line) {
        Matcher vcsMatcher;
        if (line == null) {
            PyRequirement.$$$reportNull$$$0(42);
        }
        if ((vcsMatcher = VCS_PROJECT_URL.matcher(line)).matches()) {
            return PyRequirement.createVcsRequirement(vcsMatcher);
        }
        Matcher gitMatcher = GIT_PROJECT_URL.matcher(line);
        if (gitMatcher.matches()) {
            return PyRequirement.createVcsRequirement(gitMatcher);
        }
        Matcher bzrMatcher = BZR_PROJECT_URL.matcher(line);
        if (bzrMatcher.matches()) {
            return PyRequirement.createVcsRequirement(bzrMatcher);
        }
        return null;
    }

    @Nullable
    private static PyRequirement parseRequirement(@NotNull String line) {
        Matcher matcher;
        if (line == null) {
            PyRequirement.$$$reportNull$$$0(43);
        }
        if ((matcher = REQUIREMENT.matcher(line)).matches()) {
            String name = matcher.group(NAME_GROUP);
            List<PyRequirementVersionSpec> versionSpecs = PyRequirement.parseVersionSpecs(matcher.group(REQUIREMENT_VERSIONS_SPECS_GROUP));
            List<String> installOptions = PyRequirement.calculateRequirementInstallOptions(matcher);
            String extras = matcher.group(REQUIREMENT_EXTRAS_GROUP);
            if (extras == null) {
                return new PyRequirement(name, versionSpecs, installOptions);
            }
            return new PyRequirement(name, versionSpecs, installOptions, extras);
        }
        return null;
    }

    @NotNull
    private static List<PyRequirement> fromText(@NotNull String text, @Nullable VirtualFile containingFile, @NotNull Set<VirtualFile> visitedFiles) {
        if (text == null) {
            PyRequirement.$$$reportNull$$$0(44);
        }
        if (visitedFiles == null) {
            PyRequirement.$$$reportNull$$$0(45);
        }
        if (containingFile != null) {
            visitedFiles.add(containingFile);
        }
        List list2 = ((StreamEx)StreamEx.of(PyRequirement.splitByLinesAndCollapse(text)).flatCollection(line -> {
            if (visitedFiles == null) {
                PyRequirement.$$$reportNull$$$0(104);
            }
            return PyRequirement.parseLine(line, containingFile, visitedFiles);
        }).nonNull().distinct()).toList();
        if (list2 == null) {
            PyRequirement.$$$reportNull$$$0(46);
        }
        return list2;
    }

    @NotNull
    private static String loadText(@NotNull VirtualFile file2) {
        Document document;
        if (file2 == null) {
            PyRequirement.$$$reportNull$$$0(47);
        }
        String string = (document = FileDocumentManager.getInstance().getDocument(file2)) == null ? "" : document.getText();
        if (string == null) {
            PyRequirement.$$$reportNull$$$0(48);
        }
        return string;
    }

    @NotNull
    private static String dropComments(@NotNull String line, @NotNull Matcher matcher) {
        int commentIndex;
        if (line == null) {
            PyRequirement.$$$reportNull$$$0(49);
        }
        if (matcher == null) {
            PyRequirement.$$$reportNull$$$0(50);
        }
        if ((commentIndex = matcher.start(COMMENT_GROUP)) == -1) {
            String string = line;
            if (string == null) {
                PyRequirement.$$$reportNull$$$0(51);
            }
            return string;
        }
        String string = line.substring(0, PyRequirement.findFirstNotWhiteSpaceBefore(line, commentIndex) + 1);
        if (string == null) {
            PyRequirement.$$$reportNull$$$0(52);
        }
        return string;
    }

    @NotNull
    private static Pair<String, String> parseNameAndVersionFromVcsOrArchive(@NotNull String name) {
        if (name == null) {
            PyRequirement.$$$reportNull$$$0(53);
        }
        boolean isName = true;
        ArrayList<String> nameParts = new ArrayList<String>();
        ArrayList<String> versionParts = new ArrayList<String>();
        for (String part : StringUtil.split((String)name, (String)"-")) {
            boolean partStartsWithDigit;
            boolean bl = partStartsWithDigit = !part.isEmpty() && Character.isDigit(part.charAt(0));
            if (partStartsWithDigit || "dev".equals(part)) {
                isName = false;
            }
            if (isName) {
                nameParts.add(part);
                continue;
            }
            versionParts.add(part);
        }
        Pair pair = Pair.create((Object)PyRequirement.normalizeVcsOrArchiveNameParts(nameParts), (Object)PyRequirement.normalizeVcsOrArchiveVersionParts(versionParts));
        if (pair == null) {
            PyRequirement.$$$reportNull$$$0(54);
        }
        return pair;
    }

    @NotNull
    private static PyRequirement createVcsOrArchiveRequirement(@NotNull List<String> installOptions, @NotNull Pair<String, String> nameAndVersion) {
        if (installOptions == null) {
            PyRequirement.$$$reportNull$$$0(55);
        }
        if (nameAndVersion == null) {
            PyRequirement.$$$reportNull$$$0(56);
        }
        String name = (String)nameAndVersion.getFirst();
        String version = (String)nameAndVersion.getSecond();
        if (version == null) {
            PyRequirement pyRequirement = new PyRequirement(name, Collections.emptyList(), installOptions);
            if (pyRequirement == null) {
                PyRequirement.$$$reportNull$$$0(57);
            }
            return pyRequirement;
        }
        PyRequirement pyRequirement = new PyRequirement(name, Collections.singletonList(PyRequirement.calculateVersionSpec(version, PyRequirementRelation.EQ)), installOptions);
        if (pyRequirement == null) {
            PyRequirement.$$$reportNull$$$0(58);
        }
        return pyRequirement;
    }

    @NotNull
    private static PyRequirement createVcsRequirement(@NotNull Matcher matcher) {
        if (matcher == null) {
            PyRequirement.$$$reportNull$$$0(59);
        }
        String path = matcher.group(PATH_IN_VCS_GROUP);
        String egg = PyRequirement.getEgg(matcher);
        String project = PyRequirement.extractProject(PyRequirement.dropTrunk(PyRequirement.dropRevision(path)));
        Pair<String, String> nameAndVersion = PyRequirement.parseNameAndVersionFromVcsOrArchive(egg == null ? StringUtil.trimEnd((String)project, (String)".git") : egg);
        PyRequirement pyRequirement = PyRequirement.createVcsOrArchiveRequirement(PyRequirement.calculateVcsInstallOptions(matcher), nameAndVersion);
        if (pyRequirement == null) {
            PyRequirement.$$$reportNull$$$0(60);
        }
        return pyRequirement;
    }

    @NotNull
    private static List<PyRequirementVersionSpec> parseVersionSpecs(@Nullable String versionSpecs) {
        if (versionSpecs == null) {
            List<PyRequirementVersionSpec> list2 = Collections.emptyList();
            if (list2 == null) {
                PyRequirement.$$$reportNull$$$0(61);
            }
            return list2;
        }
        List<PyRequirementVersionSpec> list3 = StreamSupport.stream(StringUtil.tokenize((String)versionSpecs, (String)",").spliterator(), false).map(String::trim).map(PyRequirement::parseVersionSpec).filter(req -> req != null).collect(Collectors.toList());
        if (list3 == null) {
            PyRequirement.$$$reportNull$$$0(62);
        }
        return list3;
    }

    @NotNull
    private static List<String> calculateRequirementInstallOptions(@NotNull Matcher matcher) {
        if (matcher == null) {
            PyRequirement.$$$reportNull$$$0(63);
        }
        ArrayList<String> result2 = new ArrayList<String>();
        result2.add(matcher.group(REQUIREMENT_GROUP));
        String requirementOptions = matcher.group(REQUIREMENT_OPTIONS_GROUP);
        if (requirementOptions != null) {
            boolean isKey = true;
            for (String token : StringUtil.tokenize((String)requirementOptions, (String)"\"")) {
                result2.add(isKey ? token.substring(PyRequirement.findFirstNotWhiteSpaceAfter(token, 0), token.length() - 1) : token);
                isKey = !isKey;
            }
        }
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            PyRequirement.$$$reportNull$$$0(64);
        }
        return arrayList;
    }

    @NotNull
    private static List<String> splitByLinesAndCollapse(@NotNull String text) {
        if (text == null) {
            PyRequirement.$$$reportNull$$$0(65);
        }
        ArrayList<String> result2 = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        for (String line : StringUtil.splitByLines((String)text)) {
            if (line.endsWith("\\") && !line.endsWith("\\\\")) {
                sb.append(line.substring(0, line.length() - 1));
                continue;
            }
            if (sb.length() == 0) {
                result2.add(line);
                continue;
            }
            sb.append(line);
            result2.add(sb.toString());
            sb.setLength(0);
        }
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            PyRequirement.$$$reportNull$$$0(66);
        }
        return arrayList;
    }

    @NotNull
    private static List<PyRequirement> parseLine(@NotNull String line, @Nullable VirtualFile containingFile, @NotNull Set<VirtualFile> visitedFiles) {
        if (line == null) {
            PyRequirement.$$$reportNull$$$0(67);
        }
        if (visitedFiles == null) {
            PyRequirement.$$$reportNull$$$0(68);
        }
        if (line.startsWith("-r")) {
            List<PyRequirement> list2 = PyRequirement.parseRecursiveLine(line, containingFile, visitedFiles, "-r".length());
            if (list2 == null) {
                PyRequirement.$$$reportNull$$$0(69);
            }
            return list2;
        }
        if (line.startsWith("--requirement ")) {
            List<PyRequirement> list3 = PyRequirement.parseRecursiveLine(line, containingFile, visitedFiles, "--requirement ".length());
            if (list3 == null) {
                PyRequirement.$$$reportNull$$$0(70);
            }
            return list3;
        }
        List<PyRequirement> list4 = Collections.singletonList(PyRequirement.fromLine(line));
        if (list4 == null) {
            PyRequirement.$$$reportNull$$$0(71);
        }
        return list4;
    }

    @NotNull
    private static String normalizeVcsOrArchiveNameParts(@NotNull List<String> nameParts) {
        if (nameParts == null) {
            PyRequirement.$$$reportNull$$$0(72);
        }
        String string = PyRequirement.normalizeName(StringUtil.join(nameParts, (String)"-"));
        if (string == null) {
            PyRequirement.$$$reportNull$$$0(73);
        }
        return string;
    }

    @Nullable
    private static String normalizeVcsOrArchiveVersionParts(@NotNull List<String> versionParts) {
        if (versionParts == null) {
            PyRequirement.$$$reportNull$$$0(74);
        }
        return versionParts.isEmpty() ? null : PyRequirement.normalizeVersion(StringUtil.join(versionParts, (String)"-"));
    }

    @NotNull
    private static List<String> calculateVcsInstallOptions(@NotNull Matcher matcher) {
        String editable;
        if (matcher == null) {
            PyRequirement.$$$reportNull$$$0(75);
        }
        ArrayList<String> result2 = new ArrayList<String>();
        String srcBefore = matcher.group(VCS_SRC_BEFORE_GROUP);
        if (srcBefore != null) {
            result2.addAll(Arrays.asList(srcBefore.split("\\s+")));
        }
        if ((editable = matcher.group(VCS_EDITABLE_GROUP)) != null) {
            result2.add(editable);
        }
        result2.add(matcher.group(VCS_GROUP));
        String srcAfter = matcher.group(VCS_SRC_AFTER_GROUP);
        if (srcAfter != null) {
            result2.addAll(Arrays.asList(srcAfter.split("\\s+")).subList(1, 3));
        }
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            PyRequirement.$$$reportNull$$$0(76);
        }
        return arrayList;
    }

    @Nullable
    private static String getEgg(@NotNull Matcher matcher) {
        String beforeSubdir;
        if (matcher == null) {
            PyRequirement.$$$reportNull$$$0(77);
        }
        return (beforeSubdir = matcher.group(VCS_EGG_BEFORE_SUBDIR_GROUP)) == null ? matcher.group(VCS_EGG_AFTER_SUBDIR_GROUP) : beforeSubdir;
    }

    @NotNull
    private static String extractProject(@NotNull String path) {
        int end;
        int slashIndex;
        if (path == null) {
            PyRequirement.$$$reportNull$$$0(78);
        }
        if ((slashIndex = path.lastIndexOf("/", (end = path.endsWith("/") ? path.length() - 1 : path.length()) - 1)) != -1) {
            String string = path.substring(slashIndex + 1, end);
            if (string == null) {
                PyRequirement.$$$reportNull$$$0(79);
            }
            return string;
        }
        if (end != path.length()) {
            String string = path.substring(0, end);
            if (string == null) {
                PyRequirement.$$$reportNull$$$0(80);
            }
            return string;
        }
        String string = path;
        if (string == null) {
            PyRequirement.$$$reportNull$$$0(81);
        }
        return string;
    }

    @NotNull
    private static String dropTrunk(@NotNull String path) {
        if (path == null) {
            PyRequirement.$$$reportNull$$$0(82);
        }
        String slashTrunk = "/trunk";
        if (path.endsWith("/trunk")) {
            String string = path.substring(0, path.length() - "/trunk".length());
            if (string == null) {
                PyRequirement.$$$reportNull$$$0(83);
            }
            return string;
        }
        String slashTrunkSlash = "/trunk/";
        if (path.endsWith("/trunk/")) {
            String string = path.substring(0, path.length() - "/trunk/".length());
            if (string == null) {
                PyRequirement.$$$reportNull$$$0(84);
            }
            return string;
        }
        String string = path;
        if (string == null) {
            PyRequirement.$$$reportNull$$$0(85);
        }
        return string;
    }

    @NotNull
    private static String dropRevision(@NotNull String path) {
        int atIndex;
        if (path == null) {
            PyRequirement.$$$reportNull$$$0(86);
        }
        if ((atIndex = path.lastIndexOf("@")) != -1) {
            String string = path.substring(0, atIndex);
            if (string == null) {
                PyRequirement.$$$reportNull$$$0(87);
            }
            return string;
        }
        String string = path;
        if (string == null) {
            PyRequirement.$$$reportNull$$$0(88);
        }
        return string;
    }

    @Nullable
    private static PyRequirementVersionSpec parseVersionSpec(@NotNull String versionSpec) {
        if (versionSpec == null) {
            PyRequirement.$$$reportNull$$$0(89);
        }
        PyRequirementRelation relation = null;
        if (versionSpec.startsWith("===")) {
            relation = PyRequirementRelation.STR_EQ;
        } else if (versionSpec.startsWith("==")) {
            relation = PyRequirementRelation.EQ;
        } else if (versionSpec.startsWith("<=")) {
            relation = PyRequirementRelation.LTE;
        } else if (versionSpec.startsWith(">=")) {
            relation = PyRequirementRelation.GTE;
        } else if (versionSpec.startsWith("<")) {
            relation = PyRequirementRelation.LT;
        } else if (versionSpec.startsWith(">")) {
            relation = PyRequirementRelation.GT;
        } else if (versionSpec.startsWith("~=")) {
            relation = PyRequirementRelation.COMPATIBLE;
        } else if (versionSpec.startsWith("!=")) {
            relation = PyRequirementRelation.NE;
        }
        if (relation != null) {
            int versionIndex = PyRequirement.findFirstNotWhiteSpaceAfter(versionSpec, relation.toString().length());
            return PyRequirement.calculateVersionSpec(versionSpec.substring(versionIndex), relation);
        }
        return null;
    }

    @NotNull
    private static List<PyRequirement> parseRecursiveLine(@NotNull String line, @Nullable VirtualFile containingFile, @NotNull Set<VirtualFile> visitedFiles, int flagLength) {
        if (line == null) {
            PyRequirement.$$$reportNull$$$0(90);
        }
        if (visitedFiles == null) {
            PyRequirement.$$$reportNull$$$0(91);
        }
        if (containingFile == null) {
            List<PyRequirement> list2 = Collections.emptyList();
            if (list2 == null) {
                PyRequirement.$$$reportNull$$$0(92);
            }
            return list2;
        }
        int pathIndex = PyRequirement.findFirstNotWhiteSpaceAfter(line, flagLength);
        if (pathIndex == line.length()) {
            List<PyRequirement> list3 = Collections.emptyList();
            if (list3 == null) {
                PyRequirement.$$$reportNull$$$0(93);
            }
            return list3;
        }
        String path = FileUtil.toSystemIndependentName((String)line.substring(pathIndex));
        VirtualFile file2 = PyRequirement.findRecursiveFile(containingFile, path);
        if (file2 != null && !visitedFiles.contains(file2)) {
            List<PyRequirement> list4 = PyRequirement.fromText(PyRequirement.loadText(file2), file2, visitedFiles);
            if (list4 == null) {
                PyRequirement.$$$reportNull$$$0(94);
            }
            return list4;
        }
        List<PyRequirement> list5 = Collections.emptyList();
        if (list5 == null) {
            PyRequirement.$$$reportNull$$$0(95);
        }
        return list5;
    }

    @NotNull
    private static String normalizeName(@NotNull String s) {
        if (s == null) {
            PyRequirement.$$$reportNull$$$0(96);
        }
        String string = s.replace("_", "-");
        if (string == null) {
            PyRequirement.$$$reportNull$$$0(97);
        }
        return string;
    }

    @NotNull
    private static String normalizeVersion(@NotNull String s) {
        if (s == null) {
            PyRequirement.$$$reportNull$$$0(98);
        }
        String string = s.replace("_", "-").replaceAll("-?py[\\d\\.]+", "");
        if (string == null) {
            PyRequirement.$$$reportNull$$$0(99);
        }
        return string;
    }

    private static int findFirstNotWhiteSpaceAfter(@NotNull String line, int beginIndex) {
        if (line == null) {
            PyRequirement.$$$reportNull$$$0(100);
        }
        for (int i = beginIndex; i < line.length(); ++i) {
            if (StringUtil.isWhiteSpace((char)line.charAt(i))) continue;
            return i;
        }
        return line.length();
    }

    private static int findFirstNotWhiteSpaceBefore(@NotNull String line, int beginIndex) {
        if (line == null) {
            PyRequirement.$$$reportNull$$$0(101);
        }
        for (int i = beginIndex; i >= 0; --i) {
            if (StringUtil.isWhiteSpace((char)line.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    @Nullable
    private static VirtualFile findRecursiveFile(@NotNull VirtualFile containingFile, @NotNull String path) {
        VirtualFile dir;
        if (containingFile == null) {
            PyRequirement.$$$reportNull$$$0(102);
        }
        if (path == null) {
            PyRequirement.$$$reportNull$$$0(103);
        }
        if ((dir = containingFile.getParent()) == null) {
            return null;
        }
        VirtualFile file2 = dir.findFileByRelativePath(path);
        if (file2 != null) {
            return file2;
        }
        return LocalFileSystem.getInstance().findFileByPath(path);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 32: 
            case 34: 
            case 37: 
            case 38: 
            case 46: 
            case 48: 
            case 51: 
            case 52: 
            case 54: 
            case 57: 
            case 58: 
            case 60: 
            case 61: 
            case 62: 
            case 64: 
            case 66: 
            case 69: 
            case 70: 
            case 71: 
            case 73: 
            case 76: 
            case 79: 
            case 80: 
            case 81: 
            case 83: 
            case 84: 
            case 85: 
            case 87: 
            case 88: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 97: 
            case 99: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 32: 
            case 34: 
            case 37: 
            case 38: 
            case 46: 
            case 48: 
            case 51: 
            case 52: 
            case 54: 
            case 57: 
            case 58: 
            case 60: 
            case 61: 
            case 62: 
            case 64: 
            case 66: 
            case 69: 
            case 70: 
            case 71: 
            case 73: 
            case 76: 
            case 79: 
            case 80: 
            case 81: 
            case 83: 
            case 84: 
            case 85: 
            case 87: 
            case 88: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 97: 
            case 99: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = NAME_GROUP;
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relation";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 8: 
            case 11: 
            case 17: 
            case 20: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "installOptions";
                break;
            }
            case 12: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = REQUIREMENT_EXTRAS_GROUP;
                break;
            }
            case 14: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionSpecs";
                break;
            }
            case 22: 
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparator";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 32: 
            case 34: 
            case 37: 
            case 38: 
            case 46: 
            case 48: 
            case 51: 
            case 52: 
            case 54: 
            case 57: 
            case 58: 
            case 60: 
            case 61: 
            case 62: 
            case 64: 
            case 66: 
            case 69: 
            case 70: 
            case 71: 
            case 73: 
            case 76: 
            case 79: 
            case 80: 
            case 81: 
            case 83: 
            case 84: 
            case 85: 
            case 87: 
            case 88: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 97: 
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/packaging/PyRequirement";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packages";
                break;
            }
            case 30: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 49: 
            case 67: 
            case 90: 
            case 100: 
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 31: 
            case 44: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 33: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedRelation";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 45: 
            case 68: 
            case 91: 
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitedFiles";
                break;
            }
            case 50: 
            case 59: 
            case 63: 
            case 75: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameAndVersion";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameParts";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionParts";
                break;
            }
            case 78: 
            case 82: 
            case 86: 
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = PATH_IN_VCS_GROUP;
                break;
            }
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionSpec";
                break;
            }
            case 96: 
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/packaging/PyRequirement";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "withVersionComparator";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullName";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtras";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersionSpecs";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstallOptions";
                break;
            }
            case 32: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "fromText";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "fromFile";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateVersionSpec";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "loadText";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "dropComments";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "parseNameAndVersionFromVcsOrArchive";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "createVcsOrArchiveRequirement";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "createVcsRequirement";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "parseVersionSpecs";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateRequirementInstallOptions";
                break;
            }
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "splitByLinesAndCollapse";
                break;
            }
            case 69: 
            case 70: 
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "parseLine";
                break;
            }
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizeVcsOrArchiveNameParts";
                break;
            }
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateVcsInstallOptions";
                break;
            }
            case 79: 
            case 80: 
            case 81: {
                objectArray = objectArray2;
                objectArray2[1] = "extractProject";
                break;
            }
            case 83: 
            case 84: 
            case 85: {
                objectArray = objectArray2;
                objectArray2[1] = "dropTrunk";
                break;
            }
            case 87: 
            case 88: {
                objectArray = objectArray2;
                objectArray2[1] = "dropRevision";
                break;
            }
            case 92: 
            case 93: 
            case 94: 
            case 95: {
                objectArray = objectArray2;
                objectArray2[1] = "parseRecursiveLine";
                break;
            }
            case 97: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizeName";
                break;
            }
            case 99: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizeVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "withVersionComparator";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 32: 
            case 34: 
            case 37: 
            case 38: 
            case 46: 
            case 48: 
            case 51: 
            case 52: 
            case 54: 
            case 57: 
            case 58: 
            case 60: 
            case 61: 
            case 62: 
            case 64: 
            case 66: 
            case 69: 
            case 70: 
            case 71: 
            case 73: 
            case 76: 
            case 79: 
            case 80: 
            case 81: 
            case 83: 
            case 84: 
            case 85: 
            case 87: 
            case 88: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 97: 
            case 99: {
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "match";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "fromLine";
                break;
            }
            case 31: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "fromText";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "fromFile";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "calculateVersionSpec";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "parseGitArchiveUrl";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "parseArchiveUrl";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "parseVcsProjectUrl";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "parseRequirement";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "loadText";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "dropComments";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "parseNameAndVersionFromVcsOrArchive";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "createVcsOrArchiveRequirement";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "createVcsRequirement";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "calculateRequirementInstallOptions";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "splitByLinesAndCollapse";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "parseLine";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "normalizeVcsOrArchiveNameParts";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "normalizeVcsOrArchiveVersionParts";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "calculateVcsInstallOptions";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "getEgg";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "extractProject";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "dropTrunk";
                break;
            }
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "dropRevision";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "parseVersionSpec";
                break;
            }
            case 90: 
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "parseRecursiveLine";
                break;
            }
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "normalizeName";
                break;
            }
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "normalizeVersion";
                break;
            }
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "findFirstNotWhiteSpaceAfter";
                break;
            }
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "findFirstNotWhiteSpaceBefore";
                break;
            }
            case 102: 
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "findRecursiveFile";
                break;
            }
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "lambda$fromText$4";
                break;
            }
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "lambda$withVersionComparator$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 32: 
            case 34: 
            case 37: 
            case 38: 
            case 46: 
            case 48: 
            case 51: 
            case 52: 
            case 54: 
            case 57: 
            case 58: 
            case 60: 
            case 61: 
            case 62: 
            case 64: 
            case 66: 
            case 69: 
            case 70: 
            case 71: 
            case 73: 
            case 76: 
            case 79: 
            case 80: 
            case 81: 
            case 83: 
            case 84: 
            case 85: 
            case 87: 
            case 88: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 97: 
            case 99: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

