/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.ResolveState;
import com.intellij.psi.TokenType;
import com.intellij.psi.scope.DelegatingScopeProcessor;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.ArrayUtil;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonDialectsTokenSetProvider;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStarImportElement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBaseElementImpl;
import com.jetbrains.python.psi.impl.PyImportStatementImpl;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.impl.ResolveResultList;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.resolve.ResolveImportUtil;
import com.jetbrains.python.psi.stubs.PyFromImportStatementStub;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyFromImportStatementImpl
extends PyBaseElementImpl<PyFromImportStatementStub>
implements PyFromImportStatement {
    public PyFromImportStatementImpl(ASTNode astNode) {
        super(astNode);
    }

    public PyFromImportStatementImpl(PyFromImportStatementStub stub) {
        this(stub, (IStubElementType)PyElementTypes.FROM_IMPORT_STATEMENT);
    }

    public PyFromImportStatementImpl(PyFromImportStatementStub stub, IStubElementType nodeType) {
        super(stub, nodeType);
    }

    @Override
    protected void acceptPyVisitor(PyElementVisitor pyVisitor) {
        pyVisitor.visitPyFromImportStatement(this);
    }

    @Override
    public boolean isStarImport() {
        return this.getStarImportElement() != null;
    }

    @Override
    @Nullable
    public PyReferenceExpression getImportSource() {
        return (PyReferenceExpression)this.childToPsi(PythonDialectsTokenSetProvider.INSTANCE.getReferenceExpressionTokens(), 0);
    }

    @Override
    public QualifiedName getImportSourceQName() {
        PyFromImportStatementStub stub = (PyFromImportStatementStub)this.getStub();
        if (stub != null) {
            QualifiedName qName = stub.getImportSourceQName();
            if (qName != null && qName.getComponentCount() == 0) {
                return null;
            }
            return qName;
        }
        PyReferenceExpression importSource = this.getImportSource();
        if (importSource == null) {
            return null;
        }
        return importSource.asQualifiedName();
    }

    @Override
    @NotNull
    public PyImportElement[] getImportElements() {
        PyFromImportStatementStub stub = (PyFromImportStatementStub)this.getStub();
        if (stub != null) {
            PyImportElement[] pyImportElementArray = (PyImportElement[])stub.getChildrenByType((IElementType)PyElementTypes.IMPORT_ELEMENT, PyImportElement[]::new);
            if (pyImportElementArray == null) {
                PyFromImportStatementImpl.$$$reportNull$$$0(0);
            }
            return pyImportElementArray;
        }
        ArrayList<PyImportElement> result2 = new ArrayList<PyImportElement>();
        ASTNode importKeyword = this.getNode().findChildByType((IElementType)PyTokenTypes.IMPORT_KEYWORD);
        if (importKeyword != null) {
            for (ASTNode node = importKeyword.getTreeNext(); node != null; node = node.getTreeNext()) {
                if (node.getElementType() != PyElementTypes.IMPORT_ELEMENT) continue;
                result2.add((PyImportElement)node.getPsi());
            }
        }
        PyImportElement[] pyImportElementArray = result2.toArray(new PyImportElement[result2.size()]);
        if (pyImportElementArray == null) {
            PyFromImportStatementImpl.$$$reportNull$$$0(1);
        }
        return pyImportElementArray;
    }

    @Override
    @Nullable
    public PyStarImportElement getStarImportElement() {
        return this.getStubOrPsiChild(PyElementTypes.STAR_IMPORT_ELEMENT);
    }

    @Override
    public int getRelativeLevel() {
        ASTNode seeker;
        PyFromImportStatementStub stub = (PyFromImportStatementStub)this.getStub();
        if (stub != null) {
            return stub.getRelativeLevel();
        }
        int result2 = 0;
        for (seeker = this.getNode().getFirstChildNode(); seeker != null && (seeker.getElementType() == PyTokenTypes.FROM_KEYWORD || seeker.getElementType() == TokenType.WHITE_SPACE); seeker = seeker.getTreeNext()) {
        }
        while (seeker != null && seeker.getElementType() == PyTokenTypes.DOT) {
            ++result2;
            seeker = seeker.getTreeNext();
        }
        return result2;
    }

    @Override
    public boolean isFromFuture() {
        QualifiedName qName = this.getImportSourceQName();
        return qName != null && qName.matches(new String[]{"__future__"});
    }

    @Override
    public PsiElement getLeftParen() {
        return this.findChildByType(PyTokenTypes.LPAR);
    }

    @Override
    public PsiElement getRightParen() {
        return this.findChildByType(PyTokenTypes.RPAR);
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor2, @NotNull ResolveState state2, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor2 == null) {
            PyFromImportStatementImpl.$$$reportNull$$$0(2);
        }
        if (state2 == null) {
            PyFromImportStatementImpl.$$$reportNull$$$0(3);
        }
        if (place == null) {
            PyFromImportStatementImpl.$$$reportNull$$$0(4);
        }
        if (place.getContainingFile() != this.getContainingFile()) {
            return true;
        }
        if (this.isStarImport()) {
            List<PsiElement> targets = ResolveImportUtil.resolveFromImportStatementSource(this, this.getImportSourceQName());
            for (PsiElement target2 : targets) {
                DelegatingScopeProcessor starImportableNamesProcessor;
                final PsiElement importedFile = PyUtil.turnDirIntoInit(target2);
                if (importedFile == null || importedFile.processDeclarations((PsiScopeProcessor)(starImportableNamesProcessor = new DelegatingScopeProcessor(processor2){

                    @Override
                    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state2) {
                        if (element == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (state2 == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        if (element instanceof PyElement && importedFile instanceof PyFile && !PyUtil.isStarImportableFrom(StringUtil.notNullize((String)((PyElement)element).getName()), (PyFile)importedFile)) {
                            return true;
                        }
                        return super.execute(element, state2);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "element";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "state";
                                break;
                            }
                        }
                        objectArray[1] = "com/jetbrains/python/psi/impl/PyFromImportStatementImpl$1";
                        objectArray[2] = "execute";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                }), state2, null, place)) continue;
                return false;
            }
        } else {
            PyImportElement[] importElements;
            for (PyImportElement element : importElements = this.getImportElements()) {
                if (processor2.execute((PsiElement)element, state2)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public ASTNode addInternal(ASTNode first, ASTNode last, ASTNode anchor, Boolean before) {
        ASTNode result2;
        PsiElement lastChild;
        if (anchor == null && (lastChild = this.getLastChild()) != null) {
            while (lastChild instanceof PsiComment) {
                lastChild = lastChild.getPrevSibling();
                anchor = lastChild.getNode();
            }
            ASTNode rpar_node = lastChild.getNode();
            if (rpar_node != null && rpar_node.getElementType() == PyTokenTypes.RPAR) {
                anchor = rpar_node;
            }
        }
        ASTNode prevNode = result2 = super.addInternal(first, last, anchor, before);
        while ((prevNode = prevNode.getTreePrev()) != null && prevNode.getElementType() == TokenType.WHITE_SPACE) {
        }
        if (prevNode != null && prevNode.getElementType() == PyElementTypes.IMPORT_ELEMENT && result2.getElementType() == PyElementTypes.IMPORT_ELEMENT) {
            ASTNode comma = PyElementGenerator.getInstance(this.getProject()).createComma();
            super.addInternal(comma, comma, prevNode, false);
        }
        return result2;
    }

    @Override
    public void deleteChildInternal(@NotNull ASTNode child) {
        if (child == null) {
            PyFromImportStatementImpl.$$$reportNull$$$0(5);
        }
        if (ArrayUtil.contains((Object)child.getPsi(), (Object[])this.getImportElements())) {
            PyPsiUtils.deleteAdjacentCommaWithWhitespaces((PsiElement)this, child.getPsi());
        }
        super.deleteChildInternal(child);
    }

    @Override
    @Nullable
    public PsiFileSystemItem resolveImportSource() {
        return (PsiFileSystemItem)FluentIterable.from(this.resolveImportSourceCandidates()).filter(PsiFileSystemItem.class).first().orNull();
    }

    @Override
    @NotNull
    public List<PsiElement> resolveImportSourceCandidates() {
        int level;
        QualifiedName qName = this.getImportSourceQName();
        if (qName == null && (level = this.getRelativeLevel()) > 0) {
            PsiDirectory upper = ResolveImportUtil.stepBackFrom(this.getContainingFile().getOriginalFile(), level);
            List<Object> list2 = upper == null ? Collections.emptyList() : Collections.singletonList(upper);
            if (list2 == null) {
                PyFromImportStatementImpl.$$$reportNull$$$0(6);
            }
            return list2;
        }
        List<PsiElement> list3 = ResolveImportUtil.resolveFromImportStatementSource(this, qName);
        if (list3 == null) {
            PyFromImportStatementImpl.$$$reportNull$$$0(7);
        }
        return list3;
    }

    @Override
    @NotNull
    public List<String> getFullyQualifiedObjectNames() {
        QualifiedName source = this.getImportSourceQName();
        String prefix = source != null ? source.join(".") + '.' : "";
        List<String> unqualifiedNames = PyImportStatementImpl.getImportElementNames(this.getImportElements());
        ArrayList<String> result2 = new ArrayList<String>(unqualifiedNames.size());
        for (String unqualifiedName : unqualifiedNames) {
            result2.add(prefix + unqualifiedName);
        }
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            PyFromImportStatementImpl.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public Iterable<PyElement> iterateNames() {
        PyElement resolved = PyUtil.as(this.resolveImplicitSubModule(), PyElement.class);
        ImmutableList immutableList = resolved != null ? ImmutableList.of((Object)resolved) : Collections.emptyList();
        if (immutableList == null) {
            PyFromImportStatementImpl.$$$reportNull$$$0(9);
        }
        return immutableList;
    }

    @Override
    @NotNull
    public List<RatedResolveResult> multiResolveName(@NotNull String name) {
        PsiElement element;
        QualifiedName importSourceQName;
        if (name == null) {
            PyFromImportStatementImpl.$$$reportNull$$$0(10);
        }
        if ((importSourceQName = this.getImportSourceQName()) != null && importSourceQName.endsWith(name) && (element = this.resolveImplicitSubModule()) != null) {
            List<RatedResolveResult> list2 = ResolveResultList.to(element);
            if (list2 == null) {
                PyFromImportStatementImpl.$$$reportNull$$$0(11);
            }
            return list2;
        }
        List<RatedResolveResult> list3 = Collections.emptyList();
        if (list3 == null) {
            PyFromImportStatementImpl.$$$reportNull$$$0(12);
        }
        return list3;
    }

    @Nullable
    private PsiElement resolveImplicitSubModule() {
        QualifiedName importSourceQName = this.getImportSourceQName();
        if (importSourceQName != null) {
            PsiElement resolvedImportSource;
            String name = importSourceQName.getLastComponent();
            PsiFile file2 = this.getContainingFile();
            if (name != null && PyUtil.isPackage(file2) && (resolvedImportSource = PyUtil.turnInitIntoDir((PsiElement)this.resolveImportSource())) != null && resolvedImportSource.getParent() == file2.getContainingDirectory()) {
                return resolvedImportSource;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/impl/PyFromImportStatementImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportElements";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/impl/PyFromImportStatementImpl";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveImportSourceCandidates";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullyQualifiedObjectNames";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "iterateNames";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolveName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "deleteChildInternal";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "multiResolveName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

