/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.changeSignature;

import com.intellij.lang.Language;
import com.intellij.refactoring.changeSignature.ChangeInfo;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.refactoring.changeSignature.PyParameterInfo;
import org.jetbrains.annotations.NotNull;

public class PyChangeInfo
implements ChangeInfo {
    private final PyFunction myFunction;
    private PyParameterInfo[] myNewParameterInfo;
    private final String myNewName;
    private boolean myIsParameterSetOrOrderChanged;
    private boolean myIsParametersNameChanged;
    private final boolean myIsNameChanged;

    public PyChangeInfo(PyFunction function, PyParameterInfo[] newParameterInfo, String newName) {
        this.myFunction = function;
        this.myNewParameterInfo = newParameterInfo;
        this.myNewName = newName;
        this.myIsNameChanged = !newName.equals(function.getName());
        PyParameter[] oldParameters = function.getParameterList().getParameters();
        if (oldParameters.length != newParameterInfo.length) {
            this.myIsParameterSetOrOrderChanged = true;
            this.myIsParametersNameChanged = true;
        } else {
            this.myIsParameterSetOrOrderChanged = false;
            for (int i = 0; i < newParameterInfo.length; ++i) {
                PyParameterInfo parameterInfo = newParameterInfo[i];
                if (i != parameterInfo.getOldIndex()) {
                    this.myIsParameterSetOrOrderChanged = true;
                }
                if (!parameterInfo.getName().equals(oldParameters[i].getName())) {
                    this.myIsParameterSetOrOrderChanged = true;
                    this.myIsParametersNameChanged = true;
                }
                String defaultValue = parameterInfo.getDefaultValue();
                PyExpression oldDefaultValue = oldParameters[i].getDefaultValue();
                if (oldDefaultValue == null && defaultValue != null || defaultValue == null && oldDefaultValue != null) {
                    this.myIsParameterSetOrOrderChanged = true;
                }
                if (oldDefaultValue != null && !oldDefaultValue.getText().equals(defaultValue)) {
                    this.myIsParameterSetOrOrderChanged = true;
                }
                if (parameterInfo.getDefaultInSignature() == oldParameters[i].hasDefaultValue()) continue;
                this.myIsParameterSetOrOrderChanged = true;
            }
        }
    }

    public PyFunction getMethod() {
        return this.myFunction;
    }

    @NotNull
    public PyParameterInfo[] getNewParameters() {
        if (this.myNewParameterInfo == null) {
            PyChangeInfo.$$$reportNull$$$0(0);
        }
        return this.myNewParameterInfo;
    }

    public String getNewName() {
        return this.myNewName;
    }

    public boolean isParameterSetOrOrderChanged() {
        return this.myIsParameterSetOrOrderChanged;
    }

    public boolean isParameterTypesChanged() {
        return false;
    }

    public boolean isParameterNamesChanged() {
        return this.myIsParametersNameChanged;
    }

    public boolean isNameChanged() {
        return this.myIsNameChanged;
    }

    public boolean isGenerateDelegate() {
        return false;
    }

    public boolean isReturnTypeChanged() {
        return false;
    }

    public Language getLanguage() {
        return PythonFileType.INSTANCE.getLanguage();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/changeSignature/PyChangeInfo", "getNewParameters"));
    }
}

