/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.testing;

import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.util.ThreeState;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.run.PythonConfigurationFactoryBase;
import com.jetbrains.python.testing.PyNoseTestFactory;
import com.jetbrains.python.testing.PyTestFactory;
import com.jetbrains.python.testing.PyTrialTestFactory;
import com.jetbrains.python.testing.PyUnitTestFactory;
import com.jetbrains.python.testing.PythonTestConfigurationType;
import com.jetbrains.python.testing.PythonTestConfigurationsModel;
import com.jetbrains.python.testing.PythonUnitTestUtil;
import com.jetbrains.python.testing.TestRunnerService;
import com.jetbrains.reflection.Property;
import java.util.Set;
import java.util.regex.Pattern;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessage;
import jetbrains.buildServer.messages.serviceMessages.TestStdErr;
import jetbrains.buildServer.messages.serviceMessages.TestStdOut;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000T\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u001a\b\u0010\u0017\u001a\u00020\u0001H\u0000\u001a\u001e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f\u001a\u000e\u0010 \u001a\u00020\u00012\u0006\u0010!\u001a\u00020\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0002\u001a\n \u0004*\u0004\u0018\u00010\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001f\u0010\u0005\u001a\u0010\u0012\f\u0012\n \u0004*\u0004\u0018\u00010\u00010\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0019\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\r\"\u0018\u0010\u000f\u001a\u00020\u0001*\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\""}, d2={"DEFAULT_PATH", "", "PATH_URL", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "RunnersThatRequireTestCaseClass", "", "getRunnersThatRequireTestCaseClass", "()Ljava/util/Set;", "factories", "", "Lcom/jetbrains/python/run/PythonConfigurationFactoryBase;", "getFactories", "()[Lcom/jetbrains/python/run/PythonConfigurationFactoryBase;", "[Lcom/jetbrains/python/run/PythonConfigurationFactoryBase;", "prefixedName", "Lcom/jetbrains/reflection/Property;", "getPrefixedName", "(Lcom/jetbrains/reflection/Property;)Ljava/lang/String;", "findConfigurationFactoryFromSettings", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "module", "Lcom/intellij/openapi/module/Module;", "getAdditionalArgumentsPropertyName", "isTestElement", "", "element", "Lcom/intellij/psi/PsiElement;", "testCaseClassRequired", "Lcom/intellij/util/ThreeState;", "typeEvalContext", "Lcom/jetbrains/python/psi/types/TypeEvalContext;", "processTCMessage", "text", "python-community"})
public final class PyTestsSharedKt {
    @NotNull
    private static final PythonConfigurationFactoryBase[] factories = new PythonConfigurationFactoryBase[]{PyUnitTestFactory.INSTANCE, PyTestFactory.INSTANCE, PyNoseTestFactory.INSTANCE, PyTrialTestFactory.INSTANCE};
    @NotNull
    private static final Set<String> RunnersThatRequireTestCaseClass = SetsKt.setOf((Object)PythonTestConfigurationsModel.PYTHONS_UNITTEST_NAME);
    private static final Pattern PATH_URL = Pattern.compile("^python<([^<>]+)>$");
    private static final String DEFAULT_PATH = "";

    @NotNull
    public static final PythonConfigurationFactoryBase[] getFactories() {
        return factories;
    }

    @NotNull
    public static final String processTCMessage(@NotNull String text) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        String string2 = text;
        ServiceMessage serviceMessage = ServiceMessage.parse((String)((Object)StringsKt.trim((CharSequence)string2)).toString());
        if (serviceMessage == null) {
            return text;
        }
        ServiceMessage parsedMessage = serviceMessage;
        string2 = parsedMessage;
        if (string2 instanceof TestStdOut) {
            String string3 = ((TestStdOut)parsedMessage).getStdOut();
            string = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"parsedMessage.stdOut");
        } else if (string2 instanceof TestStdErr) {
            String string4 = ((TestStdErr)parsedMessage).getStdErr();
            string = string4;
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"parsedMessage.stdErr");
        } else {
            string = DEFAULT_PATH;
        }
        return string;
    }

    @NotNull
    public static final String getAdditionalArgumentsPropertyName() {
        return "additionalArguments";
    }

    @NotNull
    public static final Set<String> getRunnersThatRequireTestCaseClass() {
        return RunnersThatRequireTestCaseClass;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isTestElement(@NotNull PsiElement element, @NotNull ThreeState testCaseClassRequired, @NotNull TypeEvalContext typeEvalContext) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)testCaseClassRequired, (String)"testCaseClassRequired");
        Intrinsics.checkParameterIsNotNull((Object)typeEvalContext, (String)"typeEvalContext");
        PsiElement psiElement = element;
        if (psiElement instanceof PyFile) {
            bl = PythonUnitTestUtil.isTestFile((PyFile)element, testCaseClassRequired, typeEvalContext);
            return bl;
        } else {
            if (psiElement instanceof PsiDirectory) {
                if (StringsKt.contains((CharSequence)((PsiDirectory)element).getName(), (CharSequence)"test", (boolean)true)) return true;
                Object[] $receiver$iv = ((PsiDirectory)element).getChildren();
                int n = 0;
                while (n < $receiver$iv.length) {
                    Object element$iv = $receiver$iv[n];
                    PsiElement it = (PsiElement)element$iv;
                    if (it instanceof PyFile && PythonUnitTestUtil.isTestFile((PyFile)it, testCaseClassRequired, typeEvalContext)) {
                        return true;
                    }
                    boolean bl2 = false;
                    if (bl2) {
                        return true;
                    }
                    ++n;
                }
                return false;
            }
            if (psiElement instanceof PyFunction) {
                bl = PythonUnitTestUtil.isTestFunction((PyFunction)element, testCaseClassRequired, typeEvalContext);
                return bl;
            } else {
                if (!(psiElement instanceof PyClass)) return false;
                bl = PythonUnitTestUtil.isTestClass((PyClass)element, testCaseClassRequired, typeEvalContext);
            }
        }
        return bl;
    }

    private static final ConfigurationFactory findConfigurationFactoryFromSettings(Module module2) {
        ConfigurationFactory configurationFactory;
        ConfigurationFactory configurationFactory2;
        Object object;
        ConfigurationFactory[] factories;
        block2: {
            Object[] objectArray;
            String name = TestRunnerService.getInstance(module2).getProjectConfiguration();
            factories = PythonTestConfigurationType.getInstance().getConfigurationFactories();
            Object[] objectArray2 = objectArray = (Object[])factories;
            for (int i = 0; i < objectArray2.length; ++i) {
                Object object2 = objectArray2[i];
                ConfigurationFactory it = (ConfigurationFactory)object2;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)name)) continue;
                object = object2;
                break block2;
            }
            object = null;
        }
        if ((configurationFactory2 = (configurationFactory = (ConfigurationFactory)object)) == null) {
            Object object3 = ArraysKt.first((Object[])factories);
            Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"factories.first()");
            configurationFactory2 = (ConfigurationFactory)object3;
        }
        return configurationFactory2;
    }

    private static final String getPrefixedName(@NotNull Property $receiver) {
        return "_new_" + $receiver.getName();
    }

    static {
        DEFAULT_PATH = DEFAULT_PATH;
    }

    public static final /* synthetic */ Pattern access$getPATH_URL$p() {
        return PATH_URL;
    }

    @NotNull
    public static final /* synthetic */ String access$getDEFAULT_PATH$p() {
        return DEFAULT_PATH;
    }

    @NotNull
    public static final /* synthetic */ String access$getPrefixedName$p(@NotNull Property $receiver) {
        return PyTestsSharedKt.getPrefixedName($receiver);
    }

    @NotNull
    public static final /* synthetic */ ConfigurationFactory access$findConfigurationFactoryFromSettings(@NotNull Module module2) {
        return PyTestsSharedKt.findConfigurationFactoryFromSettings(module2);
    }
}

