/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.testing.doctest;

import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.testing.AbstractPythonLegacyTestRunConfiguration;
import com.jetbrains.python.testing.PythonTestConfigurationType;
import com.jetbrains.python.testing.PythonTestLegacyConfigurationProducer;
import com.jetbrains.python.testing.doctest.PythonDocTestUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonDocTestConfigurationProducer
extends PythonTestLegacyConfigurationProducer {
    public PythonDocTestConfigurationProducer() {
        super(PythonTestConfigurationType.getInstance().PY_DOCTEST_FACTORY);
    }

    @Override
    protected boolean isTestFunction(@NotNull PyFunction pyFunction, @Nullable AbstractPythonLegacyTestRunConfiguration configuration) {
        if (pyFunction == null) {
            PythonDocTestConfigurationProducer.$$$reportNull$$$0(0);
        }
        return PythonDocTestUtil.isDocTestFunction(pyFunction);
    }

    @Override
    protected boolean isTestClass(@NotNull PyClass pyClass, @Nullable AbstractPythonLegacyTestRunConfiguration configuration, @Nullable TypeEvalContext context) {
        if (pyClass == null) {
            PythonDocTestConfigurationProducer.$$$reportNull$$$0(1);
        }
        return PythonDocTestUtil.isDocTestClass(pyClass);
    }

    @Override
    protected boolean isTestFile(@NotNull PyFile file2) {
        List<PyElement> testCases;
        if (file2 == null) {
            PythonDocTestConfigurationProducer.$$$reportNull$$$0(2);
        }
        return !(testCases = PythonDocTestUtil.getDocTestCasesFromFile(file2)).isEmpty();
    }

    @Override
    protected boolean isAvailable(@NotNull Location location) {
        Module module2;
        if (location == null) {
            PythonDocTestConfigurationProducer.$$$reportNull$$$0(3);
        }
        if (!PythonDocTestConfigurationProducer.isPythonModule(module2 = location.getModule())) {
            return false;
        }
        PsiElement element = location.getPsiElement();
        if (element instanceof PsiFile) {
            PyDocTestVisitor visitor2 = new PyDocTestVisitor();
            element.accept((PsiElementVisitor)visitor2);
            return visitor2.hasTests;
        }
        return true;
    }

    public boolean shouldReplace(@NotNull ConfigurationFromContext self, @NotNull ConfigurationFromContext other) {
        if (self == null) {
            PythonDocTestConfigurationProducer.$$$reportNull$$$0(4);
        }
        if (other == null) {
            PythonDocTestConfigurationProducer.$$$reportNull$$$0(5);
        }
        return self.isProducedBy(((Object)((Object)this)).getClass());
    }

    @Override
    protected boolean isTestFolder(@NotNull VirtualFile virtualFile, @NotNull Project project) {
        if (virtualFile == null) {
            PythonDocTestConfigurationProducer.$$$reportNull$$$0(6);
        }
        if (project == null) {
            PythonDocTestConfigurationProducer.$$$reportNull$$$0(7);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyFunction";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "self";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/testing/doctest/PythonDocTestConfigurationProducer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isTestFunction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isTestClass";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isTestFile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailable";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldReplace";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isTestFolder";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class PyDocTestVisitor
    extends PsiRecursiveElementVisitor {
        boolean hasTests = false;

        private PyDocTestVisitor() {
        }

        public void visitFile(PsiFile node) {
            if (node instanceof PyFile) {
                List<PyElement> testClasses = PythonDocTestUtil.getDocTestCasesFromFile((PyFile)node);
                if (!testClasses.isEmpty()) {
                    this.hasTests = true;
                }
            } else {
                String text = node.getText();
                if (PythonDocTestUtil.hasExample(text)) {
                    this.hasTests = true;
                }
            }
        }
    }
}

