/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.NotNullProducer;
import com.intellij.util.SystemProperties;
import com.intellij.util.io.NettyKt;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.MultithreadEventLoopGroup;
import io.netty.channel.oio.OioEventLoopGroup;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Random;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.ChannelRegistrar;
import org.jetbrains.io.DelegatingHttpRequestHandler;
import org.jetbrains.io.PortUnificationServerHandler;

public class BuiltInServer
implements Disposable {
    private static final int[] FORBIDDEN_PORTS = new int[]{6953, 6969, 6970};
    private final EventLoopGroup eventLoopGroup;
    private final int port;
    private final ChannelRegistrar channelRegistrar;

    private BuiltInServer(@NotNull EventLoopGroup eventLoopGroup, int port, @NotNull ChannelRegistrar channelRegistrar) {
        if (eventLoopGroup == null) {
            BuiltInServer.$$$reportNull$$$0(0);
        }
        if (channelRegistrar == null) {
            BuiltInServer.$$$reportNull$$$0(1);
        }
        this.eventLoopGroup = eventLoopGroup;
        this.port = port;
        this.channelRegistrar = channelRegistrar;
    }

    @NotNull
    public EventLoopGroup getEventLoopGroup() {
        EventLoopGroup eventLoopGroup = this.eventLoopGroup;
        if (eventLoopGroup == null) {
            BuiltInServer.$$$reportNull$$$0(2);
        }
        return eventLoopGroup;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isRunning() {
        return !this.channelRegistrar.isEmpty();
    }

    public void dispose() {
        this.channelRegistrar.close();
        Logger.getInstance(BuiltInServer.class).info("web server stopped");
    }

    @NotNull
    public static BuiltInServer start(int workerCount, int firstPort, int portsCount, boolean tryAnyPort, @Nullable NotNullProducer<ChannelHandler> handler2) throws Exception {
        BuiltInServer builtInServer = BuiltInServer.start((EventLoopGroup)NettyKt.MultiThreadEventLoopGroup(workerCount, new BuiltInServerThreadFactory()), true, firstPort, portsCount, tryAnyPort, handler2);
        if (builtInServer == null) {
            BuiltInServer.$$$reportNull$$$0(3);
        }
        return builtInServer;
    }

    @NotNull
    public static BuiltInServer startNioOrOio(int workerCount, int firstPort, int portsCount, boolean tryAnyPort, @Nullable NotNullProducer<ChannelHandler> handler2) throws Exception {
        MultithreadEventLoopGroup loopGroup;
        BuiltInServerThreadFactory threadFactory = new BuiltInServerThreadFactory();
        try {
            loopGroup = NettyKt.MultiThreadEventLoopGroup(workerCount, threadFactory);
        }
        catch (IllegalStateException e) {
            Logger.getInstance(BuiltInServer.class).warn((Throwable)e);
            loopGroup = new OioEventLoopGroup(1, (ThreadFactory)threadFactory);
        }
        BuiltInServer builtInServer = BuiltInServer.start((EventLoopGroup)loopGroup, true, firstPort, portsCount, tryAnyPort, handler2);
        if (builtInServer == null) {
            BuiltInServer.$$$reportNull$$$0(4);
        }
        return builtInServer;
    }

    @NotNull
    public static BuiltInServer start(@NotNull EventLoopGroup eventLoopGroup, boolean isEventLoopGroupOwner, int firstPort, int portsCount, boolean tryAnyPort, @Nullable NotNullProducer<ChannelHandler> handler2) throws Exception {
        if (eventLoopGroup == null) {
            BuiltInServer.$$$reportNull$$$0(5);
        }
        ChannelRegistrar channelRegistrar = new ChannelRegistrar();
        ServerBootstrap bootstrap = NettyKt.serverBootstrap(eventLoopGroup);
        BuiltInServer.configureChildHandler(bootstrap, channelRegistrar, handler2);
        int port = BuiltInServer.bind(firstPort, portsCount, tryAnyPort, bootstrap, channelRegistrar, isEventLoopGroupOwner);
        BuiltInServer builtInServer = new BuiltInServer(eventLoopGroup, port, channelRegistrar);
        if (builtInServer == null) {
            BuiltInServer.$$$reportNull$$$0(6);
        }
        return builtInServer;
    }

    static void configureChildHandler(@NotNull ServerBootstrap bootstrap, final @NotNull ChannelRegistrar channelRegistrar, final @Nullable NotNullProducer<ChannelHandler> channelHandler) {
        if (bootstrap == null) {
            BuiltInServer.$$$reportNull$$$0(7);
        }
        if (channelRegistrar == null) {
            BuiltInServer.$$$reportNull$$$0(8);
        }
        final PortUnificationServerHandler portUnificationServerHandler = channelHandler == null ? new PortUnificationServerHandler() : null;
        bootstrap.childHandler((ChannelHandler)new ChannelInitializer(){

            protected void initChannel(@NotNull Channel channel) throws Exception {
                if (channel == null) {
                    1.$$$reportNull$$$0(0);
                }
                channel.pipeline().addLast(new ChannelHandler[]{channelRegistrar, channelHandler == null ? portUnificationServerHandler : (ChannelHandler)channelHandler.produce()});
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "channel", "org/jetbrains/io/BuiltInServer$1", "initChannel"));
            }
        });
    }

    private static int bind(int firstPort, int portsCount, boolean tryAnyPort, @NotNull ServerBootstrap bootstrap, @NotNull ChannelRegistrar channelRegistrar, boolean isEventLoopGroupOwner) throws Exception {
        if (bootstrap == null) {
            BuiltInServer.$$$reportNull$$$0(9);
        }
        if (channelRegistrar == null) {
            BuiltInServer.$$$reportNull$$$0(10);
        }
        InetAddress address = InetAddress.getLoopbackAddress();
        for (int i = 0; i < portsCount; ++i) {
            int port = firstPort + i;
            if (ArrayUtil.indexOf((int[])FORBIDDEN_PORTS, (int)i) >= 0) continue;
            ChannelFuture future2 = bootstrap.bind(address, port).awaitUninterruptibly();
            if (future2.isSuccess()) {
                channelRegistrar.setServerChannel(future2.channel(), isEventLoopGroupOwner);
                return port;
            }
            if (tryAnyPort || i != portsCount - 1) continue;
            ExceptionUtil.rethrowAll((Throwable)future2.cause());
        }
        Logger.getInstance(BuiltInServer.class).info("We cannot bind to our default range, so, try to bind to any free port");
        ChannelFuture future3 = bootstrap.bind(address, 0).awaitUninterruptibly();
        if (future3.isSuccess()) {
            channelRegistrar.setServerChannel(future3.channel(), isEventLoopGroupOwner);
            return ((InetSocketAddress)future3.channel().localAddress()).getPort();
        }
        ExceptionUtil.rethrowAll((Throwable)future3.cause());
        return -1;
    }

    public static void replaceDefaultHandler(@NotNull ChannelHandlerContext context, @NotNull ChannelHandler channelHandler) {
        if (context == null) {
            BuiltInServer.$$$reportNull$$$0(11);
        }
        if (channelHandler == null) {
            BuiltInServer.$$$reportNull$$$0(12);
        }
        context.pipeline().replace(DelegatingHttpRequestHandler.class, "replacedDefaultHandler", channelHandler);
    }

    static {
        if (SystemProperties.getBooleanProperty((String)"io.netty.random.id", (boolean)true)) {
            System.setProperty("io.netty.machineId", "28:f0:76:ff:fe:16:65:0e");
            System.setProperty("io.netty.processId", Integer.toString(new Random().nextInt(65535)));
            System.setProperty("io.netty.serviceThreadPrefix", "Netty ");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventLoopGroup";
                break;
            }
            case 1: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "channelRegistrar";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/io/BuiltInServer";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bootstrap";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "channelHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/io/BuiltInServer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getEventLoopGroup";
                break;
            }
            case 3: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "start";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "startNioOrOio";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "start";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "configureChildHandler";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "bind";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "replaceDefaultHandler";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class BuiltInServerThreadFactory
    implements ThreadFactory {
        private final AtomicInteger counter = new AtomicInteger();

        private BuiltInServerThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "Netty Builtin Server " + this.counter.incrementAndGet());
        }
    }
}

