/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.debugger.PyDebuggerException;
import com.jetbrains.python.debugger.PyFrameAccessor;
import org.jetbrains.annotations.NotNull;

public class PyFullValueEvaluator
extends XFullValueEvaluator {
    private final PyFrameAccessor myDebugProcess;
    private final String myExpression;

    protected PyFullValueEvaluator(String linkText, PyFrameAccessor debugProcess, String expression) {
        super(linkText);
        this.myDebugProcess = debugProcess;
        this.myExpression = expression;
    }

    protected PyFullValueEvaluator(PyFrameAccessor debugProcess, String expression) {
        this.myDebugProcess = debugProcess;
        this.myExpression = expression;
    }

    public void startEvaluation(@NotNull XFullValueEvaluator.XFullValueEvaluationCallback callback) {
        String expression;
        if (callback == null) {
            PyFullValueEvaluator.$$$reportNull$$$0(0);
        }
        if ("".equals(expression = this.myExpression.trim())) {
            callback.evaluated("");
            return;
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (callback == null) {
                PyFullValueEvaluator.$$$reportNull$$$0(1);
            }
            try {
                PyDebugValue value = this.myDebugProcess.evaluate(expression, false, false);
                if (value.getValue() == null) {
                    throw new PyDebuggerException("Failed to Load Value");
                }
                callback.evaluated(value.getValue());
                ApplicationManager.getApplication().invokeLater(() -> this.showCustomPopup(this.myDebugProcess, value));
            }
            catch (PyDebuggerException e) {
                callback.errorOccurred(e.getTracebackError());
            }
        });
    }

    protected void showCustomPopup(PyFrameAccessor debugProcess, PyDebugValue debugValue) {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "callback";
        objectArray2[1] = "com/jetbrains/python/debugger/PyFullValueEvaluator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "startEvaluation";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$startEvaluation$1";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

