/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.util;

import com.jogamp.common.JogampRuntimeException;
import com.jogamp.common.util.ReflectionUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

public class IntObjectHashMap
implements Cloneable,
Iterable<Entry> {
    private final float loadFactor;
    private Entry[] table;
    private int size;
    private int mask;
    private int capacity;
    private int threshold;
    private Object keyNotFoundValue = null;
    private static final boolean isPrimitive;
    private static final Constructor<Entry> entryConstructor;
    private static final Method equalsMethod;

    public IntObjectHashMap() {
        this(16, 0.75f);
    }

    public IntObjectHashMap(int n) {
        this(n, 0.75f);
    }

    public IntObjectHashMap(int n, float f) {
        if (n > 0x40000000) {
            throw new IllegalArgumentException("initialCapacity is too large.");
        }
        if (n < 0) {
            throw new IllegalArgumentException("initialCapacity must be greater than zero.");
        }
        if (f <= 0.0f) {
            throw new IllegalArgumentException("loadFactor must be greater than zero.");
        }
        this.capacity = 1;
        while (this.capacity < n) {
            this.capacity <<= 1;
        }
        this.loadFactor = f;
        this.threshold = (int)((float)this.capacity * f);
        this.table = new Entry[this.capacity];
        this.mask = this.capacity - 1;
    }

    private IntObjectHashMap(float f, int n, int n2, int n3, int n4, int n5, Object object) {
        this.loadFactor = f;
        this.table = new Entry[n];
        this.size = n2;
        this.mask = n3;
        this.capacity = n4;
        this.threshold = n5;
        this.keyNotFoundValue = object;
    }

    public Object clone() {
        IntObjectHashMap intObjectHashMap = new IntObjectHashMap(this.loadFactor, this.table.length, this.size, this.mask, this.capacity, this.threshold, this.keyNotFoundValue);
        ArrayList<Entry> arrayList = new ArrayList<Entry>();
        for (int i = this.table.length - 1; i >= 0; --i) {
            Entry entry = this.table[i];
            while (null != entry) {
                arrayList.add(entry);
                entry = entry.next;
            }
            int n = arrayList.size();
            Entry entry2 = null;
            for (int j = n - 1; j >= 0; --j) {
                entry = (Entry)arrayList.remove(j);
                if (isPrimitive) {
                    entry2 = new Entry(entry.key, entry.value, entry2);
                    continue;
                }
                Object object = ReflectionUtil.callMethod(entry.value, IntObjectHashMap.getCloneMethod(entry.value), new Object[0]);
                entry2 = (Entry)ReflectionUtil.createInstance(entryConstructor, entry.key, object, entry2);
            }
            intObjectHashMap.table[i] = entry2;
        }
        return intObjectHashMap;
    }

    public boolean containsValue(Object object) {
        Entry[] entryArray = this.table;
        int n = entryArray.length;
        while (n-- > 0) {
            Entry entry = entryArray[n];
            while (entry != null) {
                Boolean bl;
                if (isPrimitive ? entry.value == object : (bl = (Boolean)ReflectionUtil.callMethod(object, equalsMethod, entry.value)) != false) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    public boolean containsKey(int n) {
        Entry[] entryArray = this.table;
        int n2 = n & this.mask;
        Entry entry = entryArray[n2];
        while (entry != null) {
            if (entry.key == n) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    public Object get(int n) {
        Entry[] entryArray = this.table;
        int n2 = n & this.mask;
        Entry entry = entryArray[n2];
        while (entry != null) {
            if (entry.key == n) {
                return entry.value;
            }
            entry = entry.next;
        }
        return this.keyNotFoundValue;
    }

    public Object put(int n, Object object) {
        Entry[] entryArray = this.table;
        int n2 = n & this.mask;
        Entry entry = entryArray[n2];
        while (entry != null) {
            if (entry.key == n) {
                Object object2 = entry.value;
                entry.value = object;
                return object2;
            }
            entry = entry.next;
        }
        entryArray[n2] = new Entry(n, object, entryArray[n2]);
        if (this.size++ >= this.threshold) {
            int n3 = 2 * this.capacity;
            Entry[] entryArray2 = new Entry[n3];
            int n4 = n3 - 1;
            for (int i = 0; i < entryArray.length; ++i) {
                Entry entry2;
                Entry entry3 = entryArray[i];
                if (entry3 == null) continue;
                entryArray[i] = null;
                do {
                    entry2 = entry3.next;
                    int n5 = entry3.key & n4;
                    entry3.next = entryArray2[n5];
                    entryArray2[n5] = entry3;
                } while ((entry3 = entry2) != null);
            }
            this.table = entryArray2;
            this.capacity = n3;
            this.threshold = (int)((float)n3 * this.loadFactor);
            this.mask = n4;
        }
        return this.keyNotFoundValue;
    }

    public void putAll(IntObjectHashMap intObjectHashMap) {
        for (Entry entry : intObjectHashMap) {
            this.put(entry.key, entry.value);
        }
    }

    public Object remove(int n) {
        Entry entry;
        Entry[] entryArray = this.table;
        int n2 = n & this.mask;
        Entry entry2 = entry = entryArray[n2];
        while (entry2 != null) {
            Entry entry3 = entry2.next;
            if (entry2.key == n) {
                --this.size;
                if (entry == entry2) {
                    entryArray[n2] = entry3;
                } else {
                    entry.next = entry3;
                }
                return entry2.value;
            }
            entry = entry2;
            entry2 = entry3;
        }
        return this.keyNotFoundValue;
    }

    public int size() {
        return this.size;
    }

    public int capacity() {
        return this.capacity;
    }

    public void clear() {
        Arrays.fill(this.table, null);
        this.size = 0;
    }

    @Override
    public Iterator<Entry> iterator() {
        return new EntryIterator(this.table);
    }

    public Object setKeyNotFoundValue(Object object) {
        Object object2 = this.keyNotFoundValue;
        this.keyNotFoundValue = object;
        return object2;
    }

    public Object getKeyNotFoundValue() {
        return this.keyNotFoundValue;
    }

    public StringBuilder toString(StringBuilder stringBuilder) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        stringBuilder.append("{");
        Iterator<Entry> iterator = this.iterator();
        while (iterator.hasNext()) {
            iterator.next().toString(stringBuilder);
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("}");
        return stringBuilder;
    }

    public String toString() {
        return this.toString(null).toString();
    }

    private static Method getCloneMethod(Object object) {
        final Class<?> clazz = object.getClass();
        return AccessController.doPrivileged(new PrivilegedAction<Method>(){

            @Override
            public Method run() {
                try {
                    return clazz.getDeclaredMethod("clone", new Class[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new JogampRuntimeException("Class " + clazz + " doesn't support clone()", noSuchMethodException);
                }
            }
        });
    }

    static {
        final Class<Object> clazz = Object.class;
        final Class<Integer> clazz2 = Integer.TYPE;
        isPrimitive = clazz.isPrimitive();
        if (!isPrimitive) {
            EntryCM entryCM = AccessController.doPrivileged(new PrivilegedAction<EntryCM>(){

                @Override
                public EntryCM run() {
                    EntryCM entryCM = new EntryCM();
                    entryCM.c = ReflectionUtil.getConstructor(Entry.class, clazz2, clazz, Entry.class);
                    try {
                        entryCM.m1 = clazz.getDeclaredMethod("equals", Object.class);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        throw new JogampRuntimeException("Class " + clazz + " doesn't support equals(Object)");
                    }
                    return entryCM;
                }
            });
            entryConstructor = entryCM.c;
            equalsMethod = entryCM.m1;
        } else {
            entryConstructor = null;
            equalsMethod = null;
        }
    }

    public static final class Entry {
        public final int key;
        public Object value;
        Entry next;

        Entry(int n, Object object, Entry entry) {
            this.key = n;
            this.value = object;
            this.next = entry;
        }

        public int getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object object) {
            this.value = object;
        }

        public StringBuilder toString(StringBuilder stringBuilder) {
            if (null == stringBuilder) {
                stringBuilder = new StringBuilder();
            }
            stringBuilder.append("[").append(this.key).append(":").append(this.value).append("]");
            return stringBuilder;
        }

        public String toString() {
            return this.toString(null).toString();
        }
    }

    static class EntryCM {
        Constructor<Entry> c = null;
        Method m1 = null;

        EntryCM() {
        }
    }

    private static final class EntryIterator
    implements Iterator<Entry> {
        private final Entry[] entries;
        private int index;
        private Entry next;

        private EntryIterator(Entry[] entryArray) {
            this.entries = entryArray;
            this.next();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Entry next() {
            Entry entry = this.next;
            if (entry != null && entry.next != null) {
                this.next = entry.next;
            } else {
                while (this.index < this.entries.length) {
                    Entry entry2;
                    if ((entry2 = this.entries[this.index++]) == null) continue;
                    this.next = entry2;
                    return entry;
                }
                this.next = null;
            }
            return entry;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

