/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.rfb;

import com.tigervnc.rfb.LogWriter;
import com.tigervnc.rfb.PixelBuffer;
import com.tigervnc.rfb.PixelFormat;
import com.tigervnc.rfb.Point;
import com.tigervnc.rfb.Rect;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;

public abstract class ModifiablePixelBuffer
extends PixelBuffer {
    static LogWriter vlog = new LogWriter("ModifiablePixelBuffer");

    public ModifiablePixelBuffer(PixelFormat pixelFormat, int n, int n2) {
        super(pixelFormat, n, n2);
    }

    protected ModifiablePixelBuffer() {
    }

    public abstract WritableRaster getBufferRW(Rect var1);

    public abstract void commitBufferRW(Rect var1);

    public synchronized void fillRect(Rect rect, byte[] byArray) {
        int n = rect.width();
        int n2 = rect.height();
        if (n2 == 0 || n == 0) {
            return;
        }
        WritableRaster writableRaster = this.getBufferRW(rect);
        ByteBuffer byteBuffer = ByteBuffer.allocate(rect.area() * this.format.bpp / 8).order(this.format.getByteOrder());
        for (int i = 0; i < rect.area(); ++i) {
            byteBuffer.put(byArray);
        }
        Raster raster = this.format.rasterFromBuffer(rect, (ByteBuffer)byteBuffer.rewind());
        writableRaster.setDataElements(0, 0, raster);
        this.commitBufferRW(rect);
    }

    public synchronized void imageRect(Rect rect, byte[] byArray) {
        WritableRaster writableRaster = this.getBufferRW(rect);
        int n = rect.area() * this.format.bpp / 8;
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, 0, n).order(this.format.getByteOrder());
        Raster raster = this.format.rasterFromBuffer(rect, byteBuffer);
        writableRaster.setDataElements(0, 0, raster);
        this.commitBufferRW(rect);
    }

    public synchronized void copyRect(Rect rect, Point point) {
        String string;
        Rect rect2 = new Rect(rect.tl, rect.br);
        if (!rect2.enclosed_by(this.getRect())) {
            string = "Destination rect %dx%d at %d,%d exceeds framebuffer %dx%d";
            vlog.error(String.format(string, rect2.width(), rect2.height(), rect2.tl.x, rect2.tl.y, this.width_, this.height_));
            rect2 = rect2.intersect(this.getRect());
        }
        if (rect2.is_empty()) {
            return;
        }
        Rect rect3 = rect2.translate(point.negate());
        if (!rect3.enclosed_by(this.getRect())) {
            string = "Source rect %dx%d at %d,%d exceeds framebuffer %dx%d";
            vlog.error(String.format(string, rect3.width(), rect3.height(), rect3.tl.x, rect3.tl.y, this.width_, this.height_));
            rect3 = rect3.intersect(this.getRect());
            rect2 = rect3.translate(point);
        }
        if (rect3.is_empty()) {
            return;
        }
        Raster raster = this.getBuffer(rect3);
        WritableRaster writableRaster = this.getBufferRW(rect2);
        writableRaster.setDataElements(0, 0, raster);
        this.commitBufferRW(rect);
    }

    public synchronized void maskRect(Rect rect, Object object, byte[] byArray) {
        Rect rect2 = this.getRect().intersect(rect);
        if (rect2.is_empty()) {
            return;
        }
        WritableRaster writableRaster = this.getBufferRW(rect2);
        ColorModel colorModel = this.format.getColorModel();
        SampleModel sampleModel = colorModel.createCompatibleSampleModel(rect.width(), rect.height());
        DataBuffer dataBuffer = null;
        ByteBuffer byteBuffer = ByteBuffer.wrap((byte[])object).order(this.format.getByteOrder());
        switch (sampleModel.getTransferType()) {
            case 3: {
                Buffer buffer = IntBuffer.allocate(byteBuffer.remaining()).put(byteBuffer.asIntBuffer());
                dataBuffer = new DataBufferInt(((IntBuffer)buffer).array(), rect.area());
                break;
            }
            case 0: {
                dataBuffer = new DataBufferByte(byteBuffer.array(), rect.area());
                break;
            }
            case 2: {
                Buffer buffer = ShortBuffer.allocate(byteBuffer.remaining()).put(byteBuffer.asShortBuffer());
                dataBuffer = new DataBufferShort(((ShortBuffer)buffer).array(), rect.area());
            }
        }
        assert (dataBuffer != null);
        Raster raster = Raster.createRaster(sampleModel, dataBuffer, new java.awt.Point(0, 0));
        ColorConvertOp colorConvertOp = this.format.getColorConvertOp(colorModel.getColorSpace());
        WritableRaster writableRaster2 = writableRaster.createCompatibleWritableRaster();
        colorConvertOp.filter(raster, writableRaster2);
        int n = rect2.width();
        int n2 = rect2.height();
        Point point = new Point(rect2.tl.x - rect.tl.x, rect2.tl.y - rect.tl.y);
        int n3 = (n + 7) / 8;
        for (int i = 0; i < n2; ++i) {
            int n4 = point.y + i;
            for (int j = 0; j < n; ++j) {
                int n5 = n4 * n3 + i / 8;
                int n6 = point.x + j;
                int n7 = 7 - n6 % 8;
                if ((byArray[n5] & 1 << n7) == 0) continue;
                writableRaster.setDataElements(j + n6, i + n4, writableRaster2.getDataElements(j + n6, i + n4, null));
            }
        }
        this.commitBufferRW(rect);
    }

    public synchronized void maskRect(Rect rect, int n, byte[] byArray) {
    }

    public synchronized void fillRect(PixelFormat pixelFormat, Rect rect, byte[] byArray) {
        WritableRaster writableRaster = this.getBufferRW(rect);
        ColorModel colorModel = pixelFormat.getColorModel();
        if (colorModel.isCompatibleRaster(writableRaster) && colorModel.isCompatibleSampleModel(writableRaster.getSampleModel())) {
            this.fillRect(rect, byArray);
        } else {
            ByteBuffer byteBuffer = ByteBuffer.allocate(rect.area() * pixelFormat.bpp / 8).order(pixelFormat.getByteOrder());
            for (int i = 0; i < rect.area(); ++i) {
                byteBuffer.put(byArray);
            }
            Raster raster = pixelFormat.rasterFromBuffer(rect, (ByteBuffer)byteBuffer.rewind());
            ColorConvertOp colorConvertOp = this.format.getColorConvertOp(colorModel.getColorSpace());
            colorConvertOp.filter(raster, writableRaster);
        }
        this.commitBufferRW(rect);
    }

    public synchronized void imageRect(PixelFormat pixelFormat, Rect rect, byte[] byArray) {
        WritableRaster writableRaster = this.getBufferRW(rect);
        ColorModel colorModel = pixelFormat.getColorModel();
        if (colorModel.isCompatibleRaster(writableRaster) && colorModel.isCompatibleSampleModel(writableRaster.getSampleModel())) {
            this.imageRect(rect, byArray);
        } else {
            int n = rect.area() * pixelFormat.bpp / 8;
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, 0, n).order(pixelFormat.getByteOrder());
            Raster raster = pixelFormat.rasterFromBuffer(rect, byteBuffer);
            ColorConvertOp colorConvertOp = this.format.getColorConvertOp(colorModel.getColorSpace());
            colorConvertOp.filter(raster, writableRaster);
        }
        this.commitBufferRW(rect);
    }

    public synchronized void imageRect(PixelFormat pixelFormat, Rect rect, Raster raster) {
        WritableRaster writableRaster = this.getBufferRW(rect);
        ColorModel colorModel = pixelFormat.getColorModel();
        if (colorModel.isCompatibleRaster(writableRaster) && colorModel.isCompatibleSampleModel(writableRaster.getSampleModel())) {
            writableRaster.setDataElements(0, 0, raster);
        } else {
            ColorConvertOp colorConvertOp = this.format.getColorConvertOp(colorModel.getColorSpace());
            colorConvertOp.filter(raster, writableRaster);
        }
        this.commitBufferRW(rect);
    }
}

