/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.layout;

import com.sun.javafx.Logging;
import com.sun.javafx.TempState;
import com.sun.javafx.binding.ExpressionHelper;
import com.sun.javafx.css.StyleConverter;
import com.sun.javafx.css.StyleableBooleanProperty;
import com.sun.javafx.css.StyleableObjectProperty;
import com.sun.javafx.css.StyleableProperty;
import com.sun.javafx.css.StyleableStringProperty;
import com.sun.javafx.css.converters.BooleanConverter;
import com.sun.javafx.css.converters.InsetsConverter;
import com.sun.javafx.css.converters.StringConverter;
import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.PickRay;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.scene.DirtyBits;
import com.sun.javafx.scene.layout.region.BackgroundFillConverter;
import com.sun.javafx.scene.layout.region.BackgroundImageConverter;
import com.sun.javafx.scene.layout.region.BorderImage;
import com.sun.javafx.scene.layout.region.BorderImageConverter;
import com.sun.javafx.scene.layout.region.BorderStyle;
import com.sun.javafx.scene.layout.region.ShapeChangeListener;
import com.sun.javafx.scene.layout.region.StrokeBorder;
import com.sun.javafx.scene.layout.region.StrokeBorderConverter;
import com.sun.javafx.sg.BackgroundFill;
import com.sun.javafx.sg.BackgroundImage;
import com.sun.javafx.sg.Border;
import com.sun.javafx.sg.ImageBorder;
import com.sun.javafx.sg.PGNode;
import com.sun.javafx.sg.PGRegion;
import com.sun.javafx.sg.PGShape;
import com.sun.javafx.sg.Repeat;
import com.sun.javafx.sg.StrokedBorder;
import com.sun.javafx.tk.Toolkit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.InvalidationListener;
import javafx.beans.binding.ObjectExpression;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableObjectValue;
import javafx.beans.value.WritableValue;
import javafx.collections.ObservableList;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Stop;
import javafx.scene.shape.SVGPath;
import javafx.scene.shape.Shape;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.shape.StrokeType;

public class Region
extends Parent {
    public static final double USE_PREF_SIZE = Double.NEGATIVE_INFINITY;
    public static final double USE_COMPUTED_SIZE = -1.0;
    private BooleanProperty snapToPixel;
    private ObjectProperty<Insets> padding;
    private final InsetsExpression insets = new InsetsExpression();
    private ReadOnlyDoubleWrapper width;
    private ReadOnlyDoubleWrapper height;
    private DoubleProperty minWidth;
    private DoubleProperty minHeight;
    private DoubleProperty prefWidth;
    private DoubleProperty prefHeight;
    private DoubleProperty maxWidth;
    private DoubleProperty maxHeight;
    private ObjectProperty<Shape> shape;
    private StringProperty shapeContent;
    private ShapeChangeListener shapeChangeListener;
    private BooleanProperty scaleShape = null;
    private BooleanProperty positionShape = null;
    private ObjectProperty<List<com.sun.javafx.scene.layout.region.BackgroundFill>> backgroundFills = null;
    private ObjectProperty<List<com.sun.javafx.scene.layout.region.BackgroundImage>> backgroundImages = null;
    private ObjectProperty<List<StrokeBorder>> strokeBorders = null;
    private ObjectProperty<List<BorderImage>> imageBorders = null;

    static double boundedSize(double d, double d2, double d3) {
        return Math.min(Math.max(d, d2), Math.max(d2, d3));
    }

    static double snapSpace(double d, boolean bl) {
        return bl ? (double)Math.round(d) : d;
    }

    static double snapSize(double d, boolean bl) {
        return bl ? Math.ceil(d) : d;
    }

    static double snapPosition(double d, boolean bl) {
        return bl ? (double)Math.round(d) : d;
    }

    static double getMaxAreaBaselineOffset(List<Node> list, Insets[] insetsArray) {
        double d = 0.0;
        for (int i = 0; i < list.size(); ++i) {
            Node node = list.get(i);
            Insets insets = insetsArray[i] != null ? insetsArray[i] : Insets.EMPTY;
            d = Math.max(d, (insets != null ? insets.getTop() : 0.0) + node.getBaselineOffset());
        }
        return d;
    }

    static double getMaxBaselineOffset(List<Node> list) {
        double d = 0.0;
        for (int i = 0; i < list.size(); ++i) {
            Node node = list.get(i);
            d = Math.max(d, node.getBaselineOffset());
        }
        return d;
    }

    static double computeXOffset(double d, double d2, HPos hPos) {
        switch (hPos) {
            case LEFT: {
                return 0.0;
            }
            case CENTER: {
                return (d - d2) / 2.0;
            }
            case RIGHT: {
                return d - d2;
            }
        }
        return 0.0;
    }

    static double computeYOffset(double d, double d2, VPos vPos) {
        switch (vPos) {
            case TOP: {
                return 0.0;
            }
            case CENTER: {
                return (d - d2) / 2.0;
            }
            case BOTTOM: {
                return d - d2;
            }
        }
        return 0.0;
    }

    static double max(List<Double> list) {
        double d = 0.0;
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                double d2 = list.get(i);
                d = Math.max(d, d2);
            }
        }
        return d;
    }

    static double[] createDoubleArray(int n, double d) {
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = d;
        }
        return dArray;
    }

    public Region() {
        this.setPickOnBounds(true);
    }

    public final BooleanProperty snapToPixelProperty() {
        if (this.snapToPixel == null) {
            this.snapToPixel = new StyleableBooleanProperty(true){

                @Override
                public void invalidated() {
                    Region.this.requestLayout();
                }

                @Override
                public StyleableProperty getStyleableProperty() {
                    return StyleableProperties.SNAP_TO_PIXEL;
                }

                @Override
                public Object getBean() {
                    return Region.this;
                }

                @Override
                public String getName() {
                    return "snapToPixel";
                }
            };
        }
        return this.snapToPixel;
    }

    public final void setSnapToPixel(boolean bl) {
        this.snapToPixelProperty().set(bl);
    }

    public final boolean isSnapToPixel() {
        return this.snapToPixel == null ? true : this.snapToPixel.get();
    }

    public final ObjectProperty<Insets> paddingProperty() {
        if (this.padding == null) {
            this.padding = new StyleableObjectProperty<Insets>(Insets.EMPTY){
                private Insets lastValidValue;
                {
                    this.lastValidValue = Insets.EMPTY;
                }

                @Override
                public void invalidated() {
                    Insets insets = (Insets)this.get();
                    if (insets == null) {
                        if (this.isBound()) {
                            this.unbind();
                        }
                        this.set(this.lastValidValue);
                        throw new NullPointerException("cannot set padding to null");
                    }
                    this.lastValidValue = insets;
                    Region.this.insets.fireValueChanged();
                    Region.this.requestLayout();
                }

                @Override
                public StyleableProperty getStyleableProperty() {
                    return StyleableProperties.PADDING;
                }

                @Override
                public Object getBean() {
                    return Region.this;
                }

                @Override
                public String getName() {
                    return "padding";
                }
            };
        }
        return this.padding;
    }

    public final void setPadding(Insets insets) {
        this.paddingProperty().set(insets);
    }

    public final Insets getPadding() {
        return this.padding == null ? Insets.EMPTY : (Insets)this.padding.get();
    }

    public Insets getInsets() {
        return this.insets.get();
    }

    @Deprecated
    public ObservableObjectValue<Insets> insets() {
        return this.insets;
    }

    public final ReadOnlyDoubleProperty widthProperty() {
        return this.widthPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyDoubleWrapper widthPropertyImpl() {
        if (this.width == null) {
            this.width = new ReadOnlyDoubleWrapper(0.0){

                @Override
                protected void invalidated() {
                    Region.this.impl_layoutBoundsChanged();
                    Region.this.impl_geomChanged();
                    Region.this.impl_markDirty(DirtyBits.NODE_GEOMETRY);
                    Region.this.requestLayout();
                }

                @Override
                public Object getBean() {
                    return Region.this;
                }

                @Override
                public String getName() {
                    return "width";
                }
            };
        }
        return this.width;
    }

    protected void setWidth(double d) {
        this.widthPropertyImpl().set(d);
    }

    public final double getWidth() {
        return this.width == null ? 0.0 : this.width.get();
    }

    public final ReadOnlyDoubleProperty heightProperty() {
        return this.heightPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyDoubleWrapper heightPropertyImpl() {
        if (this.height == null) {
            this.height = new ReadOnlyDoubleWrapper(0.0){

                @Override
                protected void invalidated() {
                    Region.this.impl_layoutBoundsChanged();
                    Region.this.impl_geomChanged();
                    Region.this.impl_markDirty(DirtyBits.NODE_GEOMETRY);
                    Region.this.requestLayout();
                }

                @Override
                public Object getBean() {
                    return Region.this;
                }

                @Override
                public String getName() {
                    return "height";
                }
            };
        }
        return this.height;
    }

    protected void setHeight(double d) {
        this.heightPropertyImpl().set(d);
    }

    public final double getHeight() {
        return this.height == null ? 0.0 : this.height.get();
    }

    public final DoubleProperty minWidthProperty() {
        if (this.minWidth == null) {
            this.minWidth = new DoublePropertyBase(-1.0){

                @Override
                public void invalidated() {
                    if (Region.this.getParent() != null) {
                        Region.this.getParent().requestLayout();
                    }
                }

                @Override
                public Object getBean() {
                    return Region.this;
                }

                @Override
                public String getName() {
                    return "minWidth";
                }
            };
        }
        return this.minWidth;
    }

    public final void setMinWidth(double d) {
        this.minWidthProperty().set(d);
    }

    public final double getMinWidth() {
        return this.minWidth == null ? -1.0 : this.minWidth.get();
    }

    public final DoubleProperty minHeightProperty() {
        if (this.minHeight == null) {
            this.minHeight = new DoublePropertyBase(-1.0){

                @Override
                public void invalidated() {
                    if (Region.this.getParent() != null) {
                        Region.this.getParent().requestLayout();
                    }
                }

                @Override
                public Object getBean() {
                    return Region.this;
                }

                @Override
                public String getName() {
                    return "minHeight";
                }
            };
        }
        return this.minHeight;
    }

    public final void setMinHeight(double d) {
        this.minHeightProperty().set(d);
    }

    public final double getMinHeight() {
        return this.minHeight == null ? -1.0 : this.minHeight.get();
    }

    public void setMinSize(double d, double d2) {
        this.setMinWidth(d);
        this.setMinHeight(d2);
    }

    public final DoubleProperty prefWidthProperty() {
        if (this.prefWidth == null) {
            this.prefWidth = new DoublePropertyBase(-1.0){

                @Override
                public void invalidated() {
                    if (Region.this.getParent() != null) {
                        Region.this.getParent().requestLayout();
                    }
                }

                @Override
                public Object getBean() {
                    return Region.this;
                }

                @Override
                public String getName() {
                    return "prefWidth";
                }
            };
        }
        return this.prefWidth;
    }

    public final void setPrefWidth(double d) {
        this.prefWidthProperty().set(d);
    }

    public final double getPrefWidth() {
        return this.prefWidth == null ? -1.0 : this.prefWidth.get();
    }

    public final DoubleProperty prefHeightProperty() {
        if (this.prefHeight == null) {
            this.prefHeight = new DoublePropertyBase(-1.0){

                @Override
                public void invalidated() {
                    if (Region.this.getParent() != null) {
                        Region.this.getParent().requestLayout();
                    }
                }

                @Override
                public Object getBean() {
                    return Region.this;
                }

                @Override
                public String getName() {
                    return "prefHeight";
                }
            };
        }
        return this.prefHeight;
    }

    public final void setPrefHeight(double d) {
        this.prefHeightProperty().set(d);
    }

    public final double getPrefHeight() {
        return this.prefHeight == null ? -1.0 : this.prefHeight.get();
    }

    public void setPrefSize(double d, double d2) {
        this.setPrefWidth(d);
        this.setPrefHeight(d2);
    }

    public final DoubleProperty maxWidthProperty() {
        if (this.maxWidth == null) {
            this.maxWidth = new DoublePropertyBase(-1.0){

                @Override
                public void invalidated() {
                    if (Region.this.getParent() != null) {
                        Region.this.getParent().requestLayout();
                    }
                }

                @Override
                public Object getBean() {
                    return Region.this;
                }

                @Override
                public String getName() {
                    return "maxWidth";
                }
            };
        }
        return this.maxWidth;
    }

    public final void setMaxWidth(double d) {
        this.maxWidthProperty().set(d);
    }

    public final double getMaxWidth() {
        return this.maxWidth == null ? -1.0 : this.maxWidth.get();
    }

    public final DoubleProperty maxHeightProperty() {
        if (this.maxHeight == null) {
            this.maxHeight = new DoublePropertyBase(-1.0){

                @Override
                public void invalidated() {
                    if (Region.this.getParent() != null) {
                        Region.this.getParent().requestLayout();
                    }
                }

                @Override
                public Object getBean() {
                    return Region.this;
                }

                @Override
                public String getName() {
                    return "maxHeight";
                }
            };
        }
        return this.maxHeight;
    }

    public final void setMaxHeight(double d) {
        this.maxHeightProperty().set(d);
    }

    public final double getMaxHeight() {
        return this.maxHeight == null ? -1.0 : this.maxHeight.get();
    }

    public void setMaxSize(double d, double d2) {
        this.setMaxWidth(d);
        this.setMaxHeight(d2);
    }

    private Shape getShape() {
        return this.shape == null ? null : (Shape)this.shape.get();
    }

    private ObjectProperty<Shape> shapeProperty() {
        if (this.shape == null) {
            this.shape = new ObjectPropertyBase<Shape>(){

                @Override
                protected void invalidated() {
                    Region.this.impl_geomChanged();
                    Region.this.requestLayout();
                    Region.this.impl_markDirty(DirtyBits.REGION_SHAPE);
                }

                @Override
                public Object getBean() {
                    return Region.this;
                }

                @Override
                public String getName() {
                    return "shape";
                }
            };
        }
        return this.shape;
    }

    private StringProperty shapeContentProperty() {
        if (this.shapeContent == null) {
            this.shapeContent = new StyleableStringProperty(){

                @Override
                protected void invalidated() {
                    String string = this.get();
                    if (string != null && !string.isEmpty()) {
                        Shape shape = Region.this.getShape();
                        if (shape instanceof SVGPath) {
                            SVGPath sVGPath = (SVGPath)shape;
                            if (!string.equals(sVGPath.getContent())) {
                                sVGPath.setContent(string);
                            }
                        } else {
                            SVGPath sVGPath = new SVGPath();
                            sVGPath.setContent(string);
                            Region.this.impl_setShape(sVGPath);
                        }
                    } else {
                        Region.this.shapeProperty().set(null);
                    }
                }

                @Override
                public Object getBean() {
                    return Region.this;
                }

                @Override
                public String getName() {
                    return "shapeContent";
                }

                @Override
                public StyleableProperty getStyleableProperty() {
                    return StyleableProperties.SHAPE;
                }
            };
        }
        return this.shapeContent;
    }

    @Deprecated
    public void impl_setShape(Shape shape) {
        Shape shape2 = this.impl_getShape();
        if (shape2 != null && !shape2.equals(shape)) {
            shape2.impl_setShapeChangeListener(null);
        }
        this.shapeProperty().set(shape);
        if (shape != null) {
            shape.impl_setShapeChangeListener(this.getShapeChangeListener());
        }
    }

    private ShapeChangeListener getShapeChangeListener() {
        if (this.shapeChangeListener == null) {
            this.shapeChangeListener = new ShapeChangeListener(){

                @Override
                public void changed() {
                    Region.this.impl_geomChanged();
                    Region.this.requestLayout();
                    Region.this.impl_markDirty(DirtyBits.REGION_SHAPE);
                }
            };
        }
        return this.shapeChangeListener;
    }

    @Deprecated
    public Shape impl_getShape() {
        return this.shape == null ? null : (Shape)this.shape.get();
    }

    private boolean getScaleShape() {
        return this.scaleShape == null ? true : this.scaleShape.get();
    }

    private BooleanProperty scaleShapeProperty() {
        if (this.scaleShape == null) {
            this.scaleShape = new StyleableBooleanProperty(true){

                @Override
                public void invalidated() {
                    Region.this.requestLayout();
                    Region.this.impl_markDirty(DirtyBits.REGION_SHAPE);
                }

                @Override
                public Object getBean() {
                    return Region.this;
                }

                @Override
                public String getName() {
                    return "scaleShape";
                }

                @Override
                public StyleableProperty getStyleableProperty() {
                    return StyleableProperties.SCALE_SHAPE;
                }
            };
        }
        return this.scaleShape;
    }

    @Deprecated
    public void impl_setScaleShape(boolean bl) {
        this.scaleShapeProperty().set(bl);
    }

    @Deprecated
    public boolean impl_getScaleShape() {
        return this.scaleShape == null ? true : this.scaleShape.get();
    }

    private boolean getPositionShape() {
        return this.positionShape == null ? true : this.positionShape.get();
    }

    private BooleanProperty positionShapeProperty() {
        if (this.positionShape == null) {
            this.positionShape = new StyleableBooleanProperty(true){

                @Override
                public void invalidated() {
                    Region.this.requestLayout();
                    Region.this.impl_markDirty(DirtyBits.REGION_SHAPE);
                }

                @Override
                public Object getBean() {
                    return Region.this;
                }

                @Override
                public String getName() {
                    return "positionShape";
                }

                @Override
                public StyleableProperty getStyleableProperty() {
                    return StyleableProperties.SCALE_SHAPE;
                }
            };
        }
        return this.positionShape;
    }

    @Deprecated
    public void impl_setPositionShape(boolean bl) {
        this.positionShapeProperty().set(bl);
    }

    @Deprecated
    public boolean impl_getPositionShape() {
        return this.positionShape == null ? true : this.positionShape.get();
    }

    private ObjectProperty<List<com.sun.javafx.scene.layout.region.BackgroundFill>> backgroundFillsProperty() {
        if (this.backgroundFills == null) {
            this.backgroundFills = new StyleableObjectProperty<List<com.sun.javafx.scene.layout.region.BackgroundFill>>(){

                @Override
                public void invalidated() {
                    Region.this.impl_geomChanged();
                    Region.this.impl_markDirty(DirtyBits.SHAPE_FILL);
                }

                @Override
                public void set(List<com.sun.javafx.scene.layout.region.BackgroundFill> list) {
                    List list2 = (List)this.get();
                    if (list2 == null ? list != null : !((Object)list2).equals(list)) {
                        super.set(list);
                    }
                }

                @Override
                public Object getBean() {
                    return Region.this;
                }

                @Override
                public String getName() {
                    return "backgroundFills";
                }

                @Override
                public StyleableProperty getStyleableProperty() {
                    return StyleableProperties.BACKGROUND_FILLS;
                }
            };
        }
        return this.backgroundFills;
    }

    private List<com.sun.javafx.scene.layout.region.BackgroundFill> getBackgroundFills() {
        return this.backgroundFills == null ? null : (List)this.backgroundFills.get();
    }

    @Deprecated
    public void impl_setBackgroundFills(List<com.sun.javafx.scene.layout.region.BackgroundFill> list) {
        List<com.sun.javafx.scene.layout.region.BackgroundFill> list2 = this.getBackgroundFills();
        if (list2 == null ? list != null : !((Object)list2).equals(list)) {
            this.backgroundFillsProperty().set(list);
        }
    }

    @Deprecated
    public List<com.sun.javafx.scene.layout.region.BackgroundFill> impl_getBackgroundFills() {
        return this.getBackgroundFills();
    }

    private ObjectProperty<List<com.sun.javafx.scene.layout.region.BackgroundImage>> backgroundImagesProperty() {
        if (this.backgroundImages == null) {
            this.backgroundImages = new StyleableObjectProperty<List<com.sun.javafx.scene.layout.region.BackgroundImage>>(){

                @Override
                public void invalidated() {
                    Region.this.impl_geomChanged();
                    Region.this.impl_markDirty(DirtyBits.NODE_CONTENTS);
                }

                @Override
                public void set(List<com.sun.javafx.scene.layout.region.BackgroundImage> list) {
                    List list2 = (List)this.get();
                    if (list2 == null ? list != null : !((Object)list2).equals(list)) {
                        super.set(list);
                    }
                }

                @Override
                public Object getBean() {
                    return Region.this;
                }

                @Override
                public String getName() {
                    return "backgroundImages";
                }

                @Override
                public StyleableProperty getStyleableProperty() {
                    return StyleableProperties.BACKGROUND_IMAGES;
                }
            };
        }
        return this.backgroundImages;
    }

    private List<com.sun.javafx.scene.layout.region.BackgroundImage> getBackgroundImages() {
        return this.backgroundImages == null ? null : (List)this.backgroundImages.get();
    }

    private void setBackgroundImages(List<com.sun.javafx.scene.layout.region.BackgroundImage> list) {
        List<com.sun.javafx.scene.layout.region.BackgroundImage> list2 = this.getBackgroundImages();
        if (list2 == null ? list == null : !((Object)list2).equals(list)) {
            this.backgroundImagesProperty().set(list);
        }
    }

    private ObjectProperty<List<StrokeBorder>> strokeBordersProperty() {
        if (this.strokeBorders == null) {
            this.strokeBorders = new StyleableObjectProperty<List<StrokeBorder>>(){

                @Override
                public void invalidated() {
                    Region.this.insets.fireValueChanged();
                    Region.this.impl_geomChanged();
                    Region.this.impl_markDirty(DirtyBits.SHAPE_STROKE);
                }

                @Override
                public void set(List<StrokeBorder> list) {
                    List list2 = (List)this.get();
                    if (list2 == null ? list != null : !((Object)list2).equals(list)) {
                        super.set(list);
                    }
                }

                @Override
                public Object getBean() {
                    return Region.this;
                }

                @Override
                public String getName() {
                    return "strokeBorders";
                }

                @Override
                public StyleableProperty getStyleableProperty() {
                    return StyleableProperties.STROKE_BORDERS;
                }
            };
        }
        return this.strokeBorders;
    }

    private List<StrokeBorder> getStrokeBorders() {
        return this.strokeBorders == null ? null : (List)this.strokeBorders.get();
    }

    private void setStrokeBorders(List<StrokeBorder> list) {
        List<StrokeBorder> list2 = this.getStrokeBorders();
        if (list2 == null ? list != null : !((Object)list2).equals(list)) {
            this.strokeBordersProperty().set(list);
        }
    }

    private ObjectProperty<List<BorderImage>> imageBordersProperty() {
        if (this.imageBorders == null) {
            this.imageBorders = new StyleableObjectProperty<List<BorderImage>>(){

                @Override
                public void invalidated() {
                    Region.this.insets.fireValueChanged();
                    Region.this.impl_geomChanged();
                    Region.this.impl_markDirty(DirtyBits.SHAPE_STROKE);
                }

                @Override
                public void set(List<BorderImage> list) {
                    List list2 = (List)this.get();
                    if (list2 == null ? list != null : !((Object)list2).equals(list)) {
                        super.set(list);
                    }
                }

                @Override
                public Object getBean() {
                    return Region.this;
                }

                @Override
                public String getName() {
                    return "imageBorders";
                }

                @Override
                public StyleableProperty getStyleableProperty() {
                    return StyleableProperties.IMAGE_BORDERS;
                }
            };
        }
        return this.imageBorders;
    }

    private List<BorderImage> getImageBorders() {
        return this.imageBorders == null ? null : (List)this.imageBorders.get();
    }

    private void setImageBorders(List<BorderImage> list) {
        List<BorderImage> list2 = this.getImageBorders();
        if (list2 == null ? list == null : !((Object)list2).equals(list)) {
            this.imageBordersProperty().set(list);
        }
    }

    @Override
    public boolean isResizable() {
        return true;
    }

    @Override
    public void resize(double d, double d2) {
        this.setWidth(d);
        this.setHeight(d2);
        PlatformLogger platformLogger = Logging.getLayoutLogger();
        if (platformLogger.isLoggable(400)) {
            platformLogger.finer(this.toString() + " resized to " + d + " x " + d2);
        }
    }

    @Override
    public final double minWidth(double d) {
        double d2 = this.getMinWidth();
        if (d2 == -1.0) {
            return super.minWidth(d);
        }
        if (d2 == Double.NEGATIVE_INFINITY) {
            return this.prefWidth(d);
        }
        return d2;
    }

    @Override
    public final double minHeight(double d) {
        double d2 = this.getMinHeight();
        if (d2 == -1.0) {
            return super.minHeight(d);
        }
        if (d2 == Double.NEGATIVE_INFINITY) {
            return this.prefHeight(d);
        }
        return d2;
    }

    @Override
    public final double prefWidth(double d) {
        double d2 = this.getPrefWidth();
        if (d2 == -1.0) {
            return super.prefWidth(d);
        }
        return d2;
    }

    @Override
    public final double prefHeight(double d) {
        double d2 = this.getPrefHeight();
        if (d2 == -1.0) {
            return super.prefHeight(d);
        }
        return d2;
    }

    @Override
    public final double maxWidth(double d) {
        double d2 = this.getMaxWidth();
        if (d2 == -1.0) {
            return this.computeMaxWidth(d);
        }
        if (d2 == Double.NEGATIVE_INFINITY) {
            return this.prefWidth(d);
        }
        return d2;
    }

    @Override
    public final double maxHeight(double d) {
        double d2 = this.getMaxHeight();
        if (d2 == -1.0) {
            return this.computeMaxHeight(d);
        }
        if (d2 == Double.NEGATIVE_INFINITY) {
            return this.prefHeight(d);
        }
        return d2;
    }

    @Override
    protected double computeMinWidth(double d) {
        return this.getInsets().getLeft() + this.getInsets().getRight();
    }

    @Override
    protected double computeMinHeight(double d) {
        return this.getInsets().getTop() + this.getInsets().getBottom();
    }

    @Override
    protected double computePrefWidth(double d) {
        double d2 = super.computePrefWidth(d);
        return this.getInsets().getLeft() + d2 + this.getInsets().getRight();
    }

    @Override
    protected double computePrefHeight(double d) {
        double d2 = super.computePrefHeight(d);
        return this.getInsets().getTop() + d2 + this.getInsets().getBottom();
    }

    protected double computeMaxWidth(double d) {
        return Double.MAX_VALUE;
    }

    protected double computeMaxHeight(double d) {
        return Double.MAX_VALUE;
    }

    protected double snapSpace(double d) {
        return Region.snapSpace(d, this.isSnapToPixel());
    }

    protected double snapSize(double d) {
        return Region.snapSize(d, this.isSnapToPixel());
    }

    protected double snapPosition(double d) {
        return Region.snapPosition(d, this.isSnapToPixel());
    }

    double computeChildMinAreaWidth(Node node, Insets insets) {
        return this.computeChildMinAreaWidth(node, insets, -1.0);
    }

    double computeChildMinAreaWidth(Node node, Insets insets, double d) {
        double d2 = insets != null ? Region.snapSpace(insets.getLeft(), this.isSnapToPixel()) : 0.0;
        double d3 = insets != null ? Region.snapSpace(insets.getRight(), this.isSnapToPixel()) : 0.0;
        double d4 = -1.0;
        if (node.getContentBias() == Orientation.VERTICAL) {
            d4 = this.snapSize(d != -1.0 ? Region.boundedSize(d, node.minHeight(-1.0), node.maxHeight(-1.0)) : node.minHeight(-1.0));
        }
        return d2 + this.snapSize(node.minWidth(d4)) + d3;
    }

    double computeChildMinAreaHeight(Node node, Insets insets) {
        return this.computeChildMinAreaHeight(node, insets, -1.0);
    }

    double computeChildMinAreaHeight(Node node, Insets insets, double d) {
        double d2 = insets != null ? Region.snapSpace(insets.getTop(), this.isSnapToPixel()) : 0.0;
        double d3 = insets != null ? Region.snapSpace(insets.getBottom(), this.isSnapToPixel()) : 0.0;
        double d4 = -1.0;
        if (node.getContentBias() == Orientation.HORIZONTAL) {
            d4 = this.snapSize(d != -1.0 ? Region.boundedSize(d, node.minWidth(-1.0), node.maxWidth(-1.0)) : node.minWidth(-1.0));
        }
        return d2 + this.snapSize(node.minHeight(d4)) + d3;
    }

    double computeChildPrefAreaWidth(Node node, Insets insets) {
        return this.computeChildPrefAreaWidth(node, insets, -1.0);
    }

    double computeChildPrefAreaWidth(Node node, Insets insets, double d) {
        double d2 = insets != null ? Region.snapSpace(insets.getTop(), this.isSnapToPixel()) : 0.0;
        double d3 = insets != null ? Region.snapSpace(insets.getBottom(), this.isSnapToPixel()) : 0.0;
        double d4 = insets != null ? Region.snapSpace(insets.getLeft(), this.isSnapToPixel()) : 0.0;
        double d5 = insets != null ? Region.snapSpace(insets.getRight(), this.isSnapToPixel()) : 0.0;
        double d6 = -1.0;
        if (node.getContentBias() == Orientation.VERTICAL) {
            d6 = this.snapSize(Region.boundedSize(d != -1.0 ? d - d2 - d3 : node.prefHeight(-1.0), node.minHeight(-1.0), node.maxHeight(-1.0)));
        }
        return d4 + this.snapSize(Region.boundedSize(node.prefWidth(d6), node.minWidth(d6), node.maxWidth(d6))) + d5;
    }

    double computeChildPrefAreaHeight(Node node, Insets insets) {
        return this.computeChildPrefAreaHeight(node, insets, -1.0);
    }

    double computeChildPrefAreaHeight(Node node, Insets insets, double d) {
        double d2 = insets != null ? Region.snapSpace(insets.getTop(), this.isSnapToPixel()) : 0.0;
        double d3 = insets != null ? Region.snapSpace(insets.getBottom(), this.isSnapToPixel()) : 0.0;
        double d4 = insets != null ? Region.snapSpace(insets.getLeft(), this.isSnapToPixel()) : 0.0;
        double d5 = insets != null ? Region.snapSpace(insets.getRight(), this.isSnapToPixel()) : 0.0;
        double d6 = -1.0;
        if (node.getContentBias() == Orientation.HORIZONTAL) {
            d6 = this.snapSize(Region.boundedSize(d != -1.0 ? d - d4 - d5 : node.prefWidth(-1.0), node.minWidth(-1.0), node.maxWidth(-1.0)));
        }
        return d2 + this.snapSize(Region.boundedSize(node.prefHeight(d6), node.minHeight(d6), node.maxHeight(d6))) + d3;
    }

    double computeChildMaxAreaWidth(Node node, Insets insets) {
        return this.computeChildMaxAreaWidth(node, insets, -1.0);
    }

    double computeChildMaxAreaWidth(Node node, Insets insets, double d) {
        double d2 = node.maxWidth(-1.0);
        if (d2 == Double.MAX_VALUE) {
            return d2;
        }
        double d3 = insets != null ? Region.snapSpace(insets.getLeft(), this.isSnapToPixel()) : 0.0;
        double d4 = insets != null ? Region.snapSpace(insets.getRight(), this.isSnapToPixel()) : 0.0;
        double d5 = -1.0;
        if (node.getContentBias() == Orientation.VERTICAL) {
            d5 = this.snapSize(d != -1.0 ? Region.boundedSize(d, node.minHeight(-1.0), node.maxHeight(-1.0)) : node.maxHeight(-1.0));
            d2 = node.maxWidth(d5);
        }
        return d3 + this.snapSize(Region.boundedSize(d2, node.minWidth(d5), node.maxWidth(d5))) + d4;
    }

    double computeChildMaxAreaHeight(Node node, Insets insets) {
        return this.computeChildMaxAreaHeight(node, insets, -1.0);
    }

    double computeChildMaxAreaHeight(Node node, Insets insets, double d) {
        double d2 = node.maxHeight(-1.0);
        if (d2 == Double.MAX_VALUE) {
            return d2;
        }
        double d3 = insets != null ? Region.snapSpace(insets.getTop(), this.isSnapToPixel()) : 0.0;
        double d4 = insets != null ? Region.snapSpace(insets.getBottom(), this.isSnapToPixel()) : 0.0;
        double d5 = -1.0;
        if (node.getContentBias() == Orientation.HORIZONTAL) {
            d5 = this.snapSize(d != -1.0 ? Region.boundedSize(d, node.minWidth(-1.0), node.maxWidth(-1.0)) : node.maxWidth(-1.0));
            d2 = node.maxHeight(d5);
        }
        return d3 + this.snapSize(Region.boundedSize(d2, node.minHeight(d5), node.maxHeight(d5))) + d4;
    }

    double computeMaxMinAreaWidth(List<Node> list, Insets[] insetsArray, HPos hPos) {
        return this.getMaxAreaWidth(list, insetsArray, Region.createDoubleArray(list.size(), -1.0), hPos, true);
    }

    double computeMaxMinAreaWidth(List<Node> list, Insets[] insetsArray, HPos hPos, double d) {
        return this.getMaxAreaWidth(list, insetsArray, Region.createDoubleArray(list.size(), d), hPos, true);
    }

    double computeMaxMinAreaWidth(List<Node> list, Insets[] insetsArray, double[] dArray, HPos hPos) {
        return this.getMaxAreaWidth(list, insetsArray, dArray, hPos, true);
    }

    double computeMaxMinAreaHeight(List<Node> list, Insets[] insetsArray, VPos vPos) {
        return this.getMaxAreaHeight(list, insetsArray, Region.createDoubleArray(list.size(), -1.0), vPos, true);
    }

    double computeMaxMinAreaHeight(List<Node> list, Insets[] insetsArray, VPos vPos, double d) {
        return this.getMaxAreaHeight(list, insetsArray, Region.createDoubleArray(list.size(), d), vPos, true);
    }

    double computeMaxMinAreaHeight(List<Node> list, Insets[] insetsArray, double[] dArray, VPos vPos) {
        return this.getMaxAreaHeight(list, insetsArray, dArray, vPos, true);
    }

    double computeMaxPrefAreaWidth(List<Node> list, Insets[] insetsArray, HPos hPos) {
        return this.getMaxAreaWidth(list, insetsArray, Region.createDoubleArray(list.size(), -1.0), hPos, false);
    }

    double computeMaxPrefAreaWidth(List<Node> list, Insets[] insetsArray, double d, HPos hPos) {
        return this.getMaxAreaWidth(list, insetsArray, Region.createDoubleArray(list.size(), d), hPos, false);
    }

    double computeMaxPrefAreaWidth(List<Node> list, Insets[] insetsArray, double[] dArray, HPos hPos) {
        return this.getMaxAreaWidth(list, insetsArray, dArray, hPos, false);
    }

    double computeMaxPrefAreaHeight(List<Node> list, Insets[] insetsArray, VPos vPos) {
        return this.getMaxAreaHeight(list, insetsArray, Region.createDoubleArray(list.size(), -1.0), vPos, false);
    }

    double computeMaxPrefAreaHeight(List<Node> list, Insets[] insetsArray, double d, VPos vPos) {
        return this.getMaxAreaHeight(list, insetsArray, Region.createDoubleArray(list.size(), d), vPos, false);
    }

    double computeMaxPrefAreaHeight(List<Node> list, Insets[] insetsArray, double[] dArray, VPos vPos) {
        return this.getMaxAreaHeight(list, insetsArray, dArray, vPos, false);
    }

    private double getMaxAreaHeight(List<Node> list, Insets[] insetsArray, double[] dArray, VPos vPos, boolean bl) {
        if (vPos == VPos.BASELINE) {
            double d = 0.0;
            double d2 = 0.0;
            for (int i = 0; i < list.size(); ++i) {
                Node node = list.get(i);
                double d3 = node.getBaselineOffset();
                double d4 = insetsArray[i] != null ? this.snapSpace(insetsArray[i].getTop()) : 0.0;
                double d5 = insetsArray[i] != null ? this.snapSpace(insetsArray[i].getBottom()) : 0.0;
                d = Math.max(d, d3 + d4);
                d2 = Math.max(d2, this.snapSpace(bl ? this.snapSize(node.minHeight(dArray[i])) : this.snapSize(node.prefHeight(dArray[i]))) - d3 + d5);
            }
            return d + d2;
        }
        double d = 0.0;
        for (int i = 0; i < list.size(); ++i) {
            Node node = list.get(i);
            d = Math.max(d, bl ? this.computeChildMinAreaHeight(node, insetsArray[i], dArray[i]) : this.computeChildPrefAreaHeight(node, insetsArray[i], dArray[i]));
        }
        return d;
    }

    private double getMaxAreaWidth(List<Node> list, Insets[] insetsArray, double[] dArray, HPos hPos, boolean bl) {
        double d = 0.0;
        for (int i = 0; i < list.size(); ++i) {
            Node node = list.get(i);
            d = Math.max(d, bl ? this.computeChildMinAreaWidth(list.get(i), insetsArray[i], dArray[i]) : this.computeChildPrefAreaWidth(node, insetsArray[i], dArray[i]));
        }
        return d;
    }

    protected void positionInArea(Node node, double d, double d2, double d3, double d4, double d5, HPos hPos, VPos vPos) {
        this.positionInArea(node, d, d2, d3, d4, d5, Insets.EMPTY, hPos, vPos);
    }

    protected void positionInArea(Node node, double d, double d2, double d3, double d4, double d5, Insets insets, HPos hPos, VPos vPos) {
        Insets insets2 = insets != null ? insets : Insets.EMPTY;
        this.position(node, d, d2, d3, d4, d5, this.snapSpace(insets2.getTop()), this.snapSpace(insets2.getRight()), this.snapSpace(insets2.getBottom()), this.snapSpace(insets2.getLeft()), hPos, vPos);
    }

    protected void layoutInArea(Node node, double d, double d2, double d3, double d4, double d5, HPos hPos, VPos vPos) {
        this.layoutInArea(node, d, d2, d3, d4, d5, Insets.EMPTY, hPos, vPos);
    }

    protected void layoutInArea(Node node, double d, double d2, double d3, double d4, double d5, Insets insets, HPos hPos, VPos vPos) {
        this.layoutInArea(node, d, d2, d3, d4, d5, insets, true, true, hPos, vPos);
    }

    protected void layoutInArea(Node node, double d, double d2, double d3, double d4, double d5, Insets insets, boolean bl, boolean bl2, HPos hPos, VPos vPos) {
        Insets insets2 = insets != null ? insets : Insets.EMPTY;
        double d6 = this.snapSpace(insets2.getTop());
        double d7 = this.snapSpace(insets2.getBottom());
        double d8 = this.snapSpace(insets2.getLeft());
        double d9 = this.snapSpace(insets2.getRight());
        if (node.isResizable()) {
            Orientation orientation = node.getContentBias();
            double d10 = d3 - d8 - d9;
            double d11 = d4 - d6 - d7;
            double d12 = 0.0;
            double d13 = 0.0;
            if (orientation == null) {
                d12 = Region.boundedSize(bl ? d10 : Math.min(d10, node.prefWidth(-1.0)), node.minWidth(-1.0), node.maxWidth(-1.0));
                d13 = Region.boundedSize(bl2 ? d11 : Math.min(d11, node.prefHeight(-1.0)), node.minHeight(-1.0), node.maxHeight(-1.0));
            } else if (orientation == Orientation.HORIZONTAL) {
                d12 = Region.boundedSize(bl ? d10 : Math.min(d10, node.prefWidth(-1.0)), node.minWidth(-1.0), node.maxWidth(-1.0));
                d13 = Region.boundedSize(bl2 ? d11 : Math.min(d11, node.prefHeight(d12)), node.minHeight(d12), node.maxHeight(d12));
            } else {
                d13 = Region.boundedSize(bl2 ? d11 : Math.min(d11, node.prefHeight(-1.0)), node.minHeight(-1.0), node.maxHeight(-1.0));
                d12 = Region.boundedSize(bl ? d10 : Math.min(d10, node.prefWidth(d13)), node.minWidth(d13), node.maxWidth(d13));
            }
            node.resize(this.snapSize(d12), this.snapSize(d13));
        }
        this.position(node, d, d2, d3, d4, d5, d6, d9, d7, d8, hPos, vPos);
    }

    private void position(Node node, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, HPos hPos, VPos vPos) {
        double d10 = d9 + Region.computeXOffset(d3 - d9 - d7, node.getLayoutBounds().getWidth(), hPos);
        double d11 = d6 + (vPos == VPos.BASELINE ? d5 - node.getBaselineOffset() : Region.computeYOffset(d4 - d6 - d8, node.getLayoutBounds().getHeight(), vPos));
        double d12 = node.isResizable() ? this.snapPosition(d + d10) : d + d10;
        double d13 = node.isResizable() ? this.snapPosition(d2 + d11) : d2 + d11;
        node.relocate(d12, d13);
    }

    @Override
    public void impl_updatePG() {
        Object object;
        super.impl_updatePG();
        PGRegion pGRegion = (PGRegion)this.impl_getPGNode();
        if (this.impl_isDirty(DirtyBits.NODE_GEOMETRY)) {
            pGRegion.setSize((float)this.getWidth(), (float)this.getHeight());
        }
        if (this.impl_isDirty(DirtyBits.SHAPE_FILL)) {
            object = null;
            try {
                List<com.sun.javafx.scene.layout.region.BackgroundFill> list = this.getBackgroundFills();
                int n = list != null ? list.size() : 0;
                BackgroundFill[] backgroundFillArray = new BackgroundFill[n];
                for (int i = 0; i < n; ++i) {
                    object = list.get(i);
                    backgroundFillArray[i] = new BackgroundFill(Toolkit.getToolkit().getPaint(list.get(i).getFill()), (float)list.get(i).getTopLeftCornerRadius(), (float)list.get(i).getTopRightCornerRadius(), (float)list.get(i).getBottomLeftCornerRadius(), (float)list.get(i).getBottomRightCornerRadius(), (float)list.get(i).getOffsets().getTop(), (float)list.get(i).getOffsets().getLeft(), (float)list.get(i).getOffsets().getBottom(), (float)list.get(i).getOffsets().getRight());
                }
                pGRegion.setBackgroundFills(backgroundFillArray);
            }
            catch (Exception exception) {
                System.out.println("Failed to apply background fills to region [" + this.getStyleClass() + "]");
                System.out.println("    because: " + exception.getMessage());
                System.out.println("    failed bf=" + object);
                if (object != null && ((com.sun.javafx.scene.layout.region.BackgroundFill)object).getFill() instanceof LinearGradient) {
                    LinearGradient linearGradient = (LinearGradient)((com.sun.javafx.scene.layout.region.BackgroundFill)object).getFill();
                    System.out.println("       startX=" + linearGradient.getStartX() + " startY=" + linearGradient.getStartY() + " endX=" + linearGradient.getEndX() + " endY=" + linearGradient.getStartY() + " proportional=" + linearGradient.isProportional() + " cycleMethod=" + (Object)((Object)linearGradient.getCycleMethod()));
                    System.out.println("       stops=");
                    for (Stop stop : linearGradient.getStops()) {
                        System.out.println(" (" + stop.getOffset() + "," + stop.getColor() + ")");
                    }
                    System.out.println(" ");
                }
                exception.printStackTrace();
            }
        }
        if (this.impl_isDirty(DirtyBits.SHAPE_STROKE)) {
            double d;
            double d2;
            int n;
            object = this.getImageBorders();
            int n2 = object != null ? object.size() : 0;
            List<StrokeBorder> list = this.getStrokeBorders();
            int n3 = list != null ? list.size() : 0;
            Border[] borderArray = new Border[n2 + n3];
            for (n = 0; n < n2; ++n) {
                d2 = ((BorderImage)object.get(n)).isProportionalWidth() ? this.getWidth() : 1.0;
                d = ((BorderImage)object.get(n)).isProportionalWidth() ? this.getHeight() : 1.0;
                double d3 = ((BorderImage)object.get(n)).isProportionalSlice() ? ((BorderImage)object.get(n)).getImage().getWidth() : 1.0;
                double d4 = ((BorderImage)object.get(n)).isProportionalSlice() ? ((BorderImage)object.get(n)).getImage().getHeight() : 1.0;
                borderArray[n] = new ImageBorder((float)(((BorderImage)object.get(n)).getTopWidth() * d), (float)(((BorderImage)object.get(n)).getLeftWidth() * d2), (float)(((BorderImage)object.get(n)).getBottomWidth() * d), (float)(((BorderImage)object.get(n)).getRightWidth() * d2), (float)((BorderImage)object.get(n)).getOffsets().getTop(), (float)((BorderImage)object.get(n)).getOffsets().getLeft(), (float)((BorderImage)object.get(n)).getOffsets().getBottom(), (float)((BorderImage)object.get(n)).getOffsets().getRight(), ((BorderImage)object.get(n)).getImage().impl_getPlatformImage(), (float)(((BorderImage)object.get(n)).getTopSlice() * d4), (float)(((BorderImage)object.get(n)).getLeftSlice() * d3), (float)(((BorderImage)object.get(n)).getBottomSlice() * d4), (float)(((BorderImage)object.get(n)).getRightSlice() * d3), Repeat.values()[((BorderImage)object.get(n)).getRepeatX().ordinal()], Repeat.values()[((BorderImage)object.get(n)).getRepeatY().ordinal()], ((BorderImage)object.get(n)).isFillCenter());
            }
            for (n = 0; n < n3; ++n) {
                d2 = list.get(n).isProportionalWidth() ? this.getWidth() : 1.0;
                d = list.get(n).isProportionalWidth() ? this.getHeight() : 1.0;
                borderArray[n + n2] = new StrokedBorder((float)(list.get(n).getTopWidth() * d), (float)(list.get(n).getLeftWidth() * d2), (float)(list.get(n).getBottomWidth() * d), (float)(list.get(n).getRightWidth() * d2), (float)list.get(n).getOffsets().getTop(), (float)list.get(n).getOffsets().getLeft(), (float)list.get(n).getOffsets().getBottom(), (float)list.get(n).getOffsets().getRight(), (float)list.get(n).getTopLeftCornerRadius(), (float)list.get(n).getTopRightCornerRadius(), (float)list.get(n).getBottomLeftCornerRadius(), (float)list.get(n).getBottomRightCornerRadius(), Toolkit.getToolkit().getPaint(list.get(n).getTopFill()), Toolkit.getToolkit().getPaint(list.get(n).getLeftFill()), Toolkit.getToolkit().getPaint(list.get(n).getBottomFill()), Toolkit.getToolkit().getPaint(list.get(n).getRightFill()), this.createSgBorderStyle(list.get(n).getTopStyle()), this.createSgBorderStyle(list.get(n).getLeftStyle()), this.createSgBorderStyle(list.get(n).getBottomStyle()), this.createSgBorderStyle(list.get(n).getRightStyle()));
            }
            pGRegion.setBorders(borderArray);
        }
        if (this.impl_isDirty(DirtyBits.NODE_CONTENTS)) {
            object = this.getBackgroundImages();
            int n = object != null ? object.size() : 0;
            BackgroundImage[] backgroundImageArray = new BackgroundImage[n];
            if (object != null) {
                for (int i = 0; i < n; ++i) {
                    com.sun.javafx.scene.layout.region.BackgroundImage backgroundImage = (com.sun.javafx.scene.layout.region.BackgroundImage)object.get(i);
                    backgroundImageArray[i] = new BackgroundImage(backgroundImage.getImage().impl_getPlatformImage(), Repeat.values()[backgroundImage.getRepeatX().ordinal()], Repeat.values()[backgroundImage.getRepeatY().ordinal()], (float)backgroundImage.getTop(), (float)backgroundImage.getLeft(), (float)backgroundImage.getBottom(), (float)backgroundImage.getRight(), (float)backgroundImage.getWidth(), (float)backgroundImage.getHeight(), backgroundImage.isProportionalHPos(), backgroundImage.isProportionalVPos(), backgroundImage.isProportionalWidth(), backgroundImage.isProportionalHeight(), backgroundImage.isContain(), backgroundImage.isCover());
                }
            }
            pGRegion.setBackgroundImages(backgroundImageArray);
        }
        if (this.impl_isDirty(DirtyBits.REGION_SHAPE)) {
            object = this.getShape();
            if (object == null) {
                pGRegion.setShape(null);
            } else {
                ((Node)object).impl_syncPGNode();
                pGRegion.setShape((PGShape)((Node)object).impl_getPGNode());
            }
            pGRegion.setResizeShape(this.getScaleShape());
            pGRegion.setPositionShape(this.getPositionShape());
        }
    }

    private com.sun.javafx.sg.BorderStyle createSgBorderStyle(BorderStyle borderStyle) {
        if (borderStyle != null && borderStyle != BorderStyle.NONE) {
            if (borderStyle == BorderStyle.SOLID) {
                return com.sun.javafx.sg.BorderStyle.SOLID;
            }
            double[] dArray = borderStyle.getStrokeDashArray() != null ? borderStyle.getStrokeDashArray() : new double[]{};
            float[] fArray = new float[dArray.length];
            for (int i = 0; i < fArray.length; ++i) {
                fArray[i] = (float)dArray[i];
            }
            return new com.sun.javafx.sg.BorderStyle(this.toPGStrokeType(borderStyle.getStrokeType()), this.toPGLineCap(borderStyle.getStrokeLineCap()), this.toPGLineJoin(borderStyle.getStrokeLineJoin()), (float)borderStyle.getStrokeMiterLimit(), fArray, (float)borderStyle.getStrokeDashOffset());
        }
        return null;
    }

    @Override
    public PGNode impl_createPGNode() {
        return Toolkit.getToolkit().createPGRegion();
    }

    @Override
    @Deprecated
    protected boolean impl_computeContains(double d, double d2) {
        List<StrokeBorder> list;
        List<BorderImage> list2;
        List<com.sun.javafx.scene.layout.region.BackgroundImage> list3;
        List<com.sun.javafx.scene.layout.region.BackgroundFill> list4;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = this.getWidth();
        double d6 = this.getHeight();
        Shape shape = this.getShape();
        if (shape != null && !this.getScaleShape()) {
            if (shape.contains(d, d2)) {
                return true;
            }
            double d7 = shape.getLayoutBounds().getWidth();
            double d8 = shape.getLayoutBounds().getHeight();
            if (this.positionShape != null && this.positionShape.get()) {
                d3 = (this.getWidth() - d7) / 2.0;
                d4 = (this.getHeight() - d8) / 2.0;
                d5 = d3 + d7;
                d6 = d4 + d8;
            } else {
                d3 = shape.getLayoutBounds().getMinX();
                d4 = shape.getLayoutBounds().getMinY();
                d5 = shape.getLayoutBounds().getMaxX();
                d6 = shape.getLayoutBounds().getMaxY();
            }
        }
        if ((list4 = this.getBackgroundFills()) != null) {
            for (int i = 0; i < list4.size(); ++i) {
                Insets insets = list4.get(i).getOffsets();
                if (list4.get(i).getFill() == null) continue;
                double d9 = d3 + insets.getLeft();
                double d10 = d4 + insets.getTop();
                double d11 = d5 - insets.getRight();
                double d12 = d6 - insets.getBottom();
                if (!(d >= d9) || !(d2 >= d10) || !(d < d11) || !(d2 < d12)) continue;
                double d13 = list4.get(i).getTopLeftCornerRadius() / 2.0;
                double d14 = list4.get(i).getTopRightCornerRadius() / 2.0;
                double d15 = list4.get(i).getBottomLeftCornerRadius() / 2.0;
                double d16 = list4.get(i).getBottomRightCornerRadius() / 2.0;
                double d17 = 1.0;
                double d18 = 1.0;
                if (d13 != 0.0 && d < d9 + d13 && d2 < d10 + d13) {
                    d17 = (d - (d9 + d13)) / d13;
                    d18 = (d2 - (d10 + d13)) / d13;
                } else if (d15 != 0.0 && d < d9 + d15 && d2 > d12 - d15) {
                    d17 = (d - (d9 + d15)) / d15;
                    d18 = (d2 - (d12 - d15)) / d15;
                } else if (d14 != 0.0 && d > d11 - d14 && d2 < d10 + d14) {
                    d17 = (d - (d11 - d14)) / d14;
                    d18 = (d2 - (d10 + d14)) / d14;
                } else {
                    if (d16 == 0.0 || !(d > d11 - d16) || !(d2 > d12 - d16)) break;
                    d17 = (d - (d11 - d16)) / d16;
                    d18 = (d2 - (d12 - d16)) / d16;
                }
                if (!(d17 * d17 + d18 * d18 < 0.5)) continue;
                return true;
            }
        }
        if ((list3 = this.getBackgroundImages()) != null) {
            for (int i = 0; i < list3.size(); ++i) {
                if (!(d >= d3 + list3.get(i).getLeft()) || !(d <= d5 - list3.get(i).getRight()) || !(d2 >= d4 + list3.get(i).getTop()) || !(d2 <= d6 - list3.get(i).getBottom())) continue;
                return true;
            }
        }
        if ((list2 = this.getImageBorders()) != null) {
            for (int i = 0; i < list2.size(); ++i) {
                Insets insets = list2.get(i).getOffsets();
                if (!this.borderContains(d, d2, d3 + insets.getLeft(), d4 + insets.getTop(), d5 - insets.getRight(), d6 - insets.getBottom(), list2.get(i).getTopWidth(), list2.get(i).getRightWidth(), list2.get(i).getBottomWidth(), list2.get(i).getLeftWidth())) continue;
                return true;
            }
        }
        if ((list = this.getStrokeBorders()) != null) {
            for (int i = 0; i < list.size(); ++i) {
                Insets insets = list.get(i).getOffsets();
                if (!this.borderContains(d, d2, d3 + insets.getLeft(), d4 + insets.getTop(), d5 - insets.getRight(), d6 - insets.getBottom(), list.get(i).getTopWidth(), list.get(i).getRightWidth(), list.get(i).getBottomWidth(), list.get(i).getLeftWidth())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean borderContains(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10) {
        return (d >= d3 && d <= d3 + d10 || d >= d5 - d8 && d <= d5) && d2 >= d4 && d2 <= d6 || (d2 >= d4 && d2 <= d4 + d7 || d2 >= d6 - d9 && d2 <= d6) && d >= d3 && d <= d5;
    }

    @Override
    @Deprecated
    protected Node impl_pickNodeLocal(double d, double d2) {
        if (this.containsBounds(d, d2)) {
            ObservableList<Node> observableList = this.getChildren();
            for (int i = observableList.size() - 1; i >= 0; --i) {
                Node node = ((Node)observableList.get(i)).impl_pickNode(d, d2);
                if (node == null) continue;
                return node;
            }
            if (this.contains(d, d2)) {
                return this;
            }
        }
        return null;
    }

    @Override
    @Deprecated
    protected Node impl_pickNodeLocal(PickRay pickRay) {
        if (this.impl_intersects(pickRay)) {
            ObservableList<Node> observableList = this.getChildren();
            for (int i = observableList.size() - 1; i >= 0; --i) {
                Node node = ((Node)observableList.get(i)).impl_pickNode(pickRay);
                if (node == null) continue;
                return node;
            }
            return this;
        }
        return null;
    }

    @Override
    @Deprecated
    protected Bounds impl_computeLayoutBounds() {
        return new BoundingBox(0.0, 0.0, 0.0, this.getWidth(), this.getHeight(), 0.0);
    }

    @Override
    @Deprecated
    protected final void impl_notifyLayoutBoundsChanged() {
    }

    @Override
    @Deprecated
    public BaseBounds impl_computeGeomBounds(BaseBounds baseBounds, BaseTransform baseTransform) {
        BaseBounds baseBounds2;
        Object object;
        List<StrokeBorder> list;
        List<BorderImage> list2;
        List<com.sun.javafx.scene.layout.region.BackgroundImage> list3;
        double d;
        double d2;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = this.getWidth();
        double d6 = this.getHeight();
        Shape shape = this.getShape();
        if (shape != null && !this.getScaleShape()) {
            d2 = shape.getLayoutBounds().getWidth();
            d = shape.getLayoutBounds().getHeight();
            if (this.getPositionShape()) {
                d3 = (this.getWidth() - d2) / 2.0;
                d4 = (this.getHeight() - d) / 2.0;
                d5 = d3 + d2;
                d6 = d4 + d;
            } else {
                d3 = shape.getLayoutBounds().getMinX();
                d4 = shape.getLayoutBounds().getMinY();
                d5 = shape.getLayoutBounds().getMaxX();
                d6 = shape.getLayoutBounds().getMaxY();
            }
        }
        d2 = d3;
        d = d4;
        double d7 = d5;
        double d8 = d6;
        List<com.sun.javafx.scene.layout.region.BackgroundFill> list4 = this.getBackgroundFills();
        if (list4 != null) {
            for (int i = 0; i < list4.size(); ++i) {
                Insets insets = list4.get(i).getOffsets();
                d2 = Math.min(d2, d3 + insets.getLeft());
                d = Math.min(d, d4 + insets.getTop());
                d7 = Math.max(d7, d5 - insets.getRight());
                d8 = Math.max(d8, d6 - insets.getBottom());
            }
        }
        if ((list3 = this.getBackgroundImages()) != null) {
            for (int i = 0; i < list3.size(); ++i) {
                d2 = Math.min(d2, d3 + list3.get(i).getLeft());
                d = Math.min(d, d4 + list3.get(i).getTop());
                d7 = Math.max(d7, d5 - list3.get(i).getRight());
                d8 = Math.max(d8, d6 - list3.get(i).getBottom());
            }
        }
        if ((list2 = this.getImageBorders()) != null) {
            for (int i = 0; i < list2.size(); ++i) {
                Insets insets = list2.get(i).getOffsets();
                d2 = Math.min(d2, d3 + insets.getLeft() - list2.get(i).getLeftWidth() / 2.0);
                d = Math.min(d, d4 + insets.getTop() - list2.get(i).getTopWidth() / 2.0);
                d7 = Math.max(d7, d5 - insets.getRight() + list2.get(i).getRightWidth() / 2.0);
                d8 = Math.max(d8, d6 - insets.getBottom() + list2.get(i).getBottomWidth() / 2.0);
            }
        }
        if ((list = this.getStrokeBorders()) != null) {
            for (int i = 0; i < list.size(); ++i) {
                object = list.get(i).getOffsets();
                d2 = Math.min(d2, d3 + ((Insets)object).getLeft() - list.get(i).getLeftWidth() / 2.0);
                d = Math.min(d, d4 + ((Insets)object).getTop() - list.get(i).getTopWidth() / 2.0);
                d7 = Math.max(d7, d5 - ((Insets)object).getRight() + list.get(i).getRightWidth() / 2.0);
                d8 = Math.max(d8, d6 - ((Insets)object).getBottom() + list.get(i).getBottomWidth() / 2.0);
            }
        }
        if ((baseBounds2 = super.impl_computeGeomBounds(baseBounds, baseTransform)).isEmpty()) {
            baseBounds = baseBounds.deriveWithNewBounds((float)d2, (float)d, 0.0f, (float)d7, (float)d8, 0.0f);
            baseBounds = baseTransform.transform(baseBounds, baseBounds);
            return baseBounds;
        }
        object = TempState.getInstance().bounds;
        object = ((BaseBounds)object).deriveWithNewBounds((float)d2, (float)d, 0.0f, (float)d7, (float)d8, 0.0f);
        BaseBounds baseBounds3 = baseTransform.transform((BaseBounds)object, (BaseBounds)object);
        baseBounds2 = baseBounds2.deriveWithUnion(baseBounds3);
        return baseBounds2;
    }

    PGShape.StrokeLineCap toPGLineCap(StrokeLineCap strokeLineCap) {
        if (strokeLineCap == StrokeLineCap.SQUARE) {
            return PGShape.StrokeLineCap.SQUARE;
        }
        if (strokeLineCap == StrokeLineCap.BUTT) {
            return PGShape.StrokeLineCap.BUTT;
        }
        return PGShape.StrokeLineCap.ROUND;
    }

    PGShape.StrokeLineJoin toPGLineJoin(StrokeLineJoin strokeLineJoin) {
        if (strokeLineJoin == StrokeLineJoin.MITER) {
            return PGShape.StrokeLineJoin.MITER;
        }
        if (strokeLineJoin == StrokeLineJoin.BEVEL) {
            return PGShape.StrokeLineJoin.BEVEL;
        }
        return PGShape.StrokeLineJoin.ROUND;
    }

    PGShape.StrokeType toPGStrokeType(StrokeType strokeType) {
        if (strokeType == StrokeType.INSIDE) {
            return PGShape.StrokeType.INSIDE;
        }
        if (strokeType == StrokeType.OUTSIDE) {
            return PGShape.StrokeType.OUTSIDE;
        }
        return PGShape.StrokeType.CENTERED;
    }

    @Deprecated
    public static List<StyleableProperty> impl_CSS_STYLEABLES() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    @Deprecated
    public List<StyleableProperty> impl_getStyleableProperties() {
        return Region.impl_CSS_STYLEABLES();
    }

    private final class InsetsExpression
    extends ObjectExpression<Insets> {
        private Insets cache = null;
        private ExpressionHelper<Insets> helper = null;

        private InsetsExpression() {
        }

        void fireValueChanged() {
            this.cache = null;
            ExpressionHelper.fireValueChangedEvent(this.helper);
        }

        @Override
        public Insets get() {
            if (Region.this.imageBorders == null && Region.this.strokeBorders == null) {
                return Region.this.getPadding();
            }
            if (this.cache == null) {
                List list;
                double d = 0.0;
                double d2 = 0.0;
                double d3 = 0.0;
                double d4 = 0.0;
                List list2 = Region.this.getImageBorders();
                if (list2 != null) {
                    for (int i = 0; i < list2.size(); ++i) {
                        Insets insets = ((BorderImage)list2.get(i)).getOffsets();
                        d3 = Math.max(d3, insets.getLeft() + ((BorderImage)list2.get(i)).getLeftWidth());
                        d = Math.max(d, insets.getTop() + ((BorderImage)list2.get(i)).getTopWidth());
                        d4 = Math.max(d4, insets.getRight() + ((BorderImage)list2.get(i)).getRightWidth());
                        d2 = Math.max(d2, insets.getBottom() + ((BorderImage)list2.get(i)).getBottomWidth());
                    }
                }
                if ((list = Region.this.getStrokeBorders()) != null) {
                    for (int i = 0; i < list.size(); ++i) {
                        Insets insets = ((StrokeBorder)list.get(i)).getOffsets();
                        d3 = Math.max(d3, insets.getLeft() + ((StrokeBorder)list.get(i)).getLeftWidth());
                        d = Math.max(d, insets.getTop() + ((StrokeBorder)list.get(i)).getTopWidth());
                        d4 = Math.max(d4, insets.getRight() + ((StrokeBorder)list.get(i)).getRightWidth());
                        d2 = Math.max(d2, insets.getBottom() + ((StrokeBorder)list.get(i)).getBottomWidth());
                    }
                }
                Insets insets = Region.this.getPadding();
                this.cache = new Insets(Math.max(0.0, d) + insets.getTop(), Math.max(0.0, d4) + insets.getRight(), Math.max(0.0, d2) + insets.getBottom(), Math.max(0.0, d3) + insets.getLeft());
            }
            return this.cache;
        }

        @Override
        public Insets getValue() {
            return this.get();
        }

        @Override
        public void addListener(InvalidationListener invalidationListener) {
            this.helper = ExpressionHelper.addListener(this.helper, this, invalidationListener);
        }

        @Override
        public void removeListener(InvalidationListener invalidationListener) {
            this.helper = ExpressionHelper.removeListener(this.helper, invalidationListener);
        }

        @Override
        public void addListener(ChangeListener<? super Insets> changeListener) {
            this.helper = ExpressionHelper.addListener(this.helper, this, changeListener);
        }

        @Override
        public void removeListener(ChangeListener<? super Insets> changeListener) {
            this.helper = ExpressionHelper.removeListener(this.helper, changeListener);
        }
    }

    private static class StyleableProperties {
        private static final StyleableProperty<Region, Insets> PADDING = new StyleableProperty<Region, Insets>("-fx-padding", (StyleConverter)InsetsConverter.getInstance(), Insets.EMPTY){

            @Override
            public boolean isSettable(Region region) {
                return region.padding == null || !region.padding.isBound();
            }

            @Override
            public WritableValue<Insets> getWritableValue(Region region) {
                return region.paddingProperty();
            }
        };
        private static final StyleableProperty<Region, List<com.sun.javafx.scene.layout.region.BackgroundFill>> BACKGROUND_FILLS = new StyleableProperty<Region, List<com.sun.javafx.scene.layout.region.BackgroundFill>>("-fx-background-fills", (StyleConverter)BackgroundFillConverter.getInstance(), null, false, com.sun.javafx.scene.layout.region.BackgroundFill.impl_CSS_STYLEABLES()){

            @Override
            public boolean isSettable(Region region) {
                return region.backgroundFills == null || !region.backgroundFills.isBound();
            }

            @Override
            public WritableValue<List<com.sun.javafx.scene.layout.region.BackgroundFill>> getWritableValue(Region region) {
                return region.backgroundFillsProperty();
            }
        };
        private static final StyleableProperty<Region, List<com.sun.javafx.scene.layout.region.BackgroundImage>> BACKGROUND_IMAGES = new StyleableProperty<Region, List<com.sun.javafx.scene.layout.region.BackgroundImage>>("-fx-background-images", (StyleConverter)BackgroundImageConverter.getInstance(), null, false, com.sun.javafx.scene.layout.region.BackgroundImage.impl_CSS_STYLEABLES()){

            @Override
            public boolean isSettable(Region region) {
                return region.backgroundImages == null || !region.backgroundImages.isBound();
            }

            @Override
            public WritableValue<List<com.sun.javafx.scene.layout.region.BackgroundImage>> getWritableValue(Region region) {
                return region.backgroundImagesProperty();
            }
        };
        private static final StyleableProperty<Region, List<BorderImage>> IMAGE_BORDERS = new StyleableProperty<Region, List<BorderImage>>("-fx-image-borders", (StyleConverter)BorderImageConverter.getInstance(), null, false, BorderImage.impl_CSS_STYLEABLES()){

            @Override
            public boolean isSettable(Region region) {
                return region.imageBorders == null || !region.imageBorders.isBound();
            }

            @Override
            public WritableValue<List<BorderImage>> getWritableValue(Region region) {
                return region.imageBordersProperty();
            }
        };
        private static final StyleableProperty<Region, List<StrokeBorder>> STROKE_BORDERS = new StyleableProperty<Region, List<StrokeBorder>>("-fx-stroke-borders", (StyleConverter)StrokeBorderConverter.getInstance(), null, false, StrokeBorder.impl_CSS_STYLEABLES()){

            @Override
            public boolean isSettable(Region region) {
                return region.strokeBorders == null || !region.strokeBorders.isBound();
            }

            @Override
            public WritableValue<List<StrokeBorder>> getWritableValue(Region region) {
                return region.strokeBordersProperty();
            }
        };
        private static final StyleableProperty<Region, String> SHAPE = new StyleableProperty<Region, String>("-fx-shape", (StyleConverter)StringConverter.getInstance()){

            @Override
            public boolean isSettable(Region region) {
                return region.shape == null || !region.shape.isBound();
            }

            @Override
            public WritableValue<String> getWritableValue(Region region) {
                return region.shapeContentProperty();
            }
        };
        private static final StyleableProperty<Region, Boolean> SCALE_SHAPE = new StyleableProperty<Region, Boolean>("-fx-scale-shape", (StyleConverter)BooleanConverter.getInstance(), Boolean.TRUE){

            @Override
            public boolean isSettable(Region region) {
                return region.scaleShape == null || !region.scaleShape.isBound();
            }

            @Override
            public WritableValue<Boolean> getWritableValue(Region region) {
                return region.scaleShapeProperty();
            }
        };
        private static final StyleableProperty<Region, Boolean> POSITION_SHAPE = new StyleableProperty<Region, Boolean>("-fx-position-shape", (StyleConverter)BooleanConverter.getInstance(), Boolean.TRUE){

            @Override
            public boolean isSettable(Region region) {
                return region.positionShape == null || !region.positionShape.isBound();
            }

            @Override
            public WritableValue<Boolean> getWritableValue(Region region) {
                return region.positionShapeProperty();
            }
        };
        private static final StyleableProperty<Region, Boolean> SNAP_TO_PIXEL = new StyleableProperty<Region, Boolean>("-fx-snap-to-pixel", (StyleConverter)BooleanConverter.getInstance(), Boolean.TRUE){

            @Override
            public boolean isSettable(Region region) {
                return region.snapToPixel == null || !region.snapToPixel.isBound();
            }

            @Override
            public WritableValue<Boolean> getWritableValue(Region region) {
                return region.snapToPixelProperty();
            }
        };
        private static final List<StyleableProperty> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList<StyleableProperty> arrayList = new ArrayList<StyleableProperty>(Parent.impl_CSS_STYLEABLES());
            Collections.addAll(arrayList, PADDING, BACKGROUND_FILLS, BACKGROUND_IMAGES, IMAGE_BORDERS, STROKE_BORDERS, SHAPE, SCALE_SHAPE, POSITION_SHAPE, SNAP_TO_PIXEL);
            STYLEABLES = Collections.unmodifiableList(arrayList);
        }
    }
}

