/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.script;

import org.apache.log4j.Logger;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpSender;
import org.zaproxy.zap.extension.script.ExtensionScript;
import org.zaproxy.zap.extension.script.ScriptWrapper;
import org.zaproxy.zap.network.HttpSenderListener;

class HttpSenderScriptListener
implements HttpSenderListener {
    private static final Logger logger = Logger.getLogger(HttpSenderScriptListener.class);
    private final ExtensionScript extension;

    public HttpSenderScriptListener(ExtensionScript extension) {
        this.extension = extension;
    }

    @Override
    public int getListenerOrder() {
        return Integer.MAX_VALUE;
    }

    @Override
    public void onHttpRequestSend(HttpMessage msg, int initiator, HttpSender sender) {
        for (ScriptWrapper script : this.extension.getScripts("httpsender")) {
            if (!script.isEnabled()) continue;
            try {
                this.extension.invokeSenderScript(script, msg, initiator, sender, true);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void onHttpResponseReceive(HttpMessage msg, int initiator, HttpSender sender) {
        for (ScriptWrapper script : this.extension.getScripts("httpsender")) {
            if (!script.isEnabled()) continue;
            try {
                this.extension.invokeSenderScript(script, msg, initiator, sender, false);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }
}

