// **********************************************************************
//
// Copyright (c) 2003-2017 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.7.0
//
// <auto-generated>
//
// Generated from file `Metrics.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

#ifndef __IceStorm_Metrics_h__
#define __IceStorm_Metrics_h__

#include <IceUtil/PushDisableWarnings.h>
#include <Ice/ProxyF.h>
#include <Ice/ObjectF.h>
#include <Ice/ValueF.h>
#include <Ice/Exception.h>
#include <Ice/LocalObject.h>
#include <Ice/StreamHelpers.h>
#include <Ice/Comparable.h>
#include <Ice/Proxy.h>
#include <Ice/Object.h>
#include <Ice/GCObject.h>
#include <Ice/Value.h>
#include <Ice/Incoming.h>
#include <Ice/FactoryTableInit.h>
#include <IceUtil/ScopedArray.h>
#include <Ice/Optional.h>
#include <Ice/ExceptionHelpers.h>
#include <Ice/Metrics.h>
#include <IceUtil/UndefSysMacros.h>
#include <IceStorm/Config.h>

#ifndef ICE_IGNORE_VERSION
#   if ICE_INT_VERSION / 100 != 307
#       error Ice version mismatch!
#   endif
#   if ICE_INT_VERSION % 100 > 50
#       error Beta header file detected
#   endif
#   if ICE_INT_VERSION % 100 < 0
#       error Ice patch level mismatch!
#   endif
#endif

#ifndef ICESTORM_API
#   if defined(ICE_STATIC_LIBS)
#       define ICESTORM_API /**/
#   elif defined(ICESTORM_API_EXPORTS)
#       define ICESTORM_API ICE_DECLSPEC_EXPORT
#   else
#       define ICESTORM_API ICE_DECLSPEC_IMPORT
#   endif
#endif

#ifdef ICE_CPP11_MAPPING // C++11 mapping

namespace IceMX
{

class TopicMetrics;
class SubscriberMetrics;

}

namespace IceMX
{

class ICE_CLASS(ICESTORM_API) TopicMetrics : public ::Ice::ValueHelper<TopicMetrics, ::IceMX::Metrics>
{
public:

    ICE_MEMBER(ICESTORM_API) virtual ~TopicMetrics();

    TopicMetrics() = default;

    TopicMetrics(const TopicMetrics&) = default;
    TopicMetrics(TopicMetrics&&) = default;
    TopicMetrics& operator=(const TopicMetrics&) = default;
    TopicMetrics& operator=(TopicMetrics&&) = default;

    TopicMetrics(const ::std::string& iceP_id, long long int iceP_total, int iceP_current, long long int iceP_totalLifetime, int iceP_failures, long long int iceP_published, long long int iceP_forwarded) :
        Ice::ValueHelper<::IceMX::TopicMetrics, ::IceMX::Metrics>(::std::move(iceP_id), iceP_total, iceP_current, iceP_totalLifetime, iceP_failures),
        published(iceP_published),
        forwarded(iceP_forwarded)
    {
    }

    std::tuple<const ::std::string&, const long long int&, const int&, const long long int&, const int&, const long long int&, const long long int&> ice_tuple() const
    {
        return std::tie(id, total, current, totalLifetime, failures, published, forwarded);
    }

    ICE_MEMBER(ICESTORM_API) static const ::std::string& ice_staticId();

    long long int published = 0LL;
    long long int forwarded = 0LL;
};

static TopicMetrics _iceS_TopicMetrics_init;

class ICE_CLASS(ICESTORM_API) SubscriberMetrics : public ::Ice::ValueHelper<SubscriberMetrics, ::IceMX::Metrics>
{
public:

    ICE_MEMBER(ICESTORM_API) virtual ~SubscriberMetrics();

    SubscriberMetrics() = default;

    SubscriberMetrics(const SubscriberMetrics&) = default;
    SubscriberMetrics(SubscriberMetrics&&) = default;
    SubscriberMetrics& operator=(const SubscriberMetrics&) = default;
    SubscriberMetrics& operator=(SubscriberMetrics&&) = default;

    SubscriberMetrics(const ::std::string& iceP_id, long long int iceP_total, int iceP_current, long long int iceP_totalLifetime, int iceP_failures, int iceP_queued, int iceP_outstanding, long long int iceP_delivered) :
        Ice::ValueHelper<::IceMX::SubscriberMetrics, ::IceMX::Metrics>(::std::move(iceP_id), iceP_total, iceP_current, iceP_totalLifetime, iceP_failures),
        queued(iceP_queued),
        outstanding(iceP_outstanding),
        delivered(iceP_delivered)
    {
    }

    std::tuple<const ::std::string&, const long long int&, const int&, const long long int&, const int&, const int&, const int&, const long long int&> ice_tuple() const
    {
        return std::tie(id, total, current, totalLifetime, failures, queued, outstanding, delivered);
    }

    ICE_MEMBER(ICESTORM_API) static const ::std::string& ice_staticId();

    int queued = 0;
    int outstanding = 0;
    long long int delivered = 0LL;
};

}

namespace IceMX
{

}

namespace Ice
{

template<typename S>
struct StreamWriter<::IceMX::TopicMetrics, S>
{
    static void write(S* ostr, const ::IceMX::TopicMetrics& v)
    {
        ostr->writeAll(v.published, v.forwarded);
    }
};

template<typename S>
struct StreamReader<::IceMX::TopicMetrics, S>
{
    static void read(S* istr, ::IceMX::TopicMetrics& v)
    {
        istr->readAll(v.published, v.forwarded);
    }
};

template<typename S>
struct StreamWriter<::IceMX::SubscriberMetrics, S>
{
    static void write(S* ostr, const ::IceMX::SubscriberMetrics& v)
    {
        ostr->writeAll(v.queued, v.outstanding, v.delivered);
    }
};

template<typename S>
struct StreamReader<::IceMX::SubscriberMetrics, S>
{
    static void read(S* istr, ::IceMX::SubscriberMetrics& v)
    {
        istr->readAll(v.queued, v.outstanding, v.delivered);
    }
};

}

namespace IceMX
{

using TopicMetricsPtr = ::std::shared_ptr<TopicMetrics>;

using SubscriberMetricsPtr = ::std::shared_ptr<SubscriberMetrics>;

}

#else // C++98 mapping

namespace IceProxy
{

namespace IceMX
{

class TopicMetrics;
ICESTORM_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< ::IceProxy::IceMX::TopicMetrics>&);
ICESTORM_API ::IceProxy::Ice::Object* upCast(::IceProxy::IceMX::TopicMetrics*);

class SubscriberMetrics;
ICESTORM_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< ::IceProxy::IceMX::SubscriberMetrics>&);
ICESTORM_API ::IceProxy::Ice::Object* upCast(::IceProxy::IceMX::SubscriberMetrics*);

}

}

namespace IceMX
{

class TopicMetrics;
ICESTORM_API ::Ice::Object* upCast(::IceMX::TopicMetrics*);
typedef ::IceInternal::Handle< ::IceMX::TopicMetrics> TopicMetricsPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceMX::TopicMetrics> TopicMetricsPrx;
typedef TopicMetricsPrx TopicMetricsPrxPtr;
ICESTORM_API void _icePatchObjectPtr(TopicMetricsPtr&, const ::Ice::ObjectPtr&);

class SubscriberMetrics;
ICESTORM_API ::Ice::Object* upCast(::IceMX::SubscriberMetrics*);
typedef ::IceInternal::Handle< ::IceMX::SubscriberMetrics> SubscriberMetricsPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceMX::SubscriberMetrics> SubscriberMetricsPrx;
typedef SubscriberMetricsPrx SubscriberMetricsPrxPtr;
ICESTORM_API void _icePatchObjectPtr(SubscriberMetricsPtr&, const ::Ice::ObjectPtr&);

}

namespace IceMX
{

}

namespace IceProxy
{

namespace IceMX
{

class ICE_CLASS(ICESTORM_API) TopicMetrics : public virtual ::Ice::Proxy<TopicMetrics, ::IceProxy::IceMX::Metrics>
{
public:

    ICE_MEMBER(ICESTORM_API) static const ::std::string& ice_staticId();

protected:

    ICE_MEMBER(ICESTORM_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
};

class ICE_CLASS(ICESTORM_API) SubscriberMetrics : public virtual ::Ice::Proxy<SubscriberMetrics, ::IceProxy::IceMX::Metrics>
{
public:

    ICE_MEMBER(ICESTORM_API) static const ::std::string& ice_staticId();

protected:

    ICE_MEMBER(ICESTORM_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
};

}

}

namespace IceMX
{

class ICESTORM_API TopicMetrics : public ::IceMX::Metrics
{
public:

    typedef TopicMetricsPrx ProxyType;
    typedef TopicMetricsPtr PointerType;

    virtual ~TopicMetrics();

    TopicMetrics() :
        published(ICE_INT64(0)),
        forwarded(ICE_INT64(0))
    {
    }

    TopicMetrics(const ::std::string& iceP_id, ::Ice::Long iceP_total, ::Ice::Int iceP_current, ::Ice::Long iceP_totalLifetime, ::Ice::Int iceP_failures, ::Ice::Long iceP_published, ::Ice::Long iceP_forwarded) :
        ::IceMX::Metrics(iceP_id, iceP_total, iceP_current, iceP_totalLifetime, iceP_failures),
        published(iceP_published),
        forwarded(iceP_forwarded)
    {
    }

    virtual ::Ice::ObjectPtr ice_clone() const;

    virtual bool ice_isA(const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual const ::std::string& ice_id(const ::Ice::Current& = ::Ice::emptyCurrent) const;

    static const ::std::string& ice_staticId();

    static ::Ice::ValueFactoryPtr ice_factory();

protected:

    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);

public:

    ::Ice::Long published;
    ::Ice::Long forwarded;
};
static ::Ice::ValueFactoryPtr _iceS_TopicMetrics_init = ::IceMX::TopicMetrics::ice_factory();

inline bool operator==(const TopicMetrics& lhs, const TopicMetrics& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const TopicMetrics& lhs, const TopicMetrics& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}

class ICESTORM_API SubscriberMetrics : public ::IceMX::Metrics
{
public:

    typedef SubscriberMetricsPrx ProxyType;
    typedef SubscriberMetricsPtr PointerType;

    virtual ~SubscriberMetrics();

    SubscriberMetrics() :
        queued(0),
        outstanding(0),
        delivered(ICE_INT64(0))
    {
    }

    SubscriberMetrics(const ::std::string& iceP_id, ::Ice::Long iceP_total, ::Ice::Int iceP_current, ::Ice::Long iceP_totalLifetime, ::Ice::Int iceP_failures, ::Ice::Int iceP_queued, ::Ice::Int iceP_outstanding, ::Ice::Long iceP_delivered) :
        ::IceMX::Metrics(iceP_id, iceP_total, iceP_current, iceP_totalLifetime, iceP_failures),
        queued(iceP_queued),
        outstanding(iceP_outstanding),
        delivered(iceP_delivered)
    {
    }

    virtual ::Ice::ObjectPtr ice_clone() const;

    virtual bool ice_isA(const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual const ::std::string& ice_id(const ::Ice::Current& = ::Ice::emptyCurrent) const;

    static const ::std::string& ice_staticId();

    static ::Ice::ValueFactoryPtr ice_factory();

protected:

    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);

public:

    ::Ice::Int queued;
    ::Ice::Int outstanding;
    ::Ice::Long delivered;
};
static ::Ice::ValueFactoryPtr _iceS_SubscriberMetrics_init = ::IceMX::SubscriberMetrics::ice_factory();

inline bool operator==(const SubscriberMetrics& lhs, const SubscriberMetrics& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const SubscriberMetrics& lhs, const SubscriberMetrics& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}

}

namespace Ice
{

template<typename S>
struct StreamWriter< ::IceMX::TopicMetrics, S>
{
    static void write(S* ostr, const ::IceMX::TopicMetrics& v)
    {
        ostr->write(v.published);
        ostr->write(v.forwarded);
    }
};

template<typename S>
struct StreamReader< ::IceMX::TopicMetrics, S>
{
    static void read(S* istr, ::IceMX::TopicMetrics& v)
    {
        istr->read(v.published);
        istr->read(v.forwarded);
    }
};

template<typename S>
struct StreamWriter< ::IceMX::SubscriberMetrics, S>
{
    static void write(S* ostr, const ::IceMX::SubscriberMetrics& v)
    {
        ostr->write(v.queued);
        ostr->write(v.outstanding);
        ostr->write(v.delivered);
    }
};

template<typename S>
struct StreamReader< ::IceMX::SubscriberMetrics, S>
{
    static void read(S* istr, ::IceMX::SubscriberMetrics& v)
    {
        istr->read(v.queued);
        istr->read(v.outstanding);
        istr->read(v.delivered);
    }
};

}

namespace IceMX
{

}

#endif

#include <IceUtil/PopDisableWarnings.h>
#endif
