/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.Communicator;
import Ice.ConnectionI;
import Ice.EncodingVersion;
import Ice.EndpointSelectionType;
import Ice.Identity;
import Ice.LocalException;
import Ice.LocatorPrx;
import Ice.ObjectPrxHelperBase;
import Ice.OutputStream;
import Ice.ProtocolVersion;
import Ice.RouterPrx;
import Ice.ToStringMode;
import Ice.Util;
import IceInternal.BatchRequestQueue;
import IceInternal.DefaultsAndOverrides;
import IceInternal.EndpointI;
import IceInternal.HashUtil;
import IceInternal.Instance;
import IceInternal.LocatorInfo;
import IceInternal.RequestHandler;
import IceInternal.RouterInfo;
import IceUtilInternal.StringUtil;
import java.util.HashMap;
import java.util.Map;

public abstract class Reference
implements Cloneable {
    public static final int ModeTwoway = 0;
    public static final int ModeOneway = 1;
    public static final int ModeBatchOneway = 2;
    public static final int ModeDatagram = 3;
    public static final int ModeBatchDatagram = 4;
    public static final int ModeLast = 4;
    protected int _hashValue;
    protected boolean _hashInitialized;
    private static Map<String, String> _emptyContext = new HashMap<String, String>();
    private final Instance _instance;
    private final Communicator _communicator;
    private int _mode;
    private boolean _secure;
    private Identity _identity;
    private Map<String, String> _context;
    private String _facet;
    private ProtocolVersion _protocol;
    private EncodingVersion _encoding;
    private int _invocationTimeout;
    protected boolean _overrideCompress;
    protected boolean _compress;

    public final int getMode() {
        return this._mode;
    }

    public final boolean getSecure() {
        return this._secure;
    }

    public final ProtocolVersion getProtocol() {
        return this._protocol;
    }

    public final EncodingVersion getEncoding() {
        return this._encoding;
    }

    public final Identity getIdentity() {
        return this._identity;
    }

    public final String getFacet() {
        return this._facet;
    }

    public final Instance getInstance() {
        return this._instance;
    }

    public final Map<String, String> getContext() {
        return this._context;
    }

    public int getInvocationTimeout() {
        return this._invocationTimeout;
    }

    public final Communicator getCommunicator() {
        return this._communicator;
    }

    public abstract EndpointI[] getEndpoints();

    public abstract String getAdapterId();

    public abstract RouterInfo getRouterInfo();

    public abstract LocatorInfo getLocatorInfo();

    public abstract boolean getCollocationOptimized();

    public abstract boolean getCacheConnection();

    public abstract boolean getPreferSecure();

    public abstract EndpointSelectionType getEndpointSelection();

    public abstract int getLocatorCacheTimeout();

    public abstract String getConnectionId();

    public final Reference changeContext(Map<String, String> newContext) {
        if (newContext == null) {
            newContext = _emptyContext;
        }
        Reference r = this._instance.referenceFactory().copy(this);
        r._context = newContext.isEmpty() ? _emptyContext : new HashMap<String, String>(newContext);
        return r;
    }

    public final Reference changeMode(int newMode) {
        if (newMode == this._mode) {
            return this;
        }
        Reference r = this._instance.referenceFactory().copy(this);
        r._mode = newMode;
        return r;
    }

    public Reference changeSecure(boolean newSecure) {
        if (newSecure == this._secure) {
            return this;
        }
        Reference r = this._instance.referenceFactory().copy(this);
        r._secure = newSecure;
        return r;
    }

    public final Reference changeIdentity(Identity newIdentity) {
        if (newIdentity.equals(this._identity)) {
            return this;
        }
        Reference r = this._instance.referenceFactory().copy(this);
        r._identity = newIdentity.clone();
        return r;
    }

    public final Reference changeFacet(String newFacet) {
        if (newFacet.equals(this._facet)) {
            return this;
        }
        Reference r = this._instance.referenceFactory().copy(this);
        r._facet = newFacet;
        return r;
    }

    public final Reference changeInvocationTimeout(int newTimeout) {
        if (newTimeout == this._invocationTimeout) {
            return this;
        }
        Reference r = this._instance.referenceFactory().copy(this);
        r._invocationTimeout = newTimeout;
        return r;
    }

    public Reference changeEncoding(EncodingVersion newEncoding) {
        if (newEncoding.equals(this._encoding)) {
            return this;
        }
        Reference r = this._instance.referenceFactory().copy(this);
        r._encoding = newEncoding;
        return r;
    }

    public Reference changeCompress(boolean newCompress) {
        if (this._overrideCompress && this._compress == newCompress) {
            return this;
        }
        Reference r = this._instance.referenceFactory().copy(this);
        r._compress = newCompress;
        r._overrideCompress = true;
        return r;
    }

    public abstract Reference changeAdapterId(String var1);

    public abstract Reference changeEndpoints(EndpointI[] var1);

    public abstract Reference changeLocator(LocatorPrx var1);

    public abstract Reference changeRouter(RouterPrx var1);

    public abstract Reference changeCollocationOptimized(boolean var1);

    public abstract Reference changeCacheConnection(boolean var1);

    public abstract Reference changePreferSecure(boolean var1);

    public abstract Reference changeEndpointSelection(EndpointSelectionType var1);

    public abstract Reference changeLocatorCacheTimeout(int var1);

    public abstract Reference changeTimeout(int var1);

    public abstract Reference changeConnectionId(String var1);

    public synchronized int hashCode() {
        if (this._hashInitialized) {
            return this._hashValue;
        }
        int h = 5381;
        h = HashUtil.hashAdd(h, this._mode);
        h = HashUtil.hashAdd(h, this._secure);
        h = HashUtil.hashAdd(h, this._identity);
        h = HashUtil.hashAdd(h, this._context);
        h = HashUtil.hashAdd(h, this._facet);
        h = HashUtil.hashAdd(h, this._overrideCompress);
        if (this._overrideCompress) {
            h = HashUtil.hashAdd(h, this._compress);
        }
        h = HashUtil.hashAdd(h, this._protocol);
        h = HashUtil.hashAdd(h, this._encoding);
        this._hashValue = h = HashUtil.hashAdd(h, this._invocationTimeout);
        this._hashInitialized = true;
        return this._hashValue;
    }

    public Boolean getCompressOverride() {
        DefaultsAndOverrides defaultsAndOverrides = this.getInstance().defaultsAndOverrides();
        if (defaultsAndOverrides.overrideCompress) {
            return defaultsAndOverrides.overrideCompressValue;
        }
        if (this._overrideCompress) {
            return this._compress;
        }
        return null;
    }

    public abstract boolean isIndirect();

    public abstract boolean isWellKnown();

    public void streamWrite(OutputStream s) {
        if (this._facet.length() == 0) {
            s.writeStringSeq(null);
        } else {
            String[] facetPath = new String[]{this._facet};
            s.writeStringSeq(facetPath);
        }
        s.writeByte((byte)this._mode);
        s.writeBool(this._secure);
        if (!s.getEncoding().equals(Util.Encoding_1_0)) {
            this._protocol.ice_writeMembers(s);
            this._encoding.ice_writeMembers(s);
        }
    }

    public String toString() {
        StringBuilder s = new StringBuilder(128);
        ToStringMode toStringMode = this._instance.toStringMode();
        String separators = " :@";
        String id = Util.identityToString(this._identity, toStringMode);
        if (StringUtil.findFirstOf(id, " :@") != -1) {
            s.append('\"');
            s.append(id);
            s.append('\"');
        } else {
            s.append(id);
        }
        if (this._facet.length() > 0) {
            s.append(" -f ");
            String fs = StringUtil.escapeString(this._facet, "", toStringMode);
            if (StringUtil.findFirstOf(fs, " :@") != -1) {
                s.append('\"');
                s.append(fs);
                s.append('\"');
            } else {
                s.append(fs);
            }
        }
        switch (this._mode) {
            case 0: {
                s.append(" -t");
                break;
            }
            case 1: {
                s.append(" -o");
                break;
            }
            case 2: {
                s.append(" -O");
                break;
            }
            case 3: {
                s.append(" -d");
                break;
            }
            case 4: {
                s.append(" -D");
            }
        }
        if (this._secure) {
            s.append(" -s");
        }
        if (!this._protocol.equals(Util.Protocol_1_0)) {
            s.append(" -p ");
            s.append(Util.protocolVersionToString(this._protocol));
        }
        s.append(" -e ");
        s.append(Util.encodingVersionToString(this._encoding));
        return s.toString();
    }

    public abstract Map<String, String> toProperty(String var1);

    public abstract RequestHandler getRequestHandler(ObjectPrxHelperBase var1);

    public abstract BatchRequestQueue getBatchRequestQueue();

    public boolean equals(Object obj) {
        Reference r = (Reference)obj;
        if (this._mode != r._mode) {
            return false;
        }
        if (this._secure != r._secure) {
            return false;
        }
        if (!this._identity.equals(r._identity)) {
            return false;
        }
        if (!this._context.equals(r._context)) {
            return false;
        }
        if (!this._facet.equals(r._facet)) {
            return false;
        }
        if (this._overrideCompress != r._overrideCompress) {
            return false;
        }
        if (this._overrideCompress && this._compress != r._compress) {
            return false;
        }
        if (!this._protocol.equals(r._protocol)) {
            return false;
        }
        if (!this._encoding.equals(r._encoding)) {
            return false;
        }
        return this._invocationTimeout == r._invocationTimeout;
    }

    public Reference clone() {
        Reference c;
        block2: {
            c = null;
            try {
                c = (Reference)super.clone();
            }
            catch (CloneNotSupportedException ex) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        return c;
    }

    protected Reference(Instance instance, Communicator communicator, Identity identity, String facet, int mode, boolean secure, ProtocolVersion protocol, EncodingVersion encoding, int invocationTimeout, Map<String, String> context) {
        assert (identity.name != null);
        assert (identity.category != null);
        assert (facet != null);
        this._instance = instance;
        this._communicator = communicator;
        this._mode = mode;
        this._secure = secure;
        this._identity = identity;
        this._context = context != null ? new HashMap<String, String>(context) : _emptyContext;
        this._facet = facet;
        this._protocol = protocol;
        this._encoding = encoding;
        this._invocationTimeout = invocationTimeout;
        this._hashInitialized = false;
        this._overrideCompress = false;
        this._compress = false;
    }

    public static interface GetConnectionCallback {
        public void setConnection(ConnectionI var1, boolean var2);

        public void setException(LocalException var1);
    }
}

