/*
 * Decompiled with CFR 0.152.
 */
package sun.reflect;

class UTF8 {
    UTF8() {
    }

    static byte[] encode(String str) {
        int len = str.length();
        byte[] res = new byte[UTF8.utf8Length(str)];
        int utf8Idx = 0;
        try {
            for (int i = 0; i < len; ++i) {
                int c = str.charAt(i) & 0xFFFF;
                if (c >= 1 && c <= 127) {
                    res[utf8Idx++] = (byte)c;
                    continue;
                }
                if (c == 0 || c >= 128 && c <= 2047) {
                    res[utf8Idx++] = (byte)(192 + (c >> 6));
                    res[utf8Idx++] = (byte)(128 + (c & 0x3F));
                    continue;
                }
                res[utf8Idx++] = (byte)(224 + (c >> 12));
                res[utf8Idx++] = (byte)(128 + (c >> 6 & 0x3F));
                res[utf8Idx++] = (byte)(128 + (c & 0x3F));
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new InternalError("Bug in sun.reflect bootstrap UTF-8 encoder");
        }
        return res;
    }

    private static int utf8Length(String str) {
        int len = str.length();
        int utf8Len = 0;
        for (int i = 0; i < len; ++i) {
            int c = str.charAt(i) & 0xFFFF;
            if (c >= 1 && c <= 127) {
                ++utf8Len;
                continue;
            }
            if (c == 0 || c >= 128 && c <= 2047) {
                utf8Len += 2;
                continue;
            }
            utf8Len += 3;
        }
        return utf8Len;
    }
}

