/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto.spec;

import java.security.spec.AlgorithmParameterSpec;

public class GCMParameterSpec
implements AlgorithmParameterSpec {
    private byte[] iv;
    private int tLen;

    public GCMParameterSpec(int n, byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("src array is null");
        }
        this.init(n, byArray, 0, byArray.length);
    }

    public GCMParameterSpec(int n, byte[] byArray, int n2, int n3) {
        this.init(n, byArray, n2, n3);
    }

    private void init(int n, byte[] byArray, int n2, int n3) {
        if (n < 0) {
            throw new IllegalArgumentException("Length argument is negative");
        }
        this.tLen = n;
        if (byArray == null || n3 < 0 || n2 < 0 || n3 + n2 > byArray.length) {
            throw new IllegalArgumentException("Invalid buffer arguments");
        }
        this.iv = new byte[n3];
        System.arraycopy(byArray, n2, this.iv, 0, n3);
    }

    public int getTLen() {
        return this.tLen;
    }

    public byte[] getIV() {
        return (byte[])this.iv.clone();
    }
}

