// **********************************************************************
//
// Copyright (c) 2003-2017 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.7.0
//
// <auto-generated>
//
// Generated from file `FileServer.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

#ifndef __IcePatch2_FileServer_h__
#define __IcePatch2_FileServer_h__

#include <IceUtil/PushDisableWarnings.h>
#include <Ice/ProxyF.h>
#include <Ice/ObjectF.h>
#include <Ice/ValueF.h>
#include <Ice/Exception.h>
#include <Ice/LocalObject.h>
#include <Ice/StreamHelpers.h>
#include <Ice/Comparable.h>
#include <Ice/Proxy.h>
#include <Ice/Object.h>
#include <Ice/GCObject.h>
#include <Ice/Value.h>
#include <Ice/Incoming.h>
#include <Ice/IncomingAsync.h>
#include <Ice/FactoryTableInit.h>
#include <IceUtil/ScopedArray.h>
#include <Ice/Optional.h>
#include <Ice/ExceptionHelpers.h>
#include <IcePatch2/FileInfo.h>
#include <IceUtil/UndefSysMacros.h>
#include <IcePatch2/Config.h>

#ifndef ICE_IGNORE_VERSION
#   if ICE_INT_VERSION / 100 != 307
#       error Ice version mismatch!
#   endif
#   if ICE_INT_VERSION % 100 > 50
#       error Beta header file detected
#   endif
#   if ICE_INT_VERSION % 100 < 0
#       error Ice patch level mismatch!
#   endif
#endif

#ifndef ICEPATCH2_API
#   if defined(ICE_STATIC_LIBS)
#       define ICEPATCH2_API /**/
#   elif defined(ICEPATCH2_API_EXPORTS)
#       define ICEPATCH2_API ICE_DECLSPEC_EXPORT
#   else
#       define ICEPATCH2_API ICE_DECLSPEC_IMPORT
#   endif
#endif

#ifdef ICE_CPP11_MAPPING // C++11 mapping

namespace IcePatch2
{

class FileServer;
class FileServerPrx;

}

namespace IcePatch2
{

using ByteSeqSeq = ::std::vector<::Ice::ByteSeq>;

class ICE_CLASS(ICEPATCH2_API) PartitionOutOfRangeException : public ::Ice::UserExceptionHelper<PartitionOutOfRangeException, ::Ice::UserException>
{
public:

    ICE_MEMBER(ICEPATCH2_API) virtual ~PartitionOutOfRangeException();

    PartitionOutOfRangeException(const PartitionOutOfRangeException&) = default;

    PartitionOutOfRangeException() = default;

    std::tuple<> ice_tuple() const
    {
        return std::tie();
    }

    ICE_MEMBER(ICEPATCH2_API) static const ::std::string& ice_staticId();
};

static PartitionOutOfRangeException _iceS_PartitionOutOfRangeException_init;

class ICE_CLASS(ICEPATCH2_API) FileAccessException : public ::Ice::UserExceptionHelper<FileAccessException, ::Ice::UserException>
{
public:

    ICE_MEMBER(ICEPATCH2_API) virtual ~FileAccessException();

    FileAccessException(const FileAccessException&) = default;

    FileAccessException() = default;

    FileAccessException(const ::std::string& iceP_reason) :
        reason(::std::move(iceP_reason))
    {
    }

    std::tuple<const ::std::string&> ice_tuple() const
    {
        return std::tie(reason);
    }

    ICE_MEMBER(ICEPATCH2_API) static const ::std::string& ice_staticId();

    ::std::string reason;
};

class ICE_CLASS(ICEPATCH2_API) FileSizeRangeException : public ::Ice::UserExceptionHelper<FileSizeRangeException, ::IcePatch2::FileAccessException>
{
public:

    ICE_MEMBER(ICEPATCH2_API) virtual ~FileSizeRangeException();

    FileSizeRangeException(const FileSizeRangeException&) = default;

    FileSizeRangeException() = default;

    FileSizeRangeException(const ::std::string& iceP_reason) :
        ::Ice::UserExceptionHelper<FileSizeRangeException, ::IcePatch2::FileAccessException>(::std::move(iceP_reason))
    {
    }

    std::tuple<const ::std::string&> ice_tuple() const
    {
        return std::tie(reason);
    }

    ICE_MEMBER(ICEPATCH2_API) static const ::std::string& ice_staticId();
};

}

namespace IcePatch2
{

class ICEPATCH2_API FileServer : public virtual ::Ice::Object
{
public:

    using ProxyType = FileServerPrx;

    virtual bool ice_isA(::std::string, const ::Ice::Current&) const override;
    virtual ::std::vector<::std::string> ice_ids(const ::Ice::Current&) const override;
    virtual ::std::string ice_id(const ::Ice::Current&) const override;

    static const ::std::string& ice_staticId();

    ICE_DEPRECATED_API("getFileInfoSeq() is deprecated, use getLargeFileInfoSeq() instead.") virtual ::IcePatch2::FileInfoSeq getFileInfoSeq(int, const ::Ice::Current&) const = 0;
    bool _iceD_getFileInfoSeq(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual ::IcePatch2::LargeFileInfoSeq getLargeFileInfoSeq(int, const ::Ice::Current&) const = 0;
    bool _iceD_getLargeFileInfoSeq(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual ::IcePatch2::ByteSeqSeq getChecksumSeq(const ::Ice::Current&) const = 0;
    bool _iceD_getChecksumSeq(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual ::Ice::ByteSeq getChecksum(const ::Ice::Current&) const = 0;
    bool _iceD_getChecksum(::IceInternal::Incoming&, const ::Ice::Current&) const;

    ICE_DEPRECATED_API("getFileCompressed() is deprecated, use getLargeFileCompressed() instead.") virtual void getFileCompressedAsync(::std::string, int, int, ::std::function<void(const ::std::pair<const ::Ice::Byte*, const ::Ice::Byte*>&)>, ::std::function<void(::std::exception_ptr)>, const ::Ice::Current&) const = 0;
    bool _iceD_getFileCompressed(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual void getLargeFileCompressedAsync(::std::string, long long int, int, ::std::function<void(const ::std::pair<const ::Ice::Byte*, const ::Ice::Byte*>&)>, ::std::function<void(::std::exception_ptr)>, const ::Ice::Current&) const = 0;
    bool _iceD_getLargeFileCompressed(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&) override;
};

}

namespace IcePatch2
{

class ICE_CLASS(ICEPATCH2_API) FileServerPrx : public virtual ::Ice::Proxy<FileServerPrx, ::Ice::ObjectPrx>
{
public:

    ICE_DEPRECATED_API("getFileInfoSeq() is deprecated, use getLargeFileInfoSeq() instead.") ::IcePatch2::FileInfoSeq getFileInfoSeq(int iceP_partition, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::IcePatch2::FileInfoSeq>(true, this, &IcePatch2::FileServerPrx::_iceI_getFileInfoSeq, iceP_partition, context).get();
    }

    template<template<typename> class P = ::std::promise>
    ICE_DEPRECATED_API("getFileInfoSeq() is deprecated, use getLargeFileInfoSeq() instead.") auto getFileInfoSeqAsync(int iceP_partition, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<::IcePatch2::FileInfoSeq>>().get_future())
    {
        return _makePromiseOutgoing<::IcePatch2::FileInfoSeq, P>(false, this, &IcePatch2::FileServerPrx::_iceI_getFileInfoSeq, iceP_partition, context);
    }

    ::std::function<void()>
    getFileInfoSeqAsync(int iceP_partition,
                        ::std::function<void(::IcePatch2::FileInfoSeq)> response,
                        ::std::function<void(::std::exception_ptr)> ex = nullptr,
                        ::std::function<void(bool)> sent = nullptr,
                        const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::IcePatch2::FileInfoSeq>(response, ex, sent, this, &IcePatch2::FileServerPrx::_iceI_getFileInfoSeq, iceP_partition, context);
    }

    ICE_MEMBER(ICEPATCH2_API) void _iceI_getFileInfoSeq(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::IcePatch2::FileInfoSeq>>&, int, const ::Ice::Context&);

    ::IcePatch2::LargeFileInfoSeq getLargeFileInfoSeq(int iceP_partition, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::IcePatch2::LargeFileInfoSeq>(true, this, &IcePatch2::FileServerPrx::_iceI_getLargeFileInfoSeq, iceP_partition, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto getLargeFileInfoSeqAsync(int iceP_partition, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<::IcePatch2::LargeFileInfoSeq>>().get_future())
    {
        return _makePromiseOutgoing<::IcePatch2::LargeFileInfoSeq, P>(false, this, &IcePatch2::FileServerPrx::_iceI_getLargeFileInfoSeq, iceP_partition, context);
    }

    ::std::function<void()>
    getLargeFileInfoSeqAsync(int iceP_partition,
                             ::std::function<void(::IcePatch2::LargeFileInfoSeq)> response,
                             ::std::function<void(::std::exception_ptr)> ex = nullptr,
                             ::std::function<void(bool)> sent = nullptr,
                             const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::IcePatch2::LargeFileInfoSeq>(response, ex, sent, this, &IcePatch2::FileServerPrx::_iceI_getLargeFileInfoSeq, iceP_partition, context);
    }

    ICE_MEMBER(ICEPATCH2_API) void _iceI_getLargeFileInfoSeq(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::IcePatch2::LargeFileInfoSeq>>&, int, const ::Ice::Context&);

    ::IcePatch2::ByteSeqSeq getChecksumSeq(const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::IcePatch2::ByteSeqSeq>(true, this, &IcePatch2::FileServerPrx::_iceI_getChecksumSeq, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto getChecksumSeqAsync(const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<::IcePatch2::ByteSeqSeq>>().get_future())
    {
        return _makePromiseOutgoing<::IcePatch2::ByteSeqSeq, P>(false, this, &IcePatch2::FileServerPrx::_iceI_getChecksumSeq, context);
    }

    ::std::function<void()>
    getChecksumSeqAsync(::std::function<void(::IcePatch2::ByteSeqSeq)> response,
                        ::std::function<void(::std::exception_ptr)> ex = nullptr,
                        ::std::function<void(bool)> sent = nullptr,
                        const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::IcePatch2::ByteSeqSeq>(response, ex, sent, this, &IcePatch2::FileServerPrx::_iceI_getChecksumSeq, context);
    }

    ICE_MEMBER(ICEPATCH2_API) void _iceI_getChecksumSeq(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::IcePatch2::ByteSeqSeq>>&, const ::Ice::Context&);

    ::Ice::ByteSeq getChecksum(const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::Ice::ByteSeq>(true, this, &IcePatch2::FileServerPrx::_iceI_getChecksum, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto getChecksumAsync(const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<::Ice::ByteSeq>>().get_future())
    {
        return _makePromiseOutgoing<::Ice::ByteSeq, P>(false, this, &IcePatch2::FileServerPrx::_iceI_getChecksum, context);
    }

    ::std::function<void()>
    getChecksumAsync(::std::function<void(::Ice::ByteSeq)> response,
                     ::std::function<void(::std::exception_ptr)> ex = nullptr,
                     ::std::function<void(bool)> sent = nullptr,
                     const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::Ice::ByteSeq>(response, ex, sent, this, &IcePatch2::FileServerPrx::_iceI_getChecksum, context);
    }

    ICE_MEMBER(ICEPATCH2_API) void _iceI_getChecksum(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::Ice::ByteSeq>>&, const ::Ice::Context&);

    ICE_DEPRECATED_API("getFileCompressed() is deprecated, use getLargeFileCompressed() instead.") ::Ice::ByteSeq getFileCompressed(const ::std::string& iceP_path, int iceP_pos, int iceP_num, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::Ice::ByteSeq>(true, this, &IcePatch2::FileServerPrx::_iceI_getFileCompressed, iceP_path, iceP_pos, iceP_num, context).get();
    }

    template<template<typename> class P = ::std::promise>
    ICE_DEPRECATED_API("getFileCompressed() is deprecated, use getLargeFileCompressed() instead.") auto getFileCompressedAsync(const ::std::string& iceP_path, int iceP_pos, int iceP_num, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<::Ice::ByteSeq>>().get_future())
    {
        return _makePromiseOutgoing<::Ice::ByteSeq, P>(false, this, &IcePatch2::FileServerPrx::_iceI_getFileCompressed, iceP_path, iceP_pos, iceP_num, context);
    }

    ICE_MEMBER(ICEPATCH2_API) ::std::function<void()>
    getFileCompressedAsync(const ::std::string&, int, int,
                           ::std::function<void(::std::pair<const ::Ice::Byte*, const ::Ice::Byte*>)>,
                           ::std::function<void(::std::exception_ptr)> = nullptr,
                           ::std::function<void(bool)> = nullptr,
                           const ::Ice::Context& = Ice::noExplicitContext);

    ICE_MEMBER(ICEPATCH2_API) void _iceI_getFileCompressed(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::Ice::ByteSeq>>&, const ::std::string&, int, int, const ::Ice::Context&);

    ::Ice::ByteSeq getLargeFileCompressed(const ::std::string& iceP_path, long long int iceP_pos, int iceP_num, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::Ice::ByteSeq>(true, this, &IcePatch2::FileServerPrx::_iceI_getLargeFileCompressed, iceP_path, iceP_pos, iceP_num, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto getLargeFileCompressedAsync(const ::std::string& iceP_path, long long int iceP_pos, int iceP_num, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<::Ice::ByteSeq>>().get_future())
    {
        return _makePromiseOutgoing<::Ice::ByteSeq, P>(false, this, &IcePatch2::FileServerPrx::_iceI_getLargeFileCompressed, iceP_path, iceP_pos, iceP_num, context);
    }

    ICE_MEMBER(ICEPATCH2_API) ::std::function<void()>
    getLargeFileCompressedAsync(const ::std::string&, long long int, int,
                                ::std::function<void(::std::pair<const ::Ice::Byte*, const ::Ice::Byte*>)>,
                                ::std::function<void(::std::exception_ptr)> = nullptr,
                                ::std::function<void(bool)> = nullptr,
                                const ::Ice::Context& = Ice::noExplicitContext);

    ICE_MEMBER(ICEPATCH2_API) void _iceI_getLargeFileCompressed(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::Ice::ByteSeq>>&, const ::std::string&, long long int, int, const ::Ice::Context&);

    ICE_MEMBER(ICEPATCH2_API) static const ::std::string& ice_staticId();

protected:

    FileServerPrx() = default;
    friend ::std::shared_ptr<FileServerPrx> IceInternal::createProxy<FileServerPrx>();

    ICE_MEMBER(ICEPATCH2_API) virtual ::std::shared_ptr<::Ice::ObjectPrx> _newInstance() const override;
};

}

namespace Ice
{

template<typename S>
struct StreamReader<::IcePatch2::FileAccessException, S>
{
    static void read(S* istr, ::IcePatch2::FileAccessException& v)
    {
        istr->readAll(v.reason);
    }
};

template<typename S>
struct StreamWriter<::IcePatch2::FileSizeRangeException, S>
{
    static void write(S*, const ::IcePatch2::FileSizeRangeException&)
    {
    }
};

template<typename S>
struct StreamReader<::IcePatch2::FileSizeRangeException, S>
{
    static void read(S*, ::IcePatch2::FileSizeRangeException&)
    {
    }
};

}

namespace IcePatch2
{

using FileServerPtr = ::std::shared_ptr<FileServer>;
using FileServerPrxPtr = ::std::shared_ptr<FileServerPrx>;

}

#else // C++98 mapping

namespace IceProxy
{

namespace IcePatch2
{

class FileServer;
ICEPATCH2_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< ::IceProxy::IcePatch2::FileServer>&);
ICEPATCH2_API ::IceProxy::Ice::Object* upCast(::IceProxy::IcePatch2::FileServer*);

}

}

namespace IcePatch2
{

class FileServer;
ICEPATCH2_API ::Ice::Object* upCast(::IcePatch2::FileServer*);
typedef ::IceInternal::Handle< ::IcePatch2::FileServer> FileServerPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IcePatch2::FileServer> FileServerPrx;
typedef FileServerPrx FileServerPrxPtr;
ICEPATCH2_API void _icePatchObjectPtr(FileServerPtr&, const ::Ice::ObjectPtr&);

}

namespace IcePatch2
{

typedef ::std::vector< ::Ice::ByteSeq> ByteSeqSeq;

class ICEPATCH2_API PartitionOutOfRangeException : public ::Ice::UserException
{
public:

    PartitionOutOfRangeException() {}
    virtual ~PartitionOutOfRangeException() throw();

    virtual ::std::string ice_id() const;
    virtual PartitionOutOfRangeException* ice_clone() const;
    virtual void ice_throw() const;

protected:

    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
};

static PartitionOutOfRangeException _iceS_PartitionOutOfRangeException_init;

class ICEPATCH2_API FileAccessException : public ::Ice::UserException
{
public:

    FileAccessException() {}
    explicit FileAccessException(const ::std::string&);
    virtual ~FileAccessException() throw();

    virtual ::std::string ice_id() const;
    virtual FileAccessException* ice_clone() const;
    virtual void ice_throw() const;

    ::std::string reason;

protected:

    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
};

class ICEPATCH2_API FileSizeRangeException : public ::IcePatch2::FileAccessException
{
public:

    FileSizeRangeException() {}
    explicit FileSizeRangeException(const ::std::string&);
    virtual ~FileSizeRangeException() throw();

    virtual ::std::string ice_id() const;
    virtual FileSizeRangeException* ice_clone() const;
    virtual void ice_throw() const;

protected:

    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
};

}

namespace IcePatch2
{

class ICEPATCH2_API AMD_FileServer_getFileCompressed : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_FileServer_getFileCompressed();

    virtual void ice_response(const ::std::pair<const ::Ice::Byte*, const ::Ice::Byte*>&) = 0;
};

typedef ::IceUtil::Handle< ::IcePatch2::AMD_FileServer_getFileCompressed> AMD_FileServer_getFileCompressedPtr;

class ICEPATCH2_API AMD_FileServer_getLargeFileCompressed : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_FileServer_getLargeFileCompressed();

    virtual void ice_response(const ::std::pair<const ::Ice::Byte*, const ::Ice::Byte*>&) = 0;
};

typedef ::IceUtil::Handle< ::IcePatch2::AMD_FileServer_getLargeFileCompressed> AMD_FileServer_getLargeFileCompressedPtr;

}

namespace IceAsync
{

namespace IcePatch2
{

class ICEPATCH2_API AMD_FileServer_getFileCompressed : public ::IcePatch2::AMD_FileServer_getFileCompressed, public ::IceInternal::IncomingAsync
{
public:

    AMD_FileServer_getFileCompressed(::IceInternal::Incoming&);

    virtual void ice_response(const ::std::pair<const ::Ice::Byte*, const ::Ice::Byte*>&);
};

class ICEPATCH2_API AMD_FileServer_getLargeFileCompressed : public ::IcePatch2::AMD_FileServer_getLargeFileCompressed, public ::IceInternal::IncomingAsync
{
public:

    AMD_FileServer_getLargeFileCompressed(::IceInternal::Incoming&);

    virtual void ice_response(const ::std::pair<const ::Ice::Byte*, const ::Ice::Byte*>&);
};

}

}

namespace IcePatch2
{

class Callback_FileServer_getFileInfoSeq_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_FileServer_getFileInfoSeq_Base> Callback_FileServer_getFileInfoSeqPtr;

class Callback_FileServer_getLargeFileInfoSeq_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_FileServer_getLargeFileInfoSeq_Base> Callback_FileServer_getLargeFileInfoSeqPtr;

class Callback_FileServer_getChecksumSeq_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_FileServer_getChecksumSeq_Base> Callback_FileServer_getChecksumSeqPtr;

class Callback_FileServer_getChecksum_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_FileServer_getChecksum_Base> Callback_FileServer_getChecksumPtr;

class Callback_FileServer_getFileCompressed_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_FileServer_getFileCompressed_Base> Callback_FileServer_getFileCompressedPtr;

class Callback_FileServer_getLargeFileCompressed_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_FileServer_getLargeFileCompressed_Base> Callback_FileServer_getLargeFileCompressedPtr;

}

namespace IceProxy
{

namespace IcePatch2
{

class ICE_CLASS(ICEPATCH2_API) FileServer : public virtual ::Ice::Proxy<FileServer, ::IceProxy::Ice::Object>
{
public:

    ICE_DEPRECATED_API("getFileInfoSeq() is deprecated, use getLargeFileInfoSeq() instead.") ICE_MEMBER(ICEPATCH2_API) ::IcePatch2::FileInfoSeq getFileInfoSeq(::Ice::Int iceP_partition, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getFileInfoSeq(_iceI_begin_getFileInfoSeq(iceP_partition, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_getFileInfoSeq(::Ice::Int iceP_partition, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getFileInfoSeq(iceP_partition, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_getFileInfoSeq(::Ice::Int iceP_partition, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getFileInfoSeq(iceP_partition, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getFileInfoSeq(::Ice::Int iceP_partition, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getFileInfoSeq(iceP_partition, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getFileInfoSeq(::Ice::Int iceP_partition, const ::IcePatch2::Callback_FileServer_getFileInfoSeqPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getFileInfoSeq(iceP_partition, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getFileInfoSeq(::Ice::Int iceP_partition, const ::Ice::Context& context, const ::IcePatch2::Callback_FileServer_getFileInfoSeqPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getFileInfoSeq(iceP_partition, context, del, cookie);
    }

    ICE_MEMBER(ICEPATCH2_API) ::IcePatch2::FileInfoSeq end_getFileInfoSeq(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEPATCH2_API) ::Ice::AsyncResultPtr _iceI_begin_getFileInfoSeq(::Ice::Int, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEPATCH2_API) ::IcePatch2::LargeFileInfoSeq getLargeFileInfoSeq(::Ice::Int iceP_partition, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getLargeFileInfoSeq(_iceI_begin_getLargeFileInfoSeq(iceP_partition, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_getLargeFileInfoSeq(::Ice::Int iceP_partition, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getLargeFileInfoSeq(iceP_partition, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_getLargeFileInfoSeq(::Ice::Int iceP_partition, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getLargeFileInfoSeq(iceP_partition, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getLargeFileInfoSeq(::Ice::Int iceP_partition, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getLargeFileInfoSeq(iceP_partition, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getLargeFileInfoSeq(::Ice::Int iceP_partition, const ::IcePatch2::Callback_FileServer_getLargeFileInfoSeqPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getLargeFileInfoSeq(iceP_partition, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getLargeFileInfoSeq(::Ice::Int iceP_partition, const ::Ice::Context& context, const ::IcePatch2::Callback_FileServer_getLargeFileInfoSeqPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getLargeFileInfoSeq(iceP_partition, context, del, cookie);
    }

    ICE_MEMBER(ICEPATCH2_API) ::IcePatch2::LargeFileInfoSeq end_getLargeFileInfoSeq(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEPATCH2_API) ::Ice::AsyncResultPtr _iceI_begin_getLargeFileInfoSeq(::Ice::Int, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEPATCH2_API) ::IcePatch2::ByteSeqSeq getChecksumSeq(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getChecksumSeq(_iceI_begin_getChecksumSeq(context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_getChecksumSeq(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getChecksumSeq(context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_getChecksumSeq(const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getChecksumSeq(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getChecksumSeq(const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getChecksumSeq(context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getChecksumSeq(const ::IcePatch2::Callback_FileServer_getChecksumSeqPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getChecksumSeq(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getChecksumSeq(const ::Ice::Context& context, const ::IcePatch2::Callback_FileServer_getChecksumSeqPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getChecksumSeq(context, del, cookie);
    }

    ICE_MEMBER(ICEPATCH2_API) ::IcePatch2::ByteSeqSeq end_getChecksumSeq(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEPATCH2_API) ::Ice::AsyncResultPtr _iceI_begin_getChecksumSeq(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEPATCH2_API) ::Ice::ByteSeq getChecksum(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getChecksum(_iceI_begin_getChecksum(context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_getChecksum(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getChecksum(context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_getChecksum(const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getChecksum(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getChecksum(const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getChecksum(context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getChecksum(const ::IcePatch2::Callback_FileServer_getChecksumPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getChecksum(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getChecksum(const ::Ice::Context& context, const ::IcePatch2::Callback_FileServer_getChecksumPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getChecksum(context, del, cookie);
    }

    ICE_MEMBER(ICEPATCH2_API) ::Ice::ByteSeq end_getChecksum(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEPATCH2_API) ::Ice::AsyncResultPtr _iceI_begin_getChecksum(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_DEPRECATED_API("getFileCompressed() is deprecated, use getLargeFileCompressed() instead.") ICE_MEMBER(ICEPATCH2_API) ::Ice::ByteSeq getFileCompressed(const ::std::string& iceP_path, ::Ice::Int iceP_pos, ::Ice::Int iceP_num, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getFileCompressed(_iceI_begin_getFileCompressed(iceP_path, iceP_pos, iceP_num, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_getFileCompressed(const ::std::string& iceP_path, ::Ice::Int iceP_pos, ::Ice::Int iceP_num, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getFileCompressed(iceP_path, iceP_pos, iceP_num, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_getFileCompressed(const ::std::string& iceP_path, ::Ice::Int iceP_pos, ::Ice::Int iceP_num, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getFileCompressed(iceP_path, iceP_pos, iceP_num, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getFileCompressed(const ::std::string& iceP_path, ::Ice::Int iceP_pos, ::Ice::Int iceP_num, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getFileCompressed(iceP_path, iceP_pos, iceP_num, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getFileCompressed(const ::std::string& iceP_path, ::Ice::Int iceP_pos, ::Ice::Int iceP_num, const ::IcePatch2::Callback_FileServer_getFileCompressedPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getFileCompressed(iceP_path, iceP_pos, iceP_num, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getFileCompressed(const ::std::string& iceP_path, ::Ice::Int iceP_pos, ::Ice::Int iceP_num, const ::Ice::Context& context, const ::IcePatch2::Callback_FileServer_getFileCompressedPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getFileCompressed(iceP_path, iceP_pos, iceP_num, context, del, cookie);
    }

    ICE_MEMBER(ICEPATCH2_API) ::Ice::ByteSeq end_getFileCompressed(const ::Ice::AsyncResultPtr&);

    ICE_MEMBER(ICEPATCH2_API) void _iceI_end_getFileCompressed(::std::pair<const ::Ice::Byte*, const ::Ice::Byte*>& ret, const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEPATCH2_API) ::Ice::AsyncResultPtr _iceI_begin_getFileCompressed(const ::std::string&, ::Ice::Int, ::Ice::Int, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEPATCH2_API) ::Ice::ByteSeq getLargeFileCompressed(const ::std::string& iceP_path, ::Ice::Long iceP_pos, ::Ice::Int iceP_num, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getLargeFileCompressed(_iceI_begin_getLargeFileCompressed(iceP_path, iceP_pos, iceP_num, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_getLargeFileCompressed(const ::std::string& iceP_path, ::Ice::Long iceP_pos, ::Ice::Int iceP_num, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getLargeFileCompressed(iceP_path, iceP_pos, iceP_num, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_getLargeFileCompressed(const ::std::string& iceP_path, ::Ice::Long iceP_pos, ::Ice::Int iceP_num, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getLargeFileCompressed(iceP_path, iceP_pos, iceP_num, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getLargeFileCompressed(const ::std::string& iceP_path, ::Ice::Long iceP_pos, ::Ice::Int iceP_num, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getLargeFileCompressed(iceP_path, iceP_pos, iceP_num, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getLargeFileCompressed(const ::std::string& iceP_path, ::Ice::Long iceP_pos, ::Ice::Int iceP_num, const ::IcePatch2::Callback_FileServer_getLargeFileCompressedPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getLargeFileCompressed(iceP_path, iceP_pos, iceP_num, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getLargeFileCompressed(const ::std::string& iceP_path, ::Ice::Long iceP_pos, ::Ice::Int iceP_num, const ::Ice::Context& context, const ::IcePatch2::Callback_FileServer_getLargeFileCompressedPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getLargeFileCompressed(iceP_path, iceP_pos, iceP_num, context, del, cookie);
    }

    ICE_MEMBER(ICEPATCH2_API) ::Ice::ByteSeq end_getLargeFileCompressed(const ::Ice::AsyncResultPtr&);

    ICE_MEMBER(ICEPATCH2_API) void _iceI_end_getLargeFileCompressed(::std::pair<const ::Ice::Byte*, const ::Ice::Byte*>& ret, const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEPATCH2_API) ::Ice::AsyncResultPtr _iceI_begin_getLargeFileCompressed(const ::std::string&, ::Ice::Long, ::Ice::Int, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEPATCH2_API) static const ::std::string& ice_staticId();

protected:

    ICE_MEMBER(ICEPATCH2_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
};

}

}

namespace IcePatch2
{

class ICEPATCH2_API FileServer : public virtual ::Ice::Object
{
public:

    typedef FileServerPrx ProxyType;
    typedef FileServerPtr PointerType;

    virtual ~FileServer();

    virtual bool ice_isA(const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual const ::std::string& ice_id(const ::Ice::Current& = ::Ice::emptyCurrent) const;

    static const ::std::string& ice_staticId();

    ICE_DEPRECATED_API("getFileInfoSeq() is deprecated, use getLargeFileInfoSeq() instead.") virtual ::IcePatch2::FileInfoSeq getFileInfoSeq(::Ice::Int, const ::Ice::Current& = ::Ice::emptyCurrent) const = 0;
    bool _iceD_getFileInfoSeq(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual ::IcePatch2::LargeFileInfoSeq getLargeFileInfoSeq(::Ice::Int, const ::Ice::Current& = ::Ice::emptyCurrent) const = 0;
    bool _iceD_getLargeFileInfoSeq(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual ::IcePatch2::ByteSeqSeq getChecksumSeq(const ::Ice::Current& = ::Ice::emptyCurrent) const = 0;
    bool _iceD_getChecksumSeq(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual ::Ice::ByteSeq getChecksum(const ::Ice::Current& = ::Ice::emptyCurrent) const = 0;
    bool _iceD_getChecksum(::IceInternal::Incoming&, const ::Ice::Current&) const;

    ICE_DEPRECATED_API("getFileCompressed() is deprecated, use getLargeFileCompressed() instead.") virtual void getFileCompressed_async(const ::IcePatch2::AMD_FileServer_getFileCompressedPtr&, const ::std::string&, ::Ice::Int, ::Ice::Int, const ::Ice::Current& = ::Ice::emptyCurrent) const = 0;
    bool _iceD_getFileCompressed(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual void getLargeFileCompressed_async(const ::IcePatch2::AMD_FileServer_getLargeFileCompressedPtr&, const ::std::string&, ::Ice::Long, ::Ice::Int, const ::Ice::Current& = ::Ice::emptyCurrent) const = 0;
    bool _iceD_getLargeFileCompressed(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&);

protected:

    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
};

inline bool operator==(const FileServer& lhs, const FileServer& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const FileServer& lhs, const FileServer& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}

}

namespace Ice
{

template<>
struct StreamableTraits< ::IcePatch2::PartitionOutOfRangeException>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<>
struct StreamableTraits< ::IcePatch2::FileAccessException>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<typename S>
struct StreamWriter< ::IcePatch2::FileAccessException, S>
{
    static void write(S* ostr, const ::IcePatch2::FileAccessException& v)
    {
        ostr->write(v.reason);
    }
};

template<typename S>
struct StreamReader< ::IcePatch2::FileAccessException, S>
{
    static void read(S* istr, ::IcePatch2::FileAccessException& v)
    {
        istr->read(v.reason);
    }
};

template<>
struct StreamableTraits< ::IcePatch2::FileSizeRangeException>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

}

namespace IcePatch2
{

template<class T>
class CallbackNC_FileServer_getFileInfoSeq : public Callback_FileServer_getFileInfoSeq_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::IcePatch2::FileInfoSeq&);

    CallbackNC_FileServer_getFileInfoSeq(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IcePatch2::FileServerPrx proxy = ::IcePatch2::FileServerPrx::uncheckedCast(result->getProxy());
        ::IcePatch2::FileInfoSeq ret;
        try
        {
            ret = proxy->end_getFileInfoSeq(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }

private:

    Response _response;
};

template<class T> Callback_FileServer_getFileInfoSeqPtr
newCallback_FileServer_getFileInfoSeq(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::IcePatch2::FileInfoSeq&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_FileServer_getFileInfoSeq<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_FileServer_getFileInfoSeqPtr
newCallback_FileServer_getFileInfoSeq(T* instance, void (T::*cb)(const ::IcePatch2::FileInfoSeq&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_FileServer_getFileInfoSeq<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_FileServer_getFileInfoSeq : public Callback_FileServer_getFileInfoSeq_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::IcePatch2::FileInfoSeq&, const CT&);

    Callback_FileServer_getFileInfoSeq(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IcePatch2::FileServerPrx proxy = ::IcePatch2::FileServerPrx::uncheckedCast(result->getProxy());
        ::IcePatch2::FileInfoSeq ret;
        try
        {
            ret = proxy->end_getFileInfoSeq(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_FileServer_getFileInfoSeqPtr
newCallback_FileServer_getFileInfoSeq(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::IcePatch2::FileInfoSeq&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_FileServer_getFileInfoSeq<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_FileServer_getFileInfoSeqPtr
newCallback_FileServer_getFileInfoSeq(T* instance, void (T::*cb)(const ::IcePatch2::FileInfoSeq&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_FileServer_getFileInfoSeq<T, CT>(instance, cb, excb, sentcb);
}

template<class T>
class CallbackNC_FileServer_getLargeFileInfoSeq : public Callback_FileServer_getLargeFileInfoSeq_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::IcePatch2::LargeFileInfoSeq&);

    CallbackNC_FileServer_getLargeFileInfoSeq(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IcePatch2::FileServerPrx proxy = ::IcePatch2::FileServerPrx::uncheckedCast(result->getProxy());
        ::IcePatch2::LargeFileInfoSeq ret;
        try
        {
            ret = proxy->end_getLargeFileInfoSeq(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }

private:

    Response _response;
};

template<class T> Callback_FileServer_getLargeFileInfoSeqPtr
newCallback_FileServer_getLargeFileInfoSeq(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::IcePatch2::LargeFileInfoSeq&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_FileServer_getLargeFileInfoSeq<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_FileServer_getLargeFileInfoSeqPtr
newCallback_FileServer_getLargeFileInfoSeq(T* instance, void (T::*cb)(const ::IcePatch2::LargeFileInfoSeq&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_FileServer_getLargeFileInfoSeq<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_FileServer_getLargeFileInfoSeq : public Callback_FileServer_getLargeFileInfoSeq_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::IcePatch2::LargeFileInfoSeq&, const CT&);

    Callback_FileServer_getLargeFileInfoSeq(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IcePatch2::FileServerPrx proxy = ::IcePatch2::FileServerPrx::uncheckedCast(result->getProxy());
        ::IcePatch2::LargeFileInfoSeq ret;
        try
        {
            ret = proxy->end_getLargeFileInfoSeq(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_FileServer_getLargeFileInfoSeqPtr
newCallback_FileServer_getLargeFileInfoSeq(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::IcePatch2::LargeFileInfoSeq&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_FileServer_getLargeFileInfoSeq<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_FileServer_getLargeFileInfoSeqPtr
newCallback_FileServer_getLargeFileInfoSeq(T* instance, void (T::*cb)(const ::IcePatch2::LargeFileInfoSeq&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_FileServer_getLargeFileInfoSeq<T, CT>(instance, cb, excb, sentcb);
}

template<class T>
class CallbackNC_FileServer_getChecksumSeq : public Callback_FileServer_getChecksumSeq_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::IcePatch2::ByteSeqSeq&);

    CallbackNC_FileServer_getChecksumSeq(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IcePatch2::FileServerPrx proxy = ::IcePatch2::FileServerPrx::uncheckedCast(result->getProxy());
        ::IcePatch2::ByteSeqSeq ret;
        try
        {
            ret = proxy->end_getChecksumSeq(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }

private:

    Response _response;
};

template<class T> Callback_FileServer_getChecksumSeqPtr
newCallback_FileServer_getChecksumSeq(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::IcePatch2::ByteSeqSeq&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_FileServer_getChecksumSeq<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_FileServer_getChecksumSeqPtr
newCallback_FileServer_getChecksumSeq(T* instance, void (T::*cb)(const ::IcePatch2::ByteSeqSeq&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_FileServer_getChecksumSeq<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_FileServer_getChecksumSeq : public Callback_FileServer_getChecksumSeq_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::IcePatch2::ByteSeqSeq&, const CT&);

    Callback_FileServer_getChecksumSeq(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IcePatch2::FileServerPrx proxy = ::IcePatch2::FileServerPrx::uncheckedCast(result->getProxy());
        ::IcePatch2::ByteSeqSeq ret;
        try
        {
            ret = proxy->end_getChecksumSeq(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_FileServer_getChecksumSeqPtr
newCallback_FileServer_getChecksumSeq(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::IcePatch2::ByteSeqSeq&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_FileServer_getChecksumSeq<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_FileServer_getChecksumSeqPtr
newCallback_FileServer_getChecksumSeq(T* instance, void (T::*cb)(const ::IcePatch2::ByteSeqSeq&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_FileServer_getChecksumSeq<T, CT>(instance, cb, excb, sentcb);
}

template<class T>
class CallbackNC_FileServer_getChecksum : public Callback_FileServer_getChecksum_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::Ice::ByteSeq&);

    CallbackNC_FileServer_getChecksum(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IcePatch2::FileServerPrx proxy = ::IcePatch2::FileServerPrx::uncheckedCast(result->getProxy());
        ::Ice::ByteSeq ret;
        try
        {
            ret = proxy->end_getChecksum(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }

private:

    Response _response;
};

template<class T> Callback_FileServer_getChecksumPtr
newCallback_FileServer_getChecksum(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::ByteSeq&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_FileServer_getChecksum<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_FileServer_getChecksumPtr
newCallback_FileServer_getChecksum(T* instance, void (T::*cb)(const ::Ice::ByteSeq&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_FileServer_getChecksum<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_FileServer_getChecksum : public Callback_FileServer_getChecksum_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::Ice::ByteSeq&, const CT&);

    Callback_FileServer_getChecksum(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IcePatch2::FileServerPrx proxy = ::IcePatch2::FileServerPrx::uncheckedCast(result->getProxy());
        ::Ice::ByteSeq ret;
        try
        {
            ret = proxy->end_getChecksum(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_FileServer_getChecksumPtr
newCallback_FileServer_getChecksum(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::ByteSeq&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_FileServer_getChecksum<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_FileServer_getChecksumPtr
newCallback_FileServer_getChecksum(T* instance, void (T::*cb)(const ::Ice::ByteSeq&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_FileServer_getChecksum<T, CT>(instance, cb, excb, sentcb);
}

template<class T>
class CallbackNC_FileServer_getFileCompressed : public Callback_FileServer_getFileCompressed_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::std::pair<const ::Ice::Byte*, const ::Ice::Byte*>&);

    CallbackNC_FileServer_getFileCompressed(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IcePatch2::FileServerPrx proxy = ::IcePatch2::FileServerPrx::uncheckedCast(result->getProxy());
        ::std::pair<const ::Ice::Byte*, const ::Ice::Byte*> ret;
        try
        {
            proxy->_iceI_end_getFileCompressed(ret, result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }

private:

    Response _response;
};

template<class T> Callback_FileServer_getFileCompressedPtr
newCallback_FileServer_getFileCompressed(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::std::pair<const ::Ice::Byte*, const ::Ice::Byte*>&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_FileServer_getFileCompressed<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_FileServer_getFileCompressedPtr
newCallback_FileServer_getFileCompressed(T* instance, void (T::*cb)(const ::std::pair<const ::Ice::Byte*, const ::Ice::Byte*>&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_FileServer_getFileCompressed<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_FileServer_getFileCompressed : public Callback_FileServer_getFileCompressed_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::std::pair<const ::Ice::Byte*, const ::Ice::Byte*>&, const CT&);

    Callback_FileServer_getFileCompressed(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IcePatch2::FileServerPrx proxy = ::IcePatch2::FileServerPrx::uncheckedCast(result->getProxy());
        ::std::pair<const ::Ice::Byte*, const ::Ice::Byte*> ret;
        try
        {
            proxy->_iceI_end_getFileCompressed(ret, result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_FileServer_getFileCompressedPtr
newCallback_FileServer_getFileCompressed(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::std::pair<const ::Ice::Byte*, const ::Ice::Byte*>&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_FileServer_getFileCompressed<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_FileServer_getFileCompressedPtr
newCallback_FileServer_getFileCompressed(T* instance, void (T::*cb)(const ::std::pair<const ::Ice::Byte*, const ::Ice::Byte*>&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_FileServer_getFileCompressed<T, CT>(instance, cb, excb, sentcb);
}

template<class T>
class CallbackNC_FileServer_getLargeFileCompressed : public Callback_FileServer_getLargeFileCompressed_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::std::pair<const ::Ice::Byte*, const ::Ice::Byte*>&);

    CallbackNC_FileServer_getLargeFileCompressed(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IcePatch2::FileServerPrx proxy = ::IcePatch2::FileServerPrx::uncheckedCast(result->getProxy());
        ::std::pair<const ::Ice::Byte*, const ::Ice::Byte*> ret;
        try
        {
            proxy->_iceI_end_getLargeFileCompressed(ret, result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }

private:

    Response _response;
};

template<class T> Callback_FileServer_getLargeFileCompressedPtr
newCallback_FileServer_getLargeFileCompressed(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::std::pair<const ::Ice::Byte*, const ::Ice::Byte*>&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_FileServer_getLargeFileCompressed<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_FileServer_getLargeFileCompressedPtr
newCallback_FileServer_getLargeFileCompressed(T* instance, void (T::*cb)(const ::std::pair<const ::Ice::Byte*, const ::Ice::Byte*>&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_FileServer_getLargeFileCompressed<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_FileServer_getLargeFileCompressed : public Callback_FileServer_getLargeFileCompressed_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::std::pair<const ::Ice::Byte*, const ::Ice::Byte*>&, const CT&);

    Callback_FileServer_getLargeFileCompressed(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IcePatch2::FileServerPrx proxy = ::IcePatch2::FileServerPrx::uncheckedCast(result->getProxy());
        ::std::pair<const ::Ice::Byte*, const ::Ice::Byte*> ret;
        try
        {
            proxy->_iceI_end_getLargeFileCompressed(ret, result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_FileServer_getLargeFileCompressedPtr
newCallback_FileServer_getLargeFileCompressed(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::std::pair<const ::Ice::Byte*, const ::Ice::Byte*>&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_FileServer_getLargeFileCompressed<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_FileServer_getLargeFileCompressedPtr
newCallback_FileServer_getLargeFileCompressed(T* instance, void (T::*cb)(const ::std::pair<const ::Ice::Byte*, const ::Ice::Byte*>&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_FileServer_getLargeFileCompressed<T, CT>(instance, cb, excb, sentcb);
}

}

#endif

#include <IceUtil/PopDisableWarnings.h>
#endif
