/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.master;

import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.MasterNodeChangePredicate;
import org.elasticsearch.cluster.NotMasterException;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.discovery.Discovery;
import org.elasticsearch.discovery.MasterNotDiscoveredException;
import org.elasticsearch.node.NodeClosedException;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportService;

public abstract class TransportMasterNodeAction<Request extends MasterNodeRequest<Request>, Response extends ActionResponse>
extends HandledTransportAction<Request, Response> {
    protected final TransportService transportService;
    protected final ClusterService clusterService;
    final String executor;

    protected TransportMasterNodeAction(Settings settings, String actionName, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<Request> request) {
        this(settings, actionName, true, transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, request);
    }

    protected TransportMasterNodeAction(Settings settings, String actionName, boolean canTripCircuitBreaker, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<Request> request) {
        super(settings, actionName, canTripCircuitBreaker, threadPool, transportService, actionFilters, indexNameExpressionResolver, request);
        this.transportService = transportService;
        this.clusterService = clusterService;
        this.executor = this.executor();
    }

    protected abstract String executor();

    protected abstract Response newResponse();

    protected abstract void masterOperation(Request var1, ClusterState var2, ActionListener<Response> var3) throws Exception;

    protected void masterOperation(Task task, Request request, ClusterState state, ActionListener<Response> listener) throws Exception {
        this.masterOperation(request, state, listener);
    }

    protected boolean localExecute(Request request) {
        return false;
    }

    protected abstract ClusterBlockException checkBlock(Request var1, ClusterState var2);

    @Override
    protected final void doExecute(Request request, ActionListener<Response> listener) {
        this.logger.warn("attempt to execute a master node operation without task");
        throw new UnsupportedOperationException("task parameter is required for this operation");
    }

    @Override
    protected void doExecute(Task task, Request request, ActionListener<Response> listener) {
        new AsyncSingleAction(this, task, request, listener).start();
    }

    protected String getMasterActionName(DiscoveryNode node) {
        return this.actionName;
    }

    static class AsyncSingleAction {
        private final ActionListener<Response> listener;
        private final Request request;
        private volatile ClusterStateObserver observer;
        private final Task task;
        final /* synthetic */ TransportMasterNodeAction this$0;

        AsyncSingleAction(Task task, Request request, ActionListener<Response> listener) {
            this.this$0 = this$0;
            this.task = task;
            this.request = request;
            if (task != null) {
                request.setParentTask(this$0.clusterService.localNode().getId(), task.getId());
            }
            this.listener = listener;
        }

        public void start() {
            ClusterState state = this.this$0.clusterService.state();
            this.observer = new ClusterStateObserver(state, this.this$0.clusterService, ((MasterNodeRequest)this.request).masterNodeTimeout(), this.this$0.logger, this.this$0.threadPool.getThreadContext());
            this.doStart(state);
        }

        protected void doStart(final ClusterState clusterState) {
            final Predicate<ClusterState> masterChangePredicate = MasterNodeChangePredicate.build(clusterState);
            final DiscoveryNodes nodes = clusterState.nodes();
            if (nodes.isLocalNodeElectedMaster() || this.this$0.localExecute(this.request)) {
                ClusterBlockException blockException = this.this$0.checkBlock(this.request, clusterState);
                if (blockException != null) {
                    if (!blockException.retryable()) {
                        this.listener.onFailure(blockException);
                    } else {
                        this.this$0.logger.trace("can't execute due to a cluster block, retrying", (Throwable)blockException);
                        this.retry(blockException, newState -> {
                            ClusterBlockException newException = this.this$0.checkBlock(this.request, (ClusterState)newState);
                            return newException == null || !newException.retryable();
                        });
                    }
                } else {
                    final ActionListener delegate = new ActionListener<Response>(){

                        @Override
                        public void onResponse(Response response) {
                            AsyncSingleAction.this.listener.onResponse(response);
                        }

                        @Override
                        public void onFailure(Exception t) {
                            if (t instanceof Discovery.FailedToCommitClusterStateException || t instanceof NotMasterException) {
                                AsyncSingleAction.this.this$0.logger.debug(() -> new ParameterizedMessage("master could not publish cluster state or stepped down before publishing action [{}], scheduling a retry", (Object)AsyncSingleAction.this.this$0.actionName), (Throwable)t);
                                AsyncSingleAction.this.retry(t, masterChangePredicate);
                            } else {
                                AsyncSingleAction.this.listener.onFailure(t);
                            }
                        }
                    };
                    this.this$0.threadPool.executor(this.this$0.executor).execute(new ActionRunnable(delegate){

                        @Override
                        protected void doRun() throws Exception {
                            AsyncSingleAction.this.this$0.masterOperation(AsyncSingleAction.this.task, AsyncSingleAction.this.request, clusterState, delegate);
                        }
                    });
                }
            } else if (nodes.getMasterNode() == null) {
                this.this$0.logger.debug("no known master node, scheduling a retry");
                this.retry(null, masterChangePredicate);
            } else {
                DiscoveryNode masterNode = nodes.getMasterNode();
                final String actionName = this.this$0.getMasterActionName(masterNode);
                this.this$0.transportService.sendRequest(masterNode, actionName, (TransportRequest)this.request, new ActionListenerResponseHandler<Response>(this.listener, this.this$0::newResponse){

                    @Override
                    public void handleException(TransportException exp) {
                        Throwable cause = exp.unwrapCause();
                        if (cause instanceof ConnectTransportException) {
                            AsyncSingleAction.this.this$0.logger.debug("connection exception while trying to forward request with action name [{}] to master node [{}], scheduling a retry. Error: [{}]", (Object)actionName, (Object)nodes.getMasterNode(), (Object)exp.getDetailedMessage());
                            AsyncSingleAction.this.retry(cause, masterChangePredicate);
                        } else {
                            AsyncSingleAction.this.listener.onFailure(exp);
                        }
                    }
                });
            }
        }

        private void retry(final Throwable failure, Predicate<ClusterState> statePredicate) {
            this.observer.waitForNextChange(new ClusterStateObserver.Listener(){

                @Override
                public void onNewClusterState(ClusterState state) {
                    AsyncSingleAction.this.doStart(state);
                }

                @Override
                public void onClusterServiceClose() {
                    AsyncSingleAction.this.listener.onFailure(new NodeClosedException(AsyncSingleAction.this.this$0.clusterService.localNode()));
                }

                @Override
                public void onTimeout(TimeValue timeout) {
                    AsyncSingleAction.this.this$0.logger.debug(() -> new ParameterizedMessage("timed out while retrying [{}] after failure (timeout [{}])", (Object)AsyncSingleAction.this.this$0.actionName, (Object)timeout), failure);
                    AsyncSingleAction.this.listener.onFailure(new MasterNotDiscoveredException(failure));
                }
            }, statePredicate);
        }
    }
}

