/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.rankeval;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.rankeval.EvaluationMetric;
import org.elasticsearch.index.rankeval.MetricDetails;
import org.elasticsearch.index.rankeval.RatedDocument;
import org.elasticsearch.index.rankeval.RatedSearchHit;

public class EvalQueryQuality
implements ToXContent,
Writeable {
    private final String queryId;
    private final double evaluationResult;
    private MetricDetails optionalMetricDetails;
    private final List<RatedSearchHit> ratedHits = new ArrayList<RatedSearchHit>();

    public EvalQueryQuality(String id, double evaluationResult) {
        this.queryId = id;
        this.evaluationResult = evaluationResult;
    }

    public EvalQueryQuality(StreamInput in) throws IOException {
        this(in.readString(), in.readDouble());
        this.ratedHits.addAll(in.readList(RatedSearchHit::new));
        this.optionalMetricDetails = (MetricDetails)in.readOptionalNamedWriteable(MetricDetails.class);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.queryId);
        out.writeDouble(this.evaluationResult);
        out.writeList(this.ratedHits);
        out.writeOptionalNamedWriteable((NamedWriteable)this.optionalMetricDetails);
    }

    public String getId() {
        return this.queryId;
    }

    public double getQualityLevel() {
        return this.evaluationResult;
    }

    public void setMetricDetails(MetricDetails breakdown) {
        this.optionalMetricDetails = breakdown;
    }

    public MetricDetails getMetricDetails() {
        return this.optionalMetricDetails;
    }

    public void addHitsAndRatings(List<RatedSearchHit> hits) {
        this.ratedHits.addAll(hits);
    }

    public List<RatedSearchHit> getHitsAndRatings() {
        return this.ratedHits;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.queryId);
        builder.field("quality_level", this.evaluationResult);
        builder.startArray("unknown_docs");
        for (RatedDocument.DocumentKey key : EvaluationMetric.filterUnknownDocuments(this.ratedHits)) {
            builder.startObject();
            builder.field(RatedDocument.INDEX_FIELD.getPreferredName(), key.getIndex());
            builder.field(RatedDocument.DOC_ID_FIELD.getPreferredName(), key.getDocId());
            builder.endObject();
        }
        builder.endArray();
        builder.startArray("hits");
        for (RatedSearchHit hit : this.ratedHits) {
            hit.toXContent(builder, params);
        }
        builder.endArray();
        if (this.optionalMetricDetails != null) {
            builder.startObject("metric_details");
            this.optionalMetricDetails.toXContent(builder, params);
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        EvalQueryQuality other = (EvalQueryQuality)obj;
        return Objects.equals(this.queryId, other.queryId) && Objects.equals(this.evaluationResult, other.evaluationResult) && Objects.equals(this.ratedHits, other.ratedHits) && Objects.equals(this.optionalMetricDetails, other.optionalMetricDetails);
    }

    public final int hashCode() {
        return Objects.hash(this.queryId, this.evaluationResult, this.ratedHits, this.optionalMetricDetails);
    }
}

