/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.QuadBuckets;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.JosmRuntimeException;

public class QuadBucketPrimitiveStore {
    private final QuadBuckets<Node> nodes = new QuadBuckets();
    private final QuadBuckets<Way> ways = new QuadBuckets();
    private final Collection<Relation> relations = new ArrayList<Relation>();

    public List<Node> searchNodes(BBox bbox) {
        return this.nodes.search(bbox);
    }

    public boolean containsNode(Node n) {
        return this.nodes.contains(n);
    }

    public List<Way> searchWays(BBox bbox) {
        return this.ways.search(bbox);
    }

    public boolean containsWay(Way w) {
        return this.ways.contains(w);
    }

    public List<Relation> searchRelations(BBox bbox) {
        return this.relations.stream().filter(r -> r.getBBox().intersects(bbox)).collect(Collectors.toList());
    }

    public boolean containsRelation(Relation r) {
        return this.relations.contains(r);
    }

    public void addPrimitive(OsmPrimitive primitive) {
        boolean success = false;
        if (primitive instanceof Node) {
            success = this.nodes.add((Node)primitive);
        } else if (primitive instanceof Way) {
            success = this.ways.add((Way)primitive);
        } else if (primitive instanceof Relation) {
            success = this.relations.add((Relation)primitive);
        }
        if (!success) {
            throw new JosmRuntimeException("failed to add primitive: " + primitive);
        }
    }

    protected void removePrimitive(OsmPrimitive primitive) {
        boolean success = false;
        if (primitive instanceof Node) {
            success = this.nodes.remove(primitive);
        } else if (primitive instanceof Way) {
            success = this.ways.remove(primitive);
        } else if (primitive instanceof Relation) {
            success = this.relations.remove(primitive);
        }
        if (!success) {
            throw new JosmRuntimeException("failed to remove primitive: " + primitive);
        }
    }

    protected void reindexNode(Node node, LatLon newCoor, EastNorth eastNorth) {
        if (!this.nodes.remove(node)) {
            throw new JosmRuntimeException("Reindexing node failed to remove");
        }
        node.setCoorInternal(newCoor, eastNorth);
        if (!this.nodes.add(node)) {
            throw new JosmRuntimeException("Reindexing node failed to add");
        }
        for (OsmPrimitive primitive : node.getReferrers()) {
            if (primitive instanceof Way) {
                this.reindexWay((Way)primitive);
                continue;
            }
            QuadBucketPrimitiveStore.reindexRelation((Relation)primitive);
        }
    }

    protected void reindexWay(Way way) {
        BBox before = way.getBBox();
        if (!this.ways.remove(way)) {
            throw new JosmRuntimeException("Reindexing way failed to remove");
        }
        way.updatePosition();
        if (!this.ways.add(way)) {
            throw new JosmRuntimeException("Reindexing way failed to add");
        }
        if (!way.getBBox().equals(before)) {
            for (OsmPrimitive primitive : way.getReferrers()) {
                QuadBucketPrimitiveStore.reindexRelation((Relation)primitive);
            }
        }
    }

    protected static void reindexRelation(Relation relation) {
        BBox before = relation.getBBox();
        relation.updatePosition();
        if (!before.equals(relation.getBBox())) {
            for (OsmPrimitive primitive : relation.getReferrers()) {
                QuadBucketPrimitiveStore.reindexRelation((Relation)primitive);
            }
        }
    }

    public void clear() {
        this.nodes.clear();
        this.ways.clear();
        this.relations.clear();
    }
}

