/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.security.AccessController;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapFrameListener;
import org.openstreetmap.josm.gui.download.DownloadSelection;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.spi.preferences.IBaseDirectories;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public abstract class Plugin
implements MapFrameListener {
    private PluginInformation info;
    private final IBaseDirectories pluginBaseDirectories = new PluginBaseDirectories();

    public Plugin(PluginInformation info) {
        this.info = info;
    }

    public PluginInformation getPluginInformation() {
        return this.info;
    }

    public void setPluginInformation(PluginInformation info) {
        this.info = info;
    }

    public IBaseDirectories getPluginDirs() {
        return this.pluginBaseDirectories;
    }

    @Deprecated
    public String getPluginDir() {
        return new File(Main.pref.getPluginsDirectory(), this.info.name).getPath();
    }

    @Override
    public void mapFrameInitialized(MapFrame oldFrame, MapFrame newFrame) {
    }

    public PreferenceSetting getPreferenceSetting() {
        return null;
    }

    public void addDownloadSelection(List<DownloadSelection> list) {
    }

    @Deprecated
    public void copy(String from, String to) throws IOException {
        String pluginDirName = this.getPluginDir();
        File pluginDir = new File(pluginDirName);
        if (!pluginDir.exists()) {
            Utils.mkDirs(pluginDir);
        }
        try (InputStream in = this.getClass().getResourceAsStream(from);){
            if (in == null) {
                throw new IOException("Resource not found: " + from);
            }
            Files.copy(in, new File(pluginDirName, to).toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public ClassLoader getPluginResourceClassLoader() {
        File pluginDir = Main.pref.getPluginsDirectory();
        File pluginJar = new File(pluginDir, this.info.name + ".jar");
        URL pluginJarUrl = Utils.fileToURL(pluginJar);
        return AccessController.doPrivileged(() -> new URLClassLoader(new URL[]{pluginJarUrl}, Plugin.class.getClassLoader()));
    }

    private class PluginBaseDirectories
    implements IBaseDirectories {
        private File preferencesDir;
        private File cacheDir;
        private File userdataDir;

        private PluginBaseDirectories() {
        }

        @Override
        public File getPreferencesDirectory(boolean createIfMissing) {
            if (this.preferencesDir == null) {
                this.preferencesDir = Config.getDirs().getPreferencesDirectory(createIfMissing).toPath().resolve("plugins").resolve(((Plugin)Plugin.this).info.name).toFile();
            }
            if (createIfMissing && !this.preferencesDir.exists() && !this.preferencesDir.mkdirs()) {
                Logging.error(I18n.tr("Failed to create missing plugin preferences directory: {0}", this.preferencesDir.getAbsoluteFile()));
            }
            return this.preferencesDir;
        }

        @Override
        public File getUserDataDirectory(boolean createIfMissing) {
            if (this.userdataDir == null) {
                this.userdataDir = Config.getDirs().getUserDataDirectory(createIfMissing).toPath().resolve("plugins").resolve(((Plugin)Plugin.this).info.name).toFile();
            }
            if (createIfMissing && !this.userdataDir.exists() && !this.userdataDir.mkdirs()) {
                Logging.error(I18n.tr("Failed to create missing plugin user data directory: {0}", this.userdataDir.getAbsoluteFile()));
            }
            return this.userdataDir;
        }

        @Override
        public File getCacheDirectory(boolean createIfMissing) {
            if (this.cacheDir == null) {
                this.cacheDir = Config.getDirs().getCacheDirectory(createIfMissing).toPath().resolve("plugins").resolve(((Plugin)Plugin.this).info.name).toFile();
            }
            if (createIfMissing && !this.cacheDir.exists() && !this.cacheDir.mkdirs()) {
                Logging.error(I18n.tr("Failed to create missing plugin cache directory: {0}", this.cacheDir.getAbsoluteFile()));
            }
            return this.cacheDir;
        }
    }
}

