/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.dce;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.backend.ast.JsArrayAccess;
import org.jetbrains.kotlin.js.backend.ast.JsBreak;
import org.jetbrains.kotlin.js.backend.ast.JsContinue;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsLocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsPrefixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsUnaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.RecursiveJsVisitor;
import org.jetbrains.kotlin.js.dce.AnalysisResult;
import org.jetbrains.kotlin.js.dce.Context;
import org.jetbrains.kotlin.js.dce.DCELogLevel;
import org.jetbrains.kotlin.js.dce.ReachabilityTracker;
import org.jetbrains.kotlin.js.dce.UtilKt;
import org.jetbrains.kotlin.js.inline.util.CollectUtilsKt;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 ?2\u00020\u0001:\u0001?B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0018\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\u0007\u00a2\u0006\u0002\u0010\u000bJ\u0016\u0010\u0017\u001a\u00020\n2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\u0019H\u0002J\u000e\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u0012J\u0010\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u0012H\u0002J\u0010\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u0012H\u0002J\u0010\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\tH\u0002J(\u0010 \u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\t2\b\u0010!\u001a\u0004\u0018\u00010\r2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\u0019H\u0002J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\rH\u0002J\u0010\u0010%\u001a\u00020\n2\u0006\u0010$\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020\n2\u0006\u0010$\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020\n2\u0006\u0010$\u001a\u00020*H\u0016J\u0010\u0010+\u001a\u00020\n2\u0006\u0010$\u001a\u00020,H\u0016J\u0010\u0010-\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\rH\u0014J\u0010\u0010.\u001a\u00020\n2\u0006\u0010$\u001a\u00020/H\u0016J\u0010\u00100\u001a\u00020\n2\u0006\u0010$\u001a\u000201H\u0016J\u0010\u00102\u001a\u00020\n2\u0006\u00103\u001a\u000204H\u0016J\u0010\u00105\u001a\u00020#2\u0006\u0010$\u001a\u000206H\u0002J\u0010\u00107\u001a\u00020\n2\u0006\u00108\u001a\u000209H\u0016J\u0010\u0010:\u001a\u00020\n2\u0006\u0010$\u001a\u00020;H\u0016J\u0010\u0010<\u001a\u00020\n2\u0006\u0010$\u001a\u00020=H\u0016J\u0016\u0010>\u001a\u00020\n2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\u0019H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lorg/jetbrains/kotlin/js/dce/ReachabilityTracker;", "Lorg/jetbrains/kotlin/js/backend/ast/RecursiveJsVisitor;", "context", "Lorg/jetbrains/kotlin/js/dce/Context;", "analysisResult", "Lorg/jetbrains/kotlin/js/dce/AnalysisResult;", "logConsumer", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/js/dce/DCELogLevel;", "", "", "(Lorg/jetbrains/kotlin/js/dce/Context;Lorg/jetbrains/kotlin/js/dce/AnalysisResult;Lkotlin/jvm/functions/Function2;)V", "currentNodeWithLocation", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "depth", "", "reachableNodes", "", "Lorg/jetbrains/kotlin/js/dce/Context$Node;", "getReachableNodes", "()Ljava/util/Set;", "reachableNodesImpl", "", "nested", "action", "Lkotlin/Function0;", "reach", "node", "reachDeclaration", "reachDependencies", "report", "message", "reportAndNest", "dueTo", "shouldTraverse", "", "x", "visit", "Lorg/jetbrains/kotlin/js/backend/ast/JsVars$JsVar;", "visitArrayAccess", "Lorg/jetbrains/kotlin/js/backend/ast/JsArrayAccess;", "visitBreak", "Lorg/jetbrains/kotlin/js/backend/ast/JsBreak;", "visitContinue", "Lorg/jetbrains/kotlin/js/backend/ast/JsContinue;", "visitElement", "visitExpressionStatement", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpressionStatement;", "visitFunction", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "visitInvocation", "invocation", "Lorg/jetbrains/kotlin/js/backend/ast/JsInvocation;", "visitNameLikeNode", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "visitNameRef", "nameRef", "Lorg/jetbrains/kotlin/js/backend/ast/JsNameRef;", "visitPrefixOperation", "Lorg/jetbrains/kotlin/js/backend/ast/JsPrefixOperation;", "visitReturn", "Lorg/jetbrains/kotlin/js/backend/ast/JsReturn;", "withErasedThis", "Companion", "js.dce"})
public final class ReachabilityTracker
extends RecursiveJsVisitor {
    private JsNode currentNodeWithLocation;
    private int depth;
    private final Set<Context.Node> reachableNodesImpl;
    private final Context context;
    private final AnalysisResult analysisResult;
    private final Function2<DCELogLevel, String, Unit> logConsumer;
    private static final Set<String> CALL_FUNCTIONS;
    public static final Companion Companion;

    @NotNull
    public final Set<Context.Node> getReachableNodes() {
        return this.reachableNodesImpl;
    }

    @Override
    public void visit(@NotNull JsVars.JsVar x) {
        Intrinsics.checkParameterIsNotNull(x, "x");
        if (this.shouldTraverse(x)) {
            super.visit(x);
        }
    }

    @Override
    public void visitExpressionStatement(@NotNull JsExpressionStatement x) {
        Intrinsics.checkParameterIsNotNull(x, "x");
        if (this.shouldTraverse(x)) {
            super.visitExpressionStatement(x);
        }
    }

    @Override
    public void visitReturn(@NotNull JsReturn x) {
        Intrinsics.checkParameterIsNotNull(x, "x");
        if (this.shouldTraverse(x)) {
            super.visitReturn(x);
        }
    }

    private final boolean shouldTraverse(JsNode x) {
        return this.analysisResult.getNodeMap().get(x) == null && !this.analysisResult.getAstNodesToEliminate().contains(x);
    }

    @Override
    public void visitNameRef(@NotNull JsNameRef nameRef) {
        Intrinsics.checkParameterIsNotNull(nameRef, "nameRef");
        if (this.visitNameLikeNode(nameRef)) {
            super.visitNameRef(nameRef);
        }
    }

    @Override
    public void visitArrayAccess(@NotNull JsArrayAccess x) {
        Intrinsics.checkParameterIsNotNull(x, "x");
        if (this.visitNameLikeNode(x)) {
            super.visitArrayAccess(x);
        }
    }

    private final boolean visitNameLikeNode(JsExpression x) {
        if (this.analysisResult.getAstNodesToSkip().contains(x)) {
            return false;
        }
        Context.Node node = this.context.extractNode(x);
        if (node != null) {
            if (!node.getReachable()) {
                this.reportAndNest("reach: referenced name " + node, this.currentNodeWithLocation, new Function0<Unit>(this, node){
                    final /* synthetic */ ReachabilityTracker this$0;
                    final /* synthetic */ Context.Node $node;

                    public final void invoke() {
                        block0: {
                            JsNode jsNode;
                            this.this$0.reach(this.$node);
                            JsNode jsNode2 = ReachabilityTracker.access$getCurrentNodeWithLocation$p(this.this$0);
                            if (jsNode2 == null) break block0;
                            JsNode it = jsNode = jsNode2;
                            Collection collection = this.$node.getUsedByAstNodes();
                            collection.add(it);
                        }
                    }
                    {
                        this.this$0 = reachabilityTracker;
                        this.$node = node;
                        super(0);
                    }
                });
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitInvocation(@NotNull JsInvocation invocation) {
        Intrinsics.checkParameterIsNotNull(invocation, "invocation");
        JsExpression function2 = invocation.getQualifier();
        if (function2 instanceof JsFunction && this.analysisResult.getFunctionsToEnter().contains(function2)) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            this.accept((JsNode)((JsFunction)function2).getBody());
            List<JsExpression> list2 = invocation.getArguments();
            Intrinsics.checkExpressionValueIsNotNull(list2, "invocation.arguments");
            Iterable iterable = $receiver$iv = (Iterable)list2;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                JsExpression it = (JsExpression)element$iv$iv;
                if (!(it instanceof JsFunction && this.analysisResult.getFunctionsToEnter().contains(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            for (JsExpression argument : (List)destination$iv$iv) {
                this.accept((JsNode)argument);
            }
        } else if (!this.analysisResult.getInvocationsToSkip().contains(invocation)) {
            JsExpression jsExpression = invocation.getQualifier();
            Intrinsics.checkExpressionValueIsNotNull(jsExpression, "invocation.qualifier");
            Context.Node node = this.context.extractNode(jsExpression);
            if (node != null) {
                Context.Qualifier qualifier = node.getQualifier();
                if (CollectionsKt.contains(ReachabilityTracker.Companion.getCALL_FUNCTIONS(), qualifier != null ? qualifier.getMemberName() : null)) {
                    Context.Qualifier qualifier2 = node.getQualifier();
                    if (qualifier2 == null) {
                        Intrinsics.throwNpe();
                    }
                    Context.Node parent2 = qualifier2.getParent();
                    this.reach(parent2);
                    JsNode jsNode = this.currentNodeWithLocation;
                    if (jsNode != null) {
                        JsNode jsNode2;
                        JsNode it = jsNode2 = jsNode;
                        Collection collection = parent2.getUsedByAstNodes();
                        collection.add(it);
                    }
                }
            }
            super.visitInvocation(invocation);
        }
    }

    @Override
    public void visitFunction(@NotNull JsFunction x) {
        Intrinsics.checkParameterIsNotNull(x, "x");
        if (!this.analysisResult.getFunctionsToEnter().contains(x)) {
            Set<JsName> set;
            Set<JsName> it = set = CollectUtilsKt.collectLocalVariables(x);
            this.context.addNodesForLocalVars((Collection<? extends JsName>)it);
            Collection collection = this.context.getNamesOfLocalVars();
            CollectionsKt.addAll(collection, (Iterable)it);
            this.withErasedThis(new Function0<Unit>(this, x){
                final /* synthetic */ ReachabilityTracker this$0;
                final /* synthetic */ JsFunction $x;

                public final void invoke() {
                    ReachabilityTracker.access$visitFunction$s884871873(this.this$0, this.$x);
                }
                {
                    this.this$0 = reachabilityTracker;
                    this.$x = jsFunction;
                    super(0);
                }
            });
        } else {
            super.visitFunction(x);
        }
    }

    private final void withErasedThis(Function0<Unit> action) {
        Context.Node oldThis = this.context.getThisNode();
        this.context.setThisNode(null);
        action.invoke();
        this.context.setThisNode(oldThis);
    }

    @Override
    public void visitBreak(@NotNull JsBreak x) {
        Intrinsics.checkParameterIsNotNull(x, "x");
    }

    @Override
    public void visitContinue(@NotNull JsContinue x) {
        Intrinsics.checkParameterIsNotNull(x, "x");
    }

    public final void reach(@NotNull Context.Node node) {
        Intrinsics.checkParameterIsNotNull(node, "node");
        if (node.getReachable()) {
            return;
        }
        node.setReachable(true);
        Collection collection = this.reachableNodesImpl;
        collection.add(node);
        this.reachDeclaration(node);
        this.reachDependencies(node);
        Iterable iterable = MapsKt.toList(node.getMembers());
        for (Object element$iv : iterable) {
            Pair $name_member = (Pair)element$iv;
            String name = (String)$name_member.component1();
            Context.Node member = (Context.Node)$name_member.component2();
            if (member.getReachable()) continue;
            this.reportAndNest("reach: member " + name, null, new Function0<Unit>(member, this){
                final /* synthetic */ Context.Node $member;
                final /* synthetic */ ReachabilityTracker this$0;
                {
                    this.$member = node;
                    this.this$0 = reachabilityTracker;
                    super(0);
                }

                public final void invoke() {
                    this.this$0.reach(this.$member);
                }
            });
        }
        if (!this.analysisResult.getFunctionsToSkip().contains(node)) {
            for (JsFunction jsFunction : node.getFunctions()) {
                this.reportAndNest("traverse: function", jsFunction, new Function0<Unit>(this, jsFunction){
                    final /* synthetic */ ReachabilityTracker this$0;
                    final /* synthetic */ JsFunction $expr;

                    public final void invoke() {
                        Set<JsName> set;
                        Set<JsName> it = set = CollectUtilsKt.collectLocalVariables(this.$expr);
                        ReachabilityTracker.access$getContext$p(this.this$0).addNodesForLocalVars((Collection<? extends JsName>)it);
                        Collection collection = ReachabilityTracker.access$getContext$p(this.this$0).getNamesOfLocalVars();
                        CollectionsKt.addAll(collection, (Iterable)it);
                        ReachabilityTracker.access$withErasedThis(this.this$0, new Function0<Unit>(this){
                            final /* synthetic */ reach.2 this$0;

                            public final void invoke() {
                                this.this$0.$expr.getBody().accept(this.this$0.this$0);
                            }
                            {
                                this.this$0 = var1_1;
                                super(0);
                            }
                        });
                    }
                    {
                        this.this$0 = reachabilityTracker;
                        this.$expr = jsFunction;
                        super(0);
                    }
                });
            }
        }
        for (JsExpression jsExpression : node.getExpressions()) {
            this.reportAndNest("traverse: value", jsExpression, new Function0<Unit>(this, jsExpression){
                final /* synthetic */ ReachabilityTracker this$0;
                final /* synthetic */ JsExpression $expr;

                public final void invoke() {
                    this.$expr.accept(this.this$0);
                }
                {
                    this.this$0 = reachabilityTracker;
                    this.$expr = jsExpression;
                    super(0);
                }
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void reachDependencies(Context.Node node) {
        List path2 = new ArrayList();
        Context.Node current = node;
        while (true) {
            Context.Qualifier qualifier;
            for (Context.Node ancestorDependency : current.getDependencies()) {
                if (SequencesKt.contains(SequencesKt.generateSequence(ancestorDependency, (Function1)reachDependencies.1.INSTANCE), current)) continue;
                Iterable $receiver$iv = CollectionsKt.asReversedMutable(path2);
                Context.Node accumulator$iv = ancestorDependency;
                for (Object element$iv : $receiver$iv) {
                    void memberName;
                    String string = (String)element$iv;
                    Context.Node n = accumulator$iv;
                    accumulator$iv = n.member((String)memberName);
                }
                Context.Node dependency = accumulator$iv;
                if (dependency.getReachable()) continue;
                this.reportAndNest("reach: dependency " + dependency, null, new Function0<Unit>(this, dependency){
                    final /* synthetic */ ReachabilityTracker this$0;
                    final /* synthetic */ Context.Node $dependency;

                    public final void invoke() {
                        this.this$0.reach(this.$dependency);
                    }
                    {
                        this.this$0 = reachabilityTracker;
                        this.$dependency = node;
                        super(0);
                    }
                });
            }
            if (current.getQualifier() == null) {
                break;
            }
            Collection collection = path2;
            String string = qualifier.getMemberName();
            collection.add(string);
            current = qualifier.getParent();
        }
    }

    private final void reachDeclaration(Context.Node node) {
        if (node.getHasSideEffects() && !node.getReachable()) {
            this.reportAndNest("reach: because of side effect", null, new Function0<Unit>(this, node){
                final /* synthetic */ ReachabilityTracker this$0;
                final /* synthetic */ Context.Node $node;

                public final void invoke() {
                    this.this$0.reach(this.$node);
                }
                {
                    this.this$0 = reachabilityTracker;
                    this.$node = node;
                    super(0);
                }
            });
        } else if (!node.getDeclarationReachable()) {
            node.setDeclarationReachable(true);
            Object object = this.reachableNodesImpl;
            object.add(node);
            Object object2 = node.getOriginal().getQualifier();
            if (object2 != null && (object2 = ((Context.Qualifier)object2).getParent()) != null) {
                Object it = object = object2;
                this.reportAndNest("reach-decl: parent " + it, null, new Function0<Unit>((Context.Node)it, this){
                    final /* synthetic */ Context.Node $it;
                    final /* synthetic */ ReachabilityTracker this$0;
                    {
                        this.$it = node;
                        this.this$0 = reachabilityTracker;
                        super(0);
                    }

                    public final void invoke() {
                        ReachabilityTracker.access$reachDeclaration(this.this$0, this.$it);
                    }
                });
            }
            for (JsExpression expr : node.getExpressions()) {
                this.reportAndNest("traverse: value", expr, new Function0<Unit>(this, expr){
                    final /* synthetic */ ReachabilityTracker this$0;
                    final /* synthetic */ JsExpression $expr;

                    public final void invoke() {
                        this.$expr.accept(this.this$0);
                    }
                    {
                        this.this$0 = reachabilityTracker;
                        this.$expr = jsExpression;
                        super(0);
                    }
                });
            }
        }
    }

    @Override
    public void visitPrefixOperation(@NotNull JsPrefixOperation x) {
        Intrinsics.checkParameterIsNotNull(x, "x");
        if (Intrinsics.areEqual(x.getOperator(), JsUnaryOperator.TYPEOF)) {
            JsExpression arg;
            JsExpression jsExpression = arg = x.getArg();
            Intrinsics.checkExpressionValueIsNotNull(jsExpression, "arg");
            Context.Node node = this.context.extractNode(jsExpression);
            if (node != null) {
                Context.Node node2;
                Context.Node it = node2 = node;
                this.reachDeclaration(it);
                return;
            }
        }
        super.visitPrefixOperation(x);
    }

    @Override
    protected void visitElement(@NotNull JsNode node) {
        Intrinsics.checkParameterIsNotNull(node, "node");
        if (this.analysisResult.getAstNodesToSkip().contains(node)) {
            return;
        }
        JsLocation newLocation = UtilKt.extractLocation(node);
        JsNode old = this.currentNodeWithLocation;
        if (newLocation != null) {
            this.currentNodeWithLocation = node;
        }
        super.visitElement(node);
        this.currentNodeWithLocation = old;
    }

    private final void report(String message) {
        this.logConsumer.invoke(DCELogLevel.INFO, StringsKt.repeat("  ", this.depth) + message);
    }

    private final void reportAndNest(String message, JsNode dueTo, Function0<Unit> action) {
        JsNode jsNode = dueTo;
        JsLocation location2 = jsNode != null ? UtilKt.extractLocation(jsNode) : null;
        String fullMessage = location2 != null ? "" + message + " (due to " + UtilKt.asString(location2) + ')' : message;
        this.report(fullMessage);
        this.nested(action);
    }

    private final void nested(Function0<Unit> action) {
        int n = this.depth;
        this.depth = n + 1;
        action.invoke();
        n = this.depth;
        this.depth = n + -1;
    }

    public ReachabilityTracker(@NotNull Context context, @NotNull AnalysisResult analysisResult2, @NotNull Function2<? super DCELogLevel, ? super String, Unit> logConsumer2) {
        Set set;
        Intrinsics.checkParameterIsNotNull(context, "context");
        Intrinsics.checkParameterIsNotNull(analysisResult2, "analysisResult");
        Intrinsics.checkParameterIsNotNull(logConsumer2, "logConsumer");
        this.context = context;
        this.analysisResult = analysisResult2;
        this.logConsumer = logConsumer2;
        ReachabilityTracker reachabilityTracker = this;
        reachabilityTracker.reachableNodesImpl = set = (Set)new LinkedHashSet();
    }

    static {
        Companion = new Companion(null);
        CALL_FUNCTIONS = SetsKt.setOf(new String[]{"call", "apply"});
    }

    @Nullable
    public static final /* synthetic */ JsNode access$getCurrentNodeWithLocation$p(ReachabilityTracker $this) {
        return $this.currentNodeWithLocation;
    }

    public static final /* synthetic */ void access$setCurrentNodeWithLocation$p(ReachabilityTracker $this, @Nullable JsNode jsNode) {
        $this.currentNodeWithLocation = jsNode;
    }

    public static final /* synthetic */ void access$visitFunction$s884871873(ReachabilityTracker $this, @NotNull JsFunction x) {
        super.visitFunction(x);
    }

    @NotNull
    public static final /* synthetic */ Context access$getContext$p(ReachabilityTracker $this) {
        return $this.context;
    }

    public static final /* synthetic */ void access$withErasedThis(ReachabilityTracker $this, @NotNull Function0 action) {
        $this.withErasedThis(action);
    }

    public static final /* synthetic */ void access$reachDeclaration(ReachabilityTracker $this, @NotNull Context.Node node) {
        $this.reachDeclaration(node);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/js/dce/ReachabilityTracker$Companion;", "", "()V", "CALL_FUNCTIONS", "", "", "getCALL_FUNCTIONS", "()Ljava/util/Set;", "js.dce"})
    public static final class Companion {
        private final Set<String> getCALL_FUNCTIONS() {
            return CALL_FUNCTIONS;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

