/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.utils.mutator;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.js.translate.utils.mutator.Mutator;
import org.jetbrains.kotlin.types.KotlinType;

public class CoercionMutator
implements Mutator {
    private final KotlinType targetType;
    private final TranslationContext context;

    public CoercionMutator(@NotNull KotlinType targetType, @NotNull TranslationContext context) {
        this.targetType = targetType;
        this.context = context;
    }

    @Override
    @NotNull
    public JsNode mutate(@NotNull JsNode node) {
        if (node instanceof JsExpression) {
            return TranslationUtils.coerce(this.context, (JsExpression)node, this.targetType);
        }
        return node;
    }
}

