/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.apache.commons.jcs.access.CacheAccess;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoader;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.cache.BufferedImageCacheEntry;
import org.openstreetmap.josm.data.imagery.AbstractWMSTileSource;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.imagery.ImageryLayerInfo;
import org.openstreetmap.josm.data.imagery.TemplatedWMSTileSource;
import org.openstreetmap.josm.data.imagery.WMSCachedTileLoader;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.data.preferences.IntegerProperty;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.Projections;
import org.openstreetmap.josm.gui.layer.AbstractCachedTileSourceLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.imagery.TileSourceDisplaySettings;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public class WMSLayer
extends AbstractCachedTileSourceLayer<AbstractWMSTileSource> {
    private static final String PREFERENCE_PREFIX = "imagery.wms";
    public static final IntegerProperty PROP_IMAGE_SIZE;
    public static final BooleanProperty PROP_DEFAULT_AUTOZOOM;
    private static final String CACHE_REGION_NAME = "WMS";
    private final List<String> serverProjections;

    public WMSLayer(ImageryInfo info) {
        super(info);
        CheckParameterUtil.ensureThat(info.getImageryType() == ImageryInfo.ImageryType.WMS, "ImageryType is WMS");
        CheckParameterUtil.ensureParameterNotNull(info.getUrl(), "info.url");
        TemplatedWMSTileSource.checkUrl(info.getUrl());
        this.serverProjections = new ArrayList<String>(info.getServerProjections());
    }

    @Override
    protected TileSourceDisplaySettings createDisplaySettings() {
        return new TileSourceDisplaySettings(PREFERENCE_PREFIX);
    }

    @Override
    public Action[] getMenuEntries() {
        ArrayList<Action> ret = new ArrayList<Action>();
        ret.addAll(Arrays.asList(super.getMenuEntries()));
        ret.add(Layer.SeparatorLayerAction.INSTANCE);
        ret.add(new Layer.LayerSaveAction(this));
        ret.add(new Layer.LayerSaveAsAction(this));
        ret.add(new BookmarkWmsAction());
        return ret.toArray(new Action[0]);
    }

    @Override
    protected AbstractWMSTileSource getTileSource() {
        TemplatedWMSTileSource tileSource = new TemplatedWMSTileSource(this.info, this.chooseProjection(Main.getProjection()));
        this.info.setAttribution(tileSource);
        return tileSource;
    }

    @Override
    public Collection<String> getNativeProjections() {
        return this.serverProjections;
    }

    @Override
    public void projectionChanged(Projection oldValue, Projection newValue) {
        super.projectionChanged(oldValue, newValue);
        Projection tileProjection = this.chooseProjection(newValue);
        if (!Objects.equals(((AbstractWMSTileSource)this.tileSource).getTileProjection(), tileProjection)) {
            ((AbstractWMSTileSource)this.tileSource).setTileProjection(tileProjection);
        }
    }

    private Projection chooseProjection(Projection requested) {
        if (this.serverProjections.contains(requested.toCode())) {
            return requested;
        }
        for (String code : this.serverProjections) {
            Projection proj = Projections.getProjectionByCode(code);
            if (proj == null) continue;
            Logging.info(I18n.tr("Reprojecting layer {0} from {1} to {2}. For best image quality and performance, switch to one of the supported projections: {3}", this.getName(), proj.toCode(), Main.getProjection().toCode(), Utils.join(", ", this.getNativeProjections())));
            return proj;
        }
        Logging.warn(I18n.tr("Unable to find supported projection for layer {0}. Using {1}.", this.getName(), requested.toCode()));
        return requested;
    }

    @Override
    protected Class<? extends TileLoader> getTileLoaderClass() {
        return WMSCachedTileLoader.class;
    }

    @Override
    protected String getCacheName() {
        return CACHE_REGION_NAME;
    }

    public static CacheAccess<String, BufferedImageCacheEntry> getCache() {
        return AbstractCachedTileSourceLayer.getCache(CACHE_REGION_NAME);
    }

    static {
        new TileSourceDisplaySettings(PREFERENCE_PREFIX);
        PROP_IMAGE_SIZE = new IntegerProperty("imagery.wms.imageSize", 512);
        PROP_DEFAULT_AUTOZOOM = new BooleanProperty("imagery.wms.default_autozoom", true);
    }

    public class BookmarkWmsAction
    extends AbstractAction {
        public BookmarkWmsAction() {
            super(I18n.tr("Set WMS Bookmark", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            ImageryLayerInfo.addLayer(new ImageryInfo(WMSLayer.this.info));
        }
    }
}

