/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Hashtable;
import java.util.Map;
import org.bouncycastle.asn1.ASN1Boolean;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERBoolean;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERUniversalString;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.asn1.x500.AttributeTypeAndValue;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.util.encoders.Hex;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.openssl.ASN1;
import org.jruby.ext.openssl.ObjectSupport;
import org.jruby.ext.openssl.OpenSSL;
import org.jruby.ext.openssl.StringHelper;
import org.jruby.ext.openssl.Utils;
import org.jruby.ext.openssl.X509;
import org.jruby.ext.openssl.X509ExtensionFactory;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.ConvertBytes;

public class X509Extension
extends RubyObject {
    private static final long serialVersionUID = 6463713017143658305L;
    private static ObjectAllocator ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new X509Extension(runtime, klass);
        }
    };
    private ASN1ObjectIdentifier objectID;
    private Object value;
    private boolean critical;
    static final byte[] critical__ = new byte[]{99, 114, 105, 116, 105, 99, 97, 108, 44, 32};
    private static final byte[] CA_ = new byte[]{67, 65, 58};
    private static final byte[] TRUE = new byte[]{84, 82, 85, 69};
    private static final byte[] FALSE = new byte[]{70, 65, 76, 83, 69};
    private static final byte[] _ = new byte[0];
    private static final byte[] SEP = new byte[]{44, 32};
    private static final byte[] Decipher_Only = new byte[]{68, 101, 99, 105, 112, 104, 101, 114, 32, 79, 110, 108, 121};
    private static final byte[] Digital_Signature = new byte[]{68, 105, 103, 105, 116, 97, 108, 32, 83, 105, 103, 110, 97, 116, 117, 114, 101};
    private static final byte[] Non_Repudiation = new byte[]{78, 111, 110, 32, 82, 101, 112, 117, 100, 105, 97, 116, 105, 111, 110};
    private static final byte[] Key_Encipherment = new byte[]{75, 101, 121, 32, 69, 110, 99, 105, 112, 104, 101, 114, 109, 101, 110, 116};
    private static final byte[] Data_Encipherment = new byte[]{68, 97, 116, 97, 32, 69, 110, 99, 105, 112, 104, 101, 114, 109, 101, 110, 116};
    private static final byte[] Key_Agreement = new byte[]{75, 101, 121, 32, 65, 103, 114, 101, 101, 109, 101, 110, 116};
    private static final byte[] Certificate_Sign = new byte[]{67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 101, 32, 83, 105, 103, 110};
    private static final byte[] CRL_Sign = new byte[]{67, 82, 76, 32, 83, 105, 103, 110};
    private static final byte[] Encipher_Only = new byte[]{69, 110, 99, 105, 112, 104, 101, 114, 32, 79, 110, 108, 121};
    private static final byte[] SSL_Client = new byte[]{83, 83, 76, 32, 67, 108, 105, 101, 110, 116};
    private static final byte[] SSL_Server = new byte[]{83, 83, 76, 32, 83, 101, 114, 118, 101, 114};
    private static final byte[] SSL_CA = new byte[]{83, 83, 76, 32, 67, 65};
    private static final byte[] SMIME = new byte[]{83, 47, 77, 73, 77, 69};
    private static final byte[] SMIME_CA = new byte[]{83, 47, 77, 73, 77, 69, 32, 67, 65};
    private static final byte[] Object_Signing = new byte[]{79, 98, 106, 101, 99, 116, 32, 83, 105, 103, 110, 105, 110, 103};
    private static final byte[] Object_Signing_CA = new byte[]{79, 98, 106, 101, 99, 116, 32, 83, 105, 103, 110, 105, 110, 103, 32, 67, 65};
    private static final byte[] Unused = new byte[]{85, 110, 117, 115, 101, 100};
    private static final byte[] Unspecified = new byte[]{85, 110, 115, 112, 101, 99, 105, 102, 105, 101, 100};
    private static final byte[] keyid_ = new byte[]{107, 101, 121, 105, 100, 58};
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static void createX509Extension(Ruby runtime, RubyModule _X509) {
        RubyClass _OpenSSLError = runtime.getModule("OpenSSL").getClass("OpenSSLError");
        _X509.defineClassUnder("ExtensionError", _OpenSSLError, _OpenSSLError.getAllocator());
        RubyClass _Extension = _X509.defineClassUnder("Extension", runtime.getObject(), ALLOCATOR);
        _Extension.defineAnnotatedMethods(X509Extension.class);
        X509ExtensionFactory.createX509ExtensionFactory(runtime, _X509);
    }

    protected X509Extension(Ruby runtime, RubyClass type) {
        super(runtime, type);
    }

    static RubyClass _Extension(Ruby runtime) {
        return X509._X509(runtime).getClass("Extension");
    }

    static X509Extension newExtension(ThreadContext context2, String oid2, java.security.cert.X509Extension ext2, boolean critical) throws IOException {
        byte[] extValue = ext2.getExtensionValue(oid2);
        if (extValue == null) {
            OpenSSL.warn(context2, ext2 + " getExtensionValue returns null for '" + oid2 + "'");
            return null;
        }
        Ruby runtime = context2.runtime;
        ASN1Primitive value2 = ASN1.readObject(extValue);
        return X509Extension.newExtension(runtime, ASN1.getObjectID(runtime, oid2), (ASN1Encodable)value2, critical);
    }

    static X509Extension[] newExtension(ThreadContext context2, String oid2, byte[] extValue, boolean critical) throws IOException {
        Ruby runtime = context2.runtime;
        ASN1ObjectIdentifier objectId = ASN1.getObjectID(runtime, oid2);
        ASN1Primitive value2 = ASN1.readObject(extValue);
        if ((oid2.equals("2.5.29.17") || oid2.equals("2.5.29.18")) && value2 instanceof ASN1OctetString) {
            ASN1Primitive oct = ASN1.readObject(((ASN1OctetString)value2).getOctets());
            if (oct instanceof ASN1Sequence) {
                ASN1Sequence seq = (ASN1Sequence)oct;
                X509Extension[] ext2 = new X509Extension[seq.size()];
                for (int i2 = 0; i2 < ext2.length; ++i2) {
                    ext2[i2] = X509Extension.newExtension(runtime, objectId, seq.getObjectAt(i2), critical);
                }
                return ext2;
            }
            return new X509Extension[]{X509Extension.newExtension(runtime, objectId, (ASN1Encodable)oct, critical)};
        }
        return new X509Extension[]{X509Extension.newExtension(runtime, objectId, (ASN1Encodable)value2, critical)};
    }

    static X509Extension newExtension(Ruby runtime, ASN1ObjectIdentifier objectId, ASN1Encodable value2, boolean critical) {
        X509Extension ext2 = new X509Extension(runtime, X509Extension._Extension(runtime));
        ext2.setRealObjectID(objectId);
        ext2.setRealValue(value2);
        ext2.setRealCritical(critical);
        return ext2;
    }

    static X509Extension newExtension(Ruby runtime, ASN1ObjectIdentifier objectId, Extension extension) {
        X509Extension ext2 = new X509Extension(runtime, X509Extension._Extension(runtime));
        ext2.setRealObjectID(objectId);
        ext2.setRealValue(extension.getParsedValue());
        ext2.setRealCritical(extension.isCritical());
        return ext2;
    }

    ASN1ObjectIdentifier getRealObjectID() {
        return this.objectID;
    }

    void setRealObjectID(ASN1ObjectIdentifier oid2) {
        this.objectID = oid2;
    }

    void setRealObjectID(String oid2) {
        this.setRealObjectID(ASN1.getObjectID(this.getRuntime(), oid2));
    }

    final ASN1Encodable getRealValue() throws IOException {
        if (this.value instanceof ASN1Encodable) {
            return (ASN1Encodable)this.value;
        }
        if (this.value instanceof ASN1.ASN1Data) {
            return ((ASN1.ASN1Data)((Object)this.value)).toASN1(this.getRuntime().getCurrentContext());
        }
        if (this.value == null) {
            throw new IllegalStateException("null extension value");
        }
        return ASN1.readObject(this.getRealValueEncoded());
    }

    final byte[] getRealValueEncoded() throws IOException {
        if (this.value instanceof byte[]) {
            return (byte[])this.value;
        }
        if (this.value instanceof RubyString) {
            return ((RubyString)this.value).getBytes();
        }
        if (this.value instanceof String) {
            return ByteList.plain((CharSequence)((String)this.value));
        }
        if (this.value instanceof ASN1OctetString) {
            return ((ASN1OctetString)this.value).getOctets();
        }
        return this.getRealValue().toASN1Primitive().getEncoded("DER");
    }

    private IRubyObject getValue(Ruby runtime) throws IOException {
        if (this.value instanceof RubyString) {
            return (RubyString)this.value;
        }
        ThreadContext context2 = runtime.getCurrentContext();
        byte[] enc = this.getRealValueEncoded();
        RubyString extValue = runtime.newString(new ByteList(enc, false));
        extValue = ASN1.decodeImpl(context2, ASN1._ASN1(runtime), (IRubyObject)extValue);
        return extValue.callMethod(context2, "value");
    }

    void setRealValue(ASN1Encodable value2) {
        if (value2 == null) {
            throw new IllegalStateException("null extension value");
        }
        this.value = value2;
    }

    boolean isRealCritical() {
        return this.critical;
    }

    void setRealCritical(boolean critical) {
        this.critical = critical;
    }

    @JRubyMethod(name={"initialize"}, rest=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context2, IRubyObject[] args) {
        if (args.length == 1) {
            byte[] bytes = OpenSSL.to_der_if_possible(context2, args[0]).asString().getBytes();
            try {
                ASN1Sequence seq = (ASN1Sequence)ASN1.readObject(bytes);
                this.setRealObjectID((ASN1ObjectIdentifier)seq.getObjectAt(0));
                ASN1Encodable criticalOrValue = seq.getObjectAt(1);
                if (criticalOrValue instanceof ASN1Boolean) {
                    this.setRealCritical(((ASN1Boolean)criticalOrValue).isTrue());
                    this.value = ((DEROctetString)seq.getObjectAt(2)).getOctets();
                }
                if (criticalOrValue instanceof DERBoolean) {
                    this.setRealCritical(((DERBoolean)criticalOrValue).isTrue());
                    this.value = ((DEROctetString)seq.getObjectAt(2)).getOctets();
                }
                this.value = ((DEROctetString)criticalOrValue).getOctets();
            }
            catch (IOException e) {
                throw X509Extension.newExtensionError(context2.runtime, e);
            }
        } else if (args.length > 1) {
            this.setRealObjectID(ASN1.getObjectID(context2.runtime, args[0].toString()));
            this.value = args[1];
        } else {
            throw context2.runtime.newArgumentError("wrong number of arguments (0 for 1..3)");
        }
        if (args.length > 2) {
            this.setRealCritical(args[2].isTrue());
        }
        return this;
    }

    public IRubyObject initialize_copy(IRubyObject original) {
        if (this == original) {
            return this;
        }
        this.checkFrozen();
        X509Extension that = (X509Extension)original;
        this.value = that.value;
        this.objectID = that.objectID;
        this.critical = that.critical;
        return this;
    }

    @JRubyMethod
    public IRubyObject oid(ThreadContext context2) {
        return context2.runtime.newString(this.oidSym(context2.runtime));
    }

    private String oidSym(Ruby runtime) {
        String name2 = ASN1.oid2Sym(runtime, this.objectID, true);
        return name2 == null ? this.objectID.toString() : name2;
    }

    @JRubyMethod(name={"oid="})
    public IRubyObject set_oid(ThreadContext context2, IRubyObject arg) {
        if (arg instanceof RubyString) {
            this.setRealObjectID(arg.toString());
            return arg;
        }
        throw context2.runtime.newTypeError(arg, context2.runtime.getString());
    }

    @JRubyMethod
    public RubyString value(ThreadContext context2) {
        if (this.value instanceof RubyString) {
            return (RubyString)this.value;
        }
        Ruby runtime = context2.runtime;
        String oid2 = this.getRealObjectID().getId();
        try {
            if (oid2.equals("2.5.29.19")) {
                ASN1Sequence seq2 = (ASN1Sequence)ASN1.readObject(this.getRealValueEncoded());
                ByteList val = new ByteList(32);
                if (seq2.size() > 0) {
                    val.append(CA_);
                    ASN1Encodable obj0 = seq2.getObjectAt(0);
                    boolean bool = obj0 instanceof ASN1Boolean ? ((ASN1Boolean)obj0).isTrue() : ((DERBoolean)obj0).isTrue();
                    val.append(bool ? TRUE : FALSE);
                }
                if (seq2.size() > 1) {
                    val.append(", pathlen:".getBytes());
                    val.append(seq2.getObjectAt(1).toString().getBytes());
                }
                return runtime.newString(val);
            }
            if (oid2.equals("2.5.29.15")) {
                byte[] enc = this.getRealValueEncoded();
                byte b3 = 0;
                byte b2 = enc[2];
                if (enc.length > 3) {
                    b3 = enc[3];
                }
                ByteList val = new ByteList(64);
                byte[] sep = _;
                if ((b2 & 0xFFFFFF80) != 0) {
                    val.append(sep);
                    val.append(Decipher_Only);
                    sep = SEP;
                }
                if ((b3 & 0xFFFFFF80) != 0) {
                    val.append(sep);
                    val.append(Digital_Signature);
                    sep = SEP;
                }
                if ((b3 & 0x40) != 0) {
                    val.append(sep);
                    val.append(Non_Repudiation);
                    sep = SEP;
                }
                if ((b3 & 0x20) != 0) {
                    val.append(sep);
                    val.append(Key_Encipherment);
                    sep = SEP;
                }
                if ((b3 & 0x10) != 0) {
                    val.append(sep);
                    val.append(Data_Encipherment);
                    sep = SEP;
                }
                if ((b3 & 8) != 0) {
                    val.append(sep);
                    val.append(Key_Agreement);
                    sep = SEP;
                }
                if ((b3 & 4) != 0) {
                    val.append(sep);
                    val.append(Certificate_Sign);
                    sep = SEP;
                }
                if ((b3 & 2) != 0) {
                    val.append(sep);
                    val.append(CRL_Sign);
                    sep = SEP;
                }
                if ((b3 & 1) != 0) {
                    val.append(sep);
                    val.append(Encipher_Only);
                }
                return runtime.newString(val);
            }
            if (oid2.equals("2.16.840.1.113730.1.1")) {
                byte b0 = this.getRealValueEncoded()[0];
                ByteList val = new ByteList(64);
                byte[] sep = _;
                if ((b0 & 0xFFFFFF80) != 0) {
                    val.append(sep);
                    val.append(SSL_Client);
                    sep = SEP;
                }
                if ((b0 & 0x40) != 0) {
                    val.append(sep);
                    val.append(SSL_Server);
                    sep = SEP;
                }
                if ((b0 & 0x20) != 0) {
                    val.append(sep);
                    val.append(SMIME);
                    sep = SEP;
                }
                if ((b0 & 0x10) != 0) {
                    val.append(sep);
                    val.append(Object_Signing);
                    sep = SEP;
                }
                if ((b0 & 8) != 0) {
                    val.append(sep);
                    val.append(Unused);
                    sep = SEP;
                }
                if ((b0 & 4) != 0) {
                    val.append(sep);
                    val.append(SSL_CA);
                    sep = SEP;
                }
                if ((b0 & 2) != 0) {
                    val.append(sep);
                    val.append(SMIME_CA);
                    sep = SEP;
                }
                if ((b0 & 1) != 0) {
                    val.append(sep);
                    val.append(Object_Signing_CA);
                }
                return runtime.newString(val);
            }
            if (oid2.equals("2.5.29.14")) {
                byte[] octets;
                ASN1Encodable value2 = this.getRealValue();
                if (value2 instanceof ASN1OctetString && (octets = ((ASN1OctetString)value2).getOctets()).length > 0 && octets[0] == 4) {
                    value2 = ASN1.readObject(octets);
                }
                return runtime.newString(X509Extension.hexBytes(X509Extension.keyidBytes(value2.toASN1Primitive()), 0));
            }
            if (oid2.equals("2.5.29.35")) {
                ASN1Encodable value3 = this.getRealValue();
                if (value3 instanceof ASN1OctetString) {
                    value3 = ASN1.readObject(((ASN1OctetString)value3).getOctets());
                }
                ByteList val = new ByteList(72);
                val.append(keyid_);
                if (value3 instanceof ASN1Sequence) {
                    ASN1Sequence seq = (ASN1Sequence)value3;
                    int size2 = seq.size();
                    if (size2 == 0) {
                        return RubyString.newEmptyString((Ruby)runtime);
                    }
                    ASN1Primitive keyid = seq.getObjectAt(0).toASN1Primitive();
                    X509Extension.hexBytes(X509Extension.keyidBytes(keyid), val).append(10);
                    for (int i2 = 1; i2 < size2; ++i2) {
                        ASN1Encodable issuer2 = seq.getObjectAt(i2);
                        if (issuer2 instanceof ASN1TaggedObject) {
                            ASN1Primitive obj = ((ASN1TaggedObject)issuer2).getObject();
                            switch (((ASN1TaggedObject)issuer2).getTagNo()) {
                                case 1: {
                                    if (!(obj instanceof ASN1TaggedObject)) break;
                                    X509Extension.formatGeneralName(GeneralName.getInstance((Object)obj), val, true);
                                    break;
                                }
                                case 2: {
                                    val.append(new byte[]{115, 101, 114, 105, 97, 108, 58});
                                    X509Extension.hexBytes(((ASN1OctetString)obj).getOctets(), val);
                                }
                            }
                        }
                        val.append(10);
                    }
                    return runtime.newString(val);
                }
                X509Extension.hexBytes(X509Extension.keyidBytes(value3.toASN1Primitive()), val).append(10);
                return runtime.newString(val);
            }
            if (oid2.equals("2.5.29.21")) {
                IRubyObject value4 = this.getValue(runtime);
                switch (RubyNumeric.fix2int((IRubyObject)value4)) {
                    case 0: {
                        return runtime.newString(new ByteList(Unspecified));
                    }
                    case 1: {
                        return RubyString.newString((Ruby)runtime, (String)"Key Compromise");
                    }
                    case 2: {
                        return RubyString.newString((Ruby)runtime, (String)"CA Compromise");
                    }
                    case 3: {
                        return RubyString.newString((Ruby)runtime, (String)"Affiliation Changed");
                    }
                    case 4: {
                        return RubyString.newString((Ruby)runtime, (String)"Superseded");
                    }
                    case 5: {
                        return RubyString.newString((Ruby)runtime, (String)"Cessation Of Operation");
                    }
                    case 6: {
                        return RubyString.newString((Ruby)runtime, (String)"Certificate Hold");
                    }
                    case 8: {
                        return RubyString.newString((Ruby)runtime, (String)"Remove From CRL");
                    }
                    case 9: {
                        return RubyString.newString((Ruby)runtime, (String)"Privilege Withdrawn");
                    }
                }
                return runtime.newString(new ByteList(Unspecified));
            }
            if (oid2.equals("2.5.29.17") || oid2.equals("2.5.29.18")) {
                try {
                    ASN1Encodable value5 = this.getRealValue();
                    ByteList val = new ByteList(64);
                    if (value5 instanceof ASN1TaggedObject) {
                        X509Extension.formatGeneralName(GeneralName.getInstance((Object)value5), val, false);
                        return runtime.newString(val);
                    }
                    if (value5 instanceof GeneralName) {
                        X509Extension.formatGeneralName((GeneralName)value5, val, false);
                        return runtime.newString(val);
                    }
                    if (value5 instanceof ASN1OctetString) {
                        value5 = ASN1.readObject(((ASN1OctetString)value5).getOctets());
                    }
                    if (value5 instanceof ASN1TaggedObject) {
                        X509Extension.formatGeneralName(GeneralName.getInstance((Object)value5), val, false);
                        return runtime.newString(val);
                    }
                    GeneralName[] names = GeneralNames.getInstance((Object)value5).getNames();
                    for (int i3 = 0; i3 < names.length; ++i3) {
                        boolean other = X509Extension.formatGeneralName(names[i3], val, false);
                        if (i3 >= names.length - 1) continue;
                        if (other) {
                            val.append(59);
                            continue;
                        }
                        val.append(44).append(32);
                    }
                    return runtime.newString(val);
                }
                catch (IllegalArgumentException e) {
                    OpenSSL.debugStackTrace(runtime, e);
                    return this.rawValueAsString(context2);
                }
            }
            if (oid2.equals("2.5.29.37")) {
                ByteList val = new ByteList(64);
                if (this.value instanceof ASN1Sequence) {
                    ASN1Sequence seq = (ASN1Sequence)this.value;
                    int size3 = seq.size();
                    for (int i4 = 0; i4 < size3; ++i4) {
                        ASN1Encodable o = seq.getObjectAt(i4);
                        String name2 = o.toString();
                        Integer nid = ASN1.oid2nid(runtime, new ASN1ObjectIdentifier(name2));
                        if (nid != null) {
                            name2 = ASN1.nid2ln(runtime, nid);
                        }
                        if (name2 == null) {
                            name2 = o.toString();
                        }
                        val.append(ByteList.plain((CharSequence)name2));
                        if (i4 >= size3 - 1) continue;
                        val.append(44).append(32);
                    }
                    return runtime.newString(val);
                }
                IRubyObject value6 = this.getValue(runtime);
                if (value6 instanceof RubyArray) {
                    RubyArray arr = (RubyArray)value6;
                    int size4 = arr.size();
                    for (int i5 = 0; i5 < size4; ++i5) {
                        IRubyObject entry = arr.eltInternal(i5);
                        if ("ObjectId".equals(entry.getMetaClass().getBaseName())) {
                            entry = entry.callMethod(context2, "ln");
                        } else if (entry.respondsTo("value")) {
                            entry = entry.callMethod(context2, "value");
                        }
                        val.append(entry.asString().getByteList());
                        if (i5 >= size4 - 1) continue;
                        val.append(44).append(32);
                    }
                }
                return runtime.newString(val);
            }
            return this.rawValueAsString(context2);
        }
        catch (IOException e) {
            OpenSSL.debugStackTrace(runtime, e);
            throw X509Extension.newExtensionError(runtime, e);
        }
    }

    private RubyString rawValueAsString(ThreadContext context2) throws IOException {
        Ruby runtime = context2.runtime;
        IRubyObject value2 = this.getValue(runtime);
        if (value2 instanceof RubyArray) {
            RubyArray arr = (RubyArray)value2;
            ByteList strVal = new ByteList(64);
            int len = arr.size();
            for (int i2 = 0; i2 < len; ++i2) {
                IRubyObject entry = arr.eltInternal(i2);
                if (entry.respondsTo("value")) {
                    entry = entry.callMethod(context2, "value");
                }
                strVal.append(entry.asString().getByteList());
                if (i2 >= len - 1) continue;
                strVal.append(44).append(32);
            }
            return runtime.newString(strVal);
        }
        return value2.asString();
    }

    private static byte[] keyidBytes(ASN1Primitive keyid) throws IOException {
        if (keyid instanceof ASN1TaggedObject) {
            keyid = ((ASN1TaggedObject)keyid).getObject();
        }
        if (keyid instanceof ASN1OctetString) {
            return ((ASN1OctetString)keyid).getOctets();
        }
        return keyid.getEncoded("DER");
    }

    private static boolean formatGeneralName(GeneralName name2, ByteList out, boolean slashed) {
        ASN1Encodable obj = name2.getName();
        boolean tagged = false;
        switch (name2.getTagNo()) {
            case 1: {
                if (!tagged) {
                    out.append(101).append(109).append(97).append(105).append(108).append(58);
                }
                tagged = true;
            }
            case 2: {
                if (!tagged) {
                    out.append(68).append(78).append(83).append(58);
                }
                tagged = true;
            }
            case 6: {
                if (!tagged) {
                    out.append(85).append(82).append(73).append(58);
                }
                String val = DERIA5String.getInstance((Object)obj).getString();
                out.append(ByteList.plain((CharSequence)val));
                break;
            }
            case 4: {
                out.append(68).append(105).append(114).append(78).append(97).append(109).append(101).append(58);
                X500Name dirName = X500Name.getInstance((Object)obj);
                if (slashed) {
                    RDN[] rdns = dirName.getRDNs();
                    Hashtable defaultSymbols = X509Extension.getDefaultSymbols();
                    for (int i2 = 0; i2 < rdns.length; ++i2) {
                        X509Extension.appendRDN(out.append(47), rdns[i2], defaultSymbols);
                    }
                    break;
                }
                out.append(ByteList.plain((CharSequence)dirName.toString()));
                break;
            }
            case 7: {
                out.append(73).append(80).append(58);
                byte[] ip = ((ASN1OctetString)name2.getName()).getOctets();
                int len = ip.length;
                boolean ip4 = len == 4;
                for (int i3 = 0; i3 < ip.length; ++i3) {
                    out.append(ConvertBytes.intToCharBytes((int)(ip[i3] & 0xFF)));
                    if (i3 == len - 1) continue;
                    if (ip4) {
                        out.append(46);
                        continue;
                    }
                    out.append(58).append(58);
                }
                break;
            }
            case 0: {
                out.append(111).append(116).append(104).append(101).append(114).append(78).append(97).append(109).append(101).append(58);
                out.append(ByteList.plain((CharSequence)obj.toString()));
                return true;
            }
            case 8: {
                out.append(82).append(73).append(68).append(58);
            }
            default: {
                out.append(ByteList.plain((CharSequence)obj.toString()));
            }
        }
        return false;
    }

    public static ByteList appendRDN(ByteList out, RDN rdn, Map<ASN1ObjectIdentifier, String> oidSymbols) {
        if (rdn.isMultiValued()) {
            AttributeTypeAndValue[] atv = rdn.getTypesAndValues();
            boolean firstAtv = true;
            for (int j = 0; j != atv.length; ++j) {
                if (firstAtv) {
                    firstAtv = false;
                } else {
                    out.append(43);
                }
                X509Extension.appendTypeAndValue(out, atv[j], oidSymbols);
            }
            return out;
        }
        return X509Extension.appendTypeAndValue(out, rdn.getFirst(), oidSymbols);
    }

    private static ByteList appendTypeAndValue(ByteList out, AttributeTypeAndValue typeAndValue, Map<ASN1ObjectIdentifier, String> oidSymbols) {
        ASN1ObjectIdentifier type = typeAndValue.getType();
        String sym = oidSymbols.get(type);
        if (sym != null) {
            out.append(ByteList.plain((CharSequence)sym));
        } else {
            out.append(ByteList.plain((CharSequence)type.getId()));
        }
        out.append(61);
        X509Extension.valueToString(typeAndValue.getValue(), out);
        return out;
    }

    private static void valueToString(ASN1Encodable value2, ByteList out) {
        int size2 = out.getRealSize();
        if (value2 instanceof ASN1String && !(value2 instanceof DERUniversalString)) {
            String str = ((ASN1String)value2).getString();
            if (str.length() > 0 && str.charAt(0) == '#') {
                out.append(92);
            }
            out.append(ByteList.plain((CharSequence)str));
        } else {
            try {
                byte[] val = value2.toASN1Primitive().getEncoded("DER");
                out.append(35).append(Hex.encode((byte[])val));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Other value has no encoded form", e);
            }
        }
        int index = size2;
        int end = out.getRealSize() - size2;
        if (end >= 2 && out.charAt(index) == '\\' && out.charAt(index + 1) == '#') {
            index += 2;
        }
        while (index <= end) {
            char c = out.charAt(index);
            if (c == ',' || c == '\"' || c == '\\' || c == '+' || c == '=' || c == '<' || c == '>' || c == ';') {
                out.insert(index, 92);
                ++index;
                ++end;
            }
            ++index;
        }
        if (out.getRealSize() - size2 > 0) {
            index = size2;
            while (out.charAt(index) == ' ') {
                out.insert(index, 92);
                index += 2;
            }
        }
        for (index = out.getRealSize() - 1; index >= size2 && out.charAt(index) == ' '; --index) {
            out.insert(index, 92);
        }
    }

    private static Hashtable getDefaultSymbols() {
        try {
            Field field = BCStyle.class.getDeclaredField("DefaultSymbols");
            field.setAccessible(true);
            return (Hashtable)field.get(null);
        }
        catch (NoSuchFieldException ex) {
            OpenSSL.debug("getDefaultSymbols", ex);
        }
        catch (SecurityException ex) {
            OpenSSL.debug("getDefaultSymbols", ex);
        }
        catch (IllegalAccessException ex) {
            OpenSSL.debug("getDefaultSymbols", ex);
        }
        return new Hashtable();
    }

    @JRubyMethod(name={"value="})
    public IRubyObject set_value(ThreadContext context2, IRubyObject arg) {
        if (arg instanceof RubyString) {
            this.value = arg;
            return arg;
        }
        throw context2.runtime.newTypeError(arg, context2.runtime.getString());
    }

    @JRubyMethod(name={"critical?"})
    public IRubyObject critical_p(ThreadContext context2) {
        return context2.runtime.newBoolean(this.isRealCritical());
    }

    @JRubyMethod(name={"critical="})
    public IRubyObject set_critical(ThreadContext context2, IRubyObject arg) {
        this.setRealCritical(arg.isTrue());
        return arg;
    }

    @JRubyMethod
    public IRubyObject to_der() {
        try {
            byte[] enc = this.toASN1Sequence().getEncoded("DER");
            return StringHelper.newString(this.getRuntime(), enc);
        }
        catch (IOException e) {
            throw X509Extension.newExtensionError(this.getRuntime(), e);
        }
    }

    ASN1Sequence toASN1Sequence() throws IOException {
        ASN1EncodableVector vec = new ASN1EncodableVector();
        vec.add((ASN1Encodable)this.getRealObjectID());
        if (this.critical) {
            vec.add((ASN1Encodable)DERBoolean.TRUE);
        }
        vec.add((ASN1Encodable)new DEROctetString(this.getRealValueEncoded()));
        return new DLSequence(vec);
    }

    @JRubyMethod
    public RubyArray to_a(ThreadContext context2) {
        RubyArray array = RubyArray.newArray((Ruby)context2.runtime, (int)3);
        array.append(this.oid(context2));
        array.append((IRubyObject)this.value(context2));
        array.append(this.critical_p(context2));
        return array;
    }

    @JRubyMethod
    public RubyHash to_h(ThreadContext context2) {
        Ruby runtime = context2.runtime;
        RubyHash hash2 = RubyHash.newHash((Ruby)runtime);
        hash2.op_aset(context2, (IRubyObject)StringHelper.newStringFrozen(runtime, "oid"), this.oid(context2));
        hash2.op_aset(context2, (IRubyObject)StringHelper.newStringFrozen(runtime, "value"), (IRubyObject)this.value(context2));
        hash2.op_aset(context2, (IRubyObject)StringHelper.newStringFrozen(runtime, "critical"), this.critical_p(context2));
        return hash2;
    }

    @JRubyMethod
    public RubyString to_s(ThreadContext context2) {
        Ruby runtime = context2.runtime;
        RubyString str = RubyString.newString((Ruby)runtime, (String)this.oidSym(runtime));
        str.getByteList().append(32).append(61).append(32);
        if (this.isRealCritical()) {
            str.getByteList().append(critical__);
        }
        RubyString value2 = this.value(context2);
        value2.callMethod(context2, "gsub!", new IRubyObject[]{RubyString.newStringShared((Ruby)runtime, (ByteList)StringHelper.NEW_LINE), RubyString.newStringShared((Ruby)runtime, (ByteList)StringHelper.COMMA_SPACE)});
        str.getByteList().append(value2.getByteList());
        return str;
    }

    public X509Extension clone() {
        try {
            return (X509Extension)((Object)super.clone());
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException(ex);
        }
    }

    @JRubyMethod
    public IRubyObject inspect() {
        return ObjectSupport.inspect((RubyBasicObject)this);
    }

    static RaiseException newExtensionError(Ruby runtime, Exception e) {
        return Utils.newError(runtime, X509._X509(runtime).getClass("ExtensionError"), e);
    }

    static RaiseException newExtensionError(Ruby runtime, String message) {
        return Utils.newError(runtime, X509._X509(runtime).getClass("ExtensionError"), message);
    }

    private static boolean isHex(char c) {
        return '0' <= c && c <= '9' || 'A' <= c && c <= 'F' || 'a' <= c && c <= 'f';
    }

    static boolean isHex(String str) {
        for (int i2 = 0; i2 < str.length(); ++i2) {
            if (X509Extension.isHex(str.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    static int upHex(char c) {
        switch (c) {
            case '0': {
                return 48;
            }
            case '1': {
                return 49;
            }
            case '2': {
                return 50;
            }
            case '3': {
                return 51;
            }
            case '4': {
                return 52;
            }
            case '5': {
                return 53;
            }
            case '6': {
                return 54;
            }
            case '7': {
                return 55;
            }
            case '8': {
                return 56;
            }
            case '9': {
                return 57;
            }
            case 'A': 
            case 'a': {
                return 65;
            }
            case 'B': 
            case 'b': {
                return 66;
            }
            case 'C': 
            case 'c': {
                return 67;
            }
            case 'D': 
            case 'd': {
                return 68;
            }
            case 'E': 
            case 'e': {
                return 69;
            }
            case 'F': 
            case 'f': {
                return 70;
            }
        }
        return -1;
    }

    private static ByteList hexBytes(byte[] data, int off) {
        int len = data.length - off;
        return X509Extension.hexBytes(data, off, len, new ByteList(len * 3));
    }

    private static ByteList hexBytes(byte[] data, ByteList out) {
        return X509Extension.hexBytes(data, 0, data.length, out);
    }

    private static ByteList hexBytes(byte[] data, int off, int len, ByteList out) {
        boolean notFist = false;
        out.ensure(len * 3 - 1);
        for (int i2 = off; i2 < off + len; ++i2) {
            if (notFist) {
                out.append(58);
            }
            byte b = data[i2];
            out.append((int)HEX[b >> 4 & 0xF]);
            out.append((int)HEX[b & 0xF]);
            notFist = true;
        }
        return out;
    }
}

