/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.renderer;

import com.google.common.base.Optional;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.ui.renderer.OWLObjectRenderer;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.SWRLBuiltInAtom;
import org.semanticweb.owlapi.model.SWRLDArgument;
import org.semanticweb.owlapi.model.SWRLVariable;
import org.semanticweb.owlapi.util.OntologyIRIShortFormProvider;
import org.semanticweb.owlapi.util.ShortFormProvider;
import uk.ac.manchester.cs.owl.owlapi.mansyntaxrenderer.ManchesterOWLSyntaxObjectRenderer;

public class OWLObjectRendererImpl
implements OWLObjectRenderer {
    private final OWLModelManager mngr;
    private WriterDelegate writerDelegate;
    private ManchesterOWLSyntaxObjectRenderer delegate;
    private OntologyIRIShortFormProvider ontURISFP;

    public OWLObjectRendererImpl(OWLModelManager mngr) {
        this.mngr = mngr;
        this.writerDelegate = new WriterDelegate();
        this.delegate = new PatchedManchesterOWLSyntaxObjectRenderer(this.writerDelegate, new ShortFormProvider(){

            public String getShortForm(OWLEntity owlEntity) {
                return OWLObjectRendererImpl.this.mngr.getRendering((OWLObject)owlEntity);
            }

            public void dispose() {
            }
        });
        this.ontURISFP = new OntologyIRIShortFormProvider();
    }

    @Override
    public String render(OWLObject object) {
        if (object instanceof OWLOntology) {
            return this.renderOntology((OWLOntology)object);
        }
        this.writerDelegate.reset();
        object.accept((OWLObjectVisitor)this.delegate);
        return this.writerDelegate.toString();
    }

    private String renderOntology(OWLOntology ontology) {
        if (ontology.isAnonymous()) {
            return ontology.getOntologyID().toString();
        }
        Optional iri = ontology.getOntologyID().getDefaultDocumentIRI();
        if (iri.isPresent()) {
            return this.ontURISFP.getShortForm((IRI)iri.get());
        }
        return "Anonymous Ontology";
    }

    private class WriterDelegate
    extends Writer {
        private StringWriter delegate;

        private WriterDelegate() {
        }

        private void reset() {
            this.delegate = new StringWriter();
        }

        public String toString() {
            return this.delegate.getBuffer().toString();
        }

        @Override
        public void close() throws IOException {
            this.delegate.close();
        }

        @Override
        public void flush() throws IOException {
            this.delegate.flush();
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            this.delegate.write(cbuf, off, len);
        }
    }

    private class PatchedManchesterOWLSyntaxObjectRenderer
    extends ManchesterOWLSyntaxObjectRenderer {
        public PatchedManchesterOWLSyntaxObjectRenderer(Writer writer, ShortFormProvider entityShortFormProvider) {
            super(writer, entityShortFormProvider);
        }

        public void visit(IRI iri) {
            this.write(OWLObjectRendererImpl.this.mngr.getOWLEntityRenderer().render(iri));
        }

        public void visit(SWRLVariable node) {
            this.write("?");
            this.write(OWLObjectRendererImpl.this.mngr.getOWLEntityRenderer().render(node.getIRI()));
        }

        public void visit(SWRLBuiltInAtom node) {
            this.write(OWLObjectRendererImpl.this.mngr.getOWLEntityRenderer().render(node.getPredicate()));
            this.write("(");
            Iterator it = node.getArguments().iterator();
            while (it.hasNext()) {
                ((SWRLDArgument)it.next()).accept((OWLObjectVisitor)this);
                if (!it.hasNext()) continue;
                this.write(", ");
            }
            this.write(")");
        }
    }
}

