/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.ui.workspace;

import java.awt.BorderLayout;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.protege.editor.core.ui.tabbedpane.CloseableTabbedPaneUI;
import org.protege.editor.core.ui.tabbedpane.WorkspaceTabCloseHandler;
import org.protege.editor.core.ui.util.ComponentFactory;
import org.protege.editor.core.ui.workspace.CustomWorkspaceTabsManager;
import org.protege.editor.core.ui.workspace.TabbedWorkspaceStateManager;
import org.protege.editor.core.ui.workspace.Workspace;
import org.protege.editor.core.ui.workspace.WorkspaceTab;
import org.protege.editor.core.ui.workspace.WorkspaceTabPlugin;
import org.protege.editor.core.ui.workspace.WorkspaceTabPluginLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TabbedWorkspace
extends Workspace {
    private final Logger logger = LoggerFactory.getLogger(TabbedWorkspace.class);
    private final JTabbedPane tabbedPane = new JTabbedPane();
    private final Set<WorkspaceTab> workspaceTabs = new HashSet<WorkspaceTab>();

    public TabbedWorkspace() {
        this.tabbedPane.setUI(new CloseableTabbedPaneUI(CloseableTabbedPaneUI.TabClosability.CLOSABLE, new WorkspaceTabCloseHandler()));
        JPanel tabHolder = new JPanel(new BorderLayout());
        tabHolder.add(this.tabbedPane);
        this.setContent(this.tabbedPane);
    }

    public void initialise() {
        List<String> visibleTabs = new TabbedWorkspaceStateManager().getTabs();
        for (WorkspaceTabPlugin plugin : this.getOrderedPlugins()) {
            if (visibleTabs.isEmpty()) {
                if (!plugin.isProtegeDefaultTab()) continue;
                this.addTabForPlugin(plugin);
                continue;
            }
            if (!visibleTabs.contains(plugin.getId())) continue;
            this.addTabForPlugin(plugin);
        }
    }

    public WorkspaceTab addTabForPlugin(WorkspaceTabPlugin plugin) {
        WorkspaceTab tab = null;
        try {
            tab = (WorkspaceTab)plugin.newInstance();
            this.addTab(tab);
        }
        catch (Throwable e) {
            if (tab != null) {
                String msg = "An error occurred when creating the " + plugin.getLabel() + " tab.";
                tab.setLayout(new BorderLayout());
                tab.add(ComponentFactory.createExceptionComponent(msg, e, null));
            }
            this.logger.error("An error occurred when attempting to instantiate a tab plugin.  Tab plugin Id: {}.  Error details: {}", (Object)plugin.getId(), (Object)e);
        }
        return tab;
    }

    @Override
    public void save() {
        try {
            super.save();
            TabbedWorkspaceStateManager man = new TabbedWorkspaceStateManager(this);
            man.save();
            for (WorkspaceTab tab : this.getWorkspaceTabs()) {
                tab.save();
                this.logger.info("Saved tab state for '{}' tab", (Object)tab.getLabel());
            }
            this.logger.info("Saved workspace");
        }
        catch (Exception e) {
            this.logger.error("An error occurred whilst saving the workspace", (Throwable)e);
        }
    }

    public List<WorkspaceTabPlugin> getOrderedPlugins() {
        WorkspaceTabPluginLoader loader = new WorkspaceTabPluginLoader(this);
        ArrayList<WorkspaceTabPlugin> plugins = new ArrayList<WorkspaceTabPlugin>(loader.getPlugins());
        CustomWorkspaceTabsManager customTabsManager = this.getCustomTabsManager();
        plugins.addAll(customTabsManager.getCustomTabPlugins(this));
        Collections.sort(plugins, (o1, o2) -> o1.getIndex().compareTo(o2.getIndex()));
        return plugins;
    }

    public CustomWorkspaceTabsManager getCustomTabsManager() {
        return new CustomWorkspaceTabsManager();
    }

    public void addTab(WorkspaceTab workspaceTab) {
        this.tabbedPane.addTab(workspaceTab.getLabel(), workspaceTab.getIcon(), workspaceTab);
        this.workspaceTabs.add(workspaceTab);
        try {
            workspaceTab.initialise();
        }
        catch (Exception e) {
            this.tabbedPane.remove(workspaceTab);
            this.tabbedPane.addTab(workspaceTab.getLabel(), workspaceTab.getIcon(), this.createErrorPanel(e));
        }
    }

    public boolean containsTab(String tabId) {
        for (WorkspaceTab tab : this.getWorkspaceTabs()) {
            if (!tab.getId().equals(tabId)) continue;
            return true;
        }
        return false;
    }

    public int getTabCount() {
        return this.tabbedPane.getTabCount();
    }

    public void setSelectedTab(int index) {
        this.tabbedPane.setSelectedIndex(index);
    }

    private JComponent createErrorPanel(Exception e) {
        return ComponentFactory.createExceptionComponent(e.getMessage(), e, null);
    }

    public void removeTab(WorkspaceTab workspaceTab) {
        this.tabbedPane.remove(workspaceTab);
        this.workspaceTabs.remove(workspaceTab);
    }

    public void setSelectedTab(WorkspaceTab workspaceTab) {
        this.tabbedPane.setSelectedComponent(workspaceTab);
    }

    public WorkspaceTab getSelectedTab() {
        return (WorkspaceTab)this.tabbedPane.getSelectedComponent();
    }

    public Set<WorkspaceTab> getWorkspaceTabs() {
        return Collections.unmodifiableSet(this.workspaceTabs);
    }

    public WorkspaceTab getWorkspaceTab(String id) {
        for (WorkspaceTab tab : this.getWorkspaceTabs()) {
            if (!tab.getId().equals(id)) continue;
            return tab;
        }
        return null;
    }

    public abstract WorkspaceTab createWorkspaceTab(String var1);

    @Override
    public void dispose() {
        this.save();
        for (WorkspaceTab tab : this.workspaceTabs) {
            try {
                tab.dispose();
                this.logger.info("Disposed of '{}' tab", (Object)tab.getLabel());
            }
            catch (Exception e) {
                this.logger.warn("The {} tab threw an exception whilst being disposed.", (Object)tab.getLabel(), (Object)e);
            }
        }
        this.workspaceTabs.clear();
        this.tabbedPane.removeAll();
        super.dispose();
        this.logger.info("Disposed of workspace");
    }
}

