/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.jpeg;

import java.io.File;
import javax.swing.JOptionPane;
import tim.prune.I18nManager;
import tim.prune.jpeg.ExifLibrary;
import tim.prune.jpeg.JpegData;

public abstract class ExifGateway {
    private static ExifLibrary _exifLibrary = null;
    private static boolean _exifFailWarned = false;

    static {
        String string = "InternalExifLibrary";
        try {
            _exifLibrary = (ExifLibrary)Class.forName("tim.prune.jpeg." + string).newInstance();
        }
        catch (Throwable throwable) {
            _exifLibrary = null;
        }
    }

    public static JpegData getJpegData(File file) {
        try {
            if (_exifLibrary != null) {
                JpegData jpegData = _exifLibrary.getJpegData(file);
                return jpegData;
            }
        }
        catch (LinkageError linkageError) {
            System.err.println("Link: " + linkageError.getMessage());
            linkageError.printStackTrace();
        }
        if (!_exifFailWarned) {
            JOptionPane.showMessageDialog(null, I18nManager.getText("error.jpegload.exifreadfailed"), I18nManager.getText("error.jpegload.dialogtitle"), 2);
            _exifFailWarned = true;
        }
        return null;
    }

    public static String getDescriptionKey() {
        String string = "internal";
        if (_exifLibrary == null || !_exifLibrary.looksOK()) {
            string = String.valueOf(string) + ".failed";
        }
        return string;
    }

    public static final double convertToPositiveValue(int n, int n2) {
        if (n2 == 0) {
            return 0.0;
        }
        double d = n;
        double d2 = n2;
        if (n >= 0) {
            return d / d2;
        }
        double d3 = Math.pow(2.0, 32.0);
        d += d3;
        if (n2 < 0) {
            d2 += d3;
        }
        return d / d2;
    }

    public static final double convertToPositiveValue(long l, long l2) {
        if (l2 == 0L) {
            return 0.0;
        }
        double d = l;
        double d2 = l2;
        return d / d2;
    }
}

