/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.jmolpanel;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import javajs.util.PT;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.jmol.api.Interface;
import org.jmol.api.JmolAbstractButton;
import org.jmol.api.JmolAdapter;
import org.jmol.awt.FileDropper;
import org.jmol.awt.Platform;
import org.jmol.console.JmolButton;
import org.jmol.console.JmolToggleButton;
import org.jmol.dialog.Dialog;
import org.jmol.i18n.GT;
import org.jmol.util.Logger;
import org.jmol.util.Parser;
import org.jmol.viewer.Viewer;
import org.openscience.jmol.app.HistoryFile;
import org.openscience.jmol.app.Jmol;
import org.openscience.jmol.app.JmolApp;
import org.openscience.jmol.app.JmolPlugin;
import org.openscience.jmol.app.SplashInterface;
import org.openscience.jmol.app.jmolpanel.AboutDialog;
import org.openscience.jmol.app.jmolpanel.AtomSetChooser;
import org.openscience.jmol.app.jmolpanel.CreditsDialog;
import org.openscience.jmol.app.jmolpanel.DisplayPanel;
import org.openscience.jmol.app.jmolpanel.GaussianDialog;
import org.openscience.jmol.app.jmolpanel.GuiMap;
import org.openscience.jmol.app.jmolpanel.JmolResourceHandler;
import org.openscience.jmol.app.jmolpanel.MeasurementTable;
import org.openscience.jmol.app.jmolpanel.PovrayDialog;
import org.openscience.jmol.app.jmolpanel.PreferencesDialog;
import org.openscience.jmol.app.jmolpanel.RecentFilesDialog;
import org.openscience.jmol.app.jmolpanel.Splash;
import org.openscience.jmol.app.jmolpanel.StatusBar;
import org.openscience.jmol.app.jmolpanel.StatusListener;
import org.openscience.jmol.app.jmolpanel.WhatsNewDialog;
import org.openscience.jmol.app.jmolpanel.console.AppConsole;
import org.openscience.jmol.app.jmolpanel.console.ConsoleTextArea;
import org.openscience.jmol.app.jsonkiosk.BannerFrame;
import org.openscience.jmol.app.jsonkiosk.JsonNioClient;
import org.openscience.jmol.app.jsonkiosk.JsonNioServer;
import org.openscience.jmol.app.jsonkiosk.KioskFrame;
import org.openscience.jmol.app.surfacetool.SurfaceTool;
import org.openscience.jmol.app.webexport.WebExport;

public class JmolPanel
extends JPanel
implements SplashInterface,
JsonNioClient {
    protected static HistoryFile historyFile;
    protected static HistoryFile pluginFile;
    public Viewer vwr;
    JmolAdapter modelAdapter;
    JmolApp jmolApp;
    StatusBar status;
    int startupWidth;
    int startupHeight;
    JsonNioServer serverService;
    protected String appletContext;
    protected PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    protected DisplayPanel display;
    protected GaussianDialog gaussianDialog;
    protected RecentFilesDialog recentFiles;
    protected AtomSetChooser atomSetChooser;
    public JFrame frame;
    protected SplashInterface splash;
    protected JFrame consoleframe;
    protected JsonNioServer service;
    protected int qualityJPG = -1;
    protected int qualityPNG = -1;
    protected String imageType;
    public GuiMap guimap = new GuiMap();
    private ExecuteScriptAction executeScriptAction;
    PreferencesDialog preferencesDialog;
    private StatusListener myStatusListener;
    private SurfaceTool surfaceTool;
    private Map<String, Action> commands;
    private Map<String, JMenuItem> menuItems;
    private JToolBar toolbar;
    private ExportAction exportAction = new ExportAction();
    private PovrayAction povrayAction = new PovrayAction();
    private ToWebAction toWebAction = new ToWebAction();
    private WriteAction writeAction = new WriteAction();
    private PrintAction printAction = new PrintAction();
    private CopyImageAction copyImageAction = new CopyImageAction();
    private CopyScriptAction copyScriptAction = new CopyScriptAction();
    private SurfaceToolAction surfaceToolAction = new SurfaceToolAction();
    private PasteClipboardAction pasteClipboardAction = new PasteClipboardAction();
    private ViewMeasurementTableAction viewMeasurementTableAction = new ViewMeasurementTableAction();
    Map<String, Object> vwrOptions;
    private static int numWindows;
    private static KioskFrame kioskFrame;
    private static BannerFrame bannerFrame;
    private static final String EDITOR_WINDOW_NAME = "ScriptEditor";
    private static final String SCRIPT_WINDOW_NAME = "ScriptWindow";
    private static final String FILE_OPEN_WINDOW_NAME = "FileOpen";
    private static final String WEB_MAKER_WINDOW_NAME = "JmolWebPageMaker";
    private static final String SURFACETOOL_WINDOW_NAME = "SurfaceToolWindow";
    private static final Dimension screenSize;
    private static final String newwinAction = "newwin";
    private static final String openAction = "open";
    private static final String openurlAction = "openurl";
    private static final String openpdbAction = "openpdb";
    private static final String openmolAction = "openmol";
    private static final String newAction = "new";
    private static final String exportActionProperty = "export";
    private static final String closeAction = "close";
    private static final String exitAction = "exit";
    private static final String aboutAction = "about";
    private static final String whatsnewAction = "whatsnew";
    private static final String creditsAction = "credits";
    private static final String uguideAction = "uguide";
    private static final String printActionProperty = "print";
    private static final String recentFilesAction = "recentFiles";
    private static final String povrayActionProperty = "povray";
    private static final String writeActionProperty = "write";
    private static final String editorAction = "editor";
    private static final String consoleAction = "console";
    private static final String toWebActionProperty = "toweb";
    private static final String atomsetchooserAction = "atomsetchooser";
    private static final String copyImageActionProperty = "copyImage";
    private static final String copyScriptActionProperty = "copyScript";
    private static final String surfaceToolActionProperty = "surfaceTool";
    private static final String pasteClipboardActionProperty = "pasteClipboard";
    private static final String gaussianAction = "gauss";
    private static final String resizeAction = "resize";
    Map<String, JmolPlugin> plugins = new Hashtable<String, JmolPlugin>();
    JMenu pluginMenu;
    private Action[] defaultActions = new Action[]{new NewAction(), new NewwinAction(), new OpenAction(), new OpenUrlAction(), new OpenPdbAction(), new OpenMolAction(), this.printAction, this.exportAction, new CloseAction(), new ExitAction(), this.copyImageAction, this.copyScriptAction, this.pasteClipboardAction, new AboutAction(), new WhatsNewAction(), new CreditsAction(), new UguideAction(), new ConsoleAction(), new RecentFilesAction(), this.povrayAction, this.writeAction, this.toWebAction, new ScriptWindowAction(), new ScriptEditorAction(), new AtomSetChooserAction(), this.viewMeasurementTableAction, new GaussianAction(), new ResizeAction(), this.surfaceToolAction};
    static final String[] imageChoices;
    static final String[] imageExtensions;
    WebExport webExport;
    static final String chemFileProperty = "chemFile";

    public JmolPanel(JmolApp jmolApp, Splash splash, JFrame frame, JmolPanel parent, int startupWidth, int startupHeight, Map<String, Object> vwrOptions, Point loc) {
        super(true);
        this.jmolApp = jmolApp;
        this.frame = frame;
        this.startupWidth = startupWidth;
        this.startupHeight = startupHeight;
        historyFile = jmolApp.historyFile;
        pluginFile = jmolApp.pluginFile;
        ++numWindows;
        try {
            this.say("history file is " + historyFile.getFile().getAbsolutePath());
            this.say("user properties file is " + jmolApp.userPropsFile.getAbsolutePath());
        }
        catch (Exception e) {
            // empty catch block
        }
        frame.setTitle("Jmol");
        frame.setDefaultCloseOperation(0);
        frame.getContentPane().setBackground(Color.lightGray);
        frame.getContentPane().setLayout(new BorderLayout());
        this.splash = splash;
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setLayout(new BorderLayout());
        this.status = new StatusBar();
        this.say(GT._("Initializing 3D display..."));
        this.display = new DisplayPanel(this);
        if (vwrOptions == null) {
            vwrOptions = new Hashtable<String, Object>();
        }
        vwrOptions.put("display", this.display);
        this.myStatusListener = new StatusListener(this, this.display);
        vwrOptions.put("statusListener", this.myStatusListener);
        if (JmolResourceHandler.codePath != null) {
            vwrOptions.put("codePath", JmolResourceHandler.codePath);
        }
        if (this.modelAdapter != null) {
            vwrOptions.put("modelAdapter", this.modelAdapter);
        }
        this.vwrOptions = vwrOptions;
        this.vwr = new Viewer(vwrOptions);
        this.display.setViewer(this.vwr);
        this.myStatusListener.setViewer(this.vwr);
        if (!jmolApp.haveDisplay) {
            return;
        }
        this.getDialogs();
        this.say(GT._("Initializing Script Window..."));
        this.vwr.getProperty("DATA_API", "getAppConsole", Boolean.TRUE);
        this.say(GT._("Building Command Hooks..."));
        this.commands = new Hashtable<String, Action>();
        if (this.display != null) {
            List<Action> actions = this.getActions();
            for (int i = 0; i < actions.size(); ++i) {
                Action a = actions.get(i);
                this.commands.put(a.getValue("Name").toString(), a);
            }
        }
        if (jmolApp.isKiosk) {
            this.add("Center", this.display);
        } else {
            JPanel panel = new JPanel();
            this.menuItems = new Hashtable<String, JMenuItem>();
            this.say(GT._("Building Menubar..."));
            this.executeScriptAction = new ExecuteScriptAction();
            JMenuBar menubar = this.createMenubar();
            this.add("North", menubar);
            panel.setLayout(new BorderLayout());
            this.toolbar = this.createToolbar();
            panel.add("North", this.toolbar);
            JPanel ip = new JPanel();
            ip.setLayout(new BorderLayout());
            ip.add("Center", this.display);
            panel.add("Center", ip);
            this.add("Center", panel);
            this.add("South", this.status);
        }
        this.say(GT._("Starting display..."));
        this.display.start();
        if (jmolApp.isKiosk) {
            bannerFrame = new BannerFrame(jmolApp.startupWidth, 75);
        } else if (loc != null) {
            frame.setLocation(loc);
        } else if (parent == null) {
            loc = historyFile.getWindowPosition("Jmol");
            if (loc != null) {
                frame.setLocation(loc);
            }
        } else {
            loc = parent.frame.getLocationOnScreen();
            int maxX = JmolPanel.screenSize.width - 50;
            int maxY = JmolPanel.screenSize.height - 50;
            loc.x += 40;
            loc.y += 40;
            if (loc.x > maxX || loc.y > maxY) {
                loc.setLocation(0, 0);
            }
            frame.setLocation(loc);
        }
        frame.getContentPane().add("Center", this);
        frame.addWindowListener(new AppCloser());
        frame.pack();
        frame.setSize(startupWidth, startupHeight);
        ImageIcon jmolIcon = JmolResourceHandler.getIconX("icon");
        Image iconImage = jmolIcon.getImage();
        frame.setIconImage(iconImage);
        AppConsole console = (AppConsole)this.vwr.getProperty("DATA_API", "getAppConsole", null);
        if (console != null && console.jcd != null) {
            historyFile.repositionWindow(SCRIPT_WINDOW_NAME, console.jcd, 200, 100, !jmolApp.isKiosk);
        }
        console.setStatusListener(this.myStatusListener);
        this.say(GT._("Setting up Drag-and-Drop..."));
        new FileDropper(this.myStatusListener, this.vwr, null);
        this.atomSetChooser = new AtomSetChooser(this.vwr, frame);
        this.pcs.addPropertyChangeListener(chemFileProperty, this.atomSetChooser);
        this.say(GT._("Launching main frame..."));
    }

    private void getDialogs() {
        this.say(GT._("Initializing Preferences..."));
        this.preferencesDialog = new PreferencesDialog(this, this.frame, this.guimap, this.vwr);
        this.say(GT._("Initializing Recent Files..."));
        this.recentFiles = new RecentFilesDialog(this.frame);
        if (this.jmolApp.haveDisplay) {
            if (this.display.measurementTable != null) {
                this.display.measurementTable.dispose();
            }
            this.display.measurementTable = new MeasurementTable(this.vwr, this.frame);
        }
    }

    protected static void startJmol(JmolApp jmolApp) {
        block12: {
            JFrame jmolFrame;
            Dialog.setupUIManager();
            if (jmolApp.isKiosk) {
                if (jmolApp.startupWidth < 100 || jmolApp.startupHeight < 100) {
                    jmolApp.startupWidth = JmolPanel.screenSize.width;
                    jmolApp.startupHeight = JmolPanel.screenSize.height - 75;
                }
                kioskFrame = new KioskFrame(0, 75, jmolApp.startupWidth, jmolApp.startupHeight, null);
                jmolFrame = kioskFrame;
            } else {
                jmolFrame = new JFrame();
            }
            Jmol jmol = null;
            try {
                if (jmolApp.jmolPosition != null) {
                    jmolFrame.setLocation(jmolApp.jmolPosition);
                }
                jmol = JmolPanel.getJmol(jmolApp, jmolFrame);
                jmolApp.startViewer(jmol.vwr, jmol.splash, false);
            }
            catch (Throwable t) {
                Logger.error("uncaught exception: " + t);
                t.printStackTrace();
            }
            if (jmolApp.haveConsole) {
                JmolPanel.getJavaConsole(jmol);
            }
            if (jmolApp.isKiosk) {
                kioskFrame.setPanel(jmol);
                bannerFrame.setLabel("click below and type exitJmol[enter] to quit");
                jmol.vwr.script("set allowKeyStrokes;set zoomLarge false;");
            }
            if (jmolApp.port > 0) {
                try {
                    jmol.service = JmolPanel.getJsonNioServer();
                    jmol.service.startService(jmolApp.port, jmol, jmol.vwr, "-1", 1);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    if (bannerFrame != null) {
                        bannerFrame.setLabel("could not start NIO service on port " + jmolApp.port);
                    }
                    if (jmol.service == null) break block12;
                    jmol.service.close();
                }
            }
        }
    }

    private static void getJavaConsole(Jmol jmol) {
        jmol.consoleframe = new JFrame(GT._("Jmol Java Console"));
        jmol.consoleframe.setIconImage(jmol.frame.getIconImage());
        try {
            final ConsoleTextArea consoleTextArea = new ConsoleTextArea(true);
            consoleTextArea.setFont(Font.decode("monospaced"));
            jmol.consoleframe.getContentPane().add((Component)new JScrollPane(consoleTextArea), "Center");
            JButton buttonClear = jmol.guimap.newJButton("JavaConsole.Clear");
            buttonClear.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    consoleTextArea.setText("");
                }
            });
            jmol.consoleframe.getContentPane().add((Component)buttonClear, "South");
        }
        catch (IOException e) {
            JTextArea errorTextArea = new JTextArea();
            errorTextArea.setFont(Font.decode("monospaced"));
            jmol.consoleframe.getContentPane().add((Component)new JScrollPane(errorTextArea), "Center");
            errorTextArea.append(GT._("Could not create ConsoleTextArea: ") + e);
        }
        Point location = jmol.frame.getLocation();
        Dimension size = jmol.frame.getSize();
        location.y += size.height;
        size.height = 200;
        if (size.height < 200 || size.height > 800) {
            size.height = 200;
        }
        if (size.width < 300 || size.width > 800) {
            size.width = 300;
        }
        if (location.y < 0 || location.y + size.height > JmolPanel.screenSize.height) {
            location.y = JmolPanel.screenSize.height - size.height;
        }
        if (location.x < 0 || location.x + size.width > JmolPanel.screenSize.width) {
            location.x = 0;
        }
        jmol.consoleframe.setBounds(location.x, location.y, size.width, size.height);
    }

    public static Jmol getJmol(JmolApp jmolApp, JFrame frame) {
        Splash splash = null;
        if (jmolApp.haveDisplay && jmolApp.splashEnabled) {
            ImageIcon splash_image = JmolResourceHandler.getIconX("splash");
            if (!jmolApp.isSilent) {
                Logger.info("splash_image=" + splash_image);
            }
            splash = new Splash(frame, splash_image);
            splash.setCursor(new Cursor(3));
            splash.showStatus(GT._("Creating main window..."));
            splash.showStatus(GT._("Initializing Swing..."));
        }
        if (jmolApp.haveDisplay) {
            try {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            }
            catch (Exception exc) {
                System.err.println("Error loading L&F: " + exc);
            }
        }
        if (splash != null) {
            splash.showStatus(GT._("Initializing Jmol..."));
        }
        Jmol window = new Jmol(jmolApp, splash, frame, null, jmolApp.startupWidth, jmolApp.startupHeight, jmolApp.info, null);
        if (jmolApp.haveDisplay) {
            frame.setVisible(true);
        }
        return window;
    }

    @Override
    public void showStatus(String message) {
        this.splash.showStatus(message);
    }

    private void report(String str) {
        if (this.jmolApp.isSilent) {
            return;
        }
        Logger.info(str);
    }

    private void say(String message) {
        if (this.jmolApp.haveDisplay) {
            if (this.splash == null) {
                this.report(message);
            } else {
                this.splash.showStatus(message);
            }
        }
    }

    public List<Action> getActions() {
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.addAll(Arrays.asList(this.defaultActions));
        actions.addAll(Arrays.asList(this.display.getActions()));
        actions.addAll(Arrays.asList(this.preferencesDialog.getActions()));
        return actions;
    }

    protected boolean doClose(boolean saveSize) {
        if (numWindows == 1 && this.vwr.ms.ac > 0 && JOptionPane.showConfirmDialog(this.frame, GT._("Exit Jmol?"), "Exit", 0, 3) != 0) {
            return false;
        }
        this.dispose(this.frame, saveSize);
        return true;
    }

    void dispose(JFrame f, boolean saveSize) {
        if (this.webExport != null) {
            WebExport.cleanUp();
        }
        if (saveSize) {
            this.saveWindowSizes();
        }
        if (this.service != null) {
            this.service.close();
            this.service = null;
        }
        if (this.serverService != null) {
            this.serverService.close();
            this.serverService = null;
        }
        for (Map.Entry<String, JmolPlugin> e : this.plugins.entrySet()) {
            try {
                e.getValue().destroy();
            }
            catch (Throwable err) {}
        }
        this.plugins.clear();
        if (numWindows <= 1) {
            this.report(GT._("Closing Jmol..."));
            System.exit(0);
        } else {
            --numWindows;
            this.vwr.dispose();
            try {
                f.dispose();
            }
            catch (Exception e) {
                Logger.error("frame disposal exception");
            }
        }
    }

    void saveWindowSizes() {
        Component c;
        AppConsole console;
        if (historyFile == null) {
            return;
        }
        if (this.frame != null) {
            this.jmolApp.border.x = this.frame.getWidth() - this.display.dimSize.width;
            this.jmolApp.border.y = this.frame.getHeight() - this.display.dimSize.height;
            historyFile.addWindowInfo("Jmol", this.frame, this.jmolApp.border);
        }
        if ((console = (AppConsole)this.vwr.getProperty("DATA_API", "getAppConsole", null)) != null && console.jcd != null) {
            historyFile.addWindowInfo(SCRIPT_WINDOW_NAME, console.jcd, null);
        }
        if ((c = (Component)this.vwr.getProperty("DATA_API", "getScriptEditor", null)) != null) {
            historyFile.addWindowInfo(EDITOR_WINDOW_NAME, c, null);
        }
        if (historyFile.getProperty("clearHistory", "false").equals("true")) {
            historyFile.clear();
        }
    }

    private JMenuItem createMenuItem(String cmd) {
        JMenuItem mi = cmd.endsWith("Check") ? this.guimap.newJCheckBoxMenuItem(cmd, false) : this.guimap.newJMenuItem(cmd);
        ImageIcon f = JmolResourceHandler.getIconX(cmd + "Image");
        if (f != null) {
            mi.setHorizontalTextPosition(4);
            mi.setIcon(f);
        }
        if (cmd.endsWith("Script")) {
            mi.setActionCommand(JmolResourceHandler.getStringX(cmd));
            mi.addActionListener(this.executeScriptAction);
        } else {
            mi.setActionCommand(cmd);
            Action a = this.getAction(cmd);
            if (a != null) {
                mi.addActionListener(a);
                a.addPropertyChangeListener(new ActionChangedListener(mi));
                mi.setEnabled(a.isEnabled());
            } else {
                mi.setEnabled(false);
            }
        }
        this.menuItems.put(cmd, mi);
        return mi;
    }

    protected JMenuItem getMenuItem(String cmd) {
        return this.menuItems.get(cmd);
    }

    protected Action getAction(String cmd) {
        return this.commands.get(cmd);
    }

    private JToolBar createToolbar() {
        this.toolbar = new JToolBar();
        String[] tool1Keys = PT.getTokens(JmolResourceHandler.getStringX("toolbar"));
        for (int i = 0; i < tool1Keys.length; ++i) {
            if (tool1Keys[i].equals("-")) {
                this.toolbar.addSeparator();
                continue;
            }
            this.toolbar.add(this.createTool(tool1Keys[i]));
        }
        this.toolbar.add(Box.createHorizontalGlue());
        return this.toolbar;
    }

    protected Component createTool(String key) {
        return this.createToolbarButton(key);
    }

    protected AbstractButton createToolbarButton(String key) {
        boolean isToggle;
        ImageIcon ii = JmolResourceHandler.getIconX(key + "Image");
        boolean isHoldButton = key.startsWith("animatePrev") || key.startsWith("animateNext");
        AbstractButton b = isHoldButton ? new AnimButton(ii, JmolResourceHandler.getStringX(key)) : new JmolButton(ii);
        String isToggleString = JmolResourceHandler.getStringX(key + "Toggle");
        if (isToggleString != null && (isToggle = Boolean.valueOf(isToggleString).booleanValue())) {
            b = new JmolToggleButton(ii);
            if (key.equals("rotateScript")) {
                this.display.buttonRotate = b;
            }
            if (key.equals("modelkitScript")) {
                this.display.buttonModelkit = b;
            }
            this.display.toolbarButtonGroup.add(b);
            String isSelectedString = JmolResourceHandler.getStringX(key + "ToggleSelected");
            if (isSelectedString != null) {
                boolean isSelected = Boolean.valueOf(isSelectedString);
                b.setSelected(isSelected);
            }
        }
        b.setRequestFocusEnabled(false);
        b.setMargin(new Insets(1, 1, 1, 1));
        Action a = null;
        String actionCommand = null;
        if (!isHoldButton) {
            if (key.endsWith("Script")) {
                actionCommand = JmolResourceHandler.getStringX(key);
                a = this.executeScriptAction;
            } else {
                actionCommand = key;
                a = this.getAction(key);
            }
        }
        if (a != null) {
            b.setActionCommand(actionCommand);
            b.addActionListener(a);
            a.addPropertyChangeListener(new ActionChangedListener(b));
            b.setEnabled(a.isEnabled());
        } else {
            b.setEnabled(isHoldButton);
        }
        String tip = this.guimap.getLabel(key + "Tip");
        if (tip != null) {
            this.guimap.map.put(key + "Tip", b);
            b.setToolTipText(tip);
        }
        return b;
    }

    private JMenuBar createMenubar() {
        JMenuBar mb = new JMenuBar();
        this.addNormalMenuBar(mb);
        this.addPluginMenu(mb);
        this.addMacrosMenu(mb);
        this.addHelpMenuBar(mb);
        return mb;
    }

    private void addPluginMenu(JMenuBar mb) {
        this.pluginMenu = this.guimap.newJMenu("plugins");
        try {
            PropertyResourceBundle bundle = new PropertyResourceBundle(this.getClass().getResourceAsStream("/org/openscience/jmol/app/plugins/plugin.properties"));
            Enumeration<String> keys = bundle.getKeys();
            while (keys.hasMoreElements()) {
                String path;
                final String key = keys.nextElement();
                JmolPlugin p = this.plugins.get(key);
                if (p != null || (path = bundle.getString(key)) == null | path.length() == 0) continue;
                try {
                    p = this.getAndRegisterPlugin(key, path);
                    if (p == null) continue;
                    String text = p.getMenuText();
                    ImageIcon icon = p.getMenuIcon();
                    if (text == null) {
                        text = key;
                    }
                    JMenuItem item = new JMenuItem(text);
                    if (icon != null) {
                        item.setHorizontalTextPosition(4);
                        item.setIcon(icon);
                    }
                    this.pluginMenu.add(item);
                    item.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            JmolPanel.this.showPlugin(key, null, null);
                        }
                    });
                }
                catch (Exception e) {
                    System.out.println("Cannot create plugin " + key + " " + path);
                }
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.toString());
        }
        mb.add(this.pluginMenu);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMacrosMenu(JMenuBar menuBar) {
        JMenu macroMenu = this.guimap.newJMenu("macros");
        File macroDir = new File(System.getProperty("user.home") + System.getProperty("file.separator") + ".jmol" + System.getProperty("file.separator") + "macros");
        this.report("User macros dir: " + macroDir);
        this.report("       exists: " + macroDir.exists());
        this.report("  isDirectory: " + macroDir.isDirectory());
        if (macroDir.exists() && macroDir.isDirectory()) {
            File[] macros = macroDir.listFiles();
            for (int i = 0; i < macros.length; ++i) {
                String macroName = macros[i].getName();
                if (!macroName.endsWith(".macro")) continue;
                if (Logger.debugging) {
                    Logger.debug("Possible macro found: " + macroName);
                }
                FileInputStream macro = null;
                try {
                    macro = new FileInputStream(macros[i]);
                    Properties macroProps = new Properties();
                    macroProps.load(macro);
                    String macroTitle = macroProps.getProperty("Title");
                    String macroScript = macroProps.getProperty("Script");
                    JMenuItem mi = new JMenuItem(macroTitle);
                    mi.setActionCommand(macroScript);
                    mi.addActionListener(this.executeScriptAction);
                    macroMenu.add(mi);
                    continue;
                }
                catch (IOException exception) {
                    System.err.println("Could not load macro file: ");
                    System.err.println(exception);
                    continue;
                }
                finally {
                    if (macro != null) {
                        try {
                            macro.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
        }
        menuBar.add(macroMenu);
    }

    private void addNormalMenuBar(JMenuBar menuBar) {
        String[] menuKeys = PT.getTokens(JmolResourceHandler.getStringX("menubar"));
        for (int i = 0; i < menuKeys.length; ++i) {
            if (menuKeys[i].equals("-")) {
                menuBar.add(Box.createHorizontalGlue());
                continue;
            }
            JMenu m = this.createMenu(menuKeys[i]);
            if (m == null) continue;
            menuBar.add(m);
        }
    }

    private void addHelpMenuBar(JMenuBar menuBar) {
        JMenu m = this.createMenu("help");
        if (m != null) {
            menuBar.add(m);
        }
    }

    JMenu createMenu(String key) {
        String[] itemKeys = PT.getTokens(JmolResourceHandler.getStringX(key));
        JMenu menu = this.guimap.newJMenu(key);
        ImageIcon f = JmolResourceHandler.getIconX(key + "Image");
        if (f != null) {
            menu.setHorizontalTextPosition(4);
            menu.setIcon(f);
        }
        for (int i = 0; i < itemKeys.length; ++i) {
            String item = itemKeys[i];
            if (item.equals("-")) {
                menu.addSeparator();
                continue;
            }
            if (item.endsWith("Menu")) {
                menu.add(this.createMenu(item));
                continue;
            }
            JMenuItem mi = this.createMenuItem(item);
            menu.add(mi);
        }
        menu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                String menuKey = ((JmolAbstractButton)e.getSource()).getKey();
                if (menuKey.equals("display") || menuKey.equals("tools")) {
                    JmolPanel.this.setMenuState();
                }
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
        return menu;
    }

    void setMenuState() {
        this.guimap.setSelected("perspectiveCheck", this.vwr.tm.perspectiveDepth);
        this.guimap.setSelected("hydrogensCheck", this.vwr.getBoolean(603979922));
        this.guimap.setSelected("measurementsCheck", this.vwr.getBoolean(603979926));
        this.guimap.setSelected("axesCheck", this.vwr.getShowAxes());
        this.guimap.setSelected("boundboxCheck", this.vwr.getShowBbcage());
        this.guimap.setEnabled("openJSpecViewScript", !this.vwr.getBoolean(1073742086));
        this.guimap.setEnabled("simulate1HSpectrumScript", !this.vwr.getBoolean(1073742086));
        this.guimap.setEnabled("simulate13CSpectrumScript", !this.vwr.getBoolean(1073742086));
    }

    void doNew() {
        JFrame newFrame = new JFrame();
        new Jmol(this.jmolApp, null, newFrame, (Jmol)this, this.startupWidth, this.startupHeight, this.vwrOptions, null);
        newFrame.setVisible(true);
    }

    void setMenuNBO(JMenu item) {
    }

    void startNBO(Map<String, Object> jmolOptions) {
        this.showPlugin("NBO", "org.gennbo.NBOPlugin", jmolOptions);
    }

    void showPlugin(String name, String path, Map<String, Object> jmolOptions) {
        try {
            JmolPlugin p = this.getAndRegisterPlugin(name, path);
            if (!p.isStarted()) {
                p.start(this.frame, this.vwr, jmolOptions);
            }
            p.setVisible(true);
        }
        catch (Throwable e) {
            System.out.println("Error creating plugin " + name);
            e.printStackTrace();
        }
    }

    private JmolPlugin getAndRegisterPlugin(String name, String path) {
        JmolPlugin p = this.plugins.get(name);
        if (p == null) {
            p = (JmolPlugin)Interface.getInterface(path, this.vwr, "plugin");
            this.plugins.put(name, p);
        }
        return p;
    }

    public static Object getInstanceWithParams(String name, Class<?>[] classes, Object ... params) {
        try {
            Class<?> cl = Class.forName(name);
            return cl.getConstructor(classes).newInstance(params);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void print() {
        PrinterJob job = PrinterJob.getPrinterJob();
        job.setPrintable(this.display);
        if (job.printDialog()) {
            try {
                job.print();
            }
            catch (PrinterException e) {
                Logger.errorEx("Error while printing", e);
            }
        }
    }

    String createImageStatus(String fileName, String type, Object text_or_bytes, int quality) {
        if (fileName != null && text_or_bytes != null) {
            return null;
        }
        String msg = fileName;
        if (msg != null && !msg.startsWith("OK") && this.status != null) {
            this.status.setStatus(1, GT._("IO Exception:"));
            this.status.setStatus(2, msg);
        }
        return msg;
    }

    void createWebExport() {
        this.webExport = WebExport.createAndShowGUI(this.vwr, historyFile, WEB_MAKER_WINDOW_NAME);
    }

    void createSurfaceTool() {
        if (this.surfaceTool != null) {
            this.surfaceTool.toFront();
        } else {
            this.surfaceTool = new SurfaceTool(this.vwr, historyFile, SURFACETOOL_WINDOW_NAME, true);
        }
    }

    public static File getUserDirectory() {
        String dir = System.getProperty("user.dir");
        return dir == null ? null : new File(System.getProperty("user.dir"));
    }

    void openFile() {
        String fileName = new Dialog().getOpenFileNameFromDialog(this.vwrOptions, this.vwr, null, this.jmolApp, FILE_OPEN_WINDOW_NAME, true);
        if (fileName == null) {
            return;
        }
        int flags = 9;
        if (fileName.startsWith("#NOCARTOONS#;")) {
            --flags;
            fileName = fileName.substring(13);
        }
        if (fileName.startsWith("#APPEND#;")) {
            fileName = fileName.substring(9);
            flags += 4;
        }
        this.vwr.openFileAsyncSpecial(fileName, flags);
    }

    void notifyFileOpen(String fullPathName, String title) {
        if (fullPathName == null || !fullPathName.equals("String[]")) {
            int pt;
            int n = pt = fullPathName == null ? -1 : fullPathName.lastIndexOf("|");
            if (pt > 0) {
                fullPathName = fullPathName.substring(0, pt);
            }
            this.recentFiles.notifyFileOpen(fullPathName);
            this.frame.setTitle(title);
        }
        if (this.atomSetChooser == null) {
            this.atomSetChooser = new AtomSetChooser(this.vwr, this.frame);
            this.pcs.addPropertyChangeListener(chemFileProperty, this.atomSetChooser);
        }
        this.pcs.firePropertyChange(chemFileProperty, null, null);
    }

    int[] resizeInnerPanel(String data) {
        int width = this.vwr.getScreenWidth();
        int height = this.vwr.getScreenHeight();
        String info = width + " " + height;
        if (data == null) {
            data = info;
        } else {
            int pt = data.indexOf("preferredWidthHeight ");
            int pt2 = data.indexOf(";", pt + 1);
            if (pt >= 0 && pt2 > pt) {
                data = data.substring(pt + 21, pt2).trim();
            }
            if (data.equals(info)) {
                return new int[]{width, height};
            }
        }
        info = JOptionPane.showInputDialog(GT._("width height?"), (Object)data);
        if (info == null) {
            return new int[]{width, height};
        }
        float[] dims = new float[2];
        int n = Parser.parseStringInfestedFloatArray(info, null, dims);
        if (n < 2) {
            return new int[]{width, height};
        }
        this.resizeDisplay((int)dims[0], (int)dims[1]);
        return new int[]{(int)dims[0], (int)dims[1]};
    }

    void resizeDisplay(int width, int height) {
        Dimension d = new Dimension(width, height);
        this.display.setJmolSize(d);
        d = new Dimension(width, 30);
        this.status.setPreferredSize(d);
        this.toolbar.setPreferredSize(d);
        Platform.getWindow(this).pack();
        d = new Dimension(width, height);
        System.out.println("resizeDisplay " + this.display.getSize((Dimension)d).width);
    }

    void updateLabels() {
        if (this.atomSetChooser != null) {
            this.atomSetChooser.dispose();
            this.atomSetChooser = null;
        }
        if (this.gaussianDialog != null) {
            this.gaussianDialog.dispose();
            this.gaussianDialog = null;
        }
        boolean doTranslate = GT.setDoTranslate(true);
        this.getDialogs();
        GT.setDoTranslate(doTranslate);
        this.guimap.updateLabels();
    }

    @Override
    public void nioRunContent(JsonNioServer jns) {
    }

    @Override
    public void nioClosed(JsonNioServer jns) {
        if (bannerFrame != null) {
            this.vwr.scriptWait("delay 2");
            bannerFrame.dispose();
            this.vwr.dispose();
            System.exit(0);
        }
        if (jns.equals(this.service)) {
            this.service = null;
        } else if (jns.equals(this.serverService)) {
            this.serverService = null;
        }
    }

    @Override
    public void setBannerLabel(String label) {
        if (bannerFrame != null) {
            bannerFrame.setLabel(label);
        }
    }

    void sendNioMessage(int port, String strInfo) {
        try {
            if (port < 0) {
                if (this.serverService != null && "STOP".equalsIgnoreCase(strInfo)) {
                    this.serverService.close();
                } else if (this.serverService == null) {
                    this.serverService = JmolPanel.getJsonNioServer();
                    if (this.serverService != null) {
                        this.serverService.startService(port, this, this.vwr, "-1", 1);
                    }
                }
                if (this.serverService != null && this.serverService.getPort() == -port && strInfo != null) {
                    if (this.service == null) {
                        this.service = JmolPanel.getJsonNioServer();
                        if (this.service != null) {
                            this.service.startService(-port, this, this.vwr, null, 1);
                        }
                    }
                    if (this.service != null) {
                        this.service.send(-port, strInfo);
                    }
                    return;
                }
                return;
            }
            if (strInfo == null) {
                return;
            }
            if (strInfo.equalsIgnoreCase("STOP")) {
                strInfo = "{\"type\":\"quit\"}";
            }
            if (this.service == null && this.serverService != null && this.serverService.getPort() == port) {
                this.serverService.send(port, strInfo);
                return;
            }
            if (this.service == null) {
                this.service = JmolPanel.getJsonNioServer();
                if (this.service != null) {
                    this.service.startService(port, this, this.vwr, null, 1);
                }
            }
            if (this.service != null) {
                this.service.send(port, strInfo);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static JsonNioServer getJsonNioServer() {
        return (JsonNioServer)Interface.getInterface("org.openscience.jmol.app.jsonkiosk.JsonNioService", null, null);
    }

    public void syncScript(String script) {
        this.vwr.syncScript(script, "~", 0);
    }

    public void updateConsoleFont() {
        AppConsole console = (AppConsole)this.vwr.getProperty("DATA_API", "getAppConsole", null);
        if (console != null) {
            console.updateFontSize();
        }
    }

    public Object getPreference(String key) {
        return this.preferencesDialog.currentProperties.get(key);
    }

    public static String getJmolProperty(String key, String defaultValue) {
        return historyFile.getProperty(key, defaultValue);
    }

    public static void setPluginOption(String pluginName, String key, String value) {
        pluginFile.addProperty(pluginName + "_" + key, value);
        pluginFile.save();
    }

    public static String getPluginOption(String pluginName, String key, String defaultValue) {
        return pluginFile.getProperty(pluginName + "_" + key, defaultValue);
    }

    static {
        numWindows = 0;
        screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        imageChoices = new String[]{"JPEG", "PNG", "GIF", "PPM", "PDF"};
        imageExtensions = new String[]{"jpg", "png", "gif", "ppm", "pdf"};
    }

    private class AnimButton
    extends JmolButton
    implements MouseListener {
        private String script;
        private long lastPressTime;

        protected AnimButton(ImageIcon ii, String script) {
            super(ii);
            this.script = script;
            this.addMouseListener(this);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            JmolPanel.this.vwr.evalStringQuiet(this.script);
            long t = System.currentTimeMillis();
            if ((float)(t - this.lastPressTime) > JmolPanel.this.jmolApp.autoAnimationDelay * 2000.0f && JmolPanel.this.jmolApp.autoAnimationDelay > 0.0f) {
                JmolPanel.this.vwr.evalStringQuiet("timeout '__animBtn' OFF;animation_running = true; delay " + JmolPanel.this.jmolApp.autoAnimationDelay + "; if(animation_running){timeout '__animBtn' -200 \"" + this.script + "\"}");
            }
            this.lastPressTime = t;
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (JmolPanel.this.jmolApp.autoAnimationDelay > 0.0f) {
                JmolPanel.this.vwr.evalStringQuiet("animation_running = false; timeout '__animBtn' OFF");
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }

    class ResizeAction
    extends AbstractAction {
        public ResizeAction() {
            super(JmolPanel.resizeAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JmolPanel.this.resizeInnerPanel(null);
        }
    }

    class ExecuteScriptAction
    extends AbstractAction {
        public ExecuteScriptAction() {
            super("executeScriptAction");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String script = e.getActionCommand();
            if (script.indexOf("#showMeasurementTable") >= 0) {
                JmolPanel.this.display.measurementTable.activate();
            }
            JmolPanel.this.vwr.evalStringQuiet(script);
        }
    }

    class SurfaceToolAction
    extends AbstractAction {
        public SurfaceToolAction() {
            super(JmolPanel.surfaceToolActionProperty);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JmolPanel.this.createSurfaceTool();
                }
            });
        }
    }

    class ViewMeasurementTableAction
    extends AbstractAction {
        public ViewMeasurementTableAction() {
            super("viewMeasurementTable");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JmolPanel.this.display.measurementTable.activate();
        }
    }

    class ToWebAction
    extends AbstractAction {
        public ToWebAction() {
            super(JmolPanel.toWebActionProperty);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JmolPanel.this.createWebExport();
                }
            });
        }
    }

    class WriteAction
    extends AbstractAction {
        public WriteAction() {
            super(JmolPanel.writeActionProperty);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String fileName = new Dialog().getSaveFileNameFromDialog(JmolPanel.this.vwr, null, "SPT");
            if (fileName != null) {
                Hashtable<String, Object> params = new Hashtable<String, Object>();
                params.put("fileName", fileName);
                params.put("type", "SPT");
                params.put("text", JmolPanel.this.vwr.getStateInfo());
                String msg = JmolPanel.this.vwr.outputToFile(params);
                Logger.info(msg);
            }
        }
    }

    class PovrayAction
    extends AbstractAction {
        public PovrayAction() {
            super(JmolPanel.povrayActionProperty);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            new PovrayDialog(JmolPanel.this.frame, JmolPanel.this.vwr);
        }
    }

    class AtomSetChooserAction
    extends AbstractAction {
        public AtomSetChooserAction() {
            super(JmolPanel.atomsetchooserAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JmolPanel.this.atomSetChooser.setVisible(true);
        }
    }

    class ScriptEditorAction
    extends AbstractAction {
        public ScriptEditorAction() {
            super(JmolPanel.editorAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Component c = (Component)JmolPanel.this.vwr.getProperty("DATA_API", "getScriptEditor", null);
            if (c != null) {
                c.setVisible(true);
            }
        }
    }

    class ScriptWindowAction
    extends AbstractAction {
        public ScriptWindowAction() {
            super(JmolPanel.consoleAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AppConsole console = (AppConsole)JmolPanel.this.vwr.getProperty("DATA_API", "getAppConsole", null);
            if (console != null) {
                console.setVisible(true);
            }
        }
    }

    class RecentFilesAction
    extends AbstractAction {
        public RecentFilesAction() {
            super(JmolPanel.recentFilesAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JmolPanel.this.recentFiles.setVisible(true);
            String selection = JmolPanel.this.recentFiles.getFile();
            if (selection == null || selection.length() == 0) {
                return;
            }
            if (selection.endsWith(" (*)")) {
                JmolPanel.this.vwr.openFileAsyncSpecial(selection.substring(0, selection.length() - 4), 9);
            } else {
                JmolPanel.this.vwr.openFileAsyncSpecial(selection, 8);
            }
        }
    }

    class ExportAction
    extends AbstractAction {
        ExportAction() {
            super(JmolPanel.exportActionProperty);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Dialog sd = new Dialog();
            String fileName = sd.getImageFileNameFromDialog(JmolPanel.this.vwr, null, JmolPanel.this.imageType, imageChoices, imageExtensions, JmolPanel.this.qualityJPG, JmolPanel.this.qualityPNG);
            if (fileName == null) {
                return;
            }
            JmolPanel.this.qualityJPG = sd.getQuality("JPG");
            JmolPanel.this.qualityPNG = sd.getQuality("PNG");
            JmolPanel.this.imageType = sd.getType();
            String sType = JmolPanel.this.imageType;
            if (sType == null) {
                sType = fileName;
                int i = sType.lastIndexOf(".");
                if (i < 0) {
                    return;
                }
                sType = sType.substring(i + 1).toUpperCase();
            }
            if (fileName.indexOf(".") < 0) {
                fileName = fileName + "." + (sType.equalsIgnoreCase("JPEG") ? "jpg" : sType.toLowerCase());
            }
            Hashtable<String, Object> params = new Hashtable<String, Object>();
            params.put("fileName", fileName);
            params.put("type", sType);
            params.put("quality", sd.getQuality(sType));
            String msg = JmolPanel.this.vwr.outputToFile(params);
            Logger.info(msg);
        }
    }

    class ExitAction
    extends AbstractAction {
        ExitAction() {
            super(JmolPanel.exitAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JmolPanel.this.saveWindowSizes();
            System.exit(0);
        }
    }

    class NewAction
    extends AbstractAction {
        protected String script;

        NewAction() {
            super(JmolPanel.newAction);
        }

        NewAction(String nm) {
            super(nm);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.script == null) {
                JmolPanel.this.revalidate();
            } else {
                JmolPanel.this.vwr.script(this.script);
            }
        }
    }

    class OpenMolAction
    extends NewAction {
        OpenMolAction() {
            super(JmolPanel.openmolAction);
            this.script = "var x__id__ = _smilesString; if (!x__id__) { x__id__ = 'tylenol'};x__id__ = prompt('" + GT._("Enter the name or identifier (SMILES, InChI, CAS) of a compound. Preface with \":\" to load from PubChem; otherwise Jmol will use the NCI/NIH Resolver.") + "',x__id__);if (!x__id__) { quit }; load @{(x__id__[1]==':' ? x__id__ : '$' + x__id__)}";
        }
    }

    class OpenPdbAction
    extends NewAction {
        OpenPdbAction() {
            super(JmolPanel.openpdbAction);
            this.script = "var x__id__ = _modelTitle; if (x__id__.length != 4) { x__id__ = '1crn'};x__id__ = prompt('" + GT._("Enter a four-digit PDB model ID or \"=\" and a three-digit ligand ID") + "',x__id__);if (!x__id__) { quit }; load @{'=' + x__id__}";
        }
    }

    class OpenUrlAction
    extends NewAction {
        String title;
        String prompt;

        OpenUrlAction() {
            super(JmolPanel.openurlAction);
            this.title = GT._("Open URL");
            this.prompt = GT._("Enter URL of molecular model");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String url = JOptionPane.showInputDialog(JmolPanel.this.frame, this.prompt, this.title, -1);
            if (url != null) {
                if (url.indexOf("://") < 0) {
                    if (url.length() == 4 && url.indexOf(".") < 0) {
                        url = "=" + url;
                    }
                    if (!url.startsWith("=")) {
                        url = "http://" + url;
                    }
                }
                JmolPanel.this.vwr.openFileAsync(url);
            }
        }
    }

    class OpenAction
    extends NewAction {
        OpenAction() {
            super(JmolPanel.openAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JmolPanel.this.openFile();
        }
    }

    class PrintAction
    extends AbstractAction {
        public PrintAction() {
            super(JmolPanel.printActionProperty);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JmolPanel.this.print();
        }
    }

    class CopyScriptAction
    extends AbstractAction {
        public CopyScriptAction() {
            super(JmolPanel.copyScriptActionProperty);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JmolPanel.this.vwr.clipImageOrPasteText((String)JmolPanel.this.vwr.getProperty("string", "stateInfo", null));
        }
    }

    class CopyImageAction
    extends AbstractAction {
        public CopyImageAction() {
            super(JmolPanel.copyImageActionProperty);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JmolPanel.this.vwr.clipImageOrPasteText(null);
        }
    }

    class PasteClipboardAction
    extends AbstractAction {
        public PasteClipboardAction() {
            super(JmolPanel.pasteClipboardActionProperty);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JmolPanel.this.vwr.loadInlineAppend(JmolPanel.this.vwr.getClipboardText(), false);
        }
    }

    class UguideAction
    extends AbstractAction {
        public UguideAction() {
            super(JmolPanel.uguideAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JmolPanel.this.vwr.showUrl(JmolResourceHandler.getStringX("UGuide.wikiURL"));
        }
    }

    class NewwinAction
    extends AbstractAction {
        NewwinAction() {
            super(JmolPanel.newwinAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JmolPanel.this.doNew();
        }
    }

    class GaussianAction
    extends AbstractAction {
        public GaussianAction() {
            super(JmolPanel.gaussianAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (JmolPanel.this.gaussianDialog == null) {
                JmolPanel.this.gaussianDialog = new GaussianDialog(JmolPanel.this.frame, JmolPanel.this.vwr);
            }
            JmolPanel.this.gaussianDialog.setVisible(true);
        }
    }

    class CreditsAction
    extends AbstractAction {
        public CreditsAction() {
            super(JmolPanel.creditsAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            new CreditsDialog(JmolPanel.this.frame).setVisible(true);
        }
    }

    class WhatsNewAction
    extends AbstractAction {
        public WhatsNewAction() {
            super(JmolPanel.whatsnewAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WhatsNewDialog wnd = new WhatsNewDialog(JmolPanel.this.frame);
            wnd.setVisible(true);
        }
    }

    class AboutAction
    extends AbstractAction {
        public AboutAction() {
            super(JmolPanel.aboutAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                AboutDialog ad = new AboutDialog(JmolPanel.this.frame, JmolPanel.this.vwr);
                ad.setVisible(true);
            }
            catch (Exception ee) {
                Logger.error(ee.getMessage());
            }
        }
    }

    class ConsoleAction
    extends AbstractAction {
        public ConsoleAction() {
            super("jconsole");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (JmolPanel.this.consoleframe != null) {
                JmolPanel.this.consoleframe.setVisible(true);
            }
        }
    }

    class CloseAction
    extends AbstractAction {
        CloseAction() {
            super(JmolPanel.closeAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!JmolPanel.this.doClose(true)) {
                JmolPanel.this.vwr.script("zap");
            }
        }
    }

    private static class ActionChangedListener
    implements PropertyChangeListener {
        AbstractButton button;

        ActionChangedListener(AbstractButton button) {
            this.button = button;
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            if (e.getPropertyName().equals("Name")) {
                String text = (String)e.getNewValue();
                if (this.button.getText() != null) {
                    this.button.setText(text);
                }
            } else if (propertyName.equals("enabled")) {
                Boolean enabledState = (Boolean)e.getNewValue();
                this.button.setEnabled(enabledState);
            }
        }
    }

    protected final class AppCloser
    extends WindowAdapter {
        protected AppCloser() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            JmolPanel.this.doClose(false);
        }
    }
}

