/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jruby.RubyInstanceConfig;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.callsite.BitAndCallSite;
import org.jruby.runtime.callsite.BitOrCallSite;
import org.jruby.runtime.callsite.CmpCallSite;
import org.jruby.runtime.callsite.EqCallSite;
import org.jruby.runtime.callsite.FunctionalCachingCallSite;
import org.jruby.runtime.callsite.GeCallSite;
import org.jruby.runtime.callsite.GtCallSite;
import org.jruby.runtime.callsite.LeCallSite;
import org.jruby.runtime.callsite.LtCallSite;
import org.jruby.runtime.callsite.MinusCallSite;
import org.jruby.runtime.callsite.MulCallSite;
import org.jruby.runtime.callsite.NormalCachingCallSite;
import org.jruby.runtime.callsite.PlusCallSite;
import org.jruby.runtime.callsite.RespondToCallSite;
import org.jruby.runtime.callsite.ShiftLeftCallSite;
import org.jruby.runtime.callsite.ShiftRightCallSite;
import org.jruby.runtime.callsite.SuperCallSite;
import org.jruby.runtime.callsite.VariableCachingCallSite;
import org.jruby.runtime.callsite.XorCallSite;
import org.jruby.runtime.invokedynamic.MethodNames;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public class MethodIndex {
    private static final boolean DEBUG = false;
    private static final Logger LOG = LoggerFactory.getLogger(MethodIndex.class);
    @Deprecated
    public static final int NO_METHOD = MethodNames.DUMMY.ordinal();
    @Deprecated
    public static final int OP_EQUAL = MethodNames.OP_EQUAL.ordinal();
    @Deprecated
    public static final int EQL = MethodNames.EQL.ordinal();
    @Deprecated
    public static final int HASH = MethodNames.HASH.ordinal();
    @Deprecated
    public static final int OP_CMP = MethodNames.OP_CMP.ordinal();
    @Deprecated
    public static final int MAX_METHODS = MethodNames.values().length;
    @Deprecated
    public static final String[] METHOD_NAMES = new String[]{"", "==", "eql?", "hash", "<=>"};
    public static final Set<String> FRAME_AWARE_METHODS = Collections.synchronizedSet(new HashSet());
    public static final Set<String> SCOPE_AWARE_METHODS = Collections.synchronizedSet(new HashSet());
    private static final Map<String, String> FIXNUM_OPS;
    private static final Map<String, String> FLOAT_OPS;

    public static CallSite getCallSite(String name2) {
        if (name2.equals("respond_to?")) {
            return new RespondToCallSite();
        }
        if (RubyInstanceConfig.FASTOPS_COMPILE_ENABLED && !RubyInstanceConfig.FULL_TRACE_ENABLED) {
            return MethodIndex.getFastFixnumOpsCallSite(name2);
        }
        return new NormalCachingCallSite(name2);
    }

    public static boolean hasFastFixnumOps(String name2) {
        return FIXNUM_OPS.containsKey(name2);
    }

    public static String getFastFixnumOpsMethod(String name2) {
        return FIXNUM_OPS.get(name2);
    }

    public static CallSite getFastFixnumOpsCallSite(String name2) {
        switch (name2) {
            case "+": {
                return new PlusCallSite();
            }
            case "-": {
                return new MinusCallSite();
            }
            case "*": {
                return new MulCallSite();
            }
            case "<": {
                return new LtCallSite();
            }
            case "<=": {
                return new LeCallSite();
            }
            case ">": {
                return new GtCallSite();
            }
            case ">=": {
                return new GeCallSite();
            }
            case "==": {
                return new EqCallSite();
            }
            case "<=>": {
                return new CmpCallSite();
            }
            case "&": {
                return new BitAndCallSite();
            }
            case "|": {
                return new BitOrCallSite();
            }
            case "^": {
                return new XorCallSite();
            }
            case ">>": {
                return new ShiftRightCallSite();
            }
            case "<<": {
                return new ShiftLeftCallSite();
            }
        }
        return new NormalCachingCallSite(name2);
    }

    public static boolean hasFastFloatOps(String name2) {
        return FLOAT_OPS.containsKey(name2);
    }

    public static String getFastFloatOpsMethod(String name2) {
        return FLOAT_OPS.get(name2);
    }

    public static CallSite getFastFloatOpsCallSite(String name2) {
        if (name2.equals("+")) {
            return new PlusCallSite();
        }
        if (name2.equals("-")) {
            return new MinusCallSite();
        }
        if (name2.equals("*")) {
            return new MulCallSite();
        }
        if (name2.equals("<")) {
            return new LtCallSite();
        }
        if (name2.equals("<=")) {
            return new LeCallSite();
        }
        if (name2.equals(">")) {
            return new GtCallSite();
        }
        if (name2.equals(">=")) {
            return new GeCallSite();
        }
        if (name2.equals("==")) {
            return new EqCallSite();
        }
        if (name2.equals("<=>")) {
            return new CmpCallSite();
        }
        return new NormalCachingCallSite(name2);
    }

    public static CallSite getFunctionalCallSite(String name2) {
        return new FunctionalCachingCallSite(name2);
    }

    public static CallSite getVariableCallSite(String name2) {
        return new VariableCachingCallSite(name2);
    }

    public static CallSite getSuperCallSite() {
        return new SuperCallSite();
    }

    public static void addFrameAwareMethods(String ... methods2) {
        FRAME_AWARE_METHODS.addAll(Arrays.asList(methods2));
    }

    public static void addScopeAwareMethods(String ... methods2) {
        SCOPE_AWARE_METHODS.addAll(Arrays.asList(methods2));
    }

    static {
        String[][] fastFixnumOps = new String[][]{{"+", "op_plus"}, {"-", "op_minus"}, {"*", "op_mul"}, {"==", "op_equal"}, {"<", "op_lt"}, {"<=", "op_le"}, {">", "op_gt"}, {">=", "op_ge"}, {"<=>", "op_cmp"}, {"&", "op_and"}, {"|", "op_or"}, {"^", "op_xor"}, {">>", "op_rshift"}, {"<<", "op_lshift"}};
        FIXNUM_OPS = new HashMap<String, String>(fastFixnumOps.length + 1, 1.0f);
        for (String[] fastOp : fastFixnumOps) {
            FIXNUM_OPS.put(fastOp[0], fastOp[1]);
        }
        String[][] fastFloatOps = new String[][]{{"+", "op_plus"}, {"-", "op_minus"}, {"*", "op_mul"}, {"==", "op_equal"}, {"<", "op_lt"}, {"<=", "op_le"}, {">", "op_gt"}, {">=", "op_ge"}, {"<=>", "op_cmp"}};
        FLOAT_OPS = new HashMap<String, String>(fastFloatOps.length + 1, 1.0f);
        for (String[] fastOp : fastFloatOps) {
            FLOAT_OPS.put(fastOp[0], fastOp[1]);
        }
    }
}

