
# frozen_string_literal: true
require 'mail/utilities'
require 'mail/parser_tools'




module Mail::Parsers
  module MessageIdsParser
    extend Mail::ParserTools

    MessageIdsStruct = Struct.new(:message_ids, :error)

    
class << self
	attr_accessor :_trans_keys
	private :_trans_keys, :_trans_keys=
end
self._trans_keys = [
	0, 0, 9, 60, 10, 10, 
	9, 32, 9, 60, 9, 
	244, 9, 244, 10, 10, 
	9, 32, 9, 244, 9, 64, 
	10, 10, 9, 32, 9, 
	64, 9, 244, 10, 10, 
	9, 32, 9, 244, 9, 64, 
	10, 10, 9, 32, 9, 
	64, 9, 244, 9, 244, 
	10, 10, 9, 32, 9, 244, 
	9, 62, 10, 10, 9, 
	32, 9, 62, 9, 244, 
	10, 10, 9, 32, 9, 244, 
	10, 10, 9, 32, 128, 
	191, 160, 191, 128, 191, 
	128, 159, 144, 191, 128, 191, 
	128, 143, 9, 244, 1, 
	244, 1, 244, 10, 10, 
	9, 32, 9, 244, 9, 62, 
	10, 10, 9, 32, 9, 
	62, 33, 244, 128, 191, 
	160, 191, 128, 191, 128, 159, 
	144, 191, 128, 191, 128, 
	143, 0, 244, 128, 191, 
	160, 191, 128, 191, 128, 159, 
	144, 191, 128, 191, 128, 
	143, 10, 10, 9, 32, 
	9, 244, 128, 191, 160, 191, 
	128, 191, 128, 159, 144, 
	191, 128, 191, 128, 143, 
	9, 244, 1, 244, 10, 10, 
	9, 32, 0, 244, 128, 
	191, 160, 191, 128, 191, 
	128, 159, 144, 191, 128, 191, 
	128, 143, 9, 244, 9, 
	244, 33, 126, 33, 126, 
	128, 191, 160, 191, 128, 191, 
	128, 159, 144, 191, 128, 
	191, 128, 143, 1, 244, 
	1, 244, 10, 10, 9, 32, 
	0, 244, 128, 191, 160, 
	191, 128, 191, 128, 159, 
	144, 191, 128, 191, 128, 143, 
	9, 244, 1, 244, 1, 
	244, 10, 10, 9, 32, 
	9, 244, 9, 64, 10, 10, 
	9, 32, 9, 64, 128, 
	191, 160, 191, 128, 191, 
	128, 159, 144, 191, 128, 191, 
	128, 143, 0, 244, 128, 
	191, 160, 191, 128, 191, 
	128, 159, 144, 191, 128, 191, 
	128, 143, 10, 10, 9, 
	32, 9, 244, 9, 244, 
	10, 10, 9, 32, 9, 244, 
	1, 244, 1, 244, 10, 
	10, 9, 32, 9, 244, 
	0, 244, 128, 191, 160, 191, 
	128, 191, 128, 159, 144, 
	191, 128, 191, 128, 143, 
	1, 244, 10, 10, 9, 32, 
	128, 191, 160, 191, 128, 
	191, 128, 159, 144, 191, 
	128, 191, 128, 143, 1, 244, 
	1, 244, 10, 10, 9, 
	32, 9, 244, 9, 64, 
	10, 10, 9, 32, 9, 64, 
	0, 244, 128, 191, 160, 
	191, 128, 191, 128, 159, 
	144, 191, 128, 191, 128, 143, 
	1, 244, 10, 10, 9, 
	32, 9, 64, 10, 10, 
	9, 32, 9, 64, 9, 244, 
	33, 244, 1, 244, 1, 
	244, 10, 10, 9, 32, 
	0, 244, 128, 191, 160, 191, 
	128, 191, 128, 159, 144, 
	191, 128, 191, 128, 143, 
	9, 60, 9, 60, 9, 60, 
	0, 0, 0
]

class << self
	attr_accessor :_key_spans
	private :_key_spans, :_key_spans=
end
self._key_spans = [
	0, 52, 1, 24, 52, 236, 236, 1, 
	24, 236, 56, 1, 24, 56, 236, 1, 
	24, 236, 56, 1, 24, 56, 236, 236, 
	1, 24, 236, 54, 1, 24, 54, 236, 
	1, 24, 236, 1, 24, 64, 32, 64, 
	32, 48, 64, 16, 236, 244, 244, 1, 
	24, 236, 54, 1, 24, 54, 212, 64, 
	32, 64, 32, 48, 64, 16, 245, 64, 
	32, 64, 32, 48, 64, 16, 1, 24, 
	236, 64, 32, 64, 32, 48, 64, 16, 
	236, 244, 1, 24, 245, 64, 32, 64, 
	32, 48, 64, 16, 236, 236, 94, 94, 
	64, 32, 64, 32, 48, 64, 16, 244, 
	244, 1, 24, 245, 64, 32, 64, 32, 
	48, 64, 16, 236, 244, 244, 1, 24, 
	236, 56, 1, 24, 56, 64, 32, 64, 
	32, 48, 64, 16, 245, 64, 32, 64, 
	32, 48, 64, 16, 1, 24, 236, 236, 
	1, 24, 236, 244, 244, 1, 24, 236, 
	245, 64, 32, 64, 32, 48, 64, 16, 
	244, 1, 24, 64, 32, 64, 32, 48, 
	64, 16, 244, 244, 1, 24, 236, 56, 
	1, 24, 56, 245, 64, 32, 64, 32, 
	48, 64, 16, 244, 1, 24, 56, 1, 
	24, 56, 236, 212, 244, 244, 1, 24, 
	245, 64, 32, 64, 32, 48, 64, 16, 
	52, 52, 52, 0
]

class << self
	attr_accessor :_index_offsets
	private :_index_offsets, :_index_offsets=
end
self._index_offsets = [
	0, 0, 53, 55, 80, 133, 370, 607, 
	609, 634, 871, 928, 930, 955, 1012, 1249, 
	1251, 1276, 1513, 1570, 1572, 1597, 1654, 1891, 
	2128, 2130, 2155, 2392, 2447, 2449, 2474, 2529, 
	2766, 2768, 2793, 3030, 3032, 3057, 3122, 3155, 
	3220, 3253, 3302, 3367, 3384, 3621, 3866, 4111, 
	4113, 4138, 4375, 4430, 4432, 4457, 4512, 4725, 
	4790, 4823, 4888, 4921, 4970, 5035, 5052, 5298, 
	5363, 5396, 5461, 5494, 5543, 5608, 5625, 5627, 
	5652, 5889, 5954, 5987, 6052, 6085, 6134, 6199, 
	6216, 6453, 6698, 6700, 6725, 6971, 7036, 7069, 
	7134, 7167, 7216, 7281, 7298, 7535, 7772, 7867, 
	7962, 8027, 8060, 8125, 8158, 8207, 8272, 8289, 
	8534, 8779, 8781, 8806, 9052, 9117, 9150, 9215, 
	9248, 9297, 9362, 9379, 9616, 9861, 10106, 10108, 
	10133, 10370, 10427, 10429, 10454, 10511, 10576, 10609, 
	10674, 10707, 10756, 10821, 10838, 11084, 11149, 11182, 
	11247, 11280, 11329, 11394, 11411, 11413, 11438, 11675, 
	11912, 11914, 11939, 12176, 12421, 12666, 12668, 12693, 
	12930, 13176, 13241, 13274, 13339, 13372, 13421, 13486, 
	13503, 13748, 13750, 13775, 13840, 13873, 13938, 13971, 
	14020, 14085, 14102, 14347, 14592, 14594, 14619, 14856, 
	14913, 14915, 14940, 14997, 15243, 15308, 15341, 15406, 
	15439, 15488, 15553, 15570, 15815, 15817, 15842, 15899, 
	15901, 15926, 15983, 16220, 16433, 16678, 16923, 16925, 
	16950, 17196, 17261, 17294, 17359, 17392, 17441, 17506, 
	17523, 17576, 17629, 17682
]

class << self
	attr_accessor :_indicies
	private :_indicies, :_indicies=
end
self._indicies = [
	0, 1, 1, 1, 2, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 0, 
	1, 1, 1, 1, 1, 1, 1, 3, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 4, 1, 5, 1, 0, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 0, 1, 
	6, 1, 1, 1, 7, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 6, 
	1, 1, 1, 1, 1, 1, 1, 8, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 9, 1, 10, 1, 1, 
	1, 11, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 10, 12, 13, 12, 
	12, 12, 12, 12, 14, 1, 12, 12, 
	1, 12, 15, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 1, 1, 
	1, 12, 1, 12, 1, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 1, 
	1, 1, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 16, 16, 
	16, 16, 16, 16, 16, 16, 16, 16, 
	16, 16, 16, 16, 16, 16, 16, 16, 
	16, 16, 16, 16, 16, 16, 16, 16, 
	16, 16, 16, 16, 17, 18, 18, 18, 
	18, 18, 18, 18, 18, 18, 18, 18, 
	18, 19, 18, 18, 20, 21, 21, 21, 
	22, 1, 23, 1, 1, 1, 24, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 23, 12, 13, 12, 12, 12, 12, 
	12, 25, 1, 12, 12, 1, 12, 15, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 1, 1, 1, 12, 1, 
	12, 1, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 1, 1, 1, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 16, 16, 16, 16, 16, 
	16, 16, 16, 16, 16, 16, 16, 16, 
	16, 16, 16, 16, 16, 16, 16, 16, 
	16, 16, 16, 16, 16, 16, 16, 16, 
	16, 17, 18, 18, 18, 18, 18, 18, 
	18, 18, 18, 18, 18, 18, 19, 18, 
	18, 20, 21, 21, 21, 22, 1, 26, 
	1, 23, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	23, 1, 27, 1, 1, 1, 28, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 27, 29, 30, 29, 29, 29, 29, 
	29, 31, 1, 29, 29, 1, 29, 32, 
	29, 29, 29, 29, 29, 29, 29, 29, 
	29, 29, 29, 1, 1, 1, 29, 1, 
	29, 33, 29, 29, 29, 29, 29, 29, 
	29, 29, 29, 29, 29, 29, 29, 29, 
	29, 29, 29, 29, 29, 29, 29, 29, 
	29, 29, 29, 29, 1, 1, 1, 29, 
	29, 29, 29, 29, 29, 29, 29, 29, 
	29, 29, 29, 29, 29, 29, 29, 29, 
	29, 29, 29, 29, 29, 29, 29, 29, 
	29, 29, 29, 29, 29, 29, 29, 29, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 34, 34, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	34, 35, 36, 36, 36, 36, 36, 36, 
	36, 36, 36, 36, 36, 36, 37, 36, 
	36, 38, 39, 39, 39, 40, 1, 41, 
	1, 1, 1, 42, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 41, 1, 
	1, 1, 1, 1, 1, 1, 43, 1, 
	1, 1, 1, 1, 44, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 45, 1, 
	46, 1, 41, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 41, 1, 47, 1, 1, 1, 48, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 47, 1, 1, 1, 1, 1, 
	1, 1, 49, 1, 1, 1, 1, 1, 
	50, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 51, 1, 44, 1, 1, 1, 
	52, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 44, 53, 54, 53, 53, 
	53, 53, 53, 55, 1, 53, 53, 1, 
	53, 1, 53, 53, 53, 53, 53, 53, 
	53, 53, 53, 53, 53, 1, 1, 1, 
	53, 1, 53, 1, 53, 53, 53, 53, 
	53, 53, 53, 53, 53, 53, 53, 53, 
	53, 53, 53, 53, 53, 53, 53, 53, 
	53, 53, 53, 53, 53, 53, 1, 1, 
	1, 53, 53, 53, 53, 53, 53, 53, 
	53, 53, 53, 53, 53, 53, 53, 53, 
	53, 53, 53, 53, 53, 53, 53, 53, 
	53, 53, 53, 53, 53, 53, 53, 53, 
	53, 53, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 57, 58, 58, 58, 58, 
	58, 58, 58, 58, 58, 58, 58, 58, 
	59, 58, 58, 60, 61, 61, 61, 62, 
	1, 63, 1, 44, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 44, 1, 64, 1, 1, 1, 
	65, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 64, 53, 1, 53, 53, 
	53, 53, 53, 66, 1, 53, 53, 1, 
	53, 44, 53, 53, 53, 53, 53, 53, 
	53, 53, 53, 53, 53, 1, 1, 1, 
	53, 1, 53, 67, 53, 53, 53, 53, 
	53, 53, 53, 53, 53, 53, 53, 53, 
	53, 53, 53, 53, 53, 53, 53, 53, 
	53, 53, 53, 53, 53, 53, 1, 1, 
	1, 53, 53, 53, 53, 53, 53, 53, 
	53, 53, 53, 53, 53, 53, 53, 53, 
	53, 53, 53, 53, 53, 53, 53, 53, 
	53, 53, 53, 53, 53, 53, 53, 53, 
	53, 53, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 57, 58, 58, 58, 58, 
	58, 58, 58, 58, 58, 58, 58, 58, 
	59, 58, 58, 60, 61, 61, 61, 62, 
	1, 64, 1, 1, 1, 65, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	64, 1, 1, 1, 1, 1, 1, 1, 
	66, 1, 1, 1, 1, 1, 44, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	67, 1, 68, 1, 64, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 64, 1, 69, 1, 1, 
	1, 70, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 69, 1, 1, 1, 
	1, 1, 1, 1, 71, 1, 1, 1, 
	1, 1, 50, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 72, 1, 73, 1, 
	1, 1, 74, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 73, 75, 76, 
	75, 75, 75, 75, 75, 77, 1, 75, 
	75, 1, 75, 78, 75, 75, 75, 75, 
	75, 75, 75, 75, 75, 75, 75, 1, 
	1, 1, 75, 1, 75, 79, 75, 75, 
	75, 75, 75, 75, 75, 75, 75, 75, 
	75, 75, 75, 75, 75, 75, 75, 75, 
	75, 75, 75, 75, 75, 75, 75, 75, 
	80, 1, 1, 75, 75, 75, 75, 75, 
	75, 75, 75, 75, 75, 75, 75, 75, 
	75, 75, 75, 75, 75, 75, 75, 75, 
	75, 75, 75, 75, 75, 75, 75, 75, 
	75, 75, 75, 75, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 81, 
	81, 81, 81, 81, 81, 81, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 81, 
	81, 81, 81, 81, 81, 82, 83, 83, 
	83, 83, 83, 83, 83, 83, 83, 83, 
	83, 83, 84, 83, 83, 85, 86, 86, 
	86, 87, 1, 88, 1, 1, 1, 89, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 88, 90, 91, 90, 90, 90, 
	90, 90, 92, 1, 90, 90, 1, 90, 
	93, 90, 90, 90, 90, 90, 90, 90, 
	90, 90, 90, 90, 1, 1, 1, 90, 
	1, 90, 1, 90, 90, 90, 90, 90, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	90, 90, 90, 90, 90, 94, 1, 1, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	90, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 95, 95, 95, 95, 
	95, 95, 95, 95, 95, 95, 95, 95, 
	95, 95, 95, 95, 95, 95, 95, 95, 
	95, 95, 95, 95, 95, 95, 95, 95, 
	95, 95, 96, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 98, 
	97, 97, 99, 100, 100, 100, 101, 1, 
	102, 1, 88, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 88, 1, 103, 1, 1, 1, 104, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 103, 90, 91, 90, 90, 90, 
	90, 90, 105, 1, 90, 90, 1, 90, 
	106, 90, 90, 90, 90, 90, 90, 90, 
	90, 90, 90, 90, 1, 1, 1, 90, 
	107, 90, 1, 90, 90, 90, 90, 90, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	90, 90, 90, 90, 90, 1, 1, 1, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	90, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 95, 95, 95, 95, 
	95, 95, 95, 95, 95, 95, 95, 95, 
	95, 95, 95, 95, 95, 95, 95, 95, 
	95, 95, 95, 95, 95, 95, 95, 95, 
	95, 95, 96, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 98, 
	97, 97, 99, 100, 100, 100, 101, 1, 
	103, 1, 1, 1, 104, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 103, 
	1, 1, 1, 1, 1, 1, 1, 105, 
	1, 1, 1, 1, 1, 108, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 107, 1, 109, 
	1, 103, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	103, 1, 110, 1, 1, 1, 111, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 110, 1, 1, 1, 1, 1, 1, 
	1, 112, 1, 1, 1, 1, 1, 113, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 114, 
	1, 108, 1, 1, 1, 115, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	108, 116, 1, 116, 116, 116, 116, 116, 
	117, 1, 116, 116, 1, 116, 1, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 1, 1, 1, 116, 1, 116, 
	1, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 1, 1, 1, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	119, 120, 120, 120, 120, 120, 120, 120, 
	120, 120, 120, 120, 120, 121, 120, 120, 
	122, 123, 123, 123, 124, 1, 125, 1, 
	108, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 108, 
	1, 103, 1, 1, 1, 104, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	103, 116, 1, 116, 116, 116, 116, 116, 
	105, 1, 116, 116, 1, 116, 108, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 1, 1, 1, 116, 107, 116, 
	1, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 1, 1, 1, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	119, 120, 120, 120, 120, 120, 120, 120, 
	120, 120, 120, 120, 120, 121, 120, 120, 
	122, 123, 123, 123, 124, 1, 126, 1, 
	127, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 127, 
	1, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 116, 116, 116, 116, 116, 116, 116, 
	116, 1, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 1, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 1, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 1, 120, 120, 120, 
	120, 120, 120, 120, 120, 120, 120, 120, 
	120, 120, 120, 120, 120, 120, 120, 120, 
	120, 120, 120, 120, 120, 120, 120, 120, 
	120, 120, 120, 120, 120, 120, 120, 120, 
	120, 120, 120, 120, 120, 120, 120, 120, 
	120, 120, 120, 120, 120, 1, 120, 120, 
	120, 120, 120, 120, 120, 120, 120, 120, 
	120, 120, 120, 120, 120, 120, 120, 120, 
	120, 120, 120, 120, 120, 120, 120, 120, 
	120, 120, 120, 120, 120, 120, 120, 120, 
	120, 120, 120, 120, 120, 120, 120, 120, 
	120, 120, 120, 120, 120, 120, 120, 120, 
	120, 120, 120, 120, 120, 120, 120, 120, 
	120, 120, 120, 120, 120, 120, 1, 120, 
	120, 120, 120, 120, 120, 120, 120, 120, 
	120, 120, 120, 120, 120, 120, 120, 1, 
	113, 1, 1, 1, 128, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 113, 
	129, 1, 129, 129, 129, 129, 129, 130, 
	1, 129, 129, 1, 129, 1, 129, 129, 
	129, 129, 129, 129, 129, 129, 129, 129, 
	129, 1, 1, 1, 129, 1, 129, 1, 
	129, 129, 129, 129, 129, 129, 129, 129, 
	129, 129, 129, 129, 129, 129, 129, 129, 
	129, 129, 129, 129, 129, 129, 129, 129, 
	129, 129, 1, 1, 1, 129, 129, 129, 
	129, 129, 129, 129, 129, 129, 129, 129, 
	129, 129, 129, 129, 129, 129, 129, 129, 
	129, 129, 129, 129, 129, 129, 129, 129, 
	129, 129, 129, 129, 129, 129, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 131, 131, 131, 131, 131, 131, 131, 
	131, 131, 131, 131, 131, 131, 131, 131, 
	131, 131, 131, 131, 131, 131, 131, 131, 
	131, 131, 131, 131, 131, 131, 131, 132, 
	133, 133, 133, 133, 133, 133, 133, 133, 
	133, 133, 133, 133, 134, 133, 133, 135, 
	136, 136, 136, 137, 1, 138, 138, 138, 
	138, 138, 138, 138, 138, 91, 1, 138, 
	138, 139, 138, 138, 138, 138, 138, 138, 
	138, 138, 138, 138, 138, 138, 138, 138, 
	138, 138, 138, 138, 91, 138, 1, 138, 
	138, 138, 138, 138, 138, 138, 138, 138, 
	138, 138, 138, 138, 138, 138, 138, 138, 
	138, 138, 138, 138, 138, 138, 138, 138, 
	138, 138, 138, 138, 138, 138, 138, 138, 
	138, 138, 138, 138, 138, 138, 138, 138, 
	138, 138, 138, 138, 138, 138, 138, 138, 
	138, 138, 138, 138, 138, 138, 138, 138, 
	140, 138, 138, 138, 138, 138, 138, 138, 
	138, 138, 138, 138, 138, 138, 138, 138, 
	138, 138, 138, 138, 138, 138, 138, 138, 
	138, 138, 138, 138, 138, 138, 138, 138, 
	138, 138, 138, 138, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 141, 141, 
	141, 141, 141, 141, 141, 141, 141, 141, 
	141, 141, 141, 141, 141, 141, 141, 141, 
	141, 141, 141, 141, 141, 141, 141, 141, 
	141, 141, 141, 141, 142, 143, 143, 143, 
	143, 143, 143, 143, 143, 143, 143, 143, 
	143, 144, 143, 143, 145, 146, 146, 146, 
	147, 1, 138, 138, 138, 138, 138, 138, 
	138, 138, 138, 1, 138, 138, 148, 138, 
	138, 138, 138, 138, 138, 138, 138, 138, 
	138, 138, 138, 138, 138, 138, 138, 138, 
	138, 138, 138, 149, 138, 138, 138, 138, 
	138, 138, 138, 138, 138, 138, 138, 138, 
	138, 138, 138, 138, 138, 138, 138, 138, 
	138, 138, 138, 138, 138, 138, 138, 138, 
	138, 138, 138, 138, 138, 138, 138, 138, 
	138, 138, 138, 138, 138, 138, 138, 138, 
	138, 138, 138, 138, 138, 138, 138, 138, 
	138, 138, 138, 138, 138, 140, 138, 138, 
	138, 138, 138, 138, 138, 138, 138, 138, 
	138, 138, 138, 138, 138, 138, 138, 138, 
	138, 138, 138, 138, 138, 138, 138, 138, 
	138, 138, 138, 138, 138, 138, 138, 138, 
	138, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 141, 141, 141, 141, 141, 
	141, 141, 141, 141, 141, 141, 141, 141, 
	141, 141, 141, 141, 141, 141, 141, 141, 
	141, 141, 141, 141, 141, 141, 141, 141, 
	141, 142, 143, 143, 143, 143, 143, 143, 
	143, 143, 143, 143, 143, 143, 144, 143, 
	143, 145, 146, 146, 146, 147, 1, 150, 
	1, 138, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	138, 1, 151, 1, 1, 1, 152, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 151, 149, 91, 149, 149, 149, 149, 
	149, 153, 1, 149, 149, 1, 149, 93, 
	149, 149, 149, 149, 149, 149, 149, 149, 
	149, 149, 149, 1, 1, 1, 149, 107, 
	149, 1, 149, 149, 149, 149, 149, 149, 
	149, 149, 149, 149, 149, 149, 149, 149, 
	149, 149, 149, 149, 149, 149, 149, 149, 
	149, 149, 149, 149, 1, 1, 1, 149, 
	149, 149, 149, 149, 149, 149, 149, 149, 
	149, 149, 149, 149, 149, 149, 149, 149, 
	149, 149, 149, 149, 149, 149, 149, 149, 
	149, 149, 149, 149, 149, 149, 149, 149, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 154, 154, 154, 154, 154, 
	154, 154, 154, 154, 154, 154, 154, 154, 
	154, 154, 154, 154, 154, 154, 154, 154, 
	154, 154, 154, 154, 154, 154, 154, 154, 
	154, 155, 156, 156, 156, 156, 156, 156, 
	156, 156, 156, 156, 156, 156, 157, 156, 
	156, 158, 159, 159, 159, 160, 1, 151, 
	1, 1, 1, 152, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 151, 1, 
	1, 1, 1, 1, 1, 1, 153, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 107, 1, 161, 1, 
	151, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 151, 
	1, 162, 1, 1, 1, 163, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	162, 1, 1, 1, 1, 1, 1, 1, 
	164, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 114, 1, 
	149, 91, 149, 149, 149, 149, 149, 1, 
	1, 149, 149, 1, 149, 93, 149, 149, 
	149, 149, 149, 149, 149, 149, 149, 149, 
	149, 1, 1, 1, 149, 1, 149, 1, 
	149, 149, 149, 149, 149, 149, 149, 149, 
	149, 149, 149, 149, 149, 149, 149, 149, 
	149, 149, 149, 149, 149, 149, 149, 149, 
	149, 149, 1, 1, 1, 149, 149, 149, 
	149, 149, 149, 149, 149, 149, 149, 149, 
	149, 149, 149, 149, 149, 149, 149, 149, 
	149, 149, 149, 149, 149, 149, 149, 149, 
	149, 149, 149, 149, 149, 149, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 154, 154, 154, 154, 154, 154, 154, 
	154, 154, 154, 154, 154, 154, 154, 154, 
	154, 154, 154, 154, 154, 154, 154, 154, 
	154, 154, 154, 154, 154, 154, 154, 155, 
	156, 156, 156, 156, 156, 156, 156, 156, 
	156, 156, 156, 156, 157, 156, 156, 158, 
	159, 159, 159, 160, 1, 149, 149, 149, 
	149, 149, 149, 149, 149, 149, 149, 149, 
	149, 149, 149, 149, 149, 149, 149, 149, 
	149, 149, 149, 149, 149, 149, 149, 149, 
	149, 149, 149, 149, 149, 149, 149, 149, 
	149, 149, 149, 149, 149, 149, 149, 149, 
	149, 149, 149, 149, 149, 149, 149, 149, 
	149, 149, 149, 149, 149, 149, 149, 149, 
	149, 149, 149, 149, 149, 1, 154, 154, 
	154, 154, 154, 154, 154, 154, 154, 154, 
	154, 154, 154, 154, 154, 154, 154, 154, 
	154, 154, 154, 154, 154, 154, 154, 154, 
	154, 154, 154, 154, 154, 154, 1, 154, 
	154, 154, 154, 154, 154, 154, 154, 154, 
	154, 154, 154, 154, 154, 154, 154, 154, 
	154, 154, 154, 154, 154, 154, 154, 154, 
	154, 154, 154, 154, 154, 154, 154, 154, 
	154, 154, 154, 154, 154, 154, 154, 154, 
	154, 154, 154, 154, 154, 154, 154, 154, 
	154, 154, 154, 154, 154, 154, 154, 154, 
	154, 154, 154, 154, 154, 154, 154, 1, 
	154, 154, 154, 154, 154, 154, 154, 154, 
	154, 154, 154, 154, 154, 154, 154, 154, 
	154, 154, 154, 154, 154, 154, 154, 154, 
	154, 154, 154, 154, 154, 154, 154, 154, 
	1, 156, 156, 156, 156, 156, 156, 156, 
	156, 156, 156, 156, 156, 156, 156, 156, 
	156, 156, 156, 156, 156, 156, 156, 156, 
	156, 156, 156, 156, 156, 156, 156, 156, 
	156, 156, 156, 156, 156, 156, 156, 156, 
	156, 156, 156, 156, 156, 156, 156, 156, 
	156, 1, 156, 156, 156, 156, 156, 156, 
	156, 156, 156, 156, 156, 156, 156, 156, 
	156, 156, 156, 156, 156, 156, 156, 156, 
	156, 156, 156, 156, 156, 156, 156, 156, 
	156, 156, 156, 156, 156, 156, 156, 156, 
	156, 156, 156, 156, 156, 156, 156, 156, 
	156, 156, 156, 156, 156, 156, 156, 156, 
	156, 156, 156, 156, 156, 156, 156, 156, 
	156, 156, 1, 156, 156, 156, 156, 156, 
	156, 156, 156, 156, 156, 156, 156, 156, 
	156, 156, 156, 1, 138, 138, 138, 138, 
	138, 138, 138, 138, 138, 138, 138, 138, 
	138, 138, 138, 138, 138, 138, 138, 138, 
	138, 138, 138, 138, 138, 138, 138, 138, 
	138, 138, 138, 138, 138, 138, 138, 138, 
	138, 138, 138, 138, 138, 138, 138, 138, 
	138, 138, 138, 138, 138, 138, 138, 138, 
	138, 138, 138, 138, 138, 138, 138, 138, 
	138, 138, 138, 138, 138, 138, 138, 138, 
	138, 138, 138, 138, 138, 138, 138, 138, 
	138, 138, 138, 138, 138, 138, 138, 138, 
	138, 138, 138, 138, 138, 138, 138, 138, 
	138, 138, 138, 138, 138, 138, 138, 138, 
	138, 138, 138, 138, 138, 138, 138, 138, 
	138, 138, 138, 138, 138, 138, 138, 138, 
	138, 138, 138, 138, 138, 138, 138, 138, 
	138, 138, 138, 138, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 141, 141, 
	141, 141, 141, 141, 141, 141, 141, 141, 
	141, 141, 141, 141, 141, 141, 141, 141, 
	141, 141, 141, 141, 141, 141, 141, 141, 
	141, 141, 141, 141, 142, 143, 143, 143, 
	143, 143, 143, 143, 143, 143, 143, 143, 
	143, 144, 143, 143, 145, 146, 146, 146, 
	147, 1, 138, 138, 138, 138, 138, 138, 
	138, 138, 138, 138, 138, 138, 138, 138, 
	138, 138, 138, 138, 138, 138, 138, 138, 
	138, 138, 138, 138, 138, 138, 138, 138, 
	138, 138, 138, 138, 138, 138, 138, 138, 
	138, 138, 138, 138, 138, 138, 138, 138, 
	138, 138, 138, 138, 138, 138, 138, 138, 
	138, 138, 138, 138, 138, 138, 138, 138, 
	138, 138, 1, 141, 141, 141, 141, 141, 
	141, 141, 141, 141, 141, 141, 141, 141, 
	141, 141, 141, 141, 141, 141, 141, 141, 
	141, 141, 141, 141, 141, 141, 141, 141, 
	141, 141, 141, 1, 141, 141, 141, 141, 
	141, 141, 141, 141, 141, 141, 141, 141, 
	141, 141, 141, 141, 141, 141, 141, 141, 
	141, 141, 141, 141, 141, 141, 141, 141, 
	141, 141, 141, 141, 141, 141, 141, 141, 
	141, 141, 141, 141, 141, 141, 141, 141, 
	141, 141, 141, 141, 141, 141, 141, 141, 
	141, 141, 141, 141, 141, 141, 141, 141, 
	141, 141, 141, 141, 1, 141, 141, 141, 
	141, 141, 141, 141, 141, 141, 141, 141, 
	141, 141, 141, 141, 141, 141, 141, 141, 
	141, 141, 141, 141, 141, 141, 141, 141, 
	141, 141, 141, 141, 141, 1, 143, 143, 
	143, 143, 143, 143, 143, 143, 143, 143, 
	143, 143, 143, 143, 143, 143, 143, 143, 
	143, 143, 143, 143, 143, 143, 143, 143, 
	143, 143, 143, 143, 143, 143, 143, 143, 
	143, 143, 143, 143, 143, 143, 143, 143, 
	143, 143, 143, 143, 143, 143, 1, 143, 
	143, 143, 143, 143, 143, 143, 143, 143, 
	143, 143, 143, 143, 143, 143, 143, 143, 
	143, 143, 143, 143, 143, 143, 143, 143, 
	143, 143, 143, 143, 143, 143, 143, 143, 
	143, 143, 143, 143, 143, 143, 143, 143, 
	143, 143, 143, 143, 143, 143, 143, 143, 
	143, 143, 143, 143, 143, 143, 143, 143, 
	143, 143, 143, 143, 143, 143, 143, 1, 
	143, 143, 143, 143, 143, 143, 143, 143, 
	143, 143, 143, 143, 143, 143, 143, 143, 
	1, 165, 1, 91, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 91, 1, 108, 1, 1, 1, 
	115, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 108, 90, 91, 90, 90, 
	90, 90, 90, 117, 1, 90, 90, 1, 
	90, 93, 90, 90, 90, 90, 90, 90, 
	90, 90, 90, 90, 90, 1, 1, 1, 
	90, 1, 90, 1, 90, 90, 90, 90, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	90, 90, 90, 90, 90, 90, 1, 1, 
	1, 90, 90, 90, 90, 90, 90, 90, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	90, 90, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 95, 95, 95, 
	95, 95, 95, 95, 95, 95, 95, 95, 
	95, 95, 95, 95, 95, 95, 95, 95, 
	95, 95, 95, 95, 95, 95, 95, 95, 
	95, 95, 95, 96, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	98, 97, 97, 99, 100, 100, 100, 101, 
	1, 90, 90, 90, 90, 90, 90, 90, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	90, 1, 95, 95, 95, 95, 95, 95, 
	95, 95, 95, 95, 95, 95, 95, 95, 
	95, 95, 95, 95, 95, 95, 95, 95, 
	95, 95, 95, 95, 95, 95, 95, 95, 
	95, 95, 1, 95, 95, 95, 95, 95, 
	95, 95, 95, 95, 95, 95, 95, 95, 
	95, 95, 95, 95, 95, 95, 95, 95, 
	95, 95, 95, 95, 95, 95, 95, 95, 
	95, 95, 95, 95, 95, 95, 95, 95, 
	95, 95, 95, 95, 95, 95, 95, 95, 
	95, 95, 95, 95, 95, 95, 95, 95, 
	95, 95, 95, 95, 95, 95, 95, 95, 
	95, 95, 95, 1, 95, 95, 95, 95, 
	95, 95, 95, 95, 95, 95, 95, 95, 
	95, 95, 95, 95, 95, 95, 95, 95, 
	95, 95, 95, 95, 95, 95, 95, 95, 
	95, 95, 95, 95, 1, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 1, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 1, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 1, 
	166, 1, 1, 1, 167, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 166, 
	168, 169, 168, 168, 168, 168, 168, 170, 
	1, 168, 168, 1, 168, 171, 168, 168, 
	168, 168, 168, 168, 168, 168, 168, 168, 
	168, 1, 1, 1, 168, 1, 168, 1, 
	168, 168, 168, 168, 168, 168, 168, 168, 
	168, 168, 168, 168, 168, 168, 168, 168, 
	168, 168, 168, 168, 168, 168, 168, 168, 
	168, 168, 172, 1, 1, 168, 168, 168, 
	168, 168, 168, 168, 168, 168, 168, 168, 
	168, 168, 168, 168, 168, 168, 168, 168, 
	168, 168, 168, 168, 168, 168, 168, 168, 
	168, 168, 168, 168, 168, 168, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 173, 173, 173, 173, 173, 173, 173, 
	173, 173, 173, 173, 173, 173, 173, 173, 
	173, 173, 173, 173, 173, 173, 173, 173, 
	173, 173, 173, 173, 173, 173, 173, 174, 
	175, 175, 175, 175, 175, 175, 175, 175, 
	175, 175, 175, 175, 176, 175, 175, 177, 
	178, 178, 178, 179, 1, 94, 94, 94, 
	94, 94, 94, 94, 94, 94, 1, 94, 
	94, 180, 94, 94, 94, 94, 94, 94, 
	94, 94, 94, 94, 94, 94, 94, 94, 
	94, 94, 94, 94, 94, 94, 94, 94, 
	94, 94, 94, 94, 94, 94, 94, 94, 
	94, 94, 94, 94, 94, 94, 94, 94, 
	94, 94, 94, 94, 94, 94, 94, 94, 
	94, 94, 94, 94, 94, 94, 94, 94, 
	94, 94, 94, 94, 94, 94, 94, 94, 
	94, 94, 94, 94, 94, 94, 94, 94, 
	94, 94, 94, 94, 94, 94, 94, 1, 
	181, 151, 94, 94, 94, 94, 94, 94, 
	94, 94, 94, 94, 94, 94, 94, 94, 
	94, 94, 94, 94, 94, 94, 94, 94, 
	94, 94, 94, 94, 94, 94, 94, 94, 
	94, 94, 94, 94, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 182, 182, 
	182, 182, 182, 182, 182, 182, 182, 182, 
	182, 182, 182, 182, 182, 182, 182, 182, 
	182, 182, 182, 182, 182, 182, 182, 182, 
	182, 182, 182, 182, 183, 184, 184, 184, 
	184, 184, 184, 184, 184, 184, 184, 184, 
	184, 185, 184, 184, 186, 187, 187, 187, 
	188, 1, 189, 1, 94, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 94, 1, 94, 94, 94, 
	94, 94, 94, 94, 94, 94, 94, 94, 
	94, 94, 94, 94, 94, 94, 94, 94, 
	94, 94, 94, 94, 94, 94, 94, 94, 
	94, 94, 94, 94, 94, 94, 94, 94, 
	94, 94, 94, 94, 94, 94, 94, 94, 
	94, 94, 94, 94, 94, 94, 94, 94, 
	94, 94, 94, 94, 94, 94, 94, 94, 
	94, 94, 94, 94, 94, 94, 94, 94, 
	94, 94, 94, 94, 94, 94, 94, 94, 
	94, 94, 94, 94, 94, 94, 94, 94, 
	94, 94, 94, 94, 94, 94, 94, 94, 
	94, 94, 94, 94, 94, 94, 94, 94, 
	94, 94, 94, 94, 94, 94, 94, 94, 
	94, 94, 94, 94, 94, 94, 94, 94, 
	94, 94, 94, 94, 94, 94, 94, 94, 
	94, 94, 94, 94, 94, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 182, 
	182, 182, 182, 182, 182, 182, 182, 182, 
	182, 182, 182, 182, 182, 182, 182, 182, 
	182, 182, 182, 182, 182, 182, 182, 182, 
	182, 182, 182, 182, 182, 183, 184, 184, 
	184, 184, 184, 184, 184, 184, 184, 184, 
	184, 184, 185, 184, 184, 186, 187, 187, 
	187, 188, 1, 94, 94, 94, 94, 94, 
	94, 94, 94, 94, 94, 94, 94, 94, 
	94, 94, 94, 94, 94, 94, 94, 94, 
	94, 94, 94, 94, 94, 94, 94, 94, 
	94, 94, 94, 94, 94, 94, 94, 94, 
	94, 94, 94, 94, 94, 94, 94, 94, 
	94, 94, 94, 94, 94, 94, 94, 94, 
	94, 94, 94, 94, 94, 94, 94, 94, 
	94, 94, 94, 1, 182, 182, 182, 182, 
	182, 182, 182, 182, 182, 182, 182, 182, 
	182, 182, 182, 182, 182, 182, 182, 182, 
	182, 182, 182, 182, 182, 182, 182, 182, 
	182, 182, 182, 182, 1, 182, 182, 182, 
	182, 182, 182, 182, 182, 182, 182, 182, 
	182, 182, 182, 182, 182, 182, 182, 182, 
	182, 182, 182, 182, 182, 182, 182, 182, 
	182, 182, 182, 182, 182, 182, 182, 182, 
	182, 182, 182, 182, 182, 182, 182, 182, 
	182, 182, 182, 182, 182, 182, 182, 182, 
	182, 182, 182, 182, 182, 182, 182, 182, 
	182, 182, 182, 182, 182, 1, 182, 182, 
	182, 182, 182, 182, 182, 182, 182, 182, 
	182, 182, 182, 182, 182, 182, 182, 182, 
	182, 182, 182, 182, 182, 182, 182, 182, 
	182, 182, 182, 182, 182, 182, 1, 184, 
	184, 184, 184, 184, 184, 184, 184, 184, 
	184, 184, 184, 184, 184, 184, 184, 184, 
	184, 184, 184, 184, 184, 184, 184, 184, 
	184, 184, 184, 184, 184, 184, 184, 184, 
	184, 184, 184, 184, 184, 184, 184, 184, 
	184, 184, 184, 184, 184, 184, 184, 1, 
	184, 184, 184, 184, 184, 184, 184, 184, 
	184, 184, 184, 184, 184, 184, 184, 184, 
	184, 184, 184, 184, 184, 184, 184, 184, 
	184, 184, 184, 184, 184, 184, 184, 184, 
	184, 184, 184, 184, 184, 184, 184, 184, 
	184, 184, 184, 184, 184, 184, 184, 184, 
	184, 184, 184, 184, 184, 184, 184, 184, 
	184, 184, 184, 184, 184, 184, 184, 184, 
	1, 184, 184, 184, 184, 184, 184, 184, 
	184, 184, 184, 184, 184, 184, 184, 184, 
	184, 1, 103, 1, 1, 1, 104, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 103, 190, 91, 190, 190, 190, 190, 
	190, 105, 1, 190, 190, 1, 190, 191, 
	190, 190, 190, 190, 190, 190, 190, 190, 
	190, 190, 190, 1, 1, 1, 190, 107, 
	190, 79, 190, 190, 190, 190, 190, 190, 
	190, 190, 190, 190, 190, 190, 190, 190, 
	190, 190, 190, 190, 190, 190, 190, 190, 
	190, 190, 190, 190, 1, 1, 1, 190, 
	190, 190, 190, 190, 190, 190, 190, 190, 
	190, 190, 190, 190, 190, 190, 190, 190, 
	190, 190, 190, 190, 190, 190, 190, 190, 
	190, 190, 190, 190, 190, 190, 190, 190, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 95, 95, 95, 95, 95, 
	95, 95, 95, 95, 95, 95, 95, 95, 
	95, 95, 95, 95, 95, 95, 95, 95, 
	95, 95, 95, 95, 95, 95, 95, 95, 
	95, 96, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 98, 97, 
	97, 99, 100, 100, 100, 101, 1, 108, 
	1, 1, 1, 115, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 108, 190, 
	91, 190, 190, 190, 190, 190, 117, 1, 
	190, 190, 1, 190, 93, 190, 190, 190, 
	190, 190, 190, 190, 190, 190, 190, 190, 
	1, 1, 1, 190, 192, 190, 79, 190, 
	190, 190, 190, 190, 190, 190, 190, 190, 
	190, 190, 190, 190, 190, 190, 190, 190, 
	190, 190, 190, 190, 190, 190, 190, 190, 
	190, 1, 1, 1, 190, 190, 190, 190, 
	190, 190, 190, 190, 190, 190, 190, 190, 
	190, 190, 190, 190, 190, 190, 190, 190, 
	190, 190, 190, 190, 190, 190, 190, 190, 
	190, 190, 190, 190, 190, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	95, 95, 95, 95, 95, 95, 95, 95, 
	95, 95, 95, 95, 95, 95, 95, 95, 
	95, 95, 95, 95, 95, 95, 95, 95, 
	95, 95, 95, 95, 95, 95, 96, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 98, 97, 97, 99, 100, 
	100, 100, 101, 1, 79, 1, 79, 79, 
	79, 79, 79, 1, 1, 79, 79, 1, 
	79, 193, 79, 79, 79, 79, 79, 79, 
	79, 79, 79, 79, 79, 1, 1, 1, 
	79, 192, 79, 79, 79, 79, 79, 79, 
	79, 79, 79, 79, 79, 79, 79, 79, 
	79, 79, 79, 79, 79, 79, 79, 79, 
	79, 79, 79, 79, 79, 79, 1, 1, 
	1, 79, 79, 79, 79, 79, 79, 79, 
	79, 79, 79, 79, 79, 79, 79, 79, 
	79, 79, 79, 79, 79, 79, 79, 79, 
	79, 79, 79, 79, 79, 79, 79, 79, 
	79, 79, 1, 79, 1, 79, 79, 79, 
	79, 79, 1, 1, 79, 79, 1, 79, 
	1, 79, 79, 79, 79, 79, 79, 79, 
	79, 79, 79, 79, 1, 1, 1, 79, 
	192, 79, 79, 79, 79, 79, 79, 79, 
	79, 79, 79, 79, 79, 79, 79, 79, 
	79, 79, 79, 79, 79, 79, 79, 79, 
	79, 79, 79, 79, 79, 1, 1, 1, 
	79, 79, 79, 79, 79, 79, 79, 79, 
	79, 79, 79, 79, 79, 79, 79, 79, 
	79, 79, 79, 79, 79, 79, 79, 79, 
	79, 79, 79, 79, 79, 79, 79, 79, 
	79, 1, 53, 53, 53, 53, 53, 53, 
	53, 53, 53, 53, 53, 53, 53, 53, 
	53, 53, 53, 53, 53, 53, 53, 53, 
	53, 53, 53, 53, 53, 53, 53, 53, 
	53, 53, 53, 53, 53, 53, 53, 53, 
	53, 53, 53, 53, 53, 53, 53, 53, 
	53, 53, 53, 53, 53, 53, 53, 53, 
	53, 53, 53, 53, 53, 53, 53, 53, 
	53, 53, 1, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 1, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 1, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 1, 58, 58, 
	58, 58, 58, 58, 58, 58, 58, 58, 
	58, 58, 58, 58, 58, 58, 58, 58, 
	58, 58, 58, 58, 58, 58, 58, 58, 
	58, 58, 58, 58, 58, 58, 58, 58, 
	58, 58, 58, 58, 58, 58, 58, 58, 
	58, 58, 58, 58, 58, 58, 1, 58, 
	58, 58, 58, 58, 58, 58, 58, 58, 
	58, 58, 58, 58, 58, 58, 58, 58, 
	58, 58, 58, 58, 58, 58, 58, 58, 
	58, 58, 58, 58, 58, 58, 58, 58, 
	58, 58, 58, 58, 58, 58, 58, 58, 
	58, 58, 58, 58, 58, 58, 58, 58, 
	58, 58, 58, 58, 58, 58, 58, 58, 
	58, 58, 58, 58, 58, 58, 58, 1, 
	58, 58, 58, 58, 58, 58, 58, 58, 
	58, 58, 58, 58, 58, 58, 58, 58, 
	1, 194, 194, 194, 194, 194, 194, 194, 
	194, 194, 1, 194, 194, 195, 194, 194, 
	194, 194, 194, 194, 194, 194, 194, 194, 
	194, 194, 194, 194, 194, 194, 194, 194, 
	194, 194, 196, 194, 194, 194, 194, 194, 
	194, 194, 194, 194, 194, 194, 194, 194, 
	194, 194, 194, 194, 194, 194, 194, 194, 
	194, 194, 194, 194, 194, 194, 194, 194, 
	194, 194, 194, 194, 194, 194, 194, 194, 
	194, 194, 194, 194, 194, 194, 194, 194, 
	194, 194, 194, 194, 194, 194, 194, 194, 
	194, 194, 194, 194, 197, 194, 194, 194, 
	194, 194, 194, 194, 194, 194, 194, 194, 
	194, 194, 194, 194, 194, 194, 194, 194, 
	194, 194, 194, 194, 194, 194, 194, 194, 
	194, 194, 194, 194, 194, 194, 194, 194, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 198, 198, 198, 198, 198, 198, 
	198, 198, 198, 198, 198, 198, 198, 198, 
	198, 198, 198, 198, 198, 198, 198, 198, 
	198, 198, 198, 198, 198, 198, 198, 198, 
	199, 200, 200, 200, 200, 200, 200, 200, 
	200, 200, 200, 200, 200, 201, 200, 200, 
	202, 203, 203, 203, 204, 1, 205, 205, 
	205, 205, 205, 205, 205, 205, 205, 1, 
	205, 205, 206, 205, 205, 205, 205, 205, 
	205, 205, 205, 205, 205, 205, 205, 205, 
	205, 205, 205, 205, 205, 205, 205, 207, 
	205, 205, 205, 205, 205, 205, 205, 205, 
	205, 205, 205, 205, 205, 205, 205, 205, 
	205, 205, 205, 205, 205, 205, 205, 205, 
	205, 205, 205, 205, 205, 205, 205, 205, 
	205, 205, 205, 205, 205, 205, 205, 205, 
	205, 205, 205, 205, 205, 205, 205, 205, 
	205, 205, 205, 205, 205, 205, 205, 205, 
	205, 208, 205, 205, 205, 205, 205, 205, 
	205, 205, 205, 205, 205, 205, 205, 205, 
	205, 205, 205, 205, 205, 205, 205, 205, 
	205, 205, 205, 205, 205, 205, 205, 205, 
	205, 205, 205, 205, 205, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 209, 
	209, 209, 209, 209, 209, 209, 209, 209, 
	209, 209, 209, 209, 209, 209, 209, 209, 
	209, 209, 209, 209, 209, 209, 209, 209, 
	209, 209, 209, 209, 209, 210, 211, 211, 
	211, 211, 211, 211, 211, 211, 211, 211, 
	211, 211, 212, 211, 211, 213, 214, 214, 
	214, 215, 1, 216, 1, 205, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 205, 1, 205, 205, 
	205, 205, 205, 205, 205, 205, 205, 205, 
	205, 205, 205, 205, 205, 205, 205, 205, 
	205, 205, 205, 205, 205, 205, 205, 205, 
	205, 205, 205, 205, 205, 205, 205, 205, 
	205, 205, 205, 205, 205, 205, 205, 205, 
	205, 205, 205, 205, 205, 205, 205, 205, 
	205, 205, 205, 205, 205, 205, 205, 205, 
	205, 205, 205, 205, 205, 205, 205, 205, 
	205, 205, 205, 205, 205, 205, 205, 205, 
	205, 205, 205, 205, 205, 205, 205, 205, 
	205, 205, 205, 205, 205, 205, 205, 205, 
	205, 205, 205, 205, 205, 205, 205, 205, 
	205, 205, 205, 205, 205, 205, 205, 205, 
	205, 205, 205, 205, 205, 205, 205, 205, 
	205, 205, 205, 205, 205, 205, 205, 205, 
	205, 205, 205, 205, 205, 205, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	209, 209, 209, 209, 209, 209, 209, 209, 
	209, 209, 209, 209, 209, 209, 209, 209, 
	209, 209, 209, 209, 209, 209, 209, 209, 
	209, 209, 209, 209, 209, 209, 210, 211, 
	211, 211, 211, 211, 211, 211, 211, 211, 
	211, 211, 211, 212, 211, 211, 213, 214, 
	214, 214, 215, 1, 205, 205, 205, 205, 
	205, 205, 205, 205, 205, 205, 205, 205, 
	205, 205, 205, 205, 205, 205, 205, 205, 
	205, 205, 205, 205, 205, 205, 205, 205, 
	205, 205, 205, 205, 205, 205, 205, 205, 
	205, 205, 205, 205, 205, 205, 205, 205, 
	205, 205, 205, 205, 205, 205, 205, 205, 
	205, 205, 205, 205, 205, 205, 205, 205, 
	205, 205, 205, 205, 1, 209, 209, 209, 
	209, 209, 209, 209, 209, 209, 209, 209, 
	209, 209, 209, 209, 209, 209, 209, 209, 
	209, 209, 209, 209, 209, 209, 209, 209, 
	209, 209, 209, 209, 209, 1, 209, 209, 
	209, 209, 209, 209, 209, 209, 209, 209, 
	209, 209, 209, 209, 209, 209, 209, 209, 
	209, 209, 209, 209, 209, 209, 209, 209, 
	209, 209, 209, 209, 209, 209, 209, 209, 
	209, 209, 209, 209, 209, 209, 209, 209, 
	209, 209, 209, 209, 209, 209, 209, 209, 
	209, 209, 209, 209, 209, 209, 209, 209, 
	209, 209, 209, 209, 209, 209, 1, 209, 
	209, 209, 209, 209, 209, 209, 209, 209, 
	209, 209, 209, 209, 209, 209, 209, 209, 
	209, 209, 209, 209, 209, 209, 209, 209, 
	209, 209, 209, 209, 209, 209, 209, 1, 
	211, 211, 211, 211, 211, 211, 211, 211, 
	211, 211, 211, 211, 211, 211, 211, 211, 
	211, 211, 211, 211, 211, 211, 211, 211, 
	211, 211, 211, 211, 211, 211, 211, 211, 
	211, 211, 211, 211, 211, 211, 211, 211, 
	211, 211, 211, 211, 211, 211, 211, 211, 
	1, 211, 211, 211, 211, 211, 211, 211, 
	211, 211, 211, 211, 211, 211, 211, 211, 
	211, 211, 211, 211, 211, 211, 211, 211, 
	211, 211, 211, 211, 211, 211, 211, 211, 
	211, 211, 211, 211, 211, 211, 211, 211, 
	211, 211, 211, 211, 211, 211, 211, 211, 
	211, 211, 211, 211, 211, 211, 211, 211, 
	211, 211, 211, 211, 211, 211, 211, 211, 
	211, 1, 211, 211, 211, 211, 211, 211, 
	211, 211, 211, 211, 211, 211, 211, 211, 
	211, 211, 1, 50, 1, 1, 1, 217, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 50, 218, 219, 218, 218, 218, 
	218, 218, 220, 1, 218, 218, 1, 218, 
	1, 218, 218, 218, 218, 218, 218, 218, 
	218, 218, 218, 218, 1, 1, 1, 218, 
	1, 218, 1, 218, 218, 218, 218, 218, 
	218, 218, 218, 218, 218, 218, 218, 218, 
	218, 218, 218, 218, 218, 218, 218, 218, 
	218, 218, 218, 218, 218, 1, 1, 1, 
	218, 218, 218, 218, 218, 218, 218, 218, 
	218, 218, 218, 218, 218, 218, 218, 218, 
	218, 218, 218, 218, 218, 218, 218, 218, 
	218, 218, 218, 218, 218, 218, 218, 218, 
	218, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 221, 221, 221, 221, 
	221, 221, 221, 221, 221, 221, 221, 221, 
	221, 221, 221, 221, 221, 221, 221, 221, 
	221, 221, 221, 221, 221, 221, 221, 221, 
	221, 221, 222, 223, 223, 223, 223, 223, 
	223, 223, 223, 223, 223, 223, 223, 224, 
	223, 223, 225, 226, 226, 226, 227, 1, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	30, 1, 228, 228, 229, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 228, 30, 
	228, 1, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 230, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 228, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 231, 231, 231, 231, 231, 231, 231, 
	231, 231, 231, 231, 231, 231, 231, 231, 
	231, 231, 231, 231, 231, 231, 231, 231, 
	231, 231, 231, 231, 231, 231, 231, 232, 
	233, 233, 233, 233, 233, 233, 233, 233, 
	233, 233, 233, 233, 234, 233, 233, 235, 
	236, 236, 236, 237, 1, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 1, 228, 
	228, 238, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 239, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	230, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 231, 231, 
	231, 231, 231, 231, 231, 231, 231, 231, 
	231, 231, 231, 231, 231, 231, 231, 231, 
	231, 231, 231, 231, 231, 231, 231, 231, 
	231, 231, 231, 231, 232, 233, 233, 233, 
	233, 233, 233, 233, 233, 233, 233, 233, 
	233, 234, 233, 233, 235, 236, 236, 236, 
	237, 1, 240, 1, 228, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 228, 1, 241, 1, 1, 
	1, 242, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 241, 239, 30, 239, 
	239, 239, 239, 239, 243, 1, 239, 239, 
	1, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 1, 1, 
	1, 239, 1, 239, 33, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 1, 
	1, 1, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 244, 244, 
	244, 244, 244, 244, 244, 244, 244, 244, 
	244, 244, 244, 244, 244, 244, 244, 244, 
	244, 244, 244, 244, 244, 244, 244, 244, 
	244, 244, 244, 244, 245, 246, 246, 246, 
	246, 246, 246, 246, 246, 246, 246, 246, 
	246, 247, 246, 246, 248, 249, 249, 249, 
	250, 1, 251, 1, 1, 1, 252, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 251, 1, 1, 1, 1, 1, 1, 
	1, 253, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 45, 1, 254, 1, 251, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 251, 1, 255, 1, 
	1, 1, 256, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 255, 1, 1, 
	1, 1, 1, 1, 1, 257, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 51, 1, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 1, 
	244, 244, 244, 244, 244, 244, 244, 244, 
	244, 244, 244, 244, 244, 244, 244, 244, 
	244, 244, 244, 244, 244, 244, 244, 244, 
	244, 244, 244, 244, 244, 244, 244, 244, 
	1, 244, 244, 244, 244, 244, 244, 244, 
	244, 244, 244, 244, 244, 244, 244, 244, 
	244, 244, 244, 244, 244, 244, 244, 244, 
	244, 244, 244, 244, 244, 244, 244, 244, 
	244, 244, 244, 244, 244, 244, 244, 244, 
	244, 244, 244, 244, 244, 244, 244, 244, 
	244, 244, 244, 244, 244, 244, 244, 244, 
	244, 244, 244, 244, 244, 244, 244, 244, 
	244, 1, 244, 244, 244, 244, 244, 244, 
	244, 244, 244, 244, 244, 244, 244, 244, 
	244, 244, 244, 244, 244, 244, 244, 244, 
	244, 244, 244, 244, 244, 244, 244, 244, 
	244, 244, 1, 246, 246, 246, 246, 246, 
	246, 246, 246, 246, 246, 246, 246, 246, 
	246, 246, 246, 246, 246, 246, 246, 246, 
	246, 246, 246, 246, 246, 246, 246, 246, 
	246, 246, 246, 246, 246, 246, 246, 246, 
	246, 246, 246, 246, 246, 246, 246, 246, 
	246, 246, 246, 1, 246, 246, 246, 246, 
	246, 246, 246, 246, 246, 246, 246, 246, 
	246, 246, 246, 246, 246, 246, 246, 246, 
	246, 246, 246, 246, 246, 246, 246, 246, 
	246, 246, 246, 246, 246, 246, 246, 246, 
	246, 246, 246, 246, 246, 246, 246, 246, 
	246, 246, 246, 246, 246, 246, 246, 246, 
	246, 246, 246, 246, 246, 246, 246, 246, 
	246, 246, 246, 246, 1, 246, 246, 246, 
	246, 246, 246, 246, 246, 246, 246, 246, 
	246, 246, 246, 246, 246, 1, 228, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	231, 231, 231, 231, 231, 231, 231, 231, 
	231, 231, 231, 231, 231, 231, 231, 231, 
	231, 231, 231, 231, 231, 231, 231, 231, 
	231, 231, 231, 231, 231, 231, 232, 233, 
	233, 233, 233, 233, 233, 233, 233, 233, 
	233, 233, 233, 234, 233, 233, 235, 236, 
	236, 236, 237, 1, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 1, 231, 231, 231, 
	231, 231, 231, 231, 231, 231, 231, 231, 
	231, 231, 231, 231, 231, 231, 231, 231, 
	231, 231, 231, 231, 231, 231, 231, 231, 
	231, 231, 231, 231, 231, 1, 231, 231, 
	231, 231, 231, 231, 231, 231, 231, 231, 
	231, 231, 231, 231, 231, 231, 231, 231, 
	231, 231, 231, 231, 231, 231, 231, 231, 
	231, 231, 231, 231, 231, 231, 231, 231, 
	231, 231, 231, 231, 231, 231, 231, 231, 
	231, 231, 231, 231, 231, 231, 231, 231, 
	231, 231, 231, 231, 231, 231, 231, 231, 
	231, 231, 231, 231, 231, 231, 1, 231, 
	231, 231, 231, 231, 231, 231, 231, 231, 
	231, 231, 231, 231, 231, 231, 231, 231, 
	231, 231, 231, 231, 231, 231, 231, 231, 
	231, 231, 231, 231, 231, 231, 231, 1, 
	233, 233, 233, 233, 233, 233, 233, 233, 
	233, 233, 233, 233, 233, 233, 233, 233, 
	233, 233, 233, 233, 233, 233, 233, 233, 
	233, 233, 233, 233, 233, 233, 233, 233, 
	233, 233, 233, 233, 233, 233, 233, 233, 
	233, 233, 233, 233, 233, 233, 233, 233, 
	1, 233, 233, 233, 233, 233, 233, 233, 
	233, 233, 233, 233, 233, 233, 233, 233, 
	233, 233, 233, 233, 233, 233, 233, 233, 
	233, 233, 233, 233, 233, 233, 233, 233, 
	233, 233, 233, 233, 233, 233, 233, 233, 
	233, 233, 233, 233, 233, 233, 233, 233, 
	233, 233, 233, 233, 233, 233, 233, 233, 
	233, 233, 233, 233, 233, 233, 233, 233, 
	233, 1, 233, 233, 233, 233, 233, 233, 
	233, 233, 233, 233, 233, 233, 233, 233, 
	233, 233, 1, 258, 1, 30, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 30, 1, 259, 1, 
	1, 1, 260, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 259, 29, 261, 
	29, 29, 29, 29, 29, 262, 1, 29, 
	29, 1, 29, 239, 29, 29, 29, 29, 
	29, 29, 29, 29, 29, 29, 29, 1, 
	1, 1, 29, 1, 29, 33, 29, 29, 
	29, 29, 29, 29, 29, 29, 29, 29, 
	29, 29, 29, 29, 29, 29, 29, 29, 
	29, 29, 29, 29, 29, 29, 29, 29, 
	1, 1, 1, 29, 29, 29, 29, 29, 
	29, 29, 29, 29, 29, 29, 29, 29, 
	29, 29, 29, 29, 29, 29, 29, 29, 
	29, 29, 29, 29, 29, 29, 29, 29, 
	29, 29, 29, 29, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	34, 34, 34, 34, 34, 35, 36, 36, 
	36, 36, 36, 36, 36, 36, 36, 36, 
	36, 36, 37, 36, 36, 38, 39, 39, 
	39, 40, 1, 263, 1, 1, 1, 264, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 263, 53, 54, 53, 53, 53, 
	53, 53, 265, 1, 53, 53, 1, 53, 
	1, 53, 53, 53, 53, 53, 53, 53, 
	53, 53, 53, 53, 1, 1, 1, 53, 
	1, 53, 45, 53, 53, 53, 53, 53, 
	53, 53, 53, 53, 53, 53, 53, 53, 
	53, 53, 53, 53, 53, 53, 53, 53, 
	53, 53, 53, 53, 53, 1, 1, 1, 
	53, 53, 53, 53, 53, 53, 53, 53, 
	53, 53, 53, 53, 53, 53, 53, 53, 
	53, 53, 53, 53, 53, 53, 53, 53, 
	53, 53, 53, 53, 53, 53, 53, 53, 
	53, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 57, 58, 58, 58, 58, 58, 
	58, 58, 58, 58, 58, 58, 58, 59, 
	58, 58, 60, 61, 61, 61, 62, 1, 
	266, 1, 263, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 263, 1, 267, 1, 1, 1, 268, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 267, 218, 219, 218, 218, 218, 
	218, 218, 269, 1, 218, 218, 1, 218, 
	1, 218, 218, 218, 218, 218, 218, 218, 
	218, 218, 218, 218, 1, 1, 1, 218, 
	1, 218, 51, 218, 218, 218, 218, 218, 
	218, 218, 218, 218, 218, 218, 218, 218, 
	218, 218, 218, 218, 218, 218, 218, 218, 
	218, 218, 218, 218, 218, 1, 1, 1, 
	218, 218, 218, 218, 218, 218, 218, 218, 
	218, 218, 218, 218, 218, 218, 218, 218, 
	218, 218, 218, 218, 218, 218, 218, 218, 
	218, 218, 218, 218, 218, 218, 218, 218, 
	218, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 221, 221, 221, 221, 
	221, 221, 221, 221, 221, 221, 221, 221, 
	221, 221, 221, 221, 221, 221, 221, 221, 
	221, 221, 221, 221, 221, 221, 221, 221, 
	221, 221, 222, 223, 223, 223, 223, 223, 
	223, 223, 223, 223, 223, 223, 223, 224, 
	223, 223, 225, 226, 226, 226, 227, 1, 
	270, 270, 270, 270, 270, 270, 270, 270, 
	271, 1, 270, 270, 272, 270, 270, 270, 
	270, 270, 270, 270, 270, 270, 270, 270, 
	270, 270, 270, 270, 270, 270, 270, 271, 
	270, 196, 270, 270, 270, 270, 270, 270, 
	270, 270, 270, 270, 270, 270, 270, 270, 
	270, 270, 270, 270, 270, 270, 270, 270, 
	270, 270, 270, 270, 270, 270, 270, 270, 
	270, 270, 270, 270, 270, 270, 270, 270, 
	270, 270, 270, 270, 270, 270, 270, 270, 
	270, 270, 270, 270, 270, 270, 270, 270, 
	270, 270, 270, 273, 270, 270, 270, 270, 
	270, 270, 270, 270, 270, 270, 270, 270, 
	270, 270, 270, 270, 270, 270, 270, 270, 
	270, 270, 270, 270, 270, 270, 270, 270, 
	270, 270, 270, 270, 270, 270, 270, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 274, 274, 274, 274, 274, 274, 274, 
	274, 274, 274, 274, 274, 274, 274, 274, 
	274, 274, 274, 274, 274, 274, 274, 274, 
	274, 274, 274, 274, 274, 274, 274, 275, 
	276, 276, 276, 276, 276, 276, 276, 276, 
	276, 276, 276, 276, 277, 276, 276, 278, 
	279, 279, 279, 280, 1, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 1, 281, 
	281, 282, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 283, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	284, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 285, 285, 
	285, 285, 285, 285, 285, 285, 285, 285, 
	285, 285, 285, 285, 285, 285, 285, 285, 
	285, 285, 285, 285, 285, 285, 285, 285, 
	285, 285, 285, 285, 286, 287, 287, 287, 
	287, 287, 287, 287, 287, 287, 287, 287, 
	287, 288, 287, 287, 289, 290, 290, 290, 
	291, 1, 292, 1, 281, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 281, 1, 27, 1, 1, 
	1, 28, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 27, 239, 30, 239, 
	239, 239, 239, 239, 31, 1, 239, 239, 
	1, 239, 32, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 1, 1, 
	1, 239, 1, 239, 33, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 1, 
	1, 1, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 244, 244, 
	244, 244, 244, 244, 244, 244, 244, 244, 
	244, 244, 244, 244, 244, 244, 244, 244, 
	244, 244, 244, 244, 244, 244, 244, 244, 
	244, 244, 244, 244, 245, 246, 246, 246, 
	246, 246, 246, 246, 246, 246, 246, 246, 
	246, 247, 246, 246, 248, 249, 249, 249, 
	250, 1, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 285, 285, 285, 285, 
	285, 285, 285, 285, 285, 285, 285, 285, 
	285, 285, 285, 285, 285, 285, 285, 285, 
	285, 285, 285, 285, 285, 285, 285, 285, 
	285, 285, 286, 287, 287, 287, 287, 287, 
	287, 287, 287, 287, 287, 287, 287, 288, 
	287, 287, 289, 290, 290, 290, 291, 1, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	1, 285, 285, 285, 285, 285, 285, 285, 
	285, 285, 285, 285, 285, 285, 285, 285, 
	285, 285, 285, 285, 285, 285, 285, 285, 
	285, 285, 285, 285, 285, 285, 285, 285, 
	285, 1, 285, 285, 285, 285, 285, 285, 
	285, 285, 285, 285, 285, 285, 285, 285, 
	285, 285, 285, 285, 285, 285, 285, 285, 
	285, 285, 285, 285, 285, 285, 285, 285, 
	285, 285, 285, 285, 285, 285, 285, 285, 
	285, 285, 285, 285, 285, 285, 285, 285, 
	285, 285, 285, 285, 285, 285, 285, 285, 
	285, 285, 285, 285, 285, 285, 285, 285, 
	285, 285, 1, 285, 285, 285, 285, 285, 
	285, 285, 285, 285, 285, 285, 285, 285, 
	285, 285, 285, 285, 285, 285, 285, 285, 
	285, 285, 285, 285, 285, 285, 285, 285, 
	285, 285, 285, 1, 287, 287, 287, 287, 
	287, 287, 287, 287, 287, 287, 287, 287, 
	287, 287, 287, 287, 287, 287, 287, 287, 
	287, 287, 287, 287, 287, 287, 287, 287, 
	287, 287, 287, 287, 287, 287, 287, 287, 
	287, 287, 287, 287, 287, 287, 287, 287, 
	287, 287, 287, 287, 1, 287, 287, 287, 
	287, 287, 287, 287, 287, 287, 287, 287, 
	287, 287, 287, 287, 287, 287, 287, 287, 
	287, 287, 287, 287, 287, 287, 287, 287, 
	287, 287, 287, 287, 287, 287, 287, 287, 
	287, 287, 287, 287, 287, 287, 287, 287, 
	287, 287, 287, 287, 287, 287, 287, 287, 
	287, 287, 287, 287, 287, 287, 287, 287, 
	287, 287, 287, 287, 287, 1, 287, 287, 
	287, 287, 287, 287, 287, 287, 287, 287, 
	287, 287, 287, 287, 287, 287, 1, 281, 
	281, 281, 281, 281, 281, 281, 281, 293, 
	1, 281, 281, 294, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 293, 281, 
	207, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 284, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	285, 285, 285, 285, 285, 285, 285, 285, 
	285, 285, 285, 285, 285, 285, 285, 285, 
	285, 285, 285, 285, 285, 285, 285, 285, 
	285, 285, 285, 285, 285, 285, 286, 287, 
	287, 287, 287, 287, 287, 287, 287, 287, 
	287, 287, 287, 288, 287, 287, 289, 290, 
	290, 290, 291, 1, 295, 1, 293, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 293, 1, 29, 
	29, 29, 29, 29, 29, 29, 29, 29, 
	29, 29, 29, 29, 29, 29, 29, 29, 
	29, 29, 29, 29, 29, 29, 29, 29, 
	29, 29, 29, 29, 29, 29, 29, 29, 
	29, 29, 29, 29, 29, 29, 29, 29, 
	29, 29, 29, 29, 29, 29, 29, 29, 
	29, 29, 29, 29, 29, 29, 29, 29, 
	29, 29, 29, 29, 29, 29, 29, 1, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	1, 34, 34, 34, 34, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	34, 1, 34, 34, 34, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	34, 34, 1, 36, 36, 36, 36, 36, 
	36, 36, 36, 36, 36, 36, 36, 36, 
	36, 36, 36, 36, 36, 36, 36, 36, 
	36, 36, 36, 36, 36, 36, 36, 36, 
	36, 36, 36, 36, 36, 36, 36, 36, 
	36, 36, 36, 36, 36, 36, 36, 36, 
	36, 36, 36, 1, 36, 36, 36, 36, 
	36, 36, 36, 36, 36, 36, 36, 36, 
	36, 36, 36, 36, 36, 36, 36, 36, 
	36, 36, 36, 36, 36, 36, 36, 36, 
	36, 36, 36, 36, 36, 36, 36, 36, 
	36, 36, 36, 36, 36, 36, 36, 36, 
	36, 36, 36, 36, 36, 36, 36, 36, 
	36, 36, 36, 36, 36, 36, 36, 36, 
	36, 36, 36, 36, 1, 36, 36, 36, 
	36, 36, 36, 36, 36, 36, 36, 36, 
	36, 36, 36, 36, 36, 1, 296, 296, 
	296, 296, 296, 296, 296, 296, 297, 1, 
	296, 296, 298, 296, 296, 296, 296, 296, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	296, 296, 296, 296, 296, 297, 296, 299, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	296, 300, 296, 296, 296, 296, 296, 296, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	296, 296, 296, 296, 296, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 301, 
	301, 301, 301, 301, 301, 301, 301, 301, 
	301, 301, 301, 301, 301, 301, 301, 301, 
	301, 301, 301, 301, 301, 301, 301, 301, 
	301, 301, 301, 301, 301, 302, 303, 303, 
	303, 303, 303, 303, 303, 303, 303, 303, 
	303, 303, 304, 303, 303, 305, 306, 306, 
	306, 307, 1, 308, 308, 308, 308, 308, 
	308, 308, 308, 308, 1, 308, 308, 309, 
	308, 308, 308, 308, 308, 308, 308, 308, 
	308, 308, 308, 308, 308, 308, 308, 308, 
	308, 308, 308, 308, 310, 308, 308, 308, 
	308, 308, 308, 308, 308, 308, 308, 308, 
	308, 308, 308, 308, 308, 308, 308, 308, 
	308, 308, 308, 308, 308, 308, 308, 308, 
	308, 308, 308, 308, 308, 308, 308, 308, 
	308, 308, 308, 308, 308, 308, 308, 308, 
	308, 308, 308, 308, 308, 308, 308, 308, 
	308, 308, 308, 308, 308, 308, 311, 308, 
	308, 308, 308, 308, 308, 308, 308, 308, 
	308, 308, 308, 308, 308, 308, 308, 308, 
	308, 308, 308, 308, 308, 308, 308, 308, 
	308, 308, 308, 308, 308, 308, 308, 308, 
	308, 308, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 312, 312, 312, 312, 
	312, 312, 312, 312, 312, 312, 312, 312, 
	312, 312, 312, 312, 312, 312, 312, 312, 
	312, 312, 312, 312, 312, 312, 312, 312, 
	312, 312, 313, 314, 314, 314, 314, 314, 
	314, 314, 314, 314, 314, 314, 314, 315, 
	314, 314, 316, 317, 317, 317, 318, 1, 
	319, 1, 308, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 308, 1, 320, 1, 1, 1, 321, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 320, 239, 30, 239, 239, 239, 
	239, 239, 322, 1, 239, 239, 1, 239, 
	32, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 1, 1, 1, 239, 
	1, 239, 323, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 1, 1, 1, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 244, 244, 244, 244, 
	244, 244, 244, 244, 244, 244, 244, 244, 
	244, 244, 244, 244, 244, 244, 244, 244, 
	244, 244, 244, 244, 244, 244, 244, 244, 
	244, 244, 245, 246, 246, 246, 246, 246, 
	246, 246, 246, 246, 246, 246, 246, 247, 
	246, 246, 248, 249, 249, 249, 250, 1, 
	324, 1, 1, 1, 325, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 324, 
	1, 1, 1, 1, 1, 1, 1, 326, 
	1, 1, 1, 1, 1, 44, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 327, 
	1, 328, 1, 324, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 324, 1, 329, 1, 1, 1, 
	330, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 329, 1, 1, 1, 1, 
	1, 1, 1, 331, 1, 1, 1, 1, 
	1, 50, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 332, 1, 308, 308, 308, 
	308, 308, 308, 308, 308, 308, 308, 308, 
	308, 308, 308, 308, 308, 308, 308, 308, 
	308, 308, 308, 308, 308, 308, 308, 308, 
	308, 308, 308, 308, 308, 308, 308, 308, 
	308, 308, 308, 308, 308, 308, 308, 308, 
	308, 308, 308, 308, 308, 308, 308, 308, 
	308, 308, 308, 308, 308, 308, 308, 308, 
	308, 308, 308, 308, 308, 308, 308, 308, 
	308, 308, 308, 308, 308, 308, 308, 308, 
	308, 308, 308, 308, 308, 308, 308, 308, 
	308, 308, 308, 308, 308, 308, 308, 308, 
	308, 308, 308, 308, 308, 308, 308, 308, 
	308, 308, 308, 308, 308, 308, 308, 308, 
	308, 308, 308, 308, 308, 308, 308, 308, 
	308, 308, 308, 308, 308, 308, 308, 308, 
	308, 308, 308, 308, 308, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 312, 
	312, 312, 312, 312, 312, 312, 312, 312, 
	312, 312, 312, 312, 312, 312, 312, 312, 
	312, 312, 312, 312, 312, 312, 312, 312, 
	312, 312, 312, 312, 312, 313, 314, 314, 
	314, 314, 314, 314, 314, 314, 314, 314, 
	314, 314, 315, 314, 314, 316, 317, 317, 
	317, 318, 1, 308, 308, 308, 308, 308, 
	308, 308, 308, 308, 308, 308, 308, 308, 
	308, 308, 308, 308, 308, 308, 308, 308, 
	308, 308, 308, 308, 308, 308, 308, 308, 
	308, 308, 308, 308, 308, 308, 308, 308, 
	308, 308, 308, 308, 308, 308, 308, 308, 
	308, 308, 308, 308, 308, 308, 308, 308, 
	308, 308, 308, 308, 308, 308, 308, 308, 
	308, 308, 308, 1, 312, 312, 312, 312, 
	312, 312, 312, 312, 312, 312, 312, 312, 
	312, 312, 312, 312, 312, 312, 312, 312, 
	312, 312, 312, 312, 312, 312, 312, 312, 
	312, 312, 312, 312, 1, 312, 312, 312, 
	312, 312, 312, 312, 312, 312, 312, 312, 
	312, 312, 312, 312, 312, 312, 312, 312, 
	312, 312, 312, 312, 312, 312, 312, 312, 
	312, 312, 312, 312, 312, 312, 312, 312, 
	312, 312, 312, 312, 312, 312, 312, 312, 
	312, 312, 312, 312, 312, 312, 312, 312, 
	312, 312, 312, 312, 312, 312, 312, 312, 
	312, 312, 312, 312, 312, 1, 312, 312, 
	312, 312, 312, 312, 312, 312, 312, 312, 
	312, 312, 312, 312, 312, 312, 312, 312, 
	312, 312, 312, 312, 312, 312, 312, 312, 
	312, 312, 312, 312, 312, 312, 1, 314, 
	314, 314, 314, 314, 314, 314, 314, 314, 
	314, 314, 314, 314, 314, 314, 314, 314, 
	314, 314, 314, 314, 314, 314, 314, 314, 
	314, 314, 314, 314, 314, 314, 314, 314, 
	314, 314, 314, 314, 314, 314, 314, 314, 
	314, 314, 314, 314, 314, 314, 314, 1, 
	314, 314, 314, 314, 314, 314, 314, 314, 
	314, 314, 314, 314, 314, 314, 314, 314, 
	314, 314, 314, 314, 314, 314, 314, 314, 
	314, 314, 314, 314, 314, 314, 314, 314, 
	314, 314, 314, 314, 314, 314, 314, 314, 
	314, 314, 314, 314, 314, 314, 314, 314, 
	314, 314, 314, 314, 314, 314, 314, 314, 
	314, 314, 314, 314, 314, 314, 314, 314, 
	1, 314, 314, 314, 314, 314, 314, 314, 
	314, 314, 314, 314, 314, 314, 314, 314, 
	314, 1, 308, 308, 308, 308, 308, 308, 
	308, 308, 333, 1, 308, 308, 334, 308, 
	308, 308, 308, 308, 308, 308, 308, 308, 
	308, 308, 308, 308, 308, 308, 308, 308, 
	308, 333, 308, 335, 308, 308, 308, 308, 
	308, 308, 308, 308, 308, 308, 308, 308, 
	308, 308, 308, 308, 308, 308, 308, 308, 
	308, 308, 308, 308, 308, 308, 308, 308, 
	308, 308, 308, 308, 308, 308, 308, 308, 
	308, 308, 308, 308, 308, 308, 308, 308, 
	308, 308, 308, 308, 308, 308, 308, 308, 
	308, 308, 308, 308, 308, 311, 308, 308, 
	308, 308, 308, 308, 308, 308, 308, 308, 
	308, 308, 308, 308, 308, 308, 308, 308, 
	308, 308, 308, 308, 308, 308, 308, 308, 
	308, 308, 308, 308, 308, 308, 308, 308, 
	308, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 312, 312, 312, 312, 312, 
	312, 312, 312, 312, 312, 312, 312, 312, 
	312, 312, 312, 312, 312, 312, 312, 312, 
	312, 312, 312, 312, 312, 312, 312, 312, 
	312, 313, 314, 314, 314, 314, 314, 314, 
	314, 314, 314, 314, 314, 314, 315, 314, 
	314, 316, 317, 317, 317, 318, 1, 336, 
	1, 333, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	333, 1, 337, 1, 1, 1, 338, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 337, 1, 1, 1, 1, 1, 1, 
	1, 339, 1, 1, 1, 1, 1, 44, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 340, 1, 341, 1, 337, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 337, 1, 342, 1, 
	1, 1, 343, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 342, 1, 1, 
	1, 1, 1, 1, 1, 344, 1, 1, 
	1, 1, 1, 50, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 345, 1, 346, 
	1, 1, 1, 347, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 346, 348, 
	349, 348, 348, 348, 348, 348, 350, 1, 
	348, 348, 1, 348, 351, 348, 348, 348, 
	348, 348, 348, 348, 348, 348, 348, 348, 
	1, 1, 1, 348, 1, 348, 1, 348, 
	348, 348, 348, 348, 348, 348, 348, 348, 
	348, 348, 348, 348, 348, 348, 348, 348, 
	348, 348, 348, 348, 348, 348, 348, 348, 
	348, 1, 1, 1, 348, 348, 348, 348, 
	348, 348, 348, 348, 348, 348, 348, 348, 
	348, 348, 348, 348, 348, 348, 348, 348, 
	348, 348, 348, 348, 348, 348, 348, 348, 
	348, 348, 348, 348, 348, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	352, 352, 352, 352, 352, 352, 352, 352, 
	352, 352, 352, 352, 352, 352, 352, 352, 
	352, 352, 352, 352, 352, 352, 352, 352, 
	352, 352, 352, 352, 352, 352, 353, 354, 
	354, 354, 354, 354, 354, 354, 354, 354, 
	354, 354, 354, 355, 354, 354, 356, 357, 
	357, 357, 358, 1, 239, 30, 239, 239, 
	239, 239, 239, 1, 1, 239, 239, 1, 
	239, 359, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 1, 1, 1, 
	239, 1, 239, 1, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 1, 1, 
	1, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 244, 244, 244, 
	244, 244, 244, 244, 244, 244, 244, 244, 
	244, 244, 244, 244, 244, 244, 244, 244, 
	244, 244, 244, 244, 244, 244, 244, 244, 
	244, 244, 244, 245, 246, 246, 246, 246, 
	246, 246, 246, 246, 246, 246, 246, 246, 
	247, 246, 246, 248, 249, 249, 249, 250, 
	1, 360, 360, 360, 360, 360, 360, 360, 
	360, 360, 1, 360, 360, 361, 360, 360, 
	360, 360, 360, 360, 360, 360, 360, 360, 
	360, 360, 360, 360, 360, 360, 360, 360, 
	360, 360, 360, 360, 360, 360, 360, 360, 
	362, 363, 360, 360, 360, 360, 360, 360, 
	360, 360, 360, 360, 360, 360, 360, 360, 
	360, 360, 360, 360, 360, 360, 360, 360, 
	360, 360, 360, 360, 360, 360, 360, 360, 
	360, 360, 360, 360, 360, 360, 360, 360, 
	360, 360, 360, 360, 360, 360, 360, 360, 
	360, 360, 360, 360, 364, 360, 360, 360, 
	360, 360, 360, 360, 360, 360, 360, 360, 
	360, 360, 360, 360, 360, 360, 360, 360, 
	360, 360, 360, 360, 360, 360, 360, 360, 
	360, 360, 360, 360, 360, 360, 360, 360, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 365, 365, 365, 365, 365, 365, 
	365, 365, 365, 365, 365, 365, 365, 365, 
	365, 365, 365, 365, 365, 365, 365, 365, 
	365, 365, 365, 365, 365, 365, 365, 365, 
	366, 367, 367, 367, 367, 367, 367, 367, 
	367, 367, 367, 367, 367, 368, 367, 367, 
	369, 370, 370, 370, 371, 1, 372, 372, 
	372, 372, 372, 372, 372, 372, 372, 1, 
	372, 372, 373, 372, 372, 372, 372, 372, 
	372, 372, 372, 372, 372, 372, 372, 372, 
	372, 372, 372, 372, 372, 372, 372, 372, 
	372, 372, 372, 372, 372, 374, 375, 372, 
	372, 372, 372, 372, 372, 372, 372, 372, 
	372, 372, 372, 372, 372, 372, 372, 372, 
	372, 372, 372, 372, 372, 372, 372, 372, 
	372, 372, 372, 372, 372, 372, 372, 372, 
	372, 372, 372, 372, 372, 372, 372, 372, 
	372, 372, 372, 372, 372, 372, 372, 372, 
	372, 376, 372, 372, 372, 372, 372, 372, 
	372, 372, 372, 372, 372, 372, 372, 372, 
	372, 372, 372, 372, 372, 372, 372, 372, 
	372, 372, 372, 372, 372, 372, 372, 372, 
	372, 372, 372, 372, 372, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 377, 
	377, 377, 377, 377, 377, 377, 377, 377, 
	377, 377, 377, 377, 377, 377, 377, 377, 
	377, 377, 377, 377, 377, 377, 377, 377, 
	377, 377, 377, 377, 377, 378, 379, 379, 
	379, 379, 379, 379, 379, 379, 379, 379, 
	379, 379, 380, 379, 379, 381, 382, 382, 
	382, 383, 1, 384, 1, 372, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 372, 1, 372, 372, 
	372, 372, 372, 372, 372, 372, 372, 372, 
	372, 372, 372, 372, 372, 372, 372, 372, 
	372, 372, 372, 372, 372, 372, 372, 372, 
	372, 372, 372, 372, 372, 372, 372, 372, 
	372, 372, 372, 372, 372, 372, 372, 372, 
	372, 372, 372, 372, 372, 372, 372, 372, 
	372, 372, 372, 372, 372, 372, 372, 372, 
	372, 372, 372, 372, 372, 372, 372, 372, 
	372, 372, 372, 372, 372, 372, 372, 372, 
	372, 372, 372, 372, 372, 372, 372, 372, 
	372, 372, 372, 372, 372, 372, 372, 372, 
	372, 372, 372, 372, 372, 372, 372, 372, 
	372, 372, 372, 372, 372, 372, 372, 372, 
	372, 372, 372, 372, 372, 372, 372, 372, 
	372, 372, 372, 372, 372, 372, 372, 372, 
	372, 372, 372, 372, 372, 372, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	377, 377, 377, 377, 377, 377, 377, 377, 
	377, 377, 377, 377, 377, 377, 377, 377, 
	377, 377, 377, 377, 377, 377, 377, 377, 
	377, 377, 377, 377, 377, 377, 378, 379, 
	379, 379, 379, 379, 379, 379, 379, 379, 
	379, 379, 379, 380, 379, 379, 381, 382, 
	382, 382, 383, 1, 372, 372, 372, 372, 
	372, 372, 372, 372, 372, 372, 372, 372, 
	372, 372, 372, 372, 372, 372, 372, 372, 
	372, 372, 372, 372, 372, 372, 372, 372, 
	372, 372, 372, 372, 372, 372, 372, 372, 
	372, 372, 372, 372, 372, 372, 372, 372, 
	372, 372, 372, 372, 372, 372, 372, 372, 
	372, 372, 372, 372, 372, 372, 372, 372, 
	372, 372, 372, 372, 1, 377, 377, 377, 
	377, 377, 377, 377, 377, 377, 377, 377, 
	377, 377, 377, 377, 377, 377, 377, 377, 
	377, 377, 377, 377, 377, 377, 377, 377, 
	377, 377, 377, 377, 377, 1, 377, 377, 
	377, 377, 377, 377, 377, 377, 377, 377, 
	377, 377, 377, 377, 377, 377, 377, 377, 
	377, 377, 377, 377, 377, 377, 377, 377, 
	377, 377, 377, 377, 377, 377, 377, 377, 
	377, 377, 377, 377, 377, 377, 377, 377, 
	377, 377, 377, 377, 377, 377, 377, 377, 
	377, 377, 377, 377, 377, 377, 377, 377, 
	377, 377, 377, 377, 377, 377, 1, 377, 
	377, 377, 377, 377, 377, 377, 377, 377, 
	377, 377, 377, 377, 377, 377, 377, 377, 
	377, 377, 377, 377, 377, 377, 377, 377, 
	377, 377, 377, 377, 377, 377, 377, 1, 
	379, 379, 379, 379, 379, 379, 379, 379, 
	379, 379, 379, 379, 379, 379, 379, 379, 
	379, 379, 379, 379, 379, 379, 379, 379, 
	379, 379, 379, 379, 379, 379, 379, 379, 
	379, 379, 379, 379, 379, 379, 379, 379, 
	379, 379, 379, 379, 379, 379, 379, 379, 
	1, 379, 379, 379, 379, 379, 379, 379, 
	379, 379, 379, 379, 379, 379, 379, 379, 
	379, 379, 379, 379, 379, 379, 379, 379, 
	379, 379, 379, 379, 379, 379, 379, 379, 
	379, 379, 379, 379, 379, 379, 379, 379, 
	379, 379, 379, 379, 379, 379, 379, 379, 
	379, 379, 379, 379, 379, 379, 379, 379, 
	379, 379, 379, 379, 379, 379, 379, 379, 
	379, 1, 379, 379, 379, 379, 379, 379, 
	379, 379, 379, 379, 379, 379, 379, 379, 
	379, 379, 1, 385, 1, 1, 1, 386, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 385, 1, 1, 1, 1, 1, 
	1, 1, 387, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 388, 1, 
	127, 1, 1, 1, 389, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 127, 
	1, 1, 1, 1, 1, 1, 1, 390, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 4, 1, 391, 1, 1, 
	1, 392, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 391, 1, 1, 1, 
	1, 1, 1, 1, 393, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	9, 1, 1, 0
]

class << self
	attr_accessor :_trans_targs
	private :_trans_targs, :_trans_targs=
end
self._trans_targs = [
	1, 0, 2, 4, 5, 3, 1, 2, 
	4, 5, 6, 7, 9, 170, 194, 195, 
	163, 164, 165, 166, 167, 168, 169, 6, 
	7, 194, 8, 10, 11, 9, 116, 13, 
	142, 22, 163, 164, 165, 166, 167, 168, 
	169, 10, 11, 13, 14, 22, 12, 10, 
	11, 13, 14, 22, 15, 17, 103, 115, 
	96, 97, 98, 99, 100, 101, 102, 16, 
	18, 19, 21, 22, 20, 18, 19, 21, 
	22, 23, 24, 92, 45, 80, 54, 94, 
	81, 73, 74, 75, 76, 77, 78, 79, 
	23, 24, 26, 45, 80, 54, 81, 73, 
	74, 75, 76, 77, 78, 79, 25, 27, 
	28, 30, 72, 208, 31, 29, 27, 28, 
	30, 31, 208, 32, 34, 44, 37, 38, 
	39, 40, 41, 42, 43, 33, 36, 209, 
	32, 34, 44, 37, 38, 39, 40, 41, 
	42, 43, 46, 70, 62, 63, 64, 65, 
	66, 67, 68, 69, 47, 49, 48, 50, 
	51, 53, 55, 56, 57, 58, 59, 60, 
	61, 52, 50, 51, 53, 71, 23, 24, 
	26, 45, 80, 54, 81, 73, 74, 75, 
	76, 77, 78, 79, 82, 84, 85, 86, 
	87, 88, 89, 90, 91, 83, 92, 93, 
	208, 95, 104, 105, 18, 107, 108, 109, 
	110, 111, 112, 113, 114, 104, 105, 18, 
	107, 108, 109, 110, 111, 112, 113, 114, 
	106, 15, 17, 103, 115, 96, 97, 98, 
	99, 100, 101, 102, 117, 140, 132, 133, 
	134, 135, 136, 137, 138, 139, 118, 120, 
	119, 121, 122, 124, 125, 126, 127, 128, 
	129, 130, 131, 121, 122, 124, 123, 121, 
	122, 124, 141, 143, 144, 147, 146, 143, 
	144, 146, 145, 143, 144, 146, 148, 160, 
	161, 152, 153, 154, 155, 156, 157, 158, 
	159, 148, 149, 151, 152, 153, 154, 155, 
	156, 157, 158, 159, 150, 160, 161, 162, 
	171, 187, 188, 190, 179, 180, 181, 182, 
	183, 184, 185, 186, 171, 172, 174, 179, 
	180, 181, 182, 183, 184, 185, 186, 173, 
	175, 176, 178, 22, 175, 176, 178, 22, 
	177, 175, 176, 178, 22, 187, 188, 190, 
	189, 190, 191, 193, 22, 192, 190, 191, 
	193, 22, 6, 7, 9, 170, 194, 195, 
	163, 164, 165, 166, 167, 168, 169, 195, 
	197, 198, 197, 211, 200, 201, 202, 203, 
	204, 205, 206, 207, 197, 198, 197, 211, 
	200, 201, 202, 203, 204, 205, 206, 207, 
	199, 209, 35, 210, 5, 35, 210, 209, 
	35, 210
]

class << self
	attr_accessor :_trans_actions
	private :_trans_actions, :_trans_actions=
end
self._trans_actions = [
	0, 0, 0, 1, 2, 0, 3, 3, 
	4, 5, 6, 6, 6, 6, 7, 6, 
	6, 6, 6, 6, 6, 6, 6, 0, 
	0, 1, 0, 8, 8, 0, 0, 9, 
	0, 10, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 1, 0, 11, 0, 3, 
	3, 4, 3, 12, 0, 0, 0, 1, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 1, 0, 0, 3, 3, 4, 
	3, 13, 13, 13, 13, 14, 13, 0, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	0, 0, 0, 0, 1, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 1, 0, 15, 0, 0, 3, 3, 
	4, 3, 16, 0, 0, 1, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	3, 3, 4, 3, 3, 3, 3, 3, 
	3, 3, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 1, 0, 0, 0, 0, 0, 0, 
	0, 0, 3, 3, 4, 0, 3, 3, 
	3, 3, 4, 3, 3, 3, 3, 3, 
	3, 3, 3, 3, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 17, 17, 18, 17, 17, 17, 
	17, 17, 17, 17, 17, 0, 0, 19, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 3, 3, 3, 4, 3, 3, 3, 
	3, 3, 3, 3, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 8, 8, 9, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 1, 0, 3, 
	3, 4, 0, 8, 8, 0, 9, 0, 
	0, 1, 0, 3, 3, 4, 17, 17, 
	17, 17, 17, 17, 17, 17, 17, 17, 
	17, 0, 0, 19, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	17, 17, 17, 18, 17, 17, 17, 17, 
	17, 17, 17, 17, 0, 0, 19, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	8, 8, 9, 20, 0, 0, 1, 21, 
	0, 3, 3, 4, 22, 0, 0, 19, 
	0, 0, 0, 1, 23, 0, 3, 3, 
	4, 24, 3, 3, 25, 25, 4, 25, 
	25, 25, 25, 25, 25, 25, 25, 0, 
	26, 26, 27, 28, 26, 26, 26, 26, 
	26, 26, 26, 26, 0, 0, 1, 29, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 30, 30, 31, 32, 0, 1, 3, 
	3, 4
]

class << self
	attr_accessor :_eof_actions
	private :_eof_actions, :_eof_actions=
end
self._eof_actions = [
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	30, 0, 3, 0
]

class << self
	attr_accessor :start
end
self.start = 1;
class << self
	attr_accessor :first_final
end
self.first_final = 208;
class << self
	attr_accessor :error
end
self.error = 0;

class << self
	attr_accessor :en_comment_tail
end
self.en_comment_tail = 196;
class << self
	attr_accessor :en_main
end
self.en_main = 1;



    def self.parse(data)
      data = data.dup.force_encoding(Encoding::ASCII_8BIT) if data.respond_to?(:force_encoding)

      raise Mail::Field::NilParseError.new(Mail::MessageIdsElement) if data.nil?

      # Parser state
      message_ids = MessageIdsStruct.new([])
      msg_id_s = nil

      # 5.1 Variables Used by Ragel
      p = 0
      eof = pe = data.length
      stack = []

      
begin
	p ||= 0
	pe ||= data.length
	cs = start
	top = 0
end

      
begin
	testEof = false
	_slen, _trans, _keys, _inds, _acts, _nacts = nil
	_goto_level = 0
	_resume = 10
	_eof_trans = 15
	_again = 20
	_test_eof = 30
	_out = 40
	while true
	if _goto_level <= 0
	if p == pe
		_goto_level = _test_eof
		next
	end
	if cs == 0
		_goto_level = _out
		next
	end
	end
	if _goto_level <= _resume
	_keys = cs << 1
	_inds = _index_offsets[cs]
	_slen = _key_spans[cs]
	_wide = data[p].ord
	_trans = if (   _slen > 0 && 
			_trans_keys[_keys] <= _wide && 
			_wide <= _trans_keys[_keys + 1] 
		    ) then
			_indicies[ _inds + _wide - _trans_keys[_keys] ] 
		 else 
			_indicies[ _inds + _slen ]
		 end
	cs = _trans_targs[_trans]
	if _trans_actions[_trans] != 0
	case _trans_actions[_trans]
	when 2 then
		begin
 msg_id_s = p 		end
	when 30 then
		begin
 message_ids.message_ids << chars(data, msg_id_s, p-1).rstrip 		end
	when 3 then
		begin
		end
	when 26 then
		begin
		end
	when 15 then
		begin
		end
	when 13 then
		begin
		end
	when 11 then
		begin
		end
	when 8 then
		begin
		end
	when 6 then
		begin
		end
	when 19 then
		begin
		end
	when 17 then
		begin
		end
	when 23 then
		begin
		end
	when 1 then
		begin
 	begin
		stack[top] = cs
		top+= 1
		cs = 196
		_goto_level = _again
		next
	end
 		end
	when 29 then
		begin
 	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end
 		end
	when 32 then
		begin
 message_ids.message_ids << chars(data, msg_id_s, p-1).rstrip 		end
		begin
 msg_id_s = p 		end
	when 31 then
		begin
 message_ids.message_ids << chars(data, msg_id_s, p-1).rstrip 		end
		begin
 	begin
		stack[top] = cs
		top+= 1
		cs = 196
		_goto_level = _again
		next
	end
 		end
	when 5 then
		begin
		end
		begin
 msg_id_s = p 		end
	when 16 then
		begin
		end
		begin
		end
	when 12 then
		begin
		end
		begin
		end
	when 25 then
		begin
		end
		begin
		end
	when 24 then
		begin
		end
		begin
		end
	when 4 then
		begin
		end
		begin
 	begin
		stack[top] = cs
		top+= 1
		cs = 196
		_goto_level = _again
		next
	end
 		end
	when 27 then
		begin
		end
		begin
 	begin
		stack[top] = cs
		top+= 1
		cs = 196
		_goto_level = _again
		next
	end
 		end
	when 28 then
		begin
		end
		begin
 	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end
 		end
	when 14 then
		begin
		end
		begin
 	begin
		stack[top] = cs
		top+= 1
		cs = 196
		_goto_level = _again
		next
	end
 		end
	when 21 then
		begin
		end
		begin
		end
	when 10 then
		begin
		end
		begin
		end
	when 9 then
		begin
		end
		begin
 	begin
		stack[top] = cs
		top+= 1
		cs = 196
		_goto_level = _again
		next
	end
 		end
	when 7 then
		begin
		end
		begin
 	begin
		stack[top] = cs
		top+= 1
		cs = 196
		_goto_level = _again
		next
	end
 		end
	when 18 then
		begin
		end
		begin
		end
	when 22 then
		begin
		end
		begin
		end
		begin
		end
	when 20 then
		begin
		end
		begin
		end
		begin
		end
	end
	end
	end
	if _goto_level <= _again
	if cs == 0
		_goto_level = _out
		next
	end
	p += 1
	if p != pe
		_goto_level = _resume
		next
	end
	end
	if _goto_level <= _test_eof
	if p == eof
	  case _eof_actions[cs]
	when 30 then
		begin
 message_ids.message_ids << chars(data, msg_id_s, p-1).rstrip 		end
	when 3 then
		begin
		end
	  end
	end

	end
	if _goto_level <= _out
		break
	end
end
	end


      if p != eof || cs < 208
        raise Mail::Field::IncompleteParseError.new(Mail::MessageIdsElement, data, p)
      end

      message_ids
    end
  end
end
