// **********************************************************************
//
// Copyright (c) 2003-2017 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.7.0
//
// <auto-generated>
//
// Generated from file `RemoteLogger.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

#ifndef __Ice_RemoteLogger_h__
#define __Ice_RemoteLogger_h__

#include <IceUtil/PushDisableWarnings.h>
#include <Ice/ProxyF.h>
#include <Ice/ObjectF.h>
#include <Ice/ValueF.h>
#include <Ice/Exception.h>
#include <Ice/LocalObject.h>
#include <Ice/StreamHelpers.h>
#include <Ice/Comparable.h>
#include <Ice/Proxy.h>
#include <Ice/Object.h>
#include <Ice/GCObject.h>
#include <Ice/Value.h>
#include <Ice/Incoming.h>
#include <Ice/FactoryTableInit.h>
#include <IceUtil/ScopedArray.h>
#include <Ice/Optional.h>
#include <Ice/ExceptionHelpers.h>
#include <Ice/BuiltinSequences.h>
#include <IceUtil/UndefSysMacros.h>
#include <list>

#ifndef ICE_IGNORE_VERSION
#   if ICE_INT_VERSION / 100 != 307
#       error Ice version mismatch!
#   endif
#   if ICE_INT_VERSION % 100 > 50
#       error Beta header file detected
#   endif
#   if ICE_INT_VERSION % 100 < 0
#       error Ice patch level mismatch!
#   endif
#endif

#ifndef ICE_API
#   if defined(ICE_STATIC_LIBS)
#       define ICE_API /**/
#   elif defined(ICE_API_EXPORTS)
#       define ICE_API ICE_DECLSPEC_EXPORT
#   else
#       define ICE_API ICE_DECLSPEC_IMPORT
#   endif
#endif

#ifdef ICE_CPP11_MAPPING // C++11 mapping

namespace Ice
{

class RemoteLogger;
class RemoteLoggerPrx;
class LoggerAdmin;
class LoggerAdminPrx;

}

namespace Ice
{

enum class LogMessageType : unsigned char
{
    PrintMessage,
    TraceMessage,
    WarningMessage,
    ErrorMessage
};

using LogMessageTypeSeq = ::std::vector<::Ice::LogMessageType>;

struct LogMessage
{
    ::Ice::LogMessageType type;
    long long int timestamp;
    ::std::string traceCategory;
    ::std::string message;

    std::tuple<const ::Ice::LogMessageType&, const long long int&, const ::std::string&, const ::std::string&> ice_tuple() const
    {
        return std::tie(type, timestamp, traceCategory, message);
    }
};

using LogMessageSeq = std::list<LogMessage>;

class ICE_CLASS(ICE_API) RemoteLoggerAlreadyAttachedException : public ::Ice::UserExceptionHelper<RemoteLoggerAlreadyAttachedException, ::Ice::UserException>
{
public:

    ICE_MEMBER(ICE_API) virtual ~RemoteLoggerAlreadyAttachedException();

    RemoteLoggerAlreadyAttachedException(const RemoteLoggerAlreadyAttachedException&) = default;

    RemoteLoggerAlreadyAttachedException() = default;

    std::tuple<> ice_tuple() const
    {
        return std::tie();
    }

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();
};

static RemoteLoggerAlreadyAttachedException _iceS_RemoteLoggerAlreadyAttachedException_init;

using Ice::operator<;
using Ice::operator<=;
using Ice::operator>;
using Ice::operator>=;
using Ice::operator==;
using Ice::operator!=;

}

namespace Ice
{

class ICE_API RemoteLogger : public virtual ::Ice::Object
{
public:

    using ProxyType = RemoteLoggerPrx;

    virtual bool ice_isA(::std::string, const ::Ice::Current&) const override;
    virtual ::std::vector<::std::string> ice_ids(const ::Ice::Current&) const override;
    virtual ::std::string ice_id(const ::Ice::Current&) const override;

    static const ::std::string& ice_staticId();

    virtual void init(::std::string, ::Ice::LogMessageSeq, const ::Ice::Current&) = 0;
    bool _iceD_init(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void log(::Ice::LogMessage, const ::Ice::Current&) = 0;
    bool _iceD_log(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&) override;
};

class ICE_API LoggerAdmin : public virtual ::Ice::Object
{
public:

    using ProxyType = LoggerAdminPrx;

    virtual bool ice_isA(::std::string, const ::Ice::Current&) const override;
    virtual ::std::vector<::std::string> ice_ids(const ::Ice::Current&) const override;
    virtual ::std::string ice_id(const ::Ice::Current&) const override;

    static const ::std::string& ice_staticId();

    virtual void attachRemoteLogger(::std::shared_ptr<::Ice::RemoteLoggerPrx>, ::Ice::LogMessageTypeSeq, ::Ice::StringSeq, int, const ::Ice::Current&) = 0;
    bool _iceD_attachRemoteLogger(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual bool detachRemoteLogger(::std::shared_ptr<::Ice::RemoteLoggerPrx>, const ::Ice::Current&) = 0;
    bool _iceD_detachRemoteLogger(::IceInternal::Incoming&, const ::Ice::Current&);

    struct GetLogResult
    {
        ::Ice::LogMessageSeq returnValue;
        ::std::string prefix;
    };

    virtual ::Ice::LogMessageSeq getLog(::Ice::LogMessageTypeSeq, ::Ice::StringSeq, int, ::std::string&, const ::Ice::Current&) = 0;
    bool _iceD_getLog(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&) override;
};

}

namespace Ice
{

class ICE_CLASS(ICE_API) RemoteLoggerPrx : public virtual ::Ice::Proxy<RemoteLoggerPrx, ::Ice::ObjectPrx>
{
public:

    void init(const ::std::string& iceP_prefix, const ::Ice::LogMessageSeq& iceP_logMessages, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &Ice::RemoteLoggerPrx::_iceI_init, iceP_prefix, iceP_logMessages, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto initAsync(const ::std::string& iceP_prefix, const ::Ice::LogMessageSeq& iceP_logMessages, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &Ice::RemoteLoggerPrx::_iceI_init, iceP_prefix, iceP_logMessages, context);
    }

    ::std::function<void()>
    initAsync(const ::std::string& iceP_prefix, const ::Ice::LogMessageSeq& iceP_logMessages,
              ::std::function<void()> response,
              ::std::function<void(::std::exception_ptr)> ex = nullptr,
              ::std::function<void(bool)> sent = nullptr,
              const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(response, ex, sent, this, &Ice::RemoteLoggerPrx::_iceI_init, iceP_prefix, iceP_logMessages, context);
    }

    ICE_MEMBER(ICE_API) void _iceI_init(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::string&, const ::Ice::LogMessageSeq&, const ::Ice::Context&);

    void log(const ::Ice::LogMessage& iceP_message, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &Ice::RemoteLoggerPrx::_iceI_log, iceP_message, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto logAsync(const ::Ice::LogMessage& iceP_message, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &Ice::RemoteLoggerPrx::_iceI_log, iceP_message, context);
    }

    ::std::function<void()>
    logAsync(const ::Ice::LogMessage& iceP_message,
             ::std::function<void()> response,
             ::std::function<void(::std::exception_ptr)> ex = nullptr,
             ::std::function<void(bool)> sent = nullptr,
             const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(response, ex, sent, this, &Ice::RemoteLoggerPrx::_iceI_log, iceP_message, context);
    }

    ICE_MEMBER(ICE_API) void _iceI_log(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::Ice::LogMessage&, const ::Ice::Context&);

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();

protected:

    RemoteLoggerPrx() = default;
    friend ::std::shared_ptr<RemoteLoggerPrx> IceInternal::createProxy<RemoteLoggerPrx>();

    ICE_MEMBER(ICE_API) virtual ::std::shared_ptr<::Ice::ObjectPrx> _newInstance() const override;
};

class ICE_CLASS(ICE_API) LoggerAdminPrx : public virtual ::Ice::Proxy<LoggerAdminPrx, ::Ice::ObjectPrx>
{
public:

    void attachRemoteLogger(const ::std::shared_ptr<::Ice::RemoteLoggerPrx>& iceP_prx, const ::Ice::LogMessageTypeSeq& iceP_messageTypes, const ::Ice::StringSeq& iceP_traceCategories, int iceP_messageMax, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &Ice::LoggerAdminPrx::_iceI_attachRemoteLogger, iceP_prx, iceP_messageTypes, iceP_traceCategories, iceP_messageMax, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto attachRemoteLoggerAsync(const ::std::shared_ptr<::Ice::RemoteLoggerPrx>& iceP_prx, const ::Ice::LogMessageTypeSeq& iceP_messageTypes, const ::Ice::StringSeq& iceP_traceCategories, int iceP_messageMax, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &Ice::LoggerAdminPrx::_iceI_attachRemoteLogger, iceP_prx, iceP_messageTypes, iceP_traceCategories, iceP_messageMax, context);
    }

    ::std::function<void()>
    attachRemoteLoggerAsync(const ::std::shared_ptr<::Ice::RemoteLoggerPrx>& iceP_prx, const ::Ice::LogMessageTypeSeq& iceP_messageTypes, const ::Ice::StringSeq& iceP_traceCategories, int iceP_messageMax,
                            ::std::function<void()> response,
                            ::std::function<void(::std::exception_ptr)> ex = nullptr,
                            ::std::function<void(bool)> sent = nullptr,
                            const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(response, ex, sent, this, &Ice::LoggerAdminPrx::_iceI_attachRemoteLogger, iceP_prx, iceP_messageTypes, iceP_traceCategories, iceP_messageMax, context);
    }

    ICE_MEMBER(ICE_API) void _iceI_attachRemoteLogger(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::shared_ptr<::Ice::RemoteLoggerPrx>&, const ::Ice::LogMessageTypeSeq&, const ::Ice::StringSeq&, int, const ::Ice::Context&);

    bool detachRemoteLogger(const ::std::shared_ptr<::Ice::RemoteLoggerPrx>& iceP_prx, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<bool>(true, this, &Ice::LoggerAdminPrx::_iceI_detachRemoteLogger, iceP_prx, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto detachRemoteLoggerAsync(const ::std::shared_ptr<::Ice::RemoteLoggerPrx>& iceP_prx, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<bool>>().get_future())
    {
        return _makePromiseOutgoing<bool, P>(false, this, &Ice::LoggerAdminPrx::_iceI_detachRemoteLogger, iceP_prx, context);
    }

    ::std::function<void()>
    detachRemoteLoggerAsync(const ::std::shared_ptr<::Ice::RemoteLoggerPrx>& iceP_prx,
                            ::std::function<void(bool)> response,
                            ::std::function<void(::std::exception_ptr)> ex = nullptr,
                            ::std::function<void(bool)> sent = nullptr,
                            const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<bool>(response, ex, sent, this, &Ice::LoggerAdminPrx::_iceI_detachRemoteLogger, iceP_prx, context);
    }

    ICE_MEMBER(ICE_API) void _iceI_detachRemoteLogger(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<bool>>&, const ::std::shared_ptr<::Ice::RemoteLoggerPrx>&, const ::Ice::Context&);

    ::Ice::LogMessageSeq getLog(const ::Ice::LogMessageTypeSeq& iceP_messageTypes, const ::Ice::StringSeq& iceP_traceCategories, int iceP_messageMax, ::std::string& iceP_prefix, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        auto result = _makePromiseOutgoing<::Ice::LoggerAdmin::GetLogResult>(true, this, &Ice::LoggerAdminPrx::_iceI_getLog, iceP_messageTypes, iceP_traceCategories, iceP_messageMax, context).get();
        iceP_prefix = ::std::move(result.prefix);
        return ::std::move(result.returnValue);
    }

    template<template<typename> class P = ::std::promise>
    auto getLogAsync(const ::Ice::LogMessageTypeSeq& iceP_messageTypes, const ::Ice::StringSeq& iceP_traceCategories, int iceP_messageMax, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<::Ice::LoggerAdmin::GetLogResult>>().get_future())
    {
        return _makePromiseOutgoing<::Ice::LoggerAdmin::GetLogResult, P>(false, this, &Ice::LoggerAdminPrx::_iceI_getLog, iceP_messageTypes, iceP_traceCategories, iceP_messageMax, context);
    }

    ::std::function<void()>
    getLogAsync(const ::Ice::LogMessageTypeSeq& iceP_messageTypes, const ::Ice::StringSeq& iceP_traceCategories, int iceP_messageMax,
                ::std::function<void(::Ice::LogMessageSeq, ::std::string)> response,
                ::std::function<void(::std::exception_ptr)> ex = nullptr,
                ::std::function<void(bool)> sent = nullptr,
                const ::Ice::Context& context = Ice::noExplicitContext)
    {
        auto responseCb = [response](::Ice::LoggerAdmin::GetLogResult&& result)
        {
            response(::std::move(result.returnValue), ::std::move(result.prefix));
        };
        return _makeLamdaOutgoing<::Ice::LoggerAdmin::GetLogResult>(responseCb, ex, sent, this, &Ice::LoggerAdminPrx::_iceI_getLog, iceP_messageTypes, iceP_traceCategories, iceP_messageMax, context);
    }

    ICE_MEMBER(ICE_API) void _iceI_getLog(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::Ice::LoggerAdmin::GetLogResult>>&, const ::Ice::LogMessageTypeSeq&, const ::Ice::StringSeq&, int, const ::Ice::Context&);

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();

protected:

    LoggerAdminPrx() = default;
    friend ::std::shared_ptr<LoggerAdminPrx> IceInternal::createProxy<LoggerAdminPrx>();

    ICE_MEMBER(ICE_API) virtual ::std::shared_ptr<::Ice::ObjectPrx> _newInstance() const override;
};

}

namespace Ice
{

template<>
struct StreamableTraits< ::Ice::LogMessageType>
{
    static const StreamHelperCategory helper = StreamHelperCategoryEnum;
    static const int minValue = 0;
    static const int maxValue = 3;
    static const int minWireSize = 1;
    static const bool fixedLength = false;
};

template<>
struct StreamableTraits<::Ice::LogMessage>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 11;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamReader<::Ice::LogMessage, S>
{
    static void read(S* istr, ::Ice::LogMessage& v)
    {
        istr->readAll(v.type, v.timestamp, v.traceCategory, v.message);
    }
};

}

namespace Ice
{

using RemoteLoggerPtr = ::std::shared_ptr<RemoteLogger>;
using RemoteLoggerPrxPtr = ::std::shared_ptr<RemoteLoggerPrx>;

using LoggerAdminPtr = ::std::shared_ptr<LoggerAdmin>;
using LoggerAdminPrxPtr = ::std::shared_ptr<LoggerAdminPrx>;

}

#else // C++98 mapping

namespace IceProxy
{

namespace Ice
{

class RemoteLogger;
ICE_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< ::IceProxy::Ice::RemoteLogger>&);
ICE_API ::IceProxy::Ice::Object* upCast(::IceProxy::Ice::RemoteLogger*);

class LoggerAdmin;
ICE_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< ::IceProxy::Ice::LoggerAdmin>&);
ICE_API ::IceProxy::Ice::Object* upCast(::IceProxy::Ice::LoggerAdmin*);

}

}

namespace Ice
{

class RemoteLogger;
ICE_API ::Ice::Object* upCast(::Ice::RemoteLogger*);
typedef ::IceInternal::Handle< ::Ice::RemoteLogger> RemoteLoggerPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::Ice::RemoteLogger> RemoteLoggerPrx;
typedef RemoteLoggerPrx RemoteLoggerPrxPtr;
ICE_API void _icePatchObjectPtr(RemoteLoggerPtr&, const ::Ice::ObjectPtr&);

class LoggerAdmin;
ICE_API ::Ice::Object* upCast(::Ice::LoggerAdmin*);
typedef ::IceInternal::Handle< ::Ice::LoggerAdmin> LoggerAdminPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::Ice::LoggerAdmin> LoggerAdminPrx;
typedef LoggerAdminPrx LoggerAdminPrxPtr;
ICE_API void _icePatchObjectPtr(LoggerAdminPtr&, const ::Ice::ObjectPtr&);

}

namespace Ice
{

enum LogMessageType
{
    PrintMessage,
    TraceMessage,
    WarningMessage,
    ErrorMessage
};

typedef ::std::vector< ::Ice::LogMessageType> LogMessageTypeSeq;

struct LogMessage
{
    ::Ice::LogMessageType type;
    ::Ice::Long timestamp;
    ::std::string traceCategory;
    ::std::string message;

    bool operator==(const LogMessage& rhs_) const
    {
        if(this == &rhs_)
        {
            return true;
        }
        if(type != rhs_.type)
        {
            return false;
        }
        if(timestamp != rhs_.timestamp)
        {
            return false;
        }
        if(traceCategory != rhs_.traceCategory)
        {
            return false;
        }
        if(message != rhs_.message)
        {
            return false;
        }
        return true;
    }

    bool operator<(const LogMessage& rhs_) const
    {
        if(this == &rhs_)
        {
            return false;
        }
        if(type < rhs_.type)
        {
            return true;
        }
        else if(rhs_.type < type)
        {
            return false;
        }
        if(timestamp < rhs_.timestamp)
        {
            return true;
        }
        else if(rhs_.timestamp < timestamp)
        {
            return false;
        }
        if(traceCategory < rhs_.traceCategory)
        {
            return true;
        }
        else if(rhs_.traceCategory < traceCategory)
        {
            return false;
        }
        if(message < rhs_.message)
        {
            return true;
        }
        else if(rhs_.message < message)
        {
            return false;
        }
        return false;
    }

    bool operator!=(const LogMessage& rhs_) const
    {
        return !operator==(rhs_);
    }
    bool operator<=(const LogMessage& rhs_) const
    {
        return operator<(rhs_) || operator==(rhs_);
    }
    bool operator>(const LogMessage& rhs_) const
    {
        return !operator<(rhs_) && !operator==(rhs_);
    }
    bool operator>=(const LogMessage& rhs_) const
    {
        return !operator<(rhs_);
    }
};

typedef std::list<LogMessage> LogMessageSeq;

class ICE_API RemoteLoggerAlreadyAttachedException : public ::Ice::UserException
{
public:

    RemoteLoggerAlreadyAttachedException() {}
    virtual ~RemoteLoggerAlreadyAttachedException() throw();

    virtual ::std::string ice_id() const;
    virtual RemoteLoggerAlreadyAttachedException* ice_clone() const;
    virtual void ice_throw() const;

protected:

    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
};

static RemoteLoggerAlreadyAttachedException _iceS_RemoteLoggerAlreadyAttachedException_init;

}

namespace Ice
{

class Callback_RemoteLogger_init_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_RemoteLogger_init_Base> Callback_RemoteLogger_initPtr;

class Callback_RemoteLogger_log_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_RemoteLogger_log_Base> Callback_RemoteLogger_logPtr;

class Callback_LoggerAdmin_attachRemoteLogger_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_LoggerAdmin_attachRemoteLogger_Base> Callback_LoggerAdmin_attachRemoteLoggerPtr;

class Callback_LoggerAdmin_detachRemoteLogger_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_LoggerAdmin_detachRemoteLogger_Base> Callback_LoggerAdmin_detachRemoteLoggerPtr;

class Callback_LoggerAdmin_getLog_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_LoggerAdmin_getLog_Base> Callback_LoggerAdmin_getLogPtr;

}

namespace IceProxy
{

namespace Ice
{

class ICE_CLASS(ICE_API) RemoteLogger : public virtual ::Ice::Proxy<RemoteLogger, ::IceProxy::Ice::Object>
{
public:

    ICE_MEMBER(ICE_API) void init(const ::std::string& iceP_prefix, const ::Ice::LogMessageSeq& iceP_logMessages, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_init(_iceI_begin_init(iceP_prefix, iceP_logMessages, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_init(const ::std::string& iceP_prefix, const ::Ice::LogMessageSeq& iceP_logMessages, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_init(iceP_prefix, iceP_logMessages, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_init(const ::std::string& iceP_prefix, const ::Ice::LogMessageSeq& iceP_logMessages, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_init(iceP_prefix, iceP_logMessages, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_init(const ::std::string& iceP_prefix, const ::Ice::LogMessageSeq& iceP_logMessages, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_init(iceP_prefix, iceP_logMessages, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_init(const ::std::string& iceP_prefix, const ::Ice::LogMessageSeq& iceP_logMessages, const ::Ice::Callback_RemoteLogger_initPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_init(iceP_prefix, iceP_logMessages, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_init(const ::std::string& iceP_prefix, const ::Ice::LogMessageSeq& iceP_logMessages, const ::Ice::Context& context, const ::Ice::Callback_RemoteLogger_initPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_init(iceP_prefix, iceP_logMessages, context, del, cookie);
    }

    ICE_MEMBER(ICE_API) void end_init(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICE_API) ::Ice::AsyncResultPtr _iceI_begin_init(const ::std::string&, const ::Ice::LogMessageSeq&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICE_API) void log(const ::Ice::LogMessage& iceP_message, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_log(_iceI_begin_log(iceP_message, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_log(const ::Ice::LogMessage& iceP_message, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_log(iceP_message, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_log(const ::Ice::LogMessage& iceP_message, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_log(iceP_message, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_log(const ::Ice::LogMessage& iceP_message, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_log(iceP_message, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_log(const ::Ice::LogMessage& iceP_message, const ::Ice::Callback_RemoteLogger_logPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_log(iceP_message, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_log(const ::Ice::LogMessage& iceP_message, const ::Ice::Context& context, const ::Ice::Callback_RemoteLogger_logPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_log(iceP_message, context, del, cookie);
    }

    ICE_MEMBER(ICE_API) void end_log(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICE_API) ::Ice::AsyncResultPtr _iceI_begin_log(const ::Ice::LogMessage&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();

protected:

    ICE_MEMBER(ICE_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
};

class ICE_CLASS(ICE_API) LoggerAdmin : public virtual ::Ice::Proxy<LoggerAdmin, ::IceProxy::Ice::Object>
{
public:

    ICE_MEMBER(ICE_API) void attachRemoteLogger(const ::Ice::RemoteLoggerPrx& iceP_prx, const ::Ice::LogMessageTypeSeq& iceP_messageTypes, const ::Ice::StringSeq& iceP_traceCategories, ::Ice::Int iceP_messageMax, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_attachRemoteLogger(_iceI_begin_attachRemoteLogger(iceP_prx, iceP_messageTypes, iceP_traceCategories, iceP_messageMax, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_attachRemoteLogger(const ::Ice::RemoteLoggerPrx& iceP_prx, const ::Ice::LogMessageTypeSeq& iceP_messageTypes, const ::Ice::StringSeq& iceP_traceCategories, ::Ice::Int iceP_messageMax, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_attachRemoteLogger(iceP_prx, iceP_messageTypes, iceP_traceCategories, iceP_messageMax, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_attachRemoteLogger(const ::Ice::RemoteLoggerPrx& iceP_prx, const ::Ice::LogMessageTypeSeq& iceP_messageTypes, const ::Ice::StringSeq& iceP_traceCategories, ::Ice::Int iceP_messageMax, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_attachRemoteLogger(iceP_prx, iceP_messageTypes, iceP_traceCategories, iceP_messageMax, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_attachRemoteLogger(const ::Ice::RemoteLoggerPrx& iceP_prx, const ::Ice::LogMessageTypeSeq& iceP_messageTypes, const ::Ice::StringSeq& iceP_traceCategories, ::Ice::Int iceP_messageMax, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_attachRemoteLogger(iceP_prx, iceP_messageTypes, iceP_traceCategories, iceP_messageMax, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_attachRemoteLogger(const ::Ice::RemoteLoggerPrx& iceP_prx, const ::Ice::LogMessageTypeSeq& iceP_messageTypes, const ::Ice::StringSeq& iceP_traceCategories, ::Ice::Int iceP_messageMax, const ::Ice::Callback_LoggerAdmin_attachRemoteLoggerPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_attachRemoteLogger(iceP_prx, iceP_messageTypes, iceP_traceCategories, iceP_messageMax, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_attachRemoteLogger(const ::Ice::RemoteLoggerPrx& iceP_prx, const ::Ice::LogMessageTypeSeq& iceP_messageTypes, const ::Ice::StringSeq& iceP_traceCategories, ::Ice::Int iceP_messageMax, const ::Ice::Context& context, const ::Ice::Callback_LoggerAdmin_attachRemoteLoggerPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_attachRemoteLogger(iceP_prx, iceP_messageTypes, iceP_traceCategories, iceP_messageMax, context, del, cookie);
    }

    ICE_MEMBER(ICE_API) void end_attachRemoteLogger(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICE_API) ::Ice::AsyncResultPtr _iceI_begin_attachRemoteLogger(const ::Ice::RemoteLoggerPrx&, const ::Ice::LogMessageTypeSeq&, const ::Ice::StringSeq&, ::Ice::Int, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICE_API) bool detachRemoteLogger(const ::Ice::RemoteLoggerPrx& iceP_prx, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_detachRemoteLogger(_iceI_begin_detachRemoteLogger(iceP_prx, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_detachRemoteLogger(const ::Ice::RemoteLoggerPrx& iceP_prx, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_detachRemoteLogger(iceP_prx, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_detachRemoteLogger(const ::Ice::RemoteLoggerPrx& iceP_prx, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_detachRemoteLogger(iceP_prx, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_detachRemoteLogger(const ::Ice::RemoteLoggerPrx& iceP_prx, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_detachRemoteLogger(iceP_prx, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_detachRemoteLogger(const ::Ice::RemoteLoggerPrx& iceP_prx, const ::Ice::Callback_LoggerAdmin_detachRemoteLoggerPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_detachRemoteLogger(iceP_prx, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_detachRemoteLogger(const ::Ice::RemoteLoggerPrx& iceP_prx, const ::Ice::Context& context, const ::Ice::Callback_LoggerAdmin_detachRemoteLoggerPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_detachRemoteLogger(iceP_prx, context, del, cookie);
    }

    ICE_MEMBER(ICE_API) bool end_detachRemoteLogger(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICE_API) ::Ice::AsyncResultPtr _iceI_begin_detachRemoteLogger(const ::Ice::RemoteLoggerPrx&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICE_API) ::Ice::LogMessageSeq getLog(const ::Ice::LogMessageTypeSeq& iceP_messageTypes, const ::Ice::StringSeq& iceP_traceCategories, ::Ice::Int iceP_messageMax, ::std::string& iceP_prefix, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getLog(iceP_prefix, _iceI_begin_getLog(iceP_messageTypes, iceP_traceCategories, iceP_messageMax, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_getLog(const ::Ice::LogMessageTypeSeq& iceP_messageTypes, const ::Ice::StringSeq& iceP_traceCategories, ::Ice::Int iceP_messageMax, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getLog(iceP_messageTypes, iceP_traceCategories, iceP_messageMax, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_getLog(const ::Ice::LogMessageTypeSeq& iceP_messageTypes, const ::Ice::StringSeq& iceP_traceCategories, ::Ice::Int iceP_messageMax, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getLog(iceP_messageTypes, iceP_traceCategories, iceP_messageMax, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getLog(const ::Ice::LogMessageTypeSeq& iceP_messageTypes, const ::Ice::StringSeq& iceP_traceCategories, ::Ice::Int iceP_messageMax, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getLog(iceP_messageTypes, iceP_traceCategories, iceP_messageMax, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getLog(const ::Ice::LogMessageTypeSeq& iceP_messageTypes, const ::Ice::StringSeq& iceP_traceCategories, ::Ice::Int iceP_messageMax, const ::Ice::Callback_LoggerAdmin_getLogPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getLog(iceP_messageTypes, iceP_traceCategories, iceP_messageMax, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getLog(const ::Ice::LogMessageTypeSeq& iceP_messageTypes, const ::Ice::StringSeq& iceP_traceCategories, ::Ice::Int iceP_messageMax, const ::Ice::Context& context, const ::Ice::Callback_LoggerAdmin_getLogPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getLog(iceP_messageTypes, iceP_traceCategories, iceP_messageMax, context, del, cookie);
    }

    ICE_MEMBER(ICE_API) ::Ice::LogMessageSeq end_getLog(::std::string& iceP_prefix, const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICE_API) ::Ice::AsyncResultPtr _iceI_begin_getLog(const ::Ice::LogMessageTypeSeq&, const ::Ice::StringSeq&, ::Ice::Int, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();

protected:

    ICE_MEMBER(ICE_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
};

}

}

namespace Ice
{

class ICE_API RemoteLogger : public virtual ::Ice::Object
{
public:

    typedef RemoteLoggerPrx ProxyType;
    typedef RemoteLoggerPtr PointerType;

    virtual ~RemoteLogger();

    virtual bool ice_isA(const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual const ::std::string& ice_id(const ::Ice::Current& = ::Ice::emptyCurrent) const;

    static const ::std::string& ice_staticId();

    virtual void init(const ::std::string&, const ::Ice::LogMessageSeq&, const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_init(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void log(const ::Ice::LogMessage&, const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_log(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&);

protected:

    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
};

inline bool operator==(const RemoteLogger& lhs, const RemoteLogger& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const RemoteLogger& lhs, const RemoteLogger& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}

class ICE_API LoggerAdmin : public virtual ::Ice::Object
{
public:

    typedef LoggerAdminPrx ProxyType;
    typedef LoggerAdminPtr PointerType;

    virtual ~LoggerAdmin();

    virtual bool ice_isA(const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual const ::std::string& ice_id(const ::Ice::Current& = ::Ice::emptyCurrent) const;

    static const ::std::string& ice_staticId();

    virtual void attachRemoteLogger(const ::Ice::RemoteLoggerPrx&, const ::Ice::LogMessageTypeSeq&, const ::Ice::StringSeq&, ::Ice::Int, const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_attachRemoteLogger(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual bool detachRemoteLogger(const ::Ice::RemoteLoggerPrx&, const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_detachRemoteLogger(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual ::Ice::LogMessageSeq getLog(const ::Ice::LogMessageTypeSeq&, const ::Ice::StringSeq&, ::Ice::Int, ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_getLog(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&);

protected:

    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
};

inline bool operator==(const LoggerAdmin& lhs, const LoggerAdmin& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const LoggerAdmin& lhs, const LoggerAdmin& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}

}

namespace Ice
{

template<>
struct StreamableTraits< ::Ice::LogMessageType>
{
    static const StreamHelperCategory helper = StreamHelperCategoryEnum;
    static const int minValue = 0;
    static const int maxValue = 3;
    static const int minWireSize = 1;
    static const bool fixedLength = false;
};

template<>
struct StreamableTraits< ::Ice::LogMessage>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 11;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamWriter< ::Ice::LogMessage, S>
{
    static void write(S* ostr, const ::Ice::LogMessage& v)
    {
        ostr->write(v.type);
        ostr->write(v.timestamp);
        ostr->write(v.traceCategory);
        ostr->write(v.message);
    }
};

template<typename S>
struct StreamReader< ::Ice::LogMessage, S>
{
    static void read(S* istr, ::Ice::LogMessage& v)
    {
        istr->read(v.type);
        istr->read(v.timestamp);
        istr->read(v.traceCategory);
        istr->read(v.message);
    }
};

template<>
struct StreamableTraits< ::Ice::RemoteLoggerAlreadyAttachedException>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

}

namespace Ice
{

template<class T>
class CallbackNC_RemoteLogger_init : public Callback_RemoteLogger_init_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_RemoteLogger_init(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

template<class T> Callback_RemoteLogger_initPtr
newCallback_RemoteLogger_init(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_RemoteLogger_init<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_RemoteLogger_initPtr
newCallback_RemoteLogger_init(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_RemoteLogger_init<T>(instance, 0, excb, sentcb);
}

template<class T> Callback_RemoteLogger_initPtr
newCallback_RemoteLogger_init(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_RemoteLogger_init<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_RemoteLogger_initPtr
newCallback_RemoteLogger_init(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_RemoteLogger_init<T>(instance, 0, excb, sentcb);
}

template<class T, typename CT>
class Callback_RemoteLogger_init : public Callback_RemoteLogger_init_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_RemoteLogger_init(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

template<class T, typename CT> Callback_RemoteLogger_initPtr
newCallback_RemoteLogger_init(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_RemoteLogger_init<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_RemoteLogger_initPtr
newCallback_RemoteLogger_init(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_RemoteLogger_init<T, CT>(instance, 0, excb, sentcb);
}

template<class T, typename CT> Callback_RemoteLogger_initPtr
newCallback_RemoteLogger_init(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_RemoteLogger_init<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_RemoteLogger_initPtr
newCallback_RemoteLogger_init(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_RemoteLogger_init<T, CT>(instance, 0, excb, sentcb);
}

template<class T>
class CallbackNC_RemoteLogger_log : public Callback_RemoteLogger_log_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_RemoteLogger_log(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

template<class T> Callback_RemoteLogger_logPtr
newCallback_RemoteLogger_log(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_RemoteLogger_log<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_RemoteLogger_logPtr
newCallback_RemoteLogger_log(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_RemoteLogger_log<T>(instance, 0, excb, sentcb);
}

template<class T> Callback_RemoteLogger_logPtr
newCallback_RemoteLogger_log(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_RemoteLogger_log<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_RemoteLogger_logPtr
newCallback_RemoteLogger_log(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_RemoteLogger_log<T>(instance, 0, excb, sentcb);
}

template<class T, typename CT>
class Callback_RemoteLogger_log : public Callback_RemoteLogger_log_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_RemoteLogger_log(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

template<class T, typename CT> Callback_RemoteLogger_logPtr
newCallback_RemoteLogger_log(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_RemoteLogger_log<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_RemoteLogger_logPtr
newCallback_RemoteLogger_log(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_RemoteLogger_log<T, CT>(instance, 0, excb, sentcb);
}

template<class T, typename CT> Callback_RemoteLogger_logPtr
newCallback_RemoteLogger_log(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_RemoteLogger_log<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_RemoteLogger_logPtr
newCallback_RemoteLogger_log(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_RemoteLogger_log<T, CT>(instance, 0, excb, sentcb);
}

template<class T>
class CallbackNC_LoggerAdmin_attachRemoteLogger : public Callback_LoggerAdmin_attachRemoteLogger_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_LoggerAdmin_attachRemoteLogger(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::Ice::LoggerAdminPrx proxy = ::Ice::LoggerAdminPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_attachRemoteLogger(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)();
        }
    }

private:

    Response _response;
};

template<class T> Callback_LoggerAdmin_attachRemoteLoggerPtr
newCallback_LoggerAdmin_attachRemoteLogger(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_LoggerAdmin_attachRemoteLogger<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_LoggerAdmin_attachRemoteLoggerPtr
newCallback_LoggerAdmin_attachRemoteLogger(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_LoggerAdmin_attachRemoteLogger<T>(instance, 0, excb, sentcb);
}

template<class T> Callback_LoggerAdmin_attachRemoteLoggerPtr
newCallback_LoggerAdmin_attachRemoteLogger(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_LoggerAdmin_attachRemoteLogger<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_LoggerAdmin_attachRemoteLoggerPtr
newCallback_LoggerAdmin_attachRemoteLogger(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_LoggerAdmin_attachRemoteLogger<T>(instance, 0, excb, sentcb);
}

template<class T, typename CT>
class Callback_LoggerAdmin_attachRemoteLogger : public Callback_LoggerAdmin_attachRemoteLogger_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_LoggerAdmin_attachRemoteLogger(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::Ice::LoggerAdminPrx proxy = ::Ice::LoggerAdminPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_attachRemoteLogger(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_LoggerAdmin_attachRemoteLoggerPtr
newCallback_LoggerAdmin_attachRemoteLogger(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_LoggerAdmin_attachRemoteLogger<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_LoggerAdmin_attachRemoteLoggerPtr
newCallback_LoggerAdmin_attachRemoteLogger(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_LoggerAdmin_attachRemoteLogger<T, CT>(instance, 0, excb, sentcb);
}

template<class T, typename CT> Callback_LoggerAdmin_attachRemoteLoggerPtr
newCallback_LoggerAdmin_attachRemoteLogger(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_LoggerAdmin_attachRemoteLogger<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_LoggerAdmin_attachRemoteLoggerPtr
newCallback_LoggerAdmin_attachRemoteLogger(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_LoggerAdmin_attachRemoteLogger<T, CT>(instance, 0, excb, sentcb);
}

template<class T>
class CallbackNC_LoggerAdmin_detachRemoteLogger : public Callback_LoggerAdmin_detachRemoteLogger_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(bool);

    CallbackNC_LoggerAdmin_detachRemoteLogger(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::Ice::LoggerAdminPrx proxy = ::Ice::LoggerAdminPrx::uncheckedCast(result->getProxy());
        bool ret;
        try
        {
            ret = proxy->end_detachRemoteLogger(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }

private:

    Response _response;
};

template<class T> Callback_LoggerAdmin_detachRemoteLoggerPtr
newCallback_LoggerAdmin_detachRemoteLogger(const IceUtil::Handle<T>& instance, void (T::*cb)(bool), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_LoggerAdmin_detachRemoteLogger<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_LoggerAdmin_detachRemoteLoggerPtr
newCallback_LoggerAdmin_detachRemoteLogger(T* instance, void (T::*cb)(bool), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_LoggerAdmin_detachRemoteLogger<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_LoggerAdmin_detachRemoteLogger : public Callback_LoggerAdmin_detachRemoteLogger_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(bool, const CT&);

    Callback_LoggerAdmin_detachRemoteLogger(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::Ice::LoggerAdminPrx proxy = ::Ice::LoggerAdminPrx::uncheckedCast(result->getProxy());
        bool ret;
        try
        {
            ret = proxy->end_detachRemoteLogger(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_LoggerAdmin_detachRemoteLoggerPtr
newCallback_LoggerAdmin_detachRemoteLogger(const IceUtil::Handle<T>& instance, void (T::*cb)(bool, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_LoggerAdmin_detachRemoteLogger<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_LoggerAdmin_detachRemoteLoggerPtr
newCallback_LoggerAdmin_detachRemoteLogger(T* instance, void (T::*cb)(bool, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_LoggerAdmin_detachRemoteLogger<T, CT>(instance, cb, excb, sentcb);
}

template<class T>
class CallbackNC_LoggerAdmin_getLog : public Callback_LoggerAdmin_getLog_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::Ice::LogMessageSeq&, const ::std::string&);

    CallbackNC_LoggerAdmin_getLog(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::Ice::LoggerAdminPrx proxy = ::Ice::LoggerAdminPrx::uncheckedCast(result->getProxy());
        ::std::string iceP_prefix;
        ::Ice::LogMessageSeq ret;
        try
        {
            ret = proxy->end_getLog(iceP_prefix, result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret, iceP_prefix);
        }
    }

private:

    Response _response;
};

template<class T> Callback_LoggerAdmin_getLogPtr
newCallback_LoggerAdmin_getLog(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::LogMessageSeq&, const ::std::string&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_LoggerAdmin_getLog<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_LoggerAdmin_getLogPtr
newCallback_LoggerAdmin_getLog(T* instance, void (T::*cb)(const ::Ice::LogMessageSeq&, const ::std::string&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_LoggerAdmin_getLog<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_LoggerAdmin_getLog : public Callback_LoggerAdmin_getLog_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::Ice::LogMessageSeq&, const ::std::string&, const CT&);

    Callback_LoggerAdmin_getLog(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::Ice::LoggerAdminPrx proxy = ::Ice::LoggerAdminPrx::uncheckedCast(result->getProxy());
        ::std::string iceP_prefix;
        ::Ice::LogMessageSeq ret;
        try
        {
            ret = proxy->end_getLog(iceP_prefix, result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, iceP_prefix, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_LoggerAdmin_getLogPtr
newCallback_LoggerAdmin_getLog(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::LogMessageSeq&, const ::std::string&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_LoggerAdmin_getLog<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_LoggerAdmin_getLogPtr
newCallback_LoggerAdmin_getLog(T* instance, void (T::*cb)(const ::Ice::LogMessageSeq&, const ::std::string&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_LoggerAdmin_getLog<T, CT>(instance, cb, excb, sentcb);
}

}

#endif

#include <IceUtil/PopDisableWarnings.h>
#endif
