// **********************************************************************
//
// Copyright (c) 2003-2017 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.7.0
//
// <auto-generated>
//
// Generated from file `Exception.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

#ifndef __IceGrid_Exception_h__
#define __IceGrid_Exception_h__

#include <IceUtil/PushDisableWarnings.h>
#include <Ice/ProxyF.h>
#include <Ice/ObjectF.h>
#include <Ice/ValueF.h>
#include <Ice/Exception.h>
#include <Ice/LocalObject.h>
#include <Ice/StreamHelpers.h>
#include <Ice/Comparable.h>
#include <Ice/FactoryTableInit.h>
#include <IceUtil/ScopedArray.h>
#include <Ice/Optional.h>
#include <Ice/ExceptionHelpers.h>
#include <Ice/Identity.h>
#include <Ice/BuiltinSequences.h>
#include <IceUtil/UndefSysMacros.h>
#include <IceGrid/Config.h>

#ifndef ICE_IGNORE_VERSION
#   if ICE_INT_VERSION / 100 != 307
#       error Ice version mismatch!
#   endif
#   if ICE_INT_VERSION % 100 > 50
#       error Beta header file detected
#   endif
#   if ICE_INT_VERSION % 100 < 0
#       error Ice patch level mismatch!
#   endif
#endif

#ifndef ICEGRID_API
#   if defined(ICE_STATIC_LIBS)
#       define ICEGRID_API /**/
#   elif defined(ICEGRID_API_EXPORTS)
#       define ICEGRID_API ICE_DECLSPEC_EXPORT
#   else
#       define ICEGRID_API ICE_DECLSPEC_IMPORT
#   endif
#endif

#ifdef ICE_CPP11_MAPPING // C++11 mapping

namespace IceGrid
{

class ICE_CLASS(ICEGRID_API) ApplicationNotExistException : public ::Ice::UserExceptionHelper<ApplicationNotExistException, ::Ice::UserException>
{
public:

    ICE_MEMBER(ICEGRID_API) virtual ~ApplicationNotExistException();

    ApplicationNotExistException(const ApplicationNotExistException&) = default;

    ApplicationNotExistException() = default;

    ApplicationNotExistException(const ::std::string& iceP_name) :
        name(::std::move(iceP_name))
    {
    }

    std::tuple<const ::std::string&> ice_tuple() const
    {
        return std::tie(name);
    }

    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

    ::std::string name;
};

static ApplicationNotExistException _iceS_ApplicationNotExistException_init;

class ICE_CLASS(ICEGRID_API) ServerNotExistException : public ::Ice::UserExceptionHelper<ServerNotExistException, ::Ice::UserException>
{
public:

    ICE_MEMBER(ICEGRID_API) virtual ~ServerNotExistException();

    ServerNotExistException(const ServerNotExistException&) = default;

    ServerNotExistException() = default;

    ServerNotExistException(const ::std::string& iceP_id) :
        id(::std::move(iceP_id))
    {
    }

    std::tuple<const ::std::string&> ice_tuple() const
    {
        return std::tie(id);
    }

    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

    ::std::string id;
};

class ICE_CLASS(ICEGRID_API) ServerStartException : public ::Ice::UserExceptionHelper<ServerStartException, ::Ice::UserException>
{
public:

    ICE_MEMBER(ICEGRID_API) virtual ~ServerStartException();

    ServerStartException(const ServerStartException&) = default;

    ServerStartException() = default;

    ServerStartException(const ::std::string& iceP_id, const ::std::string& iceP_reason) :
        id(::std::move(iceP_id)),
        reason(::std::move(iceP_reason))
    {
    }

    std::tuple<const ::std::string&, const ::std::string&> ice_tuple() const
    {
        return std::tie(id, reason);
    }

    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

    ::std::string id;
    ::std::string reason;
};

class ICE_CLASS(ICEGRID_API) ServerStopException : public ::Ice::UserExceptionHelper<ServerStopException, ::Ice::UserException>
{
public:

    ICE_MEMBER(ICEGRID_API) virtual ~ServerStopException();

    ServerStopException(const ServerStopException&) = default;

    ServerStopException() = default;

    ServerStopException(const ::std::string& iceP_id, const ::std::string& iceP_reason) :
        id(::std::move(iceP_id)),
        reason(::std::move(iceP_reason))
    {
    }

    std::tuple<const ::std::string&, const ::std::string&> ice_tuple() const
    {
        return std::tie(id, reason);
    }

    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

    ::std::string id;
    ::std::string reason;
};

class ICE_CLASS(ICEGRID_API) AdapterNotExistException : public ::Ice::UserExceptionHelper<AdapterNotExistException, ::Ice::UserException>
{
public:

    ICE_MEMBER(ICEGRID_API) virtual ~AdapterNotExistException();

    AdapterNotExistException(const AdapterNotExistException&) = default;

    AdapterNotExistException() = default;

    AdapterNotExistException(const ::std::string& iceP_id) :
        id(::std::move(iceP_id))
    {
    }

    std::tuple<const ::std::string&> ice_tuple() const
    {
        return std::tie(id);
    }

    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

    ::std::string id;
};

class ICE_CLASS(ICEGRID_API) ObjectExistsException : public ::Ice::UserExceptionHelper<ObjectExistsException, ::Ice::UserException>
{
public:

    ICE_MEMBER(ICEGRID_API) virtual ~ObjectExistsException();

    ObjectExistsException(const ObjectExistsException&) = default;

    ObjectExistsException() = default;

    ObjectExistsException(const ::Ice::Identity& iceP_id) :
        id(::std::move(iceP_id))
    {
    }

    std::tuple<const ::Ice::Identity&> ice_tuple() const
    {
        return std::tie(id);
    }

    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

    ::Ice::Identity id;
};

class ICE_CLASS(ICEGRID_API) ObjectNotRegisteredException : public ::Ice::UserExceptionHelper<ObjectNotRegisteredException, ::Ice::UserException>
{
public:

    ICE_MEMBER(ICEGRID_API) virtual ~ObjectNotRegisteredException();

    ObjectNotRegisteredException(const ObjectNotRegisteredException&) = default;

    ObjectNotRegisteredException() = default;

    ObjectNotRegisteredException(const ::Ice::Identity& iceP_id) :
        id(::std::move(iceP_id))
    {
    }

    std::tuple<const ::Ice::Identity&> ice_tuple() const
    {
        return std::tie(id);
    }

    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

    ::Ice::Identity id;
};

class ICE_CLASS(ICEGRID_API) NodeNotExistException : public ::Ice::UserExceptionHelper<NodeNotExistException, ::Ice::UserException>
{
public:

    ICE_MEMBER(ICEGRID_API) virtual ~NodeNotExistException();

    NodeNotExistException(const NodeNotExistException&) = default;

    NodeNotExistException() = default;

    NodeNotExistException(const ::std::string& iceP_name) :
        name(::std::move(iceP_name))
    {
    }

    std::tuple<const ::std::string&> ice_tuple() const
    {
        return std::tie(name);
    }

    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

    ::std::string name;
};

class ICE_CLASS(ICEGRID_API) RegistryNotExistException : public ::Ice::UserExceptionHelper<RegistryNotExistException, ::Ice::UserException>
{
public:

    ICE_MEMBER(ICEGRID_API) virtual ~RegistryNotExistException();

    RegistryNotExistException(const RegistryNotExistException&) = default;

    RegistryNotExistException() = default;

    RegistryNotExistException(const ::std::string& iceP_name) :
        name(::std::move(iceP_name))
    {
    }

    std::tuple<const ::std::string&> ice_tuple() const
    {
        return std::tie(name);
    }

    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

    ::std::string name;
};

class ICE_CLASS(ICEGRID_API) DeploymentException : public ::Ice::UserExceptionHelper<DeploymentException, ::Ice::UserException>
{
public:

    ICE_MEMBER(ICEGRID_API) virtual ~DeploymentException();

    DeploymentException(const DeploymentException&) = default;

    DeploymentException() = default;

    DeploymentException(const ::std::string& iceP_reason) :
        reason(::std::move(iceP_reason))
    {
    }

    std::tuple<const ::std::string&> ice_tuple() const
    {
        return std::tie(reason);
    }

    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

    ::std::string reason;
};

class ICE_CLASS(ICEGRID_API) NodeUnreachableException : public ::Ice::UserExceptionHelper<NodeUnreachableException, ::Ice::UserException>
{
public:

    ICE_MEMBER(ICEGRID_API) virtual ~NodeUnreachableException();

    NodeUnreachableException(const NodeUnreachableException&) = default;

    NodeUnreachableException() = default;

    NodeUnreachableException(const ::std::string& iceP_name, const ::std::string& iceP_reason) :
        name(::std::move(iceP_name)),
        reason(::std::move(iceP_reason))
    {
    }

    std::tuple<const ::std::string&, const ::std::string&> ice_tuple() const
    {
        return std::tie(name, reason);
    }

    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

    ::std::string name;
    ::std::string reason;
};

class ICE_CLASS(ICEGRID_API) ServerUnreachableException : public ::Ice::UserExceptionHelper<ServerUnreachableException, ::Ice::UserException>
{
public:

    ICE_MEMBER(ICEGRID_API) virtual ~ServerUnreachableException();

    ServerUnreachableException(const ServerUnreachableException&) = default;

    ServerUnreachableException() = default;

    ServerUnreachableException(const ::std::string& iceP_name, const ::std::string& iceP_reason) :
        name(::std::move(iceP_name)),
        reason(::std::move(iceP_reason))
    {
    }

    std::tuple<const ::std::string&, const ::std::string&> ice_tuple() const
    {
        return std::tie(name, reason);
    }

    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

    ::std::string name;
    ::std::string reason;
};

class ICE_CLASS(ICEGRID_API) RegistryUnreachableException : public ::Ice::UserExceptionHelper<RegistryUnreachableException, ::Ice::UserException>
{
public:

    ICE_MEMBER(ICEGRID_API) virtual ~RegistryUnreachableException();

    RegistryUnreachableException(const RegistryUnreachableException&) = default;

    RegistryUnreachableException() = default;

    RegistryUnreachableException(const ::std::string& iceP_name, const ::std::string& iceP_reason) :
        name(::std::move(iceP_name)),
        reason(::std::move(iceP_reason))
    {
    }

    std::tuple<const ::std::string&, const ::std::string&> ice_tuple() const
    {
        return std::tie(name, reason);
    }

    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

    ::std::string name;
    ::std::string reason;
};

class ICE_CLASS(ICEGRID_API) BadSignalException : public ::Ice::UserExceptionHelper<BadSignalException, ::Ice::UserException>
{
public:

    ICE_MEMBER(ICEGRID_API) virtual ~BadSignalException();

    BadSignalException(const BadSignalException&) = default;

    BadSignalException() = default;

    BadSignalException(const ::std::string& iceP_reason) :
        reason(::std::move(iceP_reason))
    {
    }

    std::tuple<const ::std::string&> ice_tuple() const
    {
        return std::tie(reason);
    }

    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

    ::std::string reason;
};

class ICE_CLASS(ICEGRID_API) PatchException : public ::Ice::UserExceptionHelper<PatchException, ::Ice::UserException>
{
public:

    ICE_MEMBER(ICEGRID_API) virtual ~PatchException();

    PatchException(const PatchException&) = default;

    PatchException() = default;

    PatchException(const ::Ice::StringSeq& iceP_reasons) :
        reasons(::std::move(iceP_reasons))
    {
    }

    std::tuple<const ::Ice::StringSeq&> ice_tuple() const
    {
        return std::tie(reasons);
    }

    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

    ::Ice::StringSeq reasons;
};

class ICE_CLASS(ICEGRID_API) AccessDeniedException : public ::Ice::UserExceptionHelper<AccessDeniedException, ::Ice::UserException>
{
public:

    ICE_MEMBER(ICEGRID_API) virtual ~AccessDeniedException();

    AccessDeniedException(const AccessDeniedException&) = default;

    AccessDeniedException() = default;

    AccessDeniedException(const ::std::string& iceP_lockUserId) :
        lockUserId(::std::move(iceP_lockUserId))
    {
    }

    std::tuple<const ::std::string&> ice_tuple() const
    {
        return std::tie(lockUserId);
    }

    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

    ::std::string lockUserId;
};

class ICE_CLASS(ICEGRID_API) AllocationException : public ::Ice::UserExceptionHelper<AllocationException, ::Ice::UserException>
{
public:

    ICE_MEMBER(ICEGRID_API) virtual ~AllocationException();

    AllocationException(const AllocationException&) = default;

    AllocationException() = default;

    AllocationException(const ::std::string& iceP_reason) :
        reason(::std::move(iceP_reason))
    {
    }

    std::tuple<const ::std::string&> ice_tuple() const
    {
        return std::tie(reason);
    }

    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

    ::std::string reason;
};

class ICE_CLASS(ICEGRID_API) AllocationTimeoutException : public ::Ice::UserExceptionHelper<AllocationTimeoutException, ::IceGrid::AllocationException>
{
public:

    ICE_MEMBER(ICEGRID_API) virtual ~AllocationTimeoutException();

    AllocationTimeoutException(const AllocationTimeoutException&) = default;

    AllocationTimeoutException() = default;

    AllocationTimeoutException(const ::std::string& iceP_reason) :
        ::Ice::UserExceptionHelper<AllocationTimeoutException, ::IceGrid::AllocationException>(::std::move(iceP_reason))
    {
    }

    std::tuple<const ::std::string&> ice_tuple() const
    {
        return std::tie(reason);
    }

    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();
};

class ICE_CLASS(ICEGRID_API) PermissionDeniedException : public ::Ice::UserExceptionHelper<PermissionDeniedException, ::Ice::UserException>
{
public:

    ICE_MEMBER(ICEGRID_API) virtual ~PermissionDeniedException();

    PermissionDeniedException(const PermissionDeniedException&) = default;

    PermissionDeniedException() = default;

    PermissionDeniedException(const ::std::string& iceP_reason) :
        reason(::std::move(iceP_reason))
    {
    }

    std::tuple<const ::std::string&> ice_tuple() const
    {
        return std::tie(reason);
    }

    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

    ::std::string reason;
};

class ICE_CLASS(ICEGRID_API) ObserverAlreadyRegisteredException : public ::Ice::UserExceptionHelper<ObserverAlreadyRegisteredException, ::Ice::UserException>
{
public:

    ICE_MEMBER(ICEGRID_API) virtual ~ObserverAlreadyRegisteredException();

    ObserverAlreadyRegisteredException(const ObserverAlreadyRegisteredException&) = default;

    ObserverAlreadyRegisteredException() = default;

    ObserverAlreadyRegisteredException(const ::Ice::Identity& iceP_id) :
        id(::std::move(iceP_id))
    {
    }

    std::tuple<const ::Ice::Identity&> ice_tuple() const
    {
        return std::tie(id);
    }

    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

    ::Ice::Identity id;
};

class ICE_CLASS(ICEGRID_API) FileNotAvailableException : public ::Ice::UserExceptionHelper<FileNotAvailableException, ::Ice::UserException>
{
public:

    ICE_MEMBER(ICEGRID_API) virtual ~FileNotAvailableException();

    FileNotAvailableException(const FileNotAvailableException&) = default;

    FileNotAvailableException() = default;

    FileNotAvailableException(const ::std::string& iceP_reason) :
        reason(::std::move(iceP_reason))
    {
    }

    std::tuple<const ::std::string&> ice_tuple() const
    {
        return std::tie(reason);
    }

    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

    ::std::string reason;
};

}

namespace Ice
{

template<typename S>
struct StreamReader<::IceGrid::ApplicationNotExistException, S>
{
    static void read(S* istr, ::IceGrid::ApplicationNotExistException& v)
    {
        istr->readAll(v.name);
    }
};

template<typename S>
struct StreamReader<::IceGrid::ServerNotExistException, S>
{
    static void read(S* istr, ::IceGrid::ServerNotExistException& v)
    {
        istr->readAll(v.id);
    }
};

template<typename S>
struct StreamReader<::IceGrid::ServerStartException, S>
{
    static void read(S* istr, ::IceGrid::ServerStartException& v)
    {
        istr->readAll(v.id, v.reason);
    }
};

template<typename S>
struct StreamReader<::IceGrid::ServerStopException, S>
{
    static void read(S* istr, ::IceGrid::ServerStopException& v)
    {
        istr->readAll(v.id, v.reason);
    }
};

template<typename S>
struct StreamReader<::IceGrid::AdapterNotExistException, S>
{
    static void read(S* istr, ::IceGrid::AdapterNotExistException& v)
    {
        istr->readAll(v.id);
    }
};

template<typename S>
struct StreamReader<::IceGrid::ObjectExistsException, S>
{
    static void read(S* istr, ::IceGrid::ObjectExistsException& v)
    {
        istr->readAll(v.id);
    }
};

template<typename S>
struct StreamReader<::IceGrid::ObjectNotRegisteredException, S>
{
    static void read(S* istr, ::IceGrid::ObjectNotRegisteredException& v)
    {
        istr->readAll(v.id);
    }
};

template<typename S>
struct StreamReader<::IceGrid::NodeNotExistException, S>
{
    static void read(S* istr, ::IceGrid::NodeNotExistException& v)
    {
        istr->readAll(v.name);
    }
};

template<typename S>
struct StreamReader<::IceGrid::RegistryNotExistException, S>
{
    static void read(S* istr, ::IceGrid::RegistryNotExistException& v)
    {
        istr->readAll(v.name);
    }
};

template<typename S>
struct StreamReader<::IceGrid::DeploymentException, S>
{
    static void read(S* istr, ::IceGrid::DeploymentException& v)
    {
        istr->readAll(v.reason);
    }
};

template<typename S>
struct StreamReader<::IceGrid::NodeUnreachableException, S>
{
    static void read(S* istr, ::IceGrid::NodeUnreachableException& v)
    {
        istr->readAll(v.name, v.reason);
    }
};

template<typename S>
struct StreamReader<::IceGrid::ServerUnreachableException, S>
{
    static void read(S* istr, ::IceGrid::ServerUnreachableException& v)
    {
        istr->readAll(v.name, v.reason);
    }
};

template<typename S>
struct StreamReader<::IceGrid::RegistryUnreachableException, S>
{
    static void read(S* istr, ::IceGrid::RegistryUnreachableException& v)
    {
        istr->readAll(v.name, v.reason);
    }
};

template<typename S>
struct StreamReader<::IceGrid::BadSignalException, S>
{
    static void read(S* istr, ::IceGrid::BadSignalException& v)
    {
        istr->readAll(v.reason);
    }
};

template<typename S>
struct StreamReader<::IceGrid::PatchException, S>
{
    static void read(S* istr, ::IceGrid::PatchException& v)
    {
        istr->readAll(v.reasons);
    }
};

template<typename S>
struct StreamReader<::IceGrid::AccessDeniedException, S>
{
    static void read(S* istr, ::IceGrid::AccessDeniedException& v)
    {
        istr->readAll(v.lockUserId);
    }
};

template<typename S>
struct StreamReader<::IceGrid::AllocationException, S>
{
    static void read(S* istr, ::IceGrid::AllocationException& v)
    {
        istr->readAll(v.reason);
    }
};

template<typename S>
struct StreamWriter<::IceGrid::AllocationTimeoutException, S>
{
    static void write(S*, const ::IceGrid::AllocationTimeoutException&)
    {
    }
};

template<typename S>
struct StreamReader<::IceGrid::AllocationTimeoutException, S>
{
    static void read(S*, ::IceGrid::AllocationTimeoutException&)
    {
    }
};

template<typename S>
struct StreamReader<::IceGrid::PermissionDeniedException, S>
{
    static void read(S* istr, ::IceGrid::PermissionDeniedException& v)
    {
        istr->readAll(v.reason);
    }
};

template<typename S>
struct StreamReader<::IceGrid::ObserverAlreadyRegisteredException, S>
{
    static void read(S* istr, ::IceGrid::ObserverAlreadyRegisteredException& v)
    {
        istr->readAll(v.id);
    }
};

template<typename S>
struct StreamReader<::IceGrid::FileNotAvailableException, S>
{
    static void read(S* istr, ::IceGrid::FileNotAvailableException& v)
    {
        istr->readAll(v.reason);
    }
};

}

#else // C++98 mapping

namespace IceGrid
{

class ICEGRID_API ApplicationNotExistException : public ::Ice::UserException
{
public:

    ApplicationNotExistException() {}
    explicit ApplicationNotExistException(const ::std::string&);
    virtual ~ApplicationNotExistException() throw();

    virtual ::std::string ice_id() const;
    virtual ApplicationNotExistException* ice_clone() const;
    virtual void ice_throw() const;

    ::std::string name;

protected:

    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
};

static ApplicationNotExistException _iceS_ApplicationNotExistException_init;

class ICEGRID_API ServerNotExistException : public ::Ice::UserException
{
public:

    ServerNotExistException() {}
    explicit ServerNotExistException(const ::std::string&);
    virtual ~ServerNotExistException() throw();

    virtual ::std::string ice_id() const;
    virtual ServerNotExistException* ice_clone() const;
    virtual void ice_throw() const;

    ::std::string id;

protected:

    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
};

class ICEGRID_API ServerStartException : public ::Ice::UserException
{
public:

    ServerStartException() {}
    ServerStartException(const ::std::string&, const ::std::string&);
    virtual ~ServerStartException() throw();

    virtual ::std::string ice_id() const;
    virtual ServerStartException* ice_clone() const;
    virtual void ice_throw() const;

    ::std::string id;
    ::std::string reason;

protected:

    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
};

class ICEGRID_API ServerStopException : public ::Ice::UserException
{
public:

    ServerStopException() {}
    ServerStopException(const ::std::string&, const ::std::string&);
    virtual ~ServerStopException() throw();

    virtual ::std::string ice_id() const;
    virtual ServerStopException* ice_clone() const;
    virtual void ice_throw() const;

    ::std::string id;
    ::std::string reason;

protected:

    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
};

class ICEGRID_API AdapterNotExistException : public ::Ice::UserException
{
public:

    AdapterNotExistException() {}
    explicit AdapterNotExistException(const ::std::string&);
    virtual ~AdapterNotExistException() throw();

    virtual ::std::string ice_id() const;
    virtual AdapterNotExistException* ice_clone() const;
    virtual void ice_throw() const;

    ::std::string id;

protected:

    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
};

class ICEGRID_API ObjectExistsException : public ::Ice::UserException
{
public:

    ObjectExistsException() {}
    explicit ObjectExistsException(const ::Ice::Identity&);
    virtual ~ObjectExistsException() throw();

    virtual ::std::string ice_id() const;
    virtual ObjectExistsException* ice_clone() const;
    virtual void ice_throw() const;

    ::Ice::Identity id;

protected:

    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
};

class ICEGRID_API ObjectNotRegisteredException : public ::Ice::UserException
{
public:

    ObjectNotRegisteredException() {}
    explicit ObjectNotRegisteredException(const ::Ice::Identity&);
    virtual ~ObjectNotRegisteredException() throw();

    virtual ::std::string ice_id() const;
    virtual ObjectNotRegisteredException* ice_clone() const;
    virtual void ice_throw() const;

    ::Ice::Identity id;

protected:

    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
};

class ICEGRID_API NodeNotExistException : public ::Ice::UserException
{
public:

    NodeNotExistException() {}
    explicit NodeNotExistException(const ::std::string&);
    virtual ~NodeNotExistException() throw();

    virtual ::std::string ice_id() const;
    virtual NodeNotExistException* ice_clone() const;
    virtual void ice_throw() const;

    ::std::string name;

protected:

    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
};

class ICEGRID_API RegistryNotExistException : public ::Ice::UserException
{
public:

    RegistryNotExistException() {}
    explicit RegistryNotExistException(const ::std::string&);
    virtual ~RegistryNotExistException() throw();

    virtual ::std::string ice_id() const;
    virtual RegistryNotExistException* ice_clone() const;
    virtual void ice_throw() const;

    ::std::string name;

protected:

    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
};

class ICEGRID_API DeploymentException : public ::Ice::UserException
{
public:

    DeploymentException() {}
    explicit DeploymentException(const ::std::string&);
    virtual ~DeploymentException() throw();

    virtual ::std::string ice_id() const;
    virtual DeploymentException* ice_clone() const;
    virtual void ice_throw() const;

    ::std::string reason;

protected:

    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
};

class ICEGRID_API NodeUnreachableException : public ::Ice::UserException
{
public:

    NodeUnreachableException() {}
    NodeUnreachableException(const ::std::string&, const ::std::string&);
    virtual ~NodeUnreachableException() throw();

    virtual ::std::string ice_id() const;
    virtual NodeUnreachableException* ice_clone() const;
    virtual void ice_throw() const;

    ::std::string name;
    ::std::string reason;

protected:

    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
};

class ICEGRID_API ServerUnreachableException : public ::Ice::UserException
{
public:

    ServerUnreachableException() {}
    ServerUnreachableException(const ::std::string&, const ::std::string&);
    virtual ~ServerUnreachableException() throw();

    virtual ::std::string ice_id() const;
    virtual ServerUnreachableException* ice_clone() const;
    virtual void ice_throw() const;

    ::std::string name;
    ::std::string reason;

protected:

    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
};

class ICEGRID_API RegistryUnreachableException : public ::Ice::UserException
{
public:

    RegistryUnreachableException() {}
    RegistryUnreachableException(const ::std::string&, const ::std::string&);
    virtual ~RegistryUnreachableException() throw();

    virtual ::std::string ice_id() const;
    virtual RegistryUnreachableException* ice_clone() const;
    virtual void ice_throw() const;

    ::std::string name;
    ::std::string reason;

protected:

    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
};

class ICEGRID_API BadSignalException : public ::Ice::UserException
{
public:

    BadSignalException() {}
    explicit BadSignalException(const ::std::string&);
    virtual ~BadSignalException() throw();

    virtual ::std::string ice_id() const;
    virtual BadSignalException* ice_clone() const;
    virtual void ice_throw() const;

    ::std::string reason;

protected:

    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
};

class ICEGRID_API PatchException : public ::Ice::UserException
{
public:

    PatchException() {}
    explicit PatchException(const ::Ice::StringSeq&);
    virtual ~PatchException() throw();

    virtual ::std::string ice_id() const;
    virtual PatchException* ice_clone() const;
    virtual void ice_throw() const;

    ::Ice::StringSeq reasons;

protected:

    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
};

class ICEGRID_API AccessDeniedException : public ::Ice::UserException
{
public:

    AccessDeniedException() {}
    explicit AccessDeniedException(const ::std::string&);
    virtual ~AccessDeniedException() throw();

    virtual ::std::string ice_id() const;
    virtual AccessDeniedException* ice_clone() const;
    virtual void ice_throw() const;

    ::std::string lockUserId;

protected:

    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
};

class ICEGRID_API AllocationException : public ::Ice::UserException
{
public:

    AllocationException() {}
    explicit AllocationException(const ::std::string&);
    virtual ~AllocationException() throw();

    virtual ::std::string ice_id() const;
    virtual AllocationException* ice_clone() const;
    virtual void ice_throw() const;

    ::std::string reason;

protected:

    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
};

class ICEGRID_API AllocationTimeoutException : public ::IceGrid::AllocationException
{
public:

    AllocationTimeoutException() {}
    explicit AllocationTimeoutException(const ::std::string&);
    virtual ~AllocationTimeoutException() throw();

    virtual ::std::string ice_id() const;
    virtual AllocationTimeoutException* ice_clone() const;
    virtual void ice_throw() const;

protected:

    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
};

class ICEGRID_API PermissionDeniedException : public ::Ice::UserException
{
public:

    PermissionDeniedException() {}
    explicit PermissionDeniedException(const ::std::string&);
    virtual ~PermissionDeniedException() throw();

    virtual ::std::string ice_id() const;
    virtual PermissionDeniedException* ice_clone() const;
    virtual void ice_throw() const;

    ::std::string reason;

protected:

    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
};

class ICEGRID_API ObserverAlreadyRegisteredException : public ::Ice::UserException
{
public:

    ObserverAlreadyRegisteredException() {}
    explicit ObserverAlreadyRegisteredException(const ::Ice::Identity&);
    virtual ~ObserverAlreadyRegisteredException() throw();

    virtual ::std::string ice_id() const;
    virtual ObserverAlreadyRegisteredException* ice_clone() const;
    virtual void ice_throw() const;

    ::Ice::Identity id;

protected:

    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
};

class ICEGRID_API FileNotAvailableException : public ::Ice::UserException
{
public:

    FileNotAvailableException() {}
    explicit FileNotAvailableException(const ::std::string&);
    virtual ~FileNotAvailableException() throw();

    virtual ::std::string ice_id() const;
    virtual FileNotAvailableException* ice_clone() const;
    virtual void ice_throw() const;

    ::std::string reason;

protected:

    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
};

}

namespace Ice
{

template<>
struct StreamableTraits< ::IceGrid::ApplicationNotExistException>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<typename S>
struct StreamWriter< ::IceGrid::ApplicationNotExistException, S>
{
    static void write(S* ostr, const ::IceGrid::ApplicationNotExistException& v)
    {
        ostr->write(v.name);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::ApplicationNotExistException, S>
{
    static void read(S* istr, ::IceGrid::ApplicationNotExistException& v)
    {
        istr->read(v.name);
    }
};

template<>
struct StreamableTraits< ::IceGrid::ServerNotExistException>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<typename S>
struct StreamWriter< ::IceGrid::ServerNotExistException, S>
{
    static void write(S* ostr, const ::IceGrid::ServerNotExistException& v)
    {
        ostr->write(v.id);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::ServerNotExistException, S>
{
    static void read(S* istr, ::IceGrid::ServerNotExistException& v)
    {
        istr->read(v.id);
    }
};

template<>
struct StreamableTraits< ::IceGrid::ServerStartException>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<typename S>
struct StreamWriter< ::IceGrid::ServerStartException, S>
{
    static void write(S* ostr, const ::IceGrid::ServerStartException& v)
    {
        ostr->write(v.id);
        ostr->write(v.reason);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::ServerStartException, S>
{
    static void read(S* istr, ::IceGrid::ServerStartException& v)
    {
        istr->read(v.id);
        istr->read(v.reason);
    }
};

template<>
struct StreamableTraits< ::IceGrid::ServerStopException>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<typename S>
struct StreamWriter< ::IceGrid::ServerStopException, S>
{
    static void write(S* ostr, const ::IceGrid::ServerStopException& v)
    {
        ostr->write(v.id);
        ostr->write(v.reason);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::ServerStopException, S>
{
    static void read(S* istr, ::IceGrid::ServerStopException& v)
    {
        istr->read(v.id);
        istr->read(v.reason);
    }
};

template<>
struct StreamableTraits< ::IceGrid::AdapterNotExistException>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<typename S>
struct StreamWriter< ::IceGrid::AdapterNotExistException, S>
{
    static void write(S* ostr, const ::IceGrid::AdapterNotExistException& v)
    {
        ostr->write(v.id);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::AdapterNotExistException, S>
{
    static void read(S* istr, ::IceGrid::AdapterNotExistException& v)
    {
        istr->read(v.id);
    }
};

template<>
struct StreamableTraits< ::IceGrid::ObjectExistsException>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<typename S>
struct StreamWriter< ::IceGrid::ObjectExistsException, S>
{
    static void write(S* ostr, const ::IceGrid::ObjectExistsException& v)
    {
        ostr->write(v.id);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::ObjectExistsException, S>
{
    static void read(S* istr, ::IceGrid::ObjectExistsException& v)
    {
        istr->read(v.id);
    }
};

template<>
struct StreamableTraits< ::IceGrid::ObjectNotRegisteredException>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<typename S>
struct StreamWriter< ::IceGrid::ObjectNotRegisteredException, S>
{
    static void write(S* ostr, const ::IceGrid::ObjectNotRegisteredException& v)
    {
        ostr->write(v.id);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::ObjectNotRegisteredException, S>
{
    static void read(S* istr, ::IceGrid::ObjectNotRegisteredException& v)
    {
        istr->read(v.id);
    }
};

template<>
struct StreamableTraits< ::IceGrid::NodeNotExistException>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<typename S>
struct StreamWriter< ::IceGrid::NodeNotExistException, S>
{
    static void write(S* ostr, const ::IceGrid::NodeNotExistException& v)
    {
        ostr->write(v.name);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::NodeNotExistException, S>
{
    static void read(S* istr, ::IceGrid::NodeNotExistException& v)
    {
        istr->read(v.name);
    }
};

template<>
struct StreamableTraits< ::IceGrid::RegistryNotExistException>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<typename S>
struct StreamWriter< ::IceGrid::RegistryNotExistException, S>
{
    static void write(S* ostr, const ::IceGrid::RegistryNotExistException& v)
    {
        ostr->write(v.name);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::RegistryNotExistException, S>
{
    static void read(S* istr, ::IceGrid::RegistryNotExistException& v)
    {
        istr->read(v.name);
    }
};

template<>
struct StreamableTraits< ::IceGrid::DeploymentException>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<typename S>
struct StreamWriter< ::IceGrid::DeploymentException, S>
{
    static void write(S* ostr, const ::IceGrid::DeploymentException& v)
    {
        ostr->write(v.reason);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::DeploymentException, S>
{
    static void read(S* istr, ::IceGrid::DeploymentException& v)
    {
        istr->read(v.reason);
    }
};

template<>
struct StreamableTraits< ::IceGrid::NodeUnreachableException>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<typename S>
struct StreamWriter< ::IceGrid::NodeUnreachableException, S>
{
    static void write(S* ostr, const ::IceGrid::NodeUnreachableException& v)
    {
        ostr->write(v.name);
        ostr->write(v.reason);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::NodeUnreachableException, S>
{
    static void read(S* istr, ::IceGrid::NodeUnreachableException& v)
    {
        istr->read(v.name);
        istr->read(v.reason);
    }
};

template<>
struct StreamableTraits< ::IceGrid::ServerUnreachableException>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<typename S>
struct StreamWriter< ::IceGrid::ServerUnreachableException, S>
{
    static void write(S* ostr, const ::IceGrid::ServerUnreachableException& v)
    {
        ostr->write(v.name);
        ostr->write(v.reason);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::ServerUnreachableException, S>
{
    static void read(S* istr, ::IceGrid::ServerUnreachableException& v)
    {
        istr->read(v.name);
        istr->read(v.reason);
    }
};

template<>
struct StreamableTraits< ::IceGrid::RegistryUnreachableException>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<typename S>
struct StreamWriter< ::IceGrid::RegistryUnreachableException, S>
{
    static void write(S* ostr, const ::IceGrid::RegistryUnreachableException& v)
    {
        ostr->write(v.name);
        ostr->write(v.reason);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::RegistryUnreachableException, S>
{
    static void read(S* istr, ::IceGrid::RegistryUnreachableException& v)
    {
        istr->read(v.name);
        istr->read(v.reason);
    }
};

template<>
struct StreamableTraits< ::IceGrid::BadSignalException>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<typename S>
struct StreamWriter< ::IceGrid::BadSignalException, S>
{
    static void write(S* ostr, const ::IceGrid::BadSignalException& v)
    {
        ostr->write(v.reason);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::BadSignalException, S>
{
    static void read(S* istr, ::IceGrid::BadSignalException& v)
    {
        istr->read(v.reason);
    }
};

template<>
struct StreamableTraits< ::IceGrid::PatchException>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<typename S>
struct StreamWriter< ::IceGrid::PatchException, S>
{
    static void write(S* ostr, const ::IceGrid::PatchException& v)
    {
        ostr->write(v.reasons);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::PatchException, S>
{
    static void read(S* istr, ::IceGrid::PatchException& v)
    {
        istr->read(v.reasons);
    }
};

template<>
struct StreamableTraits< ::IceGrid::AccessDeniedException>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<typename S>
struct StreamWriter< ::IceGrid::AccessDeniedException, S>
{
    static void write(S* ostr, const ::IceGrid::AccessDeniedException& v)
    {
        ostr->write(v.lockUserId);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::AccessDeniedException, S>
{
    static void read(S* istr, ::IceGrid::AccessDeniedException& v)
    {
        istr->read(v.lockUserId);
    }
};

template<>
struct StreamableTraits< ::IceGrid::AllocationException>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<typename S>
struct StreamWriter< ::IceGrid::AllocationException, S>
{
    static void write(S* ostr, const ::IceGrid::AllocationException& v)
    {
        ostr->write(v.reason);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::AllocationException, S>
{
    static void read(S* istr, ::IceGrid::AllocationException& v)
    {
        istr->read(v.reason);
    }
};

template<>
struct StreamableTraits< ::IceGrid::AllocationTimeoutException>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<>
struct StreamableTraits< ::IceGrid::PermissionDeniedException>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<typename S>
struct StreamWriter< ::IceGrid::PermissionDeniedException, S>
{
    static void write(S* ostr, const ::IceGrid::PermissionDeniedException& v)
    {
        ostr->write(v.reason);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::PermissionDeniedException, S>
{
    static void read(S* istr, ::IceGrid::PermissionDeniedException& v)
    {
        istr->read(v.reason);
    }
};

template<>
struct StreamableTraits< ::IceGrid::ObserverAlreadyRegisteredException>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<typename S>
struct StreamWriter< ::IceGrid::ObserverAlreadyRegisteredException, S>
{
    static void write(S* ostr, const ::IceGrid::ObserverAlreadyRegisteredException& v)
    {
        ostr->write(v.id);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::ObserverAlreadyRegisteredException, S>
{
    static void read(S* istr, ::IceGrid::ObserverAlreadyRegisteredException& v)
    {
        istr->read(v.id);
    }
};

template<>
struct StreamableTraits< ::IceGrid::FileNotAvailableException>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<typename S>
struct StreamWriter< ::IceGrid::FileNotAvailableException, S>
{
    static void write(S* ostr, const ::IceGrid::FileNotAvailableException& v)
    {
        ostr->write(v.reason);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::FileNotAvailableException, S>
{
    static void read(S* istr, ::IceGrid::FileNotAvailableException& v)
    {
        istr->read(v.reason);
    }
};

}

#endif

#include <IceUtil/PopDisableWarnings.h>
#endif
