/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.ComponentInputMap;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.common.debug.DebugUtils;
import net.sf.freecol.common.debug.FreeColDebugger;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.ProductionType;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.UnitType;

public final class TilePanel
extends FreeColPanel {
    private static final Logger logger = Logger.getLogger(TilePanel.class.getName());
    private static final String COLOPEDIA = "COLOPEDIA";

    public TilePanel(FreeColClient freeColClient, Tile tile) {
        super(freeColClient, new MigLayout("wrap 2, insets 20 30 10 30", "[right, sg][left, sg]"));
        Player debugPlayer;
        int defenceBonus;
        StringTemplate settlementName;
        StringTemplate ownerName;
        Player player = freeColClient.getMyPlayer();
        TileType tileType = tile.getType();
        JButton colopediaButton = Utility.localizedButton("colopedia");
        colopediaButton.setActionCommand(tile.getType().getId());
        colopediaButton.addActionListener(this);
        ComponentInputMap inputMap = new ComponentInputMap(this.okButton);
        ((InputMap)inputMap).put(KeyStroke.getKeyStroke(27, 0, false), "pressed");
        ((InputMap)inputMap).put(KeyStroke.getKeyStroke(27, 0, true), "released");
        SwingUtilities.replaceUIInputMap(this.okButton, 2, inputMap);
        StringTemplate template = StringTemplate.template("tilePanel.label").addStringTemplate("%label%", tile.getLabel()).addAmount("%x%", tile.getX()).addAmount("%y%", tile.getY());
        this.add((Component)Utility.localizedLabel(template), "span, center");
        ImageLibrary lib = this.getImageLibrary();
        BufferedImage image = this.getGUI().createTileImage(tile);
        this.add((Component)new JLabel(new ImageIcon(image)), "span, center");
        if (tile.getRegion() != null) {
            this.add(Utility.localizedLabel("tilePanel.region"));
            this.add(Utility.localizedLabel(tile.getRegion().getLabel()));
        }
        if (tile.getOwner() != null && (ownerName = tile.getOwner().getNationLabel()) != null) {
            this.add(Utility.localizedLabel("tilePanel.owner"));
            this.add(Utility.localizedLabel(ownerName));
        }
        if (tile.getOwningSettlement() != null && (settlementName = tile.getOwningSettlement().getLocationLabelFor(player)) != null) {
            this.add(Utility.localizedLabel("tilePanel.settlement"));
            this.add(Utility.localizedLabel(settlementName));
        }
        if ((defenceBonus = tile.getDefenceBonusPercentage()) != 0) {
            this.add(Utility.localizedLabel("tilePanel.defenseBonus"));
            this.add(new JLabel(Integer.toString(defenceBonus) + "%"));
        }
        int movementCost = tile.getType().getBasicMoveCost() / 3;
        this.add(Utility.localizedLabel("tilePanel.movementCost"));
        this.add(new JLabel(Integer.toString(movementCost)));
        if (tileType != null) {
            UnitType colonist = this.getSpecification().getDefaultUnitType();
            JLabel label = null;
            boolean first = true;
            for (ProductionType productionType : tileType.getAvailableProductionTypes(false)) {
                for (AbstractGoods output : productionType.getOutputs()) {
                    GoodsType goodsType = output.getType();
                    int potential = output.getAmount();
                    if (tile.getTileItemContainer() != null) {
                        potential = tile.getTileItemContainer().getTotalBonusPotential(goodsType, colonist, potential, true);
                    }
                    int expertPotential = potential;
                    UnitType expert = this.getSpecification().getExpertForProducing(goodsType);
                    if (expert != null) {
                        expertPotential = (int)expert.applyModifiers(potential, this.getGame().getTurn(), goodsType.getId());
                    }
                    if (potential > 0) {
                        label = new JLabel(String.valueOf(potential), new ImageIcon(lib.getIconImage(goodsType)), 0);
                        if (first) {
                            this.add((Component)label, "span, split, center");
                            first = false;
                        } else {
                            this.add(label);
                        }
                    }
                    if (expertPotential <= potential) continue;
                    if (label == null) {
                        label = new JLabel(String.valueOf(expertPotential), new ImageIcon(lib.getIconImage(goodsType)), 0);
                        label.setToolTipText(Messages.getName(expert));
                        if (first) {
                            this.add((Component)label, "span, split");
                            first = false;
                            continue;
                        }
                        this.add(new JLabel("/"));
                        this.add(label);
                        continue;
                    }
                    label.setText(String.valueOf(potential) + "/" + String.valueOf(expertPotential));
                    label.setToolTipText(Messages.getName(colonist) + "/" + Messages.getName(expert));
                }
            }
        }
        if ((debugPlayer = FreeColDebugger.debugDisplayColonyValuePlayer()) != null) {
            List<Double> values = debugPlayer.getAllColonyValues(tile);
            int result = debugPlayer.getColonyValue(tile);
            if (result < 0) {
                this.add((Component)new JLabel(DebugUtils.getColonyValue(tile)), "newline 5, span, align center");
            } else {
                for (Player.ColonyValueCategory c : Player.ColonyValueCategory.values()) {
                    String cat = c.toString();
                    this.add((Component)new JLabel(cat + values.get(c.ordinal())), "newline 5, span, align center");
                }
                for (int a = Player.ColonyValueCategory.A_GOODS.ordinal(); a < values.size(); ++a) {
                    this.add((Component)new JLabel("... " + values.get(a)), "newline 5, span, align center");
                }
                this.add((Component)new JLabel("Result " + result), "newline 5, span, align center");
            }
        }
        this.add((Component)this.okButton, "newline 30, span, split 2, align center, tag ok");
        this.add((Component)colopediaButton, "tag help");
        this.setSize(this.getPreferredSize());
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String command = ae.getActionCommand();
        if ("OK".equals(command)) {
            this.getGUI().removeFromCanvas(this);
        } else {
            this.getGUI().showColopediaPanel(command);
        }
    }

    @Override
    public String getUIClassID() {
        return "TilePanelUI";
    }
}

