/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.data;

import java.util.ArrayList;
import tim.prune.data.DataPoint;
import tim.prune.data.SourceInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileInfo {
    private ArrayList<SourceInfo> _sources = new ArrayList();

    public FileInfo() {
    }

    private FileInfo(ArrayList<SourceInfo> arrayList) {
        this._sources = arrayList;
    }

    public void addSource(SourceInfo sourceInfo) {
        this._sources.add(sourceInfo);
    }

    public void replaceSource(SourceInfo sourceInfo) {
        this._sources.clear();
        this.addSource(sourceInfo);
    }

    public void removeSource() {
        this._sources.remove(this._sources.size() - 1);
    }

    public int getNumFiles() {
        return this._sources.size();
    }

    public String getFilename() {
        if (this.getNumFiles() == 1) {
            return this._sources.get(0).getName();
        }
        return "";
    }

    public SourceInfo getSource(int n) {
        return this._sources.get(n);
    }

    public SourceInfo getSourceForPoint(DataPoint dataPoint) {
        for (SourceInfo sourceInfo : this._sources) {
            if (sourceInfo.getIndex(dataPoint) < 0) continue;
            return sourceInfo;
        }
        return null;
    }

    public FileInfo clone() {
        ArrayList arrayList = (ArrayList)this._sources.clone();
        return new FileInfo(arrayList);
    }
}

