/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.progress.swing;

import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapStatus;
import org.openstreetmap.josm.gui.PleaseWaitDialog;
import org.openstreetmap.josm.gui.progress.AbstractProgressMonitor;
import org.openstreetmap.josm.gui.progress.CancelHandler;
import org.openstreetmap.josm.gui.progress.ProgressException;
import org.openstreetmap.josm.gui.progress.ProgressTaskId;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.bugreport.BugReport;

public class PleaseWaitProgressMonitor
extends AbstractProgressMonitor {
    public static final int PROGRESS_BAR_MAX = 10000;
    static PleaseWaitProgressMonitor currentProgressMonitor;
    private final Component dialogParent;
    private int currentProgressValue;
    private String customText;
    private String title;
    private boolean indeterminate;
    private boolean isInBackground;
    private PleaseWaitDialog dialog;
    private String windowTitle;
    protected ProgressTaskId taskId;
    private boolean cancelable;
    private final ActionListener cancelListener = e -> this.cancel();
    private final ActionListener inBackgroundListener = e -> {
        this.isInBackground = true;
        ProgressMonitorDialog dlg = this.getDialog();
        if (dlg != null) {
            this.reset();
            dlg.setVisible(true);
        }
    };
    private final WindowListener windowListener = new WindowAdapter(){

        @Override
        public void windowClosing(WindowEvent e) {
            PleaseWaitProgressMonitor.this.cancel();
        }
    };

    public static PleaseWaitProgressMonitor getCurrent() {
        return currentProgressMonitor;
    }

    private void doInEDT(Runnable runnable) {
        SwingUtilities.invokeLater(() -> {
            try {
                runnable.run();
            }
            catch (RuntimeException e) {
                throw BugReport.intercept(e).put("monitor", this);
            }
        });
    }

    private void setDialogVisible(boolean visible) {
        if (this.dialog.isVisible() != visible) {
            this.dialog.setVisible(visible);
        }
    }

    private ProgressMonitorDialog getDialog() {
        MapStatus.BackgroundProgressMonitor backgroundMonitor = null;
        MapFrame map = MainApplication.getMap();
        if (map != null) {
            backgroundMonitor = map.statusLine.progressMonitor;
        }
        if (backgroundMonitor != null) {
            backgroundMonitor.setVisible(this.isInBackground);
        }
        if (this.dialog != null) {
            this.setDialogVisible(!this.isInBackground || backgroundMonitor == null);
        }
        if (this.isInBackground && backgroundMonitor != null) {
            backgroundMonitor.setVisible(true);
            if (this.dialog != null) {
                this.setDialogVisible(false);
            }
            return backgroundMonitor;
        }
        if (backgroundMonitor != null) {
            backgroundMonitor.setVisible(false);
            if (this.dialog != null) {
                this.setDialogVisible(true);
            }
            return this.dialog;
        }
        if (this.dialog != null) {
            this.setDialogVisible(true);
            return this.dialog;
        }
        return null;
    }

    public PleaseWaitProgressMonitor() {
        this("");
    }

    public PleaseWaitProgressMonitor(String windowTitle) {
        this(Main.parent);
        this.windowTitle = windowTitle;
    }

    public PleaseWaitProgressMonitor(Component dialogParent) {
        super(new CancelHandler());
        this.dialogParent = GraphicsEnvironment.isHeadless() ? dialogParent : GuiHelper.getFrameForComponent(dialogParent);
        this.cancelable = true;
    }

    public PleaseWaitProgressMonitor(Component dialogParent, String windowTitle) {
        this(GuiHelper.getFrameForComponent(dialogParent));
        this.windowTitle = windowTitle;
    }

    public final boolean isCancelable() {
        return this.cancelable;
    }

    public final void setCancelable(boolean cancelable) {
        this.cancelable = cancelable;
    }

    @Override
    public void doBeginTask() {
        this.doInEDT(() -> {
            currentProgressMonitor = this;
            if (GraphicsEnvironment.isHeadless()) {
                return;
            }
            if (this.dialogParent == null || this.dialog != null) {
                throw new ProgressException("PleaseWaitDialog parent must be set", new Object[0]);
            }
            this.dialog = new PleaseWaitDialog(this.dialogParent);
            if (this.windowTitle != null) {
                this.dialog.setTitle(this.windowTitle);
            }
            this.dialog.setCancelEnabled(this.cancelable);
            this.dialog.setCancelCallback(this.cancelListener);
            this.dialog.setInBackgroundCallback(this.inBackgroundListener);
            this.dialog.setCustomText("");
            this.dialog.addWindowListener(this.windowListener);
            this.dialog.setMaximumProgress(10000);
            this.dialog.setVisible(true);
        });
    }

    @Override
    public void doFinishTask() {
    }

    @Override
    protected void updateProgress(double progressValue) {
        int newValue = (int)(progressValue * 10000.0);
        if (newValue != this.currentProgressValue) {
            this.currentProgressValue = newValue;
            this.doInEDT(() -> {
                ProgressMonitorDialog dlg = this.getDialog();
                if (dlg != null) {
                    dlg.updateProgress(this.currentProgressValue);
                }
            });
        }
    }

    @Override
    protected void doSetCustomText(String title) {
        this.checkState(AbstractProgressMonitor.State.IN_TASK, AbstractProgressMonitor.State.IN_SUBTASK);
        this.customText = title;
        this.doInEDT(() -> {
            ProgressMonitorDialog dlg = this.getDialog();
            if (dlg != null) {
                dlg.setCustomText(title);
            }
        });
    }

    @Override
    protected void doSetTitle(String title) {
        this.checkState(AbstractProgressMonitor.State.IN_TASK, AbstractProgressMonitor.State.IN_SUBTASK);
        this.title = title;
        this.doInEDT(() -> {
            ProgressMonitorDialog dlg = this.getDialog();
            if (dlg != null) {
                dlg.setCurrentAction(title);
            }
        });
    }

    @Override
    protected void doSetIntermediate(boolean value) {
        this.indeterminate = value;
        this.doInEDT(() -> {
            ProgressMonitorDialog dlg = this.getDialog();
            if (dlg != null) {
                dlg.setIndeterminate(value && this.currentProgressValue == 0);
            }
        });
    }

    @Override
    public void appendLogMessage(String message) {
        this.doInEDT(() -> {
            ProgressMonitorDialog dlg = this.getDialog();
            if (dlg != null) {
                dlg.appendLogMessage(message);
            }
        });
    }

    public void reset() {
        if (this.dialog != null) {
            this.dialog.setTitle(this.title);
            this.dialog.setCustomText(this.customText);
            this.dialog.updateProgress(this.currentProgressValue);
            this.dialog.setIndeterminate(this.indeterminate && this.currentProgressValue == 0);
        }
        MapStatus.BackgroundProgressMonitor backgroundMonitor = null;
        MapFrame map = MainApplication.getMap();
        if (map != null) {
            backgroundMonitor = map.statusLine.progressMonitor;
        }
        if (backgroundMonitor != null) {
            backgroundMonitor.setCurrentAction(this.title);
            backgroundMonitor.setCustomText(this.customText);
            backgroundMonitor.updateProgress(this.currentProgressValue);
            backgroundMonitor.setIndeterminate(this.indeterminate && this.currentProgressValue == 0);
        }
    }

    public void close() {
        this.doInEDT(() -> {
            if (this.dialog != null) {
                this.dialog.setVisible(false);
                this.dialog.setCancelCallback(null);
                this.dialog.setInBackgroundCallback(null);
                this.dialog.removeWindowListener(this.windowListener);
                this.dialog.dispose();
                this.dialog = null;
                currentProgressMonitor = null;
                MapFrame map = MainApplication.getMap();
                if (map != null) {
                    map.statusLine.progressMonitor.setVisible(false);
                }
            }
        });
    }

    public void showForegroundDialog() {
        this.isInBackground = false;
        this.doInEDT(() -> {
            if (this.dialog != null) {
                this.dialog.setInBackgroundPossible(this.taskId != null && MainApplication.isDisplayingMapView());
                this.reset();
                this.getDialog();
            }
        });
    }

    @Override
    public void setProgressTaskId(ProgressTaskId taskId) {
        this.taskId = taskId;
        this.doInEDT(() -> {
            if (this.dialog != null) {
                this.dialog.setInBackgroundPossible(taskId != null && MainApplication.isDisplayingMapView());
            }
        });
    }

    @Override
    public ProgressTaskId getProgressTaskId() {
        return this.taskId;
    }

    @Override
    public Component getWindowParent() {
        PleaseWaitDialog parent = this.dialog;
        if (this.isInBackground || parent == null) {
            return Main.parent;
        }
        return parent;
    }

    public String toString() {
        return "PleaseWaitProgressMonitor [currentProgressValue=" + this.currentProgressValue + ", customText=" + this.customText + ", title=" + this.title + ", indeterminate=" + this.indeterminate + ", isInBackground=" + this.isInBackground + ", windowTitle=" + this.windowTitle + ", taskId=" + this.taskId + ", cancelable=" + this.cancelable + ", state=" + (Object)((Object)this.state) + "]";
    }

    public static interface ProgressMonitorDialog {
        public void setVisible(boolean var1);

        public void updateProgress(int var1);

        public void setCustomText(String var1);

        public void setCurrentAction(String var1);

        public void setIndeterminate(boolean var1);

        public void appendLogMessage(String var1);
    }
}

