/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.repository.vfs;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.vfs.FileContent;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemManager;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.impl.StandardFileSystemManager;
import org.apache.ivy.plugins.repository.AbstractRepository;
import org.apache.ivy.plugins.repository.RepositoryCopyProgressListener;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.plugins.repository.vfs.VfsResource;
import org.apache.ivy.util.CopyProgressListener;
import org.apache.ivy.util.FileUtil;
import org.apache.ivy.util.Message;

public class VfsRepository
extends AbstractRepository {
    private static final String IVY_VFS_CONFIG = "ivy_vfs.xml";
    private StandardFileSystemManager manager = null;
    private final CopyProgressListener progress = new RepositoryCopyProgressListener(this);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileSystemManager getVFSManager() throws IOException {
        VfsRepository vfsRepository = this;
        synchronized (vfsRepository) {
            if (this.manager == null) {
                this.manager = this.createVFSManager();
            }
        }
        return this.manager;
    }

    private StandardFileSystemManager createVFSManager() throws IOException {
        StandardFileSystemManager standardFileSystemManager = null;
        try {
            standardFileSystemManager = new StandardFileSystemManager(){

                protected void configurePlugins() throws FileSystemException {
                }
            };
            standardFileSystemManager.setConfiguration(this.getClass().getResource(IVY_VFS_CONFIG));
            standardFileSystemManager.init();
            Message.verbose("Available VFS schemes...");
            Object[] objectArray = standardFileSystemManager.getSchemes();
            Arrays.sort(objectArray);
            for (int i = 0; i < objectArray.length; ++i) {
                Message.verbose("VFS Supported Scheme: " + (String)objectArray[i]);
            }
        }
        catch (FileSystemException fileSystemException) {
            Message.error("Unable to initialize VFS repository manager!");
            Message.error(fileSystemException.getLocalizedMessage());
            IOException iOException = new IOException(fileSystemException.getLocalizedMessage());
            iOException.initCause(fileSystemException);
            throw iOException;
        }
        return standardFileSystemManager;
    }

    protected void finalize() {
        if (this.manager != null) {
            this.manager.close();
            this.manager = null;
        }
    }

    @Override
    public Resource getResource(String string) throws IOException {
        return new VfsResource(string, this.getVFSManager());
    }

    @Override
    public void get(String string, File file) throws IOException {
        VfsResource vfsResource = new VfsResource(string, this.getVFSManager());
        this.fireTransferInitiated(vfsResource, 5);
        try {
            FileContent fileContent = vfsResource.getContent();
            if (fileContent == null) {
                throw new IllegalArgumentException("invalid vfs uri " + string + ": no content found");
            }
            FileUtil.copy(fileContent.getInputStream(), file, this.progress);
        }
        catch (IOException iOException) {
            this.fireTransferError(iOException);
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            this.fireTransferError(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public List list(String string) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        Message.debug("list called for URI" + string);
        FileObject fileObject = this.getVFSManager().resolveFile(string);
        Message.debug("resourceImpl=" + fileObject.toString());
        Message.debug("resourceImpl.exists()" + fileObject.exists());
        Message.debug("resourceImpl.getType()" + fileObject.getType());
        Message.debug("FileType.FOLDER" + FileType.FOLDER);
        if (fileObject != null && fileObject.exists() && fileObject.getType() == FileType.FOLDER) {
            FileObject[] fileObjectArray = fileObject.getChildren();
            for (int i = 0; i < fileObjectArray.length; ++i) {
                FileObject fileObject2 = fileObjectArray[i];
                Message.debug("child " + i + fileObject2.getName().getURI());
                arrayList.add(VfsResource.normalize(fileObject2.getName().getURI()));
            }
        }
        return arrayList;
    }

    @Override
    public void put(File file, String string, boolean bl) throws IOException {
        VfsResource vfsResource = new VfsResource(string, this.getVFSManager());
        this.fireTransferInitiated(vfsResource, 6);
        if (vfsResource.physicallyExists() && !bl) {
            throw new IOException("Cannot copy. Destination file: " + vfsResource.getName() + " exists and overwrite not set.");
        }
        if (vfsResource.getContent() == null) {
            throw new IllegalArgumentException("invalid vfs uri " + string + " to put data to: resource has no content");
        }
        FileUtil.copy((InputStream)new FileInputStream(file), vfsResource.getContent().getOutputStream(), this.progress);
    }
}

