/*
 * Decompiled with CFR 0.152.
 */
package javajs.img;

import java.util.zip.CRC32;
import javajs.img.ImageEncoder;
import javajs.util.AU;

abstract class CRCEncoder
extends ImageEncoder {
    protected int startPos;
    protected int bytePos;
    private CRC32 crc;
    protected byte[] pngBytes;
    protected int dataLen;
    private byte[] int2 = new byte[2];
    private byte[] int4 = new byte[4];

    CRCEncoder() {
        this.pngBytes = new byte[250];
        this.crc = new CRC32();
    }

    protected void setData(byte[] b, int pt) {
        this.pngBytes = b;
        this.dataLen = b.length;
        this.startPos = this.bytePos = pt;
    }

    protected byte[] getBytes() {
        return this.dataLen == this.pngBytes.length ? this.pngBytes : AU.arrayCopyByte(this.pngBytes, this.dataLen);
    }

    protected void writeCRC() {
        this.crc.reset();
        this.crc.update(this.pngBytes, this.startPos, this.bytePos - this.startPos);
        this.writeInt4((int)this.crc.getValue());
    }

    protected void writeInt2(int n) {
        this.int2[0] = (byte)(n >> 8 & 0xFF);
        this.int2[1] = (byte)(n & 0xFF);
        this.writeBytes(this.int2);
    }

    protected void writeInt4(int n) {
        CRCEncoder.getInt4(n, this.int4);
        this.writeBytes(this.int4);
    }

    protected static void getInt4(int n, byte[] int4) {
        int4[0] = (byte)(n >> 24 & 0xFF);
        int4[1] = (byte)(n >> 16 & 0xFF);
        int4[2] = (byte)(n >> 8 & 0xFF);
        int4[3] = (byte)(n & 0xFF);
    }

    protected void writeByte(int b) {
        byte[] temp = new byte[]{(byte)b};
        this.writeBytes(temp);
    }

    protected void writeString(String s) {
        this.writeBytes(s.getBytes());
    }

    protected void writeBytes(byte[] data) {
        int newPos = this.bytePos + data.length;
        this.dataLen = Math.max(this.dataLen, newPos);
        if (newPos > this.pngBytes.length) {
            this.pngBytes = AU.arrayCopyByte(this.pngBytes, newPos + 16);
        }
        System.arraycopy(data, 0, this.pngBytes, this.bytePos, data.length);
        this.bytePos = newPos;
    }
}

