/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xtal;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.A4;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.M3;
import javajs.util.Matrix;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.Quat;
import javajs.util.Rdr;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.MSInterface;
import org.jmol.api.Interface;
import org.jmol.api.SymmetryInterface;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;

public class JanaReader
extends AtomSetCollectionReader {
    private Lst<float[]> lattvecs;
    private int thisSub;
    private String modAxes;
    private int modDim;
    private boolean haveM40Data;
    static final String records = "tit  cell ndim qi   lat  sym  spg  end  wma";
    static final int TITLE = 0;
    static final int CELL = 5;
    static final int NDIM = 10;
    static final int QI = 15;
    static final int LATT = 20;
    static final int SYM = 25;
    static final int SPG = 30;
    static final int END = 35;
    static final int WMATRIX = 40;
    private int qicount;
    private String molName;
    private Lst<Atom> molAtoms;
    private Lst<Integer> molTtypes;
    private Lst<P3> modelMolecule;
    private boolean molHasTLS;
    private M3 matR;
    private P3 rho;
    private boolean firstPosition;
    private V3 vR;
    private V3 v0Cart;
    private boolean isLegendre;
    public static final String U_LIST = "U11U22U33U12U13U23UISO";
    private static String[] XYZ = new String[]{"x", "y", "z"};
    private float[] floats = new float[6];

    public void initializeReader() throws Exception {
        this.modAxes = this.getFilter("MODAXES=");
        this.setFractionalCoordinates(true);
        this.asc.newAtomSet();
        this.asc.setCurrentModelInfo("autoBondUsingOccupation", (Object)Boolean.TRUE);
    }

    protected boolean checkLine() throws Exception {
        if (this.line.length() < 3) {
            return true;
        }
        Logger.info((String)this.line);
        this.parseTokenStr(this.line);
        switch (records.indexOf(this.line.substring(0, 3))) {
            case 0: {
                this.asc.setAtomSetName(this.line.substring(5).trim());
                break;
            }
            case 5: {
                this.cell();
                this.setSymmetryOperator("x,y,z");
                break;
            }
            case 10: {
                this.ndim();
                break;
            }
            case 20: {
                if (this.lattvecs == null) {
                    this.lattvecs = new Lst();
                }
                if (this.ms.addLatticeVector(this.lattvecs, this.line.substring(8))) break;
                this.appendLoadNote(this.line + " not supported");
                break;
            }
            case 30: {
                this.setSpaceGroupName(this.getTokens()[1]);
                break;
            }
            case 25: {
                this.symmetry();
                break;
            }
            case 15: {
                this.qi();
                break;
            }
            case 35: {
                while (this.rd() != null) {
                    if (!this.line.startsWith("command") && this.parseIntStr(this.line) < 0) continue;
                    this.readM40Data(true);
                    break;
                }
                this.continuing = false;
                break;
            }
            case 40: {
                Matrix m;
                int n = 3 + this.modDim;
                if (this.thisSub++ == 0) {
                    m = Matrix.identity((int)n, (int)n);
                    this.ms.addSubsystem("" + this.thisSub++, m);
                }
                m = new Matrix((double[][])null, n, n);
                double[][] a = m.getArray();
                float[] data = new float[n * n];
                this.fillFloatArray(null, 0, data);
                int pt = 0;
                for (int i = 0; i < n; ++i) {
                    int j = 0;
                    while (j < n) {
                        a[i][j] = data[pt];
                        ++j;
                        ++pt;
                    }
                }
                this.ms.addSubsystem("" + this.thisSub, m);
            }
        }
        return true;
    }

    public void doPreSymmetry() throws Exception {
        if (this.ms != null) {
            this.ms.setModulation(false, null);
        }
        if (this.vibsFractional) {
            this.asc.getXSymmetry().scaleFractionalVibs();
        }
    }

    public void finalizeSubclassReader() throws Exception {
        if (!this.haveM40Data) {
            this.readM40Data(false);
        }
        if (this.lattvecs != null && this.lattvecs.size() > 0) {
            this.asc.getSymmetry().addLatticeVectors(this.lattvecs);
        }
        this.applySymmetryAndSetTrajectory();
        this.finalizeReaderASCR();
    }

    protected void finalizeSubclassSymmetry(boolean haveSymmetry) throws Exception {
        this.adjustM40Occupancies();
        if (this.ms != null && haveSymmetry) {
            this.ms.setModulation(true, this.asc.getXSymmetry().getBaseSymmetry());
            this.ms.finalizeModulation();
        }
    }

    private void cell() throws Exception {
        for (int ipt = 0; ipt < 6; ++ipt) {
            this.setUnitCellItem(ipt, this.parseFloat());
        }
    }

    private void ndim() throws Exception {
        this.ms = (MSInterface)Interface.getOption((String)"adapter.readers.cif.MSRdr", (Viewer)this.vwr, (String)"file");
        this.modDim = this.ms.initialize((AtomSetCollectionReader)this, this.parseIntStr(this.getTokens()[1]) - 3);
    }

    private void qi() throws Exception {
        double[] pt = new double[this.modDim];
        pt[this.qicount] = 1.0;
        double[] a = new double[]{this.parseFloat(), this.parseFloat(), this.parseFloat()};
        this.parseTokenStr(this.rd());
        int i = 0;
        while (i < 3) {
            int n = i++;
            a[n] = a[n] + (double)this.parseFloat();
        }
        this.ms.addModulation(null, "W_" + ++this.qicount, a, -1);
        this.ms.addModulation(null, "F_" + this.qicount + "_coefs_", pt, -1);
    }

    private void symmetry() throws Exception {
        this.setSymmetryOperator(PT.rep((String)this.line.substring(9).trim(), (String)" ", (String)","));
    }

    private void readM40Data(boolean haveReader) throws Exception {
        if (haveReader) {
            this.parseM40Floats();
        } else {
            String m40File = this.filePath;
            int ipt = m40File.lastIndexOf(".");
            if (ipt < 0) {
                return;
            }
            m40File = m40File.substring(0, ipt + 2) + "40";
            String id = m40File.substring(0, ipt);
            this.reader.close();
            this.reader = Rdr.getBR((String)((String)this.vwr.getLigandModel(id, m40File, "_file", "----")));
            if (this.out != null) {
                this.out.append("******************************* M40 DATA *******************************\n");
            }
            this.readM40Floats();
        }
        this.haveM40Data = true;
        if (this.line.startsWith("command")) {
            this.readM40WaveVectors();
        }
        int nFree = 0;
        int nGroups = 0;
        boolean isAxial = false;
        BS newSub = this.thisSub == 0 ? null : new BS();
        int iSub = this.thisSub == 0 ? 1 : this.thisSub;
        int i = 0;
        int n = 0;
        int pt = 0;
        while (i < iSub) {
            nFree = this.getInt(pt, pt + 5);
            nGroups = this.getInt(pt + 5, pt + 10);
            boolean bl = isAxial = this.getInt(pt + 15, pt + 20) == 1;
            if (nGroups != 0 && i > 0) {
                throw new Exception("Jmol cannot read rigid body M40 files for composites");
            }
            if (newSub != null) {
                newSub.set(n += nFree);
            }
            ++i;
            pt += 10;
        }
        iSub = newSub == null ? 0 : 1;
        int nAtoms = -1;
        String refAtomName = null;
        this.rho = null;
        if (nGroups > 0) {
            Logger.info((String)("JanaReader found " + nFree + " free atoms and " + nGroups + " groups"));
            this.molName = null;
            this.molAtoms = new Lst();
            this.molTtypes = new Lst();
        }
        while (this.skipToNextAtom() != null) {
            String posName;
            String name;
            ++nAtoms;
            Atom atom = new Atom();
            Logger.info((String)this.line);
            atom.atomName = name = this.line.substring(0, 9).trim();
            boolean isRefAtom = name.equals(refAtomName);
            atom.foccupancy = this.floats[2];
            boolean isJanaMolecule = Float.isNaN(atom.foccupancy);
            if (isJanaMolecule) {
                String pointGroup = this.getStr(12, 18);
                if (pointGroup.length() > 0 && !pointGroup.equals("1")) {
                    throw new Exception("Jmol cannot process M40 files with molecule positions based on point-group symmetry.");
                }
                refAtomName = null;
                if (Float.isNaN(this.floats[4])) {
                    refAtomName = this.getStr(28, 37);
                } else {
                    this.rho = P3.new3((float)this.floats[3], (float)this.floats[4], (float)this.floats[5]);
                }
                this.molName = name;
                this.molAtoms.clear();
                this.molTtypes.clear();
                this.molHasTLS = false;
                this.firstPosition = true;
                this.modelMolecule = new Lst();
                continue;
            }
            boolean isExcluded = false;
            String string = posName = name.startsWith("pos#") ? name : null;
            if (posName == null) {
                if (!this.filterAtom(atom, 0)) {
                    if (!isRefAtom) continue;
                    isExcluded = true;
                }
                this.setAtomCoordXYZ(atom, this.floats[3], this.floats[4], this.floats[5]);
                if (isRefAtom) {
                    this.rho = P3.newP((T3)atom);
                    if (isExcluded) continue;
                }
                this.asc.addAtom(atom);
                if (iSub > 0) {
                    if (newSub.get(nAtoms)) {
                        ++iSub;
                    }
                    atom.altLoc = ("" + iSub).charAt(0);
                }
                this.readAtomRecord(atom, null, null, false);
                if (this.molAtoms == null) continue;
                this.molAtoms.addLast((Object)atom);
                continue;
            }
            if (this.molAtoms.size() == 0) continue;
            this.processPosition(posName, atom, isAxial);
        }
    }

    private int getInt(int col1, int col2) {
        int n = this.line.length();
        return n > col1 ? this.parseIntStr(this.getStr(col1, col2)) : 0;
    }

    private String getStr(int col1, int col2) {
        int n = this.line.length();
        return n > col1 ? this.line.substring(col1, Math.min(n, col2)).trim() : "";
    }

    private boolean getFlag(int i) {
        return this.getInt(i, i + 1) > 0;
    }

    private String skipToNextAtom() throws Exception {
        while (this.readM40Floats() != null && (this.line.length() == 0 || this.line.charAt(0) == ' ' || this.line.charAt(0) == '-')) {
        }
        return this.line;
    }

    private void readM40WaveVectors() throws Exception {
        while (!this.readM40Floats().contains("end")) {
            if (!this.line.startsWith("wave")) continue;
            String[] tokens = this.getTokens();
            double[] pt = new double[this.modDim];
            for (int i = 0; i < this.modDim; ++i) {
                pt[i] = this.parseFloatStr(tokens[i + 2]);
            }
            this.ms.addModulation(null, "F_" + this.parseIntStr(tokens[1]) + "_coefs_", pt, -1);
        }
        this.readM40Floats();
    }

    private void processPosition(String posName, Atom pos, boolean isAxial) throws Exception {
        P3 rp;
        pos.atomName = this.molName + "_" + posName;
        boolean isImproper = this.getInt(9, 11) == -1;
        int systType = this.getInt(13, 14);
        P3 rm = systType == 0 ? null : new P3();
        P3 p3 = rp = systType == 0 ? null : new P3();
        if (systType != 0) {
            throw new Exception("Jmol can only read rigid body groups with basic crystallographic settings.");
        }
        float[][] rotData = this.readAtomRecord(pos, rm, rp, true);
        String name = pos.atomName;
        int n = this.molAtoms.size();
        Logger.info((String)(name + " Molecular group " + this.molName + " has " + n + " atoms"));
        String ext = "_" + posName.substring(4);
        V3 vTrans = V3.new3((float)pos.anisoBorU[3], (float)pos.anisoBorU[4], (float)pos.anisoBorU[5]);
        Quat phi = Quat.newAA((A4)A4.newVA((V3)V3.new3((float)0.0f, (float)0.0f, (float)1.0f), (float)((float)((double)(pos.anisoBorU[0] / 180.0f) * Math.PI))));
        Quat chi = Quat.newAA((A4)A4.newVA((V3)(isAxial ? V3.new3((float)0.0f, (float)1.0f, (float)0.0f) : V3.new3((float)1.0f, (float)0.0f, (float)0.0f)), (float)((float)((double)(pos.anisoBorU[1] / 180.0f) * Math.PI))));
        Quat psi = Quat.newAA((A4)A4.newVA((V3)(isAxial ? V3.new3((float)1.0f, (float)0.0f, (float)0.0f) : V3.new3((float)0.0f, (float)0.0f, (float)1.0f)), (float)((float)((double)(pos.anisoBorU[2] / 180.0f) * Math.PI))));
        this.matR = phi.mulQ(chi).mulQ(psi).getMatrix();
        if (isImproper) {
            this.matR.scale(-1.0f);
        }
        String script = "";
        for (int i = 0; i < n; ++i) {
            Atom a = (Atom)this.molAtoms.get(i);
            String newName = a.atomName;
            script = script + ", " + newName;
            if (this.firstPosition) {
                newName = newName + ext;
                this.modelMolecule.addLast((Object)P3.newP((T3)a));
            } else {
                a = this.asc.newCloneAtom(a);
                newName = newName.substring(0, newName.lastIndexOf("_")) + ext;
            }
            a.atomName = newName;
            V3 v0 = V3.newVsub((T3)((T3)this.modelMolecule.get(i)), (T3)this.rho);
            this.v0Cart = V3.newV((T3)v0);
            this.getSymmetry().toCartesian((T3)this.v0Cart, true);
            this.vR = V3.newV((T3)v0);
            this.cartesianProduct((T3)this.vR, null);
            a.setT((T3)this.rho);
            a.add((T3)vTrans);
            a.add((T3)this.vR);
            this.copyModulations(";" + pos.atomName, ";" + newName);
            if (rotData == null) continue;
            this.setRigidBodyRotations(";" + newName, rotData);
        }
        this.firstPosition = false;
        script = "@" + this.molName + ext + script.substring(1);
        this.addJmolScript(script);
        this.appendLoadNote(script);
    }

    private void cartesianProduct(T3 vA, T3 vB) {
        this.symmetry.toCartesian(vA, true);
        if (vB == null) {
            this.matR.rotate2(vA, vA);
        } else {
            vA.cross(vA, vB);
        }
        this.symmetry.toFractional(vA, true);
    }

    private float[][] readAtomRecord(Atom atom, P3 rm, P3 rp, boolean isPos) throws Exception {
        float[][] rotData;
        int k;
        int j;
        float o_0;
        int tType;
        String label = ";" + atom.atomName;
        int n = tType = isPos ? -1 : this.getInt(13, 14);
        if (!isPos && this.molTtypes != null) {
            this.molTtypes.addLast((Object)tType);
        }
        boolean haveSpecialOcc = this.getFlag(60);
        boolean haveSpecialDisp = this.getFlag(61);
        boolean haveSpecialUij = this.getFlag(62);
        int nOcc = this.getInt(65, 68);
        int nDisp = this.getInt(68, 71);
        int nUij = this.getInt(71, 74);
        if (rm != null) {
            this.readM40Floats();
            rm.set(this.floats[0], this.floats[1], this.floats[2]);
            rp.set(this.floats[3], this.floats[4], this.floats[5]);
        }
        if (tType > 2) {
            this.readM40Floats();
        }
        this.readM40Floats();
        switch (tType) {
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                this.readLines(tType - 1);
                this.appendLoadNote("Skipping temperature factors with order > 2");
            }
            case -1: 
            case 2: {
                for (int j2 = 0; j2 < 6; ++j2) {
                    this.asc.setU(atom, j2, this.floats[j2]);
                }
                break;
            }
            case 1: {
                if (this.floats[0] == 0.0f) break;
                this.asc.setU(atom, 7, this.floats[0]);
                break;
            }
            case 0: {
                this.molHasTLS = true;
                this.appendLoadNote("Jmol cannot process molecular TLS parameters");
            }
        }
        if (this.modDim == 0) {
            return null;
        }
        if (isPos && this.molHasTLS) {
            this.readLines(4);
        }
        float f = o_0 = nOcc > 0 && !haveSpecialOcc ? this.parseFloatStr(this.rd()) : 1.0f;
        if (o_0 != 1.0f) {
            this.ms.addModulation(null, "J_O#0" + label, new double[]{atom.foccupancy, o_0, 0.0}, -1);
        }
        atom.foccupancy *= o_0;
        int wv = 0;
        this.isLegendre = false;
        for (j = 0; j < nOcc; ++j) {
            float a1;
            float a2;
            if (haveSpecialOcc) {
                float[][] data = this.readM40FloatLines(2, 1);
                a2 = data[0][0];
                a1 = data[1][0];
            } else {
                wv = j + 1;
                this.readM40Floats();
                a1 = this.floats[0];
                a2 = this.floats[1];
            }
            double[] pt = new double[]{a1, a2, 0.0};
            if (a1 == 0.0f && a2 == 0.0f) continue;
            this.ms.addModulation(null, "O_" + wv + "#0" + label, pt, -1);
        }
        for (j = 0; j < nDisp; ++j) {
            if (haveSpecialDisp) {
                this.readM40Floats();
                float c = this.floats[3];
                float w = this.floats[4];
                for (k = 0; k < 3; ++k) {
                    if (this.floats[k] == 0.0f) continue;
                    this.ms.addModulation(null, "D_S#" + XYZ[k] + label, new double[]{c, w, this.floats[k]}, -1);
                }
                continue;
            }
            this.addSinCos(j, "D_", label, isPos);
        }
        float[][] fArray = rotData = isPos && nDisp > 0 ? this.readM40FloatLines(nDisp, 6) : (float[][])null;
        if (!isPos) {
            if (this.isLegendre) {
                nUij *= 2;
            }
            for (int j3 = 0; j3 < nUij; ++j3) {
                float[][] data;
                if (tType == 1) {
                    this.addSinCos(j3, "U_", label, false);
                    continue;
                }
                if (haveSpecialUij) {
                    Logger.error((String)("JanaReader -- not interpreting SpecialUij flag: " + this.line));
                    continue;
                }
                if (this.isLegendre) {
                    data = this.readM40FloatLines(1, 6);
                    int order = j3 + 1;
                    double coeff = 0.0;
                    int k2 = 0;
                    int p = 0;
                    while (k2 < 6) {
                        coeff = data[0][k2];
                        if (coeff != 0.0) {
                            this.ms.addModulation(null, "U_L" + order + "#" + U_LIST.substring(p, p + 3) + label, new double[]{coeff, order, 0.0}, -1);
                        }
                        ++k2;
                        p += 3;
                    }
                    continue;
                }
                data = this.readM40FloatLines(2, 6);
                k = 0;
                int p = 0;
                while (k < 6) {
                    double csin = data[1][k];
                    double ccos = data[0][k];
                    this.ms.addModulation(null, "U_" + (j3 + 1) + "#" + U_LIST.substring(p, p + 3) + label, new double[]{csin, ccos, 0.0}, -1);
                    ++k;
                    p += 3;
                }
            }
        }
        return rotData;
    }

    private void addSinCos(int j, String key, String label, boolean isPos) throws Exception {
        this.readM40Floats();
        if (this.isLegendre) {
            for (int i = 0; i < 2; ++i) {
                int order = j * 2 + i + 1;
                for (int k = 0; k < 3; ++k) {
                    float coeff = this.floats[3 * i + k];
                    if (coeff == 0.0f) continue;
                    String axis = XYZ[k % 3];
                    if (this.modAxes != null && this.modAxes.indexOf(axis.toUpperCase()) < 0) continue;
                    String id = key + "L#" + axis + order + label;
                    this.ms.addModulation(null, id, new double[]{coeff, order, 0.0}, -1);
                }
            }
            return;
        }
        this.ensureFourier(j);
        for (int k = 0; k < 3; ++k) {
            float csin = this.floats[k];
            float ccos = this.floats[k + 3];
            if (csin == 0.0f && ccos == 0.0f) {
                if (!isPos) continue;
                csin = 1.0E-10f;
            }
            String axis = XYZ[k % 3];
            if (this.modAxes != null && this.modAxes.indexOf(axis.toUpperCase()) < 0) continue;
            String id = key + (j + 1) + "#" + axis + label;
            this.ms.addModulation(null, id, new double[]{csin, ccos, 0.0}, -1);
        }
    }

    private void ensureFourier(int j) {
        double[] pt;
        if (j > 0 && this.ms.getMod("F_" + ++j + "_coefs_") == null && (pt = this.ms.getMod("F_1_coefs_")) != null) {
            double[] p = new double[this.modDim];
            int i = this.modDim;
            while (--i >= 0) {
                p[i] = pt[i] * (double)j;
            }
            this.ms.addModulation(null, "F_" + j + "_coefs_", p, -1);
        }
    }

    private String readM40Floats() throws Exception {
        this.line = this.rd();
        if (this.line == null || this.line.indexOf("-------") >= 0) {
            this.line = null;
            return null;
        }
        if (this.debugging) {
            Logger.debug((String)this.line);
        }
        this.parseM40Floats();
        return this.line;
    }

    private void parseM40Floats() {
        int ptLast = this.line.length() - 9;
        int i = 0;
        int pt = 0;
        while (i < 6) {
            this.floats[i] = pt <= ptLast ? this.parseFloatStr(this.line.substring(pt, pt + 9)) : Float.NaN;
            ++i;
            pt += 9;
        }
    }

    private float[][] readM40FloatLines(int nLines, int nFloats) throws Exception {
        float[][] data = new float[nLines][nFloats];
        for (int i = 0; i < nLines; ++i) {
            this.readM40Floats();
            if (this.line.indexOf("Legendre") == 19) {
                this.isLegendre = true;
            }
            for (int j = 0; j < nFloats; ++j) {
                data[i][j] = this.floats[j];
            }
        }
        return data;
    }

    private void adjustM40Occupancies() {
        Hashtable<String, Integer> htSiteMult = new Hashtable<String, Integer>();
        Atom[] atoms = this.asc.atoms;
        SymmetryInterface symmetry = this.asc.getSymmetry();
        int i = this.asc.ac;
        while (--i >= 0) {
            Atom a = atoms[i];
            Integer ii = (Integer)htSiteMult.get(a.atomName);
            if (ii == null) {
                ii = symmetry.getSiteMultiplicity((P3)a);
                htSiteMult.put(a.atomName, ii);
            }
            a.foccupancy *= (float)ii.intValue();
        }
    }

    private void copyModulations(String label, String newLabel) {
        Hashtable<String, double[]> mapTemp = new Hashtable<String, double[]>();
        block5: for (Map.Entry e : this.ms.getModulationMap().entrySet()) {
            String key = (String)e.getKey();
            if (!key.contains(label)) continue;
            key = PT.rep((String)key, (String)label, (String)newLabel);
            double[] val = (double[])e.getValue();
            switch (key.charAt(0)) {
                case 'O': {
                    val = new double[]{val[0], val[1], 0.0};
                    this.setRigidBodyPhase(key, val);
                    break;
                }
                case 'D': {
                    break;
                }
                case 'U': {
                    continue block5;
                }
            }
            mapTemp.put(key, val);
        }
        for (Map.Entry e : mapTemp.entrySet()) {
            this.ms.addModulation(null, (String)e.getKey(), (double[])e.getValue(), -1);
        }
    }

    private double[] setRigidBodyPhase(String key, double[] v) {
        boolean isCenter = false;
        switch (this.ms.getModType(key)) {
            case 'f': 
            case 'o': 
            case 'u': {
                break;
            }
            case 'c': 
            case 's': {
                isCenter = true;
            }
        }
        double nqDotD = 0.0;
        double n = -1.0;
        double[] qcoefs = this.ms.getQCoefs(key);
        int i = this.modDim;
        while (--i >= 0) {
            if (qcoefs[i] == 0.0) continue;
            n = qcoefs[i];
            double[] q = this.ms.getMod("W_" + (i + 1));
            nqDotD = n * (q[0] * (double)this.vR.x + q[1] * (double)this.vR.y + q[2] * (double)this.vR.z);
            break;
        }
        if (isCenter) {
            v[0] = v[0] + nqDotD;
        } else {
            double sA = v[0];
            double cA = v[1];
            double sX = Math.sin(Math.PI * 2 * nqDotD);
            double cX = Math.cos(Math.PI * 2 * nqDotD);
            v[0] = sA * cX + cA * sX;
            v[1] = -sA * sX + cA * cX;
        }
        return v;
    }

    private void setRigidBodyRotations(String label, float[][] params) {
        int n = params.length;
        for (int i = 0; i < n; ++i) {
            this.ensureFourier(i);
            String key = "D_" + (i + 1);
            float[] data = params[i];
            V3 vsin = V3.new3((float)data[0], (float)data[1], (float)data[2]);
            V3 vcos = V3.new3((float)data[3], (float)data[4], (float)data[5]);
            this.cartesianProduct((T3)vcos, (T3)this.v0Cart);
            this.cartesianProduct((T3)vsin, (T3)this.v0Cart);
            String keyx = key + "#x" + label;
            String keyy = key + "#y" + label;
            String keyz = key + "#z" + label;
            double[] vx = this.combineModulation(keyx, vsin.x, vcos.x);
            double[] vy = this.combineModulation(keyy, vsin.y, vcos.y);
            double[] vz = this.combineModulation(keyz, vsin.z, vcos.z);
            vsin.set((float)vx[0], (float)vy[0], (float)vz[0]);
            vcos.set((float)vx[1], (float)vy[1], (float)vz[1]);
            this.cartesianProduct((T3)vsin, null);
            this.cartesianProduct((T3)vcos, null);
            this.setMolecularModulation(keyx, vsin.x, vcos.x);
            this.setMolecularModulation(keyy, vsin.y, vcos.y);
            this.setMolecularModulation(keyz, vsin.z, vcos.z);
        }
    }

    private double[] combineModulation(String key, float csin, float ccos) {
        double[] v = this.ms.getMod(key);
        return new double[]{v[0] + (double)csin, v[1] + (double)ccos, 0.0};
    }

    private void setMolecularModulation(String key, float csin, float ccos) {
        this.ms.addModulation(null, key, this.setRigidBodyPhase(key, new double[]{csin, ccos, 0.0}), -1);
    }
}

