/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions.impl;

import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.AreaPicoContainer;
import com.intellij.openapi.extensions.EPAvailabilityListenerExtension;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointAvailabilityListener;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.LogProvider;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.extensions.impl.ExtensionComponentAdapter;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.openapi.extensions.impl.PicoPluginExtensionInitializationException;
import com.intellij.openapi.extensions.impl.UndefinedPluginDescriptor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.pico.CachingConstructorInjectionComponentAdapter;
import com.intellij.util.pico.DefaultPicoContainer;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.PicoContainer;

public class ExtensionsAreaImpl
implements ExtensionsArea {
    private final LogProvider myLogger;
    private static final Map<String, String> ourDefaultEPs = new THashMap<String, String>();
    private static final boolean DEBUG_REGISTRATION;
    private final AreaPicoContainer myPicoContainer;
    private final Throwable myCreationTrace;
    private final Map<String, ExtensionPointImpl> myExtensionPoints;
    private final Map<String, Throwable> myEPTraces;
    private final MultiMap<String, ExtensionPointAvailabilityListener> myAvailabilityListeners;
    private final List<Runnable> mySuspendedListenerActions;
    private boolean myAvailabilityNotificationsActive;
    private final AreaInstance myAreaInstance;
    private final String myAreaClass;

    public ExtensionsAreaImpl(String areaClass, AreaInstance areaInstance, PicoContainer parentPicoContainer, @NotNull LogProvider logger) {
        if (logger == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(0);
        }
        this.myExtensionPoints = ContainerUtil.newConcurrentMap();
        this.myEPTraces = DEBUG_REGISTRATION ? new THashMap() : null;
        this.myAvailabilityListeners = MultiMap.createSmart();
        this.mySuspendedListenerActions = new ArrayList<Runnable>();
        this.myAvailabilityNotificationsActive = true;
        this.myCreationTrace = DEBUG_REGISTRATION ? new Throwable("Area creation trace") : null;
        this.myAreaClass = areaClass;
        this.myAreaInstance = areaInstance;
        this.myPicoContainer = new DefaultPicoContainer(parentPicoContainer);
        this.myLogger = logger;
        this.initialize();
    }

    public final void notifyAreaReplaced() {
        for (ExtensionPointImpl point : this.myExtensionPoints.values()) {
            point.notifyAreaReplaced(this);
        }
    }

    @Override
    @NotNull
    public AreaPicoContainer getPicoContainer() {
        AreaPicoContainer areaPicoContainer = this.myPicoContainer;
        if (areaPicoContainer == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(2);
        }
        return areaPicoContainer;
    }

    @Override
    public String getAreaClass() {
        return this.myAreaClass;
    }

    @Override
    public void registerExtensionPoint(@NotNull PluginDescriptor pluginDescriptor, @NotNull Element extensionPointElement) {
        ExtensionPoint.Kind kind;
        String className2;
        if (pluginDescriptor == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(5);
        }
        if (extensionPointElement == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(6);
        }
        assert (pluginDescriptor.getPluginId() != null);
        String pluginId = pluginDescriptor.getPluginId().getIdString();
        String epName = extensionPointElement.getAttributeValue("qualifiedName");
        if (epName == null) {
            String name = extensionPointElement.getAttributeValue("name");
            if (name == null) {
                throw new RuntimeException("'name' attribute not specified for extension point in '" + pluginId + "' plugin");
            }
            epName = pluginId + '.' + name;
        }
        String beanClassName = extensionPointElement.getAttributeValue("beanClass");
        String interfaceClassName = extensionPointElement.getAttributeValue("interface");
        if (beanClassName == null && interfaceClassName == null) {
            throw new RuntimeException("Neither 'beanClass' nor 'interface' attribute is specified for extension point '" + epName + "' in '" + pluginId + "' plugin");
        }
        if (beanClassName != null && interfaceClassName != null) {
            throw new RuntimeException("Both 'beanClass' and 'interface' attributes are specified for extension point '" + epName + "' in '" + pluginId + "' plugin");
        }
        if (interfaceClassName != null) {
            className2 = interfaceClassName;
            kind = ExtensionPoint.Kind.INTERFACE;
        } else {
            className2 = beanClassName;
            kind = ExtensionPoint.Kind.BEAN_CLASS;
        }
        this.registerExtensionPoint(epName, className2, pluginDescriptor, kind);
    }

    @Override
    public void registerExtension(@NotNull PluginDescriptor pluginDescriptor, @NotNull Element extensionElement, String ns) {
        ExtensionComponentAdapter adapter;
        if (pluginDescriptor == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(9);
        }
        if (extensionElement == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(10);
        }
        PluginId pluginId = pluginDescriptor.getPluginId();
        if (!Extensions.isComponentSuitableForOs(extensionElement.getAttributeValue("os"))) {
            return;
        }
        String epName = ExtensionsAreaImpl.extractEPName(extensionElement, ns);
        ExtensionPoint extensionPoint = this.getExtensionPoint(epName);
        if (((ExtensionPointImpl)extensionPoint).getKind() == ExtensionPoint.Kind.INTERFACE) {
            String implClass = extensionElement.getAttributeValue("implementation");
            if (implClass == null) {
                throw new RuntimeException("'implementation' attribute not specified for '" + epName + "' extension in '" + pluginId.getIdString() + "' plugin");
            }
            adapter = new ExtensionComponentAdapter(implClass, extensionElement, this.myPicoContainer, pluginDescriptor, ExtensionsAreaImpl.shouldDeserializeInstance(extensionElement));
        } else {
            adapter = new ExtensionComponentAdapter(((ExtensionPointImpl)extensionPoint).getClassName(), extensionElement, this.myPicoContainer, pluginDescriptor, true);
        }
        this.myPicoContainer.registerComponent(adapter);
        ((ExtensionPointImpl)extensionPoint).registerExtensionAdapter(adapter);
    }

    private static boolean shouldDeserializeInstance(Element extensionElement) {
        if (!extensionElement.getContent().isEmpty()) {
            return true;
        }
        for (Attribute attribute : extensionElement.getAttributes()) {
            String name = attribute.getName();
            if ("implementation".equals(name) || "id".equals(name) || "order".equals(name)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static String extractEPName(@NotNull Element extensionElement, @Nullable String ns) {
        String epName;
        if (extensionElement == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(14);
        }
        if ((epName = extensionElement.getAttributeValue("point")) == null) {
            if (ns == null) {
                Namespace namespace = extensionElement.getNamespace();
                epName = namespace.getURI() + '.' + extensionElement.getName();
            } else {
                epName = ns + '.' + extensionElement.getName();
            }
        }
        String string = epName;
        if (string == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(15);
        }
        return string;
    }

    private void initialize() {
        for (Map.Entry<String, String> entry : ourDefaultEPs.entrySet()) {
            String epName = entry.getKey();
            this.registerExtensionPoint(epName, entry.getValue());
        }
        ((ExtensionPointImpl)this.getExtensionPoint("com.intellij.openapi.extensions.epAvailabilityListener")).addExtensionPointListener(new ExtensionPointListener(){

            public void extensionRemoved(@NotNull Object extension, PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    1.$$$reportNull$$$0(0);
                }
                EPAvailabilityListenerExtension epListenerExtension = (EPAvailabilityListenerExtension)extension;
                Collection listeners = ExtensionsAreaImpl.this.myAvailabilityListeners.get(epListenerExtension.getExtensionPointName());
                Iterator iterator2 = listeners.iterator();
                while (iterator2.hasNext()) {
                    ExtensionPointAvailabilityListener listener = (ExtensionPointAvailabilityListener)iterator2.next();
                    if (!listener.getClass().getName().equals(epListenerExtension.getListenerClass())) continue;
                    iterator2.remove();
                    return;
                }
                ExtensionsAreaImpl.this.myLogger.warn("Failed to find EP availability listener: " + epListenerExtension.getListenerClass());
            }

            public void extensionAdded(@NotNull Object extension, PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    1.$$$reportNull$$$0(1);
                }
                EPAvailabilityListenerExtension epListenerExtension = (EPAvailabilityListenerExtension)extension;
                try {
                    String epName = epListenerExtension.getExtensionPointName();
                    ExtensionPointAvailabilityListener listener = (ExtensionPointAvailabilityListener)ExtensionsAreaImpl.this.instantiate(epListenerExtension.loadListenerClass());
                    ExtensionsAreaImpl.this.addAvailabilityListener(epName, listener);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "extension";
                objectArray2[1] = "com/intellij/openapi/extensions/impl/ExtensionsAreaImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private Object instantiate(Class clazz) {
        CachingConstructorInjectionComponentAdapter adapter = new CachingConstructorInjectionComponentAdapter(Integer.toString(System.identityHashCode(new Object())), clazz);
        return adapter.getComponentInstance(this.getPicoContainer());
    }

    public void addAvailabilityListener(@NotNull String extensionPointName, @NotNull ExtensionPointAvailabilityListener listener) {
        if (extensionPointName == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(16);
        }
        if (listener == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(17);
        }
        this.myAvailabilityListeners.putValue(extensionPointName, listener);
        if (this.hasExtensionPoint(extensionPointName)) {
            this.notifyAvailableListener(listener, this.myExtensionPoints.get(extensionPointName));
        }
    }

    public void registerExtensionPoint(@NotNull String extensionPointName, @NotNull String extensionPointBeanClass) {
        if (extensionPointName == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(18);
        }
        if (extensionPointBeanClass == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(19);
        }
        this.registerExtensionPoint(extensionPointName, extensionPointBeanClass, ExtensionPoint.Kind.INTERFACE);
    }

    @Override
    public void registerExtensionPoint(@NotNull @NonNls String extensionPointName, @NotNull String extensionPointBeanClass, @NotNull ExtensionPoint.Kind kind) {
        if (extensionPointName == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(20);
        }
        if (extensionPointBeanClass == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(21);
        }
        if (kind == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(22);
        }
        this.registerExtensionPoint(extensionPointName, extensionPointBeanClass, new UndefinedPluginDescriptor(), kind);
    }

    private void registerExtensionPoint(@NotNull String extensionPointName, @NotNull String extensionPointBeanClass, @NotNull PluginDescriptor descriptor2, @NotNull ExtensionPoint.Kind kind) {
        if (extensionPointName == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(23);
        }
        if (extensionPointBeanClass == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(24);
        }
        if (descriptor2 == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(25);
        }
        if (kind == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(26);
        }
        if (this.hasExtensionPoint(extensionPointName)) {
            if (extensionPointName.equals("org.jetbrains.uast.uastLanguagePlugin")) {
                return;
            }
            String message = "Duplicate registration for EP: " + extensionPointName + ": original plugin " + ((ExtensionPointImpl)this.getExtensionPoint(extensionPointName)).getDescriptor().getPluginId() + ", new plugin " + descriptor2.getPluginId();
            if (DEBUG_REGISTRATION) {
                this.myLogger.error(message, this.myEPTraces.get(extensionPointName));
            }
            throw new PicoPluginExtensionInitializationException(message, null, descriptor2.getPluginId());
        }
        this.registerExtensionPoint(new ExtensionPointImpl(extensionPointName, extensionPointBeanClass, kind, this, this.myAreaInstance, descriptor2));
    }

    public void registerExtensionPoint(@NotNull ExtensionPointImpl extensionPoint) {
        if (extensionPoint == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(27);
        }
        String name = extensionPoint.getName();
        this.myExtensionPoints.put(name, extensionPoint);
        this.notifyEPRegistered(extensionPoint);
        if (DEBUG_REGISTRATION) {
            this.myEPTraces.put(name, new Throwable("Original registration for " + name));
        }
    }

    private void notifyEPRegistered(ExtensionPoint extensionPoint) {
        Collection<ExtensionPointAvailabilityListener> listeners = this.myAvailabilityListeners.get(extensionPoint.getName());
        for (ExtensionPointAvailabilityListener listener : listeners) {
            this.notifyAvailableListener(listener, extensionPoint);
        }
    }

    private void notifyAvailableListener(ExtensionPointAvailabilityListener listener, ExtensionPoint extensionPoint) {
        this.queueNotificationAction(() -> listener.extensionPointRegistered(extensionPoint));
    }

    private void queueNotificationAction(Runnable action2) {
        if (this.myAvailabilityNotificationsActive) {
            action2.run();
        } else {
            this.mySuspendedListenerActions.add(action2);
        }
    }

    @NotNull
    public <T> ExtensionPointImpl<T> getExtensionPoint(@NotNull String extensionPointName) {
        ExtensionPointImpl extensionPoint;
        if (extensionPointName == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(28);
        }
        if ((extensionPoint = this.myExtensionPoints.get(extensionPointName)) == null) {
            throw new IllegalArgumentException("Missing extension point: " + extensionPointName + " in area " + this.myAreaInstance);
        }
        ExtensionPointImpl extensionPointImpl = extensionPoint;
        if (extensionPointImpl == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(29);
        }
        return extensionPointImpl;
    }

    @Override
    @NotNull
    public <T> ExtensionPoint<T> getExtensionPoint(@NotNull ExtensionPointName<T> extensionPointName) {
        if (extensionPointName == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(30);
        }
        ExtensionPoint extensionPoint = this.getExtensionPoint(extensionPointName.getName());
        if (extensionPoint == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(31);
        }
        return extensionPoint;
    }

    @Override
    @NotNull
    public ExtensionPoint[] getExtensionPoints() {
        ExtensionPoint[] extensionPointArray = this.myExtensionPoints.values().toArray(new ExtensionPoint[this.myExtensionPoints.size()]);
        if (extensionPointArray == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(32);
        }
        return extensionPointArray;
    }

    @Override
    public boolean hasExtensionPoint(@NotNull String extensionPointName) {
        if (extensionPointName == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(35);
        }
        return this.myExtensionPoints.containsKey(extensionPointName);
    }

    public String toString() {
        return (this.myAreaClass == null ? "Root" : this.myAreaClass) + " Area";
    }

    void error(@NotNull String msg) {
        if (msg == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(36);
        }
        this.myLogger.error(msg);
    }

    void error(@NotNull Throwable msg) {
        if (msg == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(37);
        }
        this.myLogger.error(msg);
    }

    static {
        ourDefaultEPs.put("com.intellij.openapi.extensions.epAvailabilityListener", EPAvailabilityListenerExtension.class.getName());
        DEBUG_REGISTRATION = Boolean.FALSE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 15: 
            case 29: 
            case 31: 
            case 32: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 15: 
            case 29: 
            case 31: 
            case 32: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logger";
                break;
            }
            case 2: 
            case 15: 
            case 29: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/extensions/impl/ExtensionsAreaImpl";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginName";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionPointElement";
                break;
            }
            case 5: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
            case 8: 
            case 10: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionElement";
                break;
            }
            case 11: 
            case 27: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionPoint";
                break;
            }
            case 16: 
            case 18: 
            case 20: 
            case 23: 
            case 28: 
            case 30: 
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionPointName";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 19: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionPointBeanClass";
                break;
            }
            case 22: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "msg";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/extensions/impl/ExtensionsAreaImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPicoContainer";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "extractEPName";
                break;
            }
            case 29: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensionPoint";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensionPoints";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 15: 
            case 29: 
            case 31: 
            case 32: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "registerExtensionPoint";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "registerExtension";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "extractEPName";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addAvailabilityListener";
                break;
            }
            case 28: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getExtensionPoint";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "unregisterExtensionPoint";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "notifyEPRemoved";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "hasExtensionPoint";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "error";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 15: 
            case 29: 
            case 31: 
            case 32: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

