/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.spi;

import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import org.elasticsearch.painless.spi.Whitelist;

public final class WhitelistLoader {
    public static Whitelist loadFromResourceFiles(Class<?> resource, String ... filepaths) {
        ArrayList<Whitelist.Struct> whitelistStructs = new ArrayList<Whitelist.Struct>();
        for (String filepath : filepaths) {
            int number = -1;
            try (LineNumberReader reader = new LineNumberReader(new InputStreamReader(resource.getResourceAsStream(filepath), StandardCharsets.UTF_8));){
                String line;
                String whitelistStructOrigin = null;
                String javaClassName = null;
                boolean onlyFQNJavaClassName = false;
                ArrayList<Whitelist.Constructor> whitelistConstructors = null;
                ArrayList<Whitelist.Method> whitelistMethods = null;
                ArrayList<Whitelist.Field> whitelistFields = null;
                while ((line = reader.readLine()) != null) {
                    number = reader.getLineNumber();
                    if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') continue;
                    if (line.startsWith("class ")) {
                        if (!line.endsWith("{")) {
                            throw new IllegalArgumentException("invalid struct definition: failed to parse class opening bracket [" + line + "]");
                        }
                        String[] tokens = line.substring(5, line.length() - 1).trim().split("\\s+");
                        if (tokens.length == 2 && "only_fqn".equals(tokens[1])) {
                            onlyFQNJavaClassName = true;
                        } else if (tokens.length != 1) {
                            throw new IllegalArgumentException("invalid struct definition: failed to parse class name [" + line + "]");
                        }
                        whitelistStructOrigin = "[" + filepath + "]:[" + number + "]";
                        javaClassName = tokens[0];
                        whitelistConstructors = new ArrayList<Whitelist.Constructor>();
                        whitelistMethods = new ArrayList<Whitelist.Method>();
                        whitelistFields = new ArrayList<Whitelist.Field>();
                        continue;
                    }
                    if (line.equals("}")) {
                        if (javaClassName == null) {
                            throw new IllegalArgumentException("invalid struct definition: extraneous closing bracket");
                        }
                        whitelistStructs.add(new Whitelist.Struct(whitelistStructOrigin, javaClassName, onlyFQNJavaClassName, whitelistConstructors, whitelistMethods, whitelistFields));
                        whitelistStructOrigin = null;
                        javaClassName = null;
                        onlyFQNJavaClassName = false;
                        whitelistConstructors = null;
                        whitelistMethods = null;
                        whitelistFields = null;
                        continue;
                    }
                    String origin = "[" + filepath + "]:[" + number + "]";
                    if (javaClassName == null) {
                        throw new IllegalArgumentException("invalid object definition: expected a class name [" + line + "]");
                    }
                    if (line.startsWith("(")) {
                        if (!line.endsWith(")")) {
                            throw new IllegalArgumentException("invalid constructor definition: expected a closing parenthesis [" + line + "]");
                        }
                        String[] tokens = line.substring(1, line.length() - 1).replaceAll("\\s+", "").split(",");
                        if ("".equals(tokens[0])) {
                            tokens = new String[]{};
                        }
                        whitelistConstructors.add(new Whitelist.Constructor(origin, Arrays.asList(tokens)));
                        continue;
                    }
                    if (line.contains("(")) {
                        String javaAugmentedClassName;
                        String javaMethodName;
                        if (!line.endsWith(")")) {
                            throw new IllegalArgumentException("invalid method definition: expected a closing parenthesis [" + line + "]");
                        }
                        int parameterIndex = line.indexOf(40);
                        String[] tokens = line.trim().substring(0, parameterIndex).split("\\s+");
                        if (tokens.length == 2) {
                            javaMethodName = tokens[1];
                            javaAugmentedClassName = null;
                        } else if (tokens.length == 3) {
                            javaMethodName = tokens[2];
                            javaAugmentedClassName = tokens[1];
                        } else {
                            throw new IllegalArgumentException("invalid method definition: unexpected format [" + line + "]");
                        }
                        String painlessReturnTypeName = tokens[0];
                        tokens = line.substring(parameterIndex + 1, line.length() - 1).replaceAll("\\s+", "").split(",");
                        if ("".equals(tokens[0])) {
                            tokens = new String[]{};
                        }
                        whitelistMethods.add(new Whitelist.Method(origin, javaAugmentedClassName, javaMethodName, painlessReturnTypeName, Arrays.asList(tokens)));
                        continue;
                    }
                    String[] tokens = line.split("\\s+");
                    if (tokens.length != 2) {
                        throw new IllegalArgumentException("invalid field definition: unexpected format [" + line + "]");
                    }
                    whitelistFields.add(new Whitelist.Field(origin, tokens[1], tokens[0]));
                }
                if (javaClassName == null) continue;
                throw new IllegalArgumentException("invalid struct definition: expected closing bracket");
            }
            catch (Exception exception) {
                throw new RuntimeException("error in [" + filepath + "] at line [" + number + "]", exception);
            }
        }
        ClassLoader loader = AccessController.doPrivileged(resource::getClassLoader);
        return new Whitelist(loader, whitelistStructs);
    }

    private WhitelistLoader() {
    }
}

