/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.util.Set;
import org.elasticsearch.painless.Globals;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.node.AExpression;

final class EConstant
extends AExpression {
    EConstant(Location location, Object constant) {
        super(location);
        this.constant = constant;
    }

    @Override
    void extractVariables(Set<String> variables) {
        throw new IllegalStateException("Illegal tree structure.");
    }

    @Override
    void analyze(Locals locals) {
        if (this.constant instanceof String) {
            this.actual = locals.getDefinition().StringType;
        } else if (this.constant instanceof Double) {
            this.actual = locals.getDefinition().doubleType;
        } else if (this.constant instanceof Float) {
            this.actual = locals.getDefinition().floatType;
        } else if (this.constant instanceof Long) {
            this.actual = locals.getDefinition().longType;
        } else if (this.constant instanceof Integer) {
            this.actual = locals.getDefinition().intType;
        } else if (this.constant instanceof Character) {
            this.actual = locals.getDefinition().charType;
        } else if (this.constant instanceof Short) {
            this.actual = locals.getDefinition().shortType;
        } else if (this.constant instanceof Byte) {
            this.actual = locals.getDefinition().byteType;
        } else if (this.constant instanceof Boolean) {
            this.actual = locals.getDefinition().booleanType;
        } else {
            throw this.createError(new IllegalStateException("Illegal tree structure."));
        }
    }

    @Override
    void write(MethodWriter writer, Globals globals) {
        if (this.actual.clazz == String.class) {
            writer.push((String)this.constant);
        } else if (this.actual.clazz == Double.TYPE) {
            writer.push((Double)this.constant);
        } else if (this.actual.clazz == Float.TYPE) {
            writer.push(((Float)this.constant).floatValue());
        } else if (this.actual.clazz == Long.TYPE) {
            writer.push((Long)this.constant);
        } else if (this.actual.clazz == Integer.TYPE) {
            writer.push((Integer)this.constant);
        } else if (this.actual.clazz == Character.TYPE) {
            writer.push(((Character)this.constant).charValue());
        } else if (this.actual.clazz == Short.TYPE) {
            writer.push(((Short)this.constant).shortValue());
        } else if (this.actual.clazz == Byte.TYPE) {
            writer.push(((Byte)this.constant).byteValue());
        } else if (this.actual.clazz == Boolean.TYPE) {
            writer.push((Boolean)this.constant);
        } else {
            throw this.createError(new IllegalStateException("Illegal tree structure."));
        }
    }

    @Override
    public String toString() {
        String c = this.constant.toString();
        if (this.constant instanceof String) {
            c = "'" + c + "'";
        }
        return this.singleLineToString(this.constant.getClass().getSimpleName(), c);
    }
}

